/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppIOConst;
import com.sec.osdm.main.utils.AppFileControl;
import com.sec.osdm.main.utils.SunFtpWrapper_dm;
import com.sec.osdm.pages.utils.components.AppTextBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JRadioButton;

public class AppFileUpload
extends Thread {
    private AppFileControl m_uploader = null;
    private ArrayList m_fileList = new ArrayList();
    private AppTextBox m_compText = null;
    private Hashtable m_linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");

    public AppFileUpload(AppFileControl uploader) {
        this.m_uploader = uploader;
    }

    @Override
    public void run() {
        int cnt = 0;
        String file = "";
        this.m_fileList.clear();
        this.m_uploader.m_iniChange = false;
        int i22 = 0;
        while (i22 < this.m_uploader.m_model2.getRowHdrRowCount()) {
            if (!this.m_uploader.m_model2.isRowHidden(i22)) {
                this.m_compText = (AppTextBox)this.m_uploader.m_model2.getValueAt(i22, 6);
                file = ((AppTextBox)this.m_uploader.m_model2.getValueAt(i22, 0)).getText().toUpperCase();
                if (this.m_uploader.getNewFileSystemMode()) {
                    if (!this.m_uploader.m_iniChange && (file.endsWith(".PKM") || file.endsWith(".PGM")) && (file.startsWith("MCP") || file.startsWith("OS1") || file.startsWith("MPP") || file.startsWith("MPE") || file.startsWith("MP") || file.startsWith("STA") || file.startsWith("CS") || file.startsWith("MS") || file.startsWith("RD") || file.startsWith("AP") || file.startsWith("DR") || file.startsWith("WS") || file.startsWith("RT"))) {
                        this.m_uploader.m_iniChange = true;
                    }
                } else if (!this.m_uploader.m_iniChange && (file.endsWith(".PKG") || file.endsWith(".PGM")) && (file.startsWith("MCP") || file.startsWith("OS1") || file.startsWith("MPP") || file.startsWith("MPE") || file.startsWith("MP") || file.startsWith("STA") || file.startsWith("CS") || file.startsWith("MS") || file.startsWith("RD") || file.startsWith("AP") || file.startsWith("DR") || file.startsWith("WS") || file.startsWith("RT"))) {
                    this.m_uploader.m_iniChange = true;
                }
                if (file.endsWith(".JAR") || file.endsWith(".JNLP") || file.endsWith(".EXE") ? !this.uploadDMFile((ArrayList)this.m_uploader.m_upList.get(i22)) : !this.uploadProgramFile((ArrayList)this.m_uploader.m_upList.get(i22))) break;
                this.m_compText.setText(AppLang.getText("Uploaded"));
                this.m_uploader.m_table2.repaint();
                ++cnt;
            }
            if (AppGlobal.g_bIsCancel) {
                AppGlobal.showInfoMessage("Canceled", "Program upload is canceled.");
                break;
            }
            ++i22;
        }
        AppGlobal.hideProgress();
        if (cnt > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException i22) {
                // empty catch block
            }
            this.m_uploader.requestFileControl("Refresh");
            this.m_uploader.m_tabMain.setSelectedIndex(0);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException i22) {
                // empty catch block
            }
            AppGlobal.showInfoMessage("", "The file(s) is uploaded successfully.");
            if (this.m_uploader.m_iniChange) {
                if (AppGlobal.showConfirmMessage("INI Change", "Do you want to update INI info for uploaded file(s)?") == 0) {
                    String fileName = "";
                    int i3 = 0;
                    while (i3 < this.m_fileList.size()) {
                        fileName = ((String)this.m_fileList.get(i3)).toUpperCase();
                        int j2 = 0;
                        while (j2 < this.m_uploader.m_model1.getRowHdrRowCount()) {
                            if (((AppTextBox)this.m_uploader.m_model1.getValueAt(j2, 0)).getText().trim().toUpperCase().equals(fileName)) {
                                try {
                                    ((JRadioButton)this.m_uploader.m_model1.getValueAt(j2, 3)).doClick();
                                }
                                catch (Exception exception) {}
                                break;
                            }
                            ++j2;
                        }
                        ++i3;
                    }
                    this.m_uploader.requestFileControl("Change");
                } else {
                    this.m_uploader.requestFileControl("Refresh");
                }
            } else {
                this.m_uploader.requestFileControl("Refresh");
            }
            this.m_uploader.m_tabMain.setSelectedIndex(0);
        }
    }

    private boolean uploadProgramFile(ArrayList upload2) {
        byte[] reqData = new byte[48];
        byte[] fileInfo = new byte[40];
        byte[] header = new byte[8];
        byte[] fileData = (byte[])upload2.get(3);
        byte subId = this.m_uploader.getSubId((String)upload2.get(0));
        header = this.m_uploader.m_comm.makeMsgHeader((byte)19, subId, (byte)2, (short)0, (byte)-1, (byte)-1);
        if (!upload2.get(8).equals("")) {
            fileInfo[0] = (Byte)upload2.get(8);
        }
        if (!upload2.get(9).equals("")) {
            fileInfo[1] = (Byte)upload2.get(9);
        }
        AppFunctions.str2byte(fileInfo, 2, 14, (String)upload2.get(0));
        AppFunctions.int2byte(fileInfo, 16, (Integer)upload2.get(7));
        AppFunctions.str2byte(fileInfo, 20, 10, (String)upload2.get(5));
        AppFunctions.str2byte(fileInfo, 30, 10, (String)upload2.get(6));
        System.arraycopy(header, 0, reqData, 0, 8);
        System.arraycopy(fileInfo, 0, reqData, 8, 40);
        AppGlobal.showProgress("[" + (String)upload2.get(0) + "]", String.valueOf(AppLang.getText("Transferring")) + "...");
        this.m_compText.setText(String.valueOf(AppLang.getText("Transferring")) + "...");
        this.m_uploader.m_table2.repaint();
        this.m_uploader.m_recvData = this.m_uploader.m_comm.requestUpload(reqData, 8, "");
        if (this.m_uploader.m_recvData == null) {
            return false;
        }
        if (this.m_uploader.m_recvData[7] != 1 && this.m_uploader.m_recvData[7] != -17) {
            this.dispError(this.m_uploader.m_recvData[7]);
            return false;
        }
        byte[] upData = null;
        int rcdSize = 256;
        if (((String)this.m_linkInfo.get("LINK_KIND")).equals("MODEM")) {
            int j2 = 0;
            int k2 = 1;
            while (j2 < fileData.length) {
                int msgLen = rcdSize;
                int resp = 255;
                if (j2 + rcdSize > fileData.length) {
                    msgLen = fileData.length - j2;
                    resp = 239;
                }
                upData = new byte[msgLen + 8];
                header = this.m_uploader.m_comm.makeMsgHeader((byte)19, subId, (byte)-1, (short)k2, (byte)-1, (byte)resp);
                System.arraycopy(header, 0, upData, 0, 8);
                System.arraycopy(fileData, j2, upData, 8, msgLen);
                this.m_uploader.m_recvData = resp == 239 ? this.m_uploader.m_comm.requestUpload(upData, 8, "") : this.m_uploader.m_comm.requestUpload(upData, 0, "");
                j2 += rcdSize;
                ++k2;
            }
        } else {
            this.m_uploader.m_recvData = this.m_uploader.m_comm.requestUpload(fileData, 8, (String)upload2.get(0));
        }
        if (this.m_uploader.m_recvData == null) {
            return false;
        }
        if (this.m_uploader.m_recvData[7] != -31 && this.m_uploader.m_recvData[7] != -17) {
            this.dispError(this.m_uploader.m_recvData[7]);
            return false;
        }
        AppGlobal.showProgress("[" + (String)upload2.get(0) + "]", String.valueOf(AppLang.getText("Writing")) + "...");
        this.m_compText.setText(String.valueOf(AppLang.getText("Writing")) + "...");
        this.m_uploader.m_table2.repaint();
        int writeSize = -1;
        int sendSize = (Integer)upload2.get(7);
        while (writeSize != 0 && writeSize < sendSize) {
            this.m_uploader.m_recvData = this.m_uploader.m_comm.recvUpload(12);
            if (this.m_uploader.m_recvData != null && this.m_uploader.m_recvData.length >= 12 && (writeSize = AppFunctions.byte2int(this.m_uploader.m_recvData, 8)) > 0) {
                AppGlobal.showProgress("[" + (String)upload2.get(0) + "] - " + sendSize, String.valueOf(AppLang.getText("Writing")) + "... (" + writeSize + "=" + (int)((float)writeSize / (float)sendSize * 100.0f) + "%)");
            }
            if (!AppGlobal.g_bIsCancel) continue;
            return false;
        }
        try {
            AppFileUpload.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_fileList.add(this.m_fileList.size(), (String)upload2.get(0));
        return true;
    }

    private void dispError(byte error) {
        String msg = "";
        msg = this.m_uploader.m_recvData[7] == 0 ? "Can not program upload." : (error == -32 ? "Failed to upload program." : (AppIOConst.m_uploadError.containsKey(error) ? (String)AppIOConst.m_uploadError.get(error) : "[Response Code] 0x" + String.format("%02x", error)));
        this.m_compText.setText(AppLang.getText("Failed"));
        this.m_uploader.m_table2.repaint();
        AppGlobal.showInfoMessage("", msg);
    }

    private boolean uploadDMFile(ArrayList upload2) {
        AppGlobal.showProgress("[" + (String)upload2.get(0) + "]", String.valueOf(AppLang.getText("Transferring")) + "...");
        this.m_compText.setText(String.valueOf(AppLang.getText("Transferring")) + "...");
        this.m_uploader.m_table2.repaint();
        AppGlobal.showProgress("[" + (String)upload2.get(0) + "]", String.valueOf(AppLang.getText("Writing")) + "...");
        this.m_compText.setText(String.valueOf(AppLang.getText("Writing")) + "...");
        this.m_uploader.m_table2.repaint();
        String localFile = (String)upload2.get(1);
        String fileName = (String)upload2.get(0);
        SunFtpWrapper_dm ftp = new SunFtpWrapper_dm();
        Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        String m_ftpIP = (String)linkInfo.get("IP_ADDRESS");
        int m_ftpPort = Integer.parseInt((String)linkInfo.get("FTP_PORT"));
        String m_ftpID = AppRunInfo.getFtpID();
        String m_ftpPW = AppRunInfo.getFtpPW();
        try {
            ftp.openServer(m_ftpIP, m_ftpPort);
            ftp.login(m_ftpID, m_ftpPW);
            ftp.issueRawCommand("XMKD " + this.m_uploader.getFtpPath());
            ftp.binary();
            boolean ret = ftp.uploadFile(localFile, String.valueOf(this.m_uploader.getFtpPath()) + fileName, fileName);
            ftp.closeServer();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        catch (IOException e3) {
            e3.printStackTrace();
            this.dispError((byte)-32);
            return false;
        }
        return true;
    }
}

