/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.print;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.utils.print.AppPrinterTable;
import com.sec.osdm.pages.utils.print.AppTablePrinterRenderer;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class AppTablePrinter
extends JDialog
implements ActionListener {
    public AppPage m_appPage = null;
    public AppTable m_defaultTable = null;
    public AppTableModel m_defaultModel = null;
    public AppPrinterTable m_table = null;
    public DefaultTableModel m_model = null;
    public ArrayList m_data = new ArrayList();
    public String[][] m_tableRow = null;
    public String[][] m_tableCol = null;
    public String[][] m_tableCorner = null;
    public String m_tableConer1 = null;

    public AppTablePrinter(AppPage page, AppTable table, int tableNum) {
        super(AppGlobal.g_frmMain, String.valueOf(AppLang.getText("Print View")) + " (" + AppLang.getText("Table") + " " + (tableNum + 1) + ")", true);
        this.m_appPage = page;
        this.m_defaultTable = table;
        this.m_defaultModel = this.m_defaultTable.getModels();
        this.m_defaultTable.editingStopped(null);
        this.m_tableRow = this.m_defaultModel.getRowHdrNames();
        this.m_tableCol = this.m_defaultModel.getColHdrNames();
        this.m_tableCorner = this.m_defaultModel.getCornerHdrNames();
        this.m_tableConer1 = this.m_defaultModel.getCornerName(0);
        if (this.m_tableConer1 == null) {
            this.m_tableConer1 = "";
        }
        this.setIntialFrame(tableNum);
        JScrollPane scrolPane = new JScrollPane(this.m_table);
        scrolPane.setPreferredSize(new Dimension(700, 600));
        JPanel panel = new JPanel();
        panel.add(scrolPane);
        this.add((Component)panel, "Center");
        this.setVisible(true);
    }

    public void setIntialFrame(int tableNum) {
        this.setSize(new Dimension(800, 700));
        this.setLayout(new BorderLayout());
        this.setIconImage(AppImages.Img_Logo);
        this.setDefaultCloseOperation(2);
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        JPanel m_btnPanel = new JPanel(new FlowLayout());
        JButton m_btnPrint = new JButton(AppLang.getText("Print"));
        JButton m_btnCancel = new JButton(AppLang.getText("Cancel"));
        AppGlobal.fixSize(m_btnPrint, new Dimension(120, 25));
        AppGlobal.fixSize(m_btnCancel, new Dimension(120, 25));
        m_btnPrint.addActionListener(this);
        m_btnCancel.addActionListener(this);
        m_btnPrint.setActionCommand("Print");
        m_btnCancel.setActionCommand("Cancel");
        m_btnPanel.add(m_btnPrint);
        m_btnPanel.add(m_btnCancel);
        this.add((Component)m_btnPanel, "South");
        if (this.m_tableRow[0].length == 1 && this.m_tableCol.length == 1) {
            this.createDefaultCellTable();
        } else {
            this.createMultiCellTable();
        }
        this.setTableWidth();
    }

    public void setFixSizeColumnWidth(int width) {
        int i2 = 1;
        while (i2 < this.m_table.getColumnCount()) {
            int columnIdx = i2;
            if (this.m_defaultModel.IsRowHeaderHidden()) {
                columnIdx = i2 - 1;
            }
            this.m_table.getColumnModel().getColumn(columnIdx).setPreferredWidth(width);
            ++i2;
        }
    }

    public void setTableWidth() {
        int i2;
        this.m_table.setAutoResizeMode(0);
        int[] rowWidth = this.m_defaultModel.getRowHdrWidth();
        int[] colWidth = this.m_defaultModel.getColHdrWidth();
        if (!this.m_defaultModel.IsRowHeaderHidden() && rowWidth != null) {
            int width = 0;
            i2 = 0;
            while (i2 < rowWidth.length) {
                width = rowWidth.length > i2 ? (width += rowWidth[i2]) : (width += 100);
                ++i2;
            }
            this.m_table.getColumnModel().getColumn(0).setPreferredWidth(width);
        }
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        if (this.m_appPage.m_pageInfo.getMsgId().equals("4301")) {
            this.setFixSizeColumnWidth(80);
        } else {
            i2 = 0;
            while (i2 < this.m_defaultModel.getColHdrColCount()) {
                if (!this.m_defaultModel.isColHidden(i2)) {
                    if (this.m_appPage.m_pageInfo.getMsgId().equals("")) {
                        columnWidth.add(100);
                    } else if (colWidth.length > i2) {
                        columnWidth.add(colWidth[i2]);
                    } else {
                        columnWidth.add(150);
                    }
                }
                ++i2;
            }
            i2 = 1;
            while (i2 < this.m_table.getColumnCount()) {
                int width = 150;
                int columnIdx = i2;
                if (columnWidth.size() > i2 - 1) {
                    width = (Integer)columnWidth.get(i2 - 1);
                }
                if (this.m_defaultModel.IsRowHeaderHidden()) {
                    columnIdx = i2 - 1;
                }
                this.m_table.getColumnModel().getColumn(columnIdx).setPreferredWidth(width);
                ++i2;
            }
        }
    }

    public void createDefaultCellTable() {
        ArrayList<String> column = new ArrayList<String>();
        if (!this.m_defaultModel.IsRowHeaderHidden()) {
            if (this.m_tableCorner != null) {
                column.add(this.m_tableCorner[0][0]);
            } else {
                column.add(this.m_tableConer1);
            }
        }
        int i2 = 0;
        while (i2 < this.m_defaultModel.getColHdrColCount()) {
            if (!this.m_defaultModel.isColHidden(i2)) {
                column.add(this.m_tableCol[0][i2]);
            }
            ++i2;
        }
        Object[] header = new String[column.size()];
        int i3 = 0;
        while (i3 < header.length) {
            header[i3] = AppLang.getText(column.get(i3).toString());
            ++i3;
        }
        i3 = 0;
        while (i3 < this.m_defaultModel.getRowHdrRowCount()) {
            ArrayList<Object> alData = new ArrayList<Object>();
            if (!this.m_defaultModel.isRowHidden(i3)) {
                if (!this.m_defaultModel.IsRowHeaderHidden()) {
                    alData.add(AppLang.getText(this.m_tableRow[i3][0]));
                }
                int j2 = 0;
                while (j2 < this.m_defaultModel.getColHdrColCount()) {
                    if (!this.m_defaultModel.isColHidden(j2)) {
                        if (this.m_defaultModel.getValueAt(i3, j2) instanceof JCheckBox || this.m_defaultModel.getValueAt(i3, j2) instanceof JLabel || this.m_defaultModel.getValueAt(i3, j2) instanceof JButton || this.m_defaultModel.getValueAt(i3, j2) instanceof JProgressBar) {
                            alData.add(this.m_defaultModel.getValueAt(i3, j2));
                        } else if (this.m_defaultModel.getValueAt(i3, j2) != null) {
                            alData.add(this.m_defaultModel.getValueAt(i3, j2).toString());
                        } else {
                            alData.add("");
                        }
                    }
                    ++j2;
                }
                this.m_data.add(alData);
            }
            ++i3;
        }
        Object[][] arrData = new Object[this.m_data.size()][((ArrayList)this.m_data.get(0)).size()];
        int i4 = 0;
        while (i4 < this.m_data.size()) {
            ArrayList tmp = (ArrayList)this.m_data.get(i4);
            int j3 = 0;
            while (j3 < tmp.size()) {
                arrData[i4][j3] = tmp.get(j3);
                ++j3;
            }
            ++i4;
        }
        this.m_model = new DefaultTableModel(arrData, header);
        this.m_table = new AppPrinterTable(this.m_model);
        JTableHeader tbHeader = this.m_table.getTableHeader();
        tbHeader.setBackground(AppTablePrinterRenderer.m_headerColor);
    }

    public void createMultiCellTable() {
        int j2;
        String corner = "";
        if (!this.m_defaultModel.IsRowHeaderHidden()) {
            int i2 = 0;
            while (i2 < this.m_tableCorner.length) {
                int j3 = 0;
                while (j3 < this.m_tableCorner[0].length) {
                    if (!this.m_tableCorner[i2][j3].trim().equals("")) {
                        corner = String.valueOf(corner) + this.m_tableCorner[i2][j3];
                        if (j3 < this.m_tableCorner[0].length - 1) {
                            corner = String.valueOf(corner) + " - ";
                        }
                    }
                    ++j3;
                }
                ++i2;
            }
        }
        ArrayList<String> column = new ArrayList<String>();
        if (!this.m_defaultModel.IsRowHeaderHidden()) {
            if ((corner = corner.trim()).length() > 1 && corner.substring(corner.length() - 1).equals("-")) {
                corner = corner.substring(0, corner.length() - 2);
            }
            column.add(corner);
        }
        int i3 = 0;
        while (i3 < this.m_tableCol[0].length) {
            String strData = "";
            if (!this.m_defaultModel.isColHidden(i3)) {
                int j4 = 0;
                while (j4 < this.m_tableCol.length) {
                    strData = this.m_tableCol[j4][i3].trim().equals("") && j4 != this.m_tableCol.length - 1 ? String.valueOf(strData) + this.m_tableCol[0][i3] : String.valueOf(strData) + this.m_tableCol[j4][i3];
                    if (j4 < this.m_tableCol.length - 1) {
                        strData = String.valueOf(strData) + "-";
                    }
                    ++j4;
                }
                if ((strData = strData.trim()).length() > 0 && strData.substring(strData.length() - 1).equals("-")) {
                    strData = strData.substring(0, strData.length() - 1);
                }
                column.add(strData);
            }
            ++i3;
        }
        ArrayList<String> rowName = new ArrayList<String>();
        int i4 = 0;
        while (i4 < this.m_tableRow.length) {
            String strTemp = "";
            j2 = 0;
            while (j2 < this.m_tableRow[0].length) {
                if (this.m_tableRow[i4][j2] != null) {
                    strTemp = String.valueOf(strTemp) + this.m_tableRow[i4][j2];
                    if (j2 < this.m_tableRow[0].length - 1) {
                        strTemp = String.valueOf(strTemp) + " - ";
                    }
                }
                ++j2;
            }
            if ((strTemp = strTemp.trim()).length() > 1 && strTemp.substring(strTemp.length() - 1).equals("-")) {
                strTemp = strTemp.substring(0, strTemp.length() - 2);
            }
            rowName.add(strTemp);
            ++i4;
        }
        i4 = 0;
        while (i4 < this.m_defaultModel.getRowHdrRowCount()) {
            ArrayList<Object> alData = new ArrayList<Object>();
            if (!this.m_defaultModel.isRowHidden(i4)) {
                alData.add(AppLang.getText(rowName.get(i4).toString()));
                j2 = 0;
                while (j2 < this.m_defaultModel.getColHdrColCount()) {
                    if (!this.m_defaultModel.isColHidden(j2)) {
                        if (this.m_defaultModel.getValueAt(i4, j2) instanceof JCheckBox || this.m_defaultModel.getValueAt(i4, j2) instanceof JLabel || this.m_defaultModel.getValueAt(i4, j2) instanceof JButton) {
                            alData.add(this.m_defaultModel.getValueAt(i4, j2));
                        } else if (this.m_defaultModel.getValueAt(i4, j2) != null) {
                            alData.add(this.m_defaultModel.getValueAt(i4, j2).toString());
                        } else {
                            alData.add("");
                        }
                    }
                    ++j2;
                }
                this.m_data.add(alData);
            }
            ++i4;
        }
        Object[][] arrData = new String[this.m_data.size()][((ArrayList)this.m_data.get(0)).size()];
        int i5 = 0;
        while (i5 < this.m_data.size()) {
            ArrayList tmp = (ArrayList)this.m_data.get(i5);
            int j5 = 0;
            while (j5 < tmp.size()) {
                arrData[i5][j5] = tmp.get(j5).toString();
                ++j5;
            }
            ++i5;
        }
        Object[] header = new String[column.size()];
        int i6 = 0;
        while (i6 < header.length) {
            String[] arrString = column.get(i6).toString().split("-");
            String data = "";
            if (arrString.length > 1) {
                int j6 = 0;
                while (j6 < arrString.length) {
                    data = String.valueOf(data) + arrString[j6] + "\n";
                    ++j6;
                }
            } else {
                data = column.get(i6).toString();
            }
            data.trim();
            header[i6] = AppLang.getText(data);
            ++i6;
        }
        this.m_model = new DefaultTableModel(arrData, header);
        this.m_table = new AppPrinterTable(this.m_model);
        JTableHeader tbHeader = this.m_table.getTableHeader();
        tbHeader.setBackground(AppTablePrinterRenderer.m_headerColor);
    }

    public void print() {
        try {
            this.m_table.print(JTable.PrintMode.NORMAL);
            this.dispose();
        }
        catch (PrinterException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        if (command.equals("Print")) {
            this.print();
        } else {
            this.dispose();
        }
    }
}

