/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.pages.utils.table.SpanInfo;
import com.sec.osdm.pages.utils.table.SpanTableColumnModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SpanTableHeaderUI
extends BasicTableHeaderUI {
    @Override
    public void paint(Graphics g2, JComponent c2) {
        Rectangle oldClipBounds = g2.getClipBounds();
        Rectangle clipBounds = new Rectangle(oldClipBounds);
        SpanTableColumnModel columnModel = (SpanTableColumnModel)this.header.getColumnModel();
        SpanInfo spanInfo = columnModel.getSpanInfo();
        Rectangle cellRect = new Rectangle();
        Dimension compSize = null;
        int nColumnCount = columnModel.getColumnCount();
        int nRowCount = columnModel.getRowCount();
        TableColumn tableColumn = null;
        int column = 0;
        while (column < nColumnCount) {
            tableColumn = columnModel.getColumn(column);
            cellRect.width = tableColumn.getWidth();
            cellRect.y = 0;
            int row = 0;
            while (row < nRowCount) {
                if (spanInfo.isVisible(row, column)) {
                    compSize = columnModel.getCellSize(this.header.getTable(), row, column);
                    cellRect.height = compSize.height;
                    cellRect.width = compSize.width;
                    if (cellRect.intersects(clipBounds)) {
                        this.paintCell(g2, cellRect, row, column);
                    }
                    cellRect.y += compSize.height;
                } else {
                    int[] span = spanInfo.getSpan(row, column);
                    if (span[1] < 0) {
                        compSize = columnModel.getCellSize(this.header.getTable(), row + span[0], column + span[1]);
                        cellRect.y += compSize.height;
                    }
                }
                ++row;
            }
            cellRect.x += tableColumn.getWidth();
            ++column;
        }
    }

    public void paintCell(Graphics g2, Rectangle cellRect, int row, int col) {
        SpanTableColumnModel columnModel = (SpanTableColumnModel)this.header.getColumnModel();
        TableCellRenderer renderer = columnModel.getHeaderRenderer(row, col);
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), columnModel.getHeaderValue(row, col), false, false, row, col);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g2, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    public void paintCell(Graphics g2, Rectangle cellRect, int column) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(column);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g2, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        long width = 0L;
        Enumeration<TableColumn> columns = this.header.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn aColumn = columns.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    private int getHeaderHeight() {
        SpanTableColumnModel columnModel = (SpanTableColumnModel)this.header.getColumnModel();
        int cHeight = 0;
        SpanInfo spanInfo = columnModel.getSpanInfo();
        int row = 0;
        while (row < columnModel.getRowCount()) {
            if (spanInfo.isVisible(row, 0)) {
                cHeight += columnModel.getCellSize((JTable)this.header.getTable(), (int)row, (int)0).height;
            }
            ++row;
        }
        return cHeight;
    }

    private Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.header.getColumnModel();
        if ((width += (long)(columnModel.getColumnMargin() * columnModel.getColumnCount())) > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }
}

