/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppDownRequest;
import com.sec.osdm.io.AppFTPClient;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.AppPageMessage;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.vmaa.P2006PromptDeleteDlg;
import com.sec.osdm.pages.vmaa.P2006PromptDetailDlg;
import com.sec.osdm.pages.vmaa.P2006PromptTopPanel;
import com.sec.osdm.pages.vmaa.P2006PromptUploadDlg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class P2006Prompt
extends AppPage {
    private static final int CODEC726 = 0;
    private static final int CODEC729 = 1;
    private static final int CODEC711 = 2;
    private static int CODEC_TYPE;
    private JPanel m_btnPanel = new JPanel(new FlowLayout());
    private JComboBox m_cbPage = new JComboBox();
    private JButton m_btnFirPage = new JButton("<<");
    private JButton m_btnPrev = new JButton("<");
    private JButton m_btnNext = new JButton(">");
    private JButton m_btnLast = new JButton(">>");
    private JLabel m_lbPageStatus = new JLabel();
    private P2006PromptTopPanel m_topPanel = null;
    private static AppFTPClient m_ftpClient;
    private static String m_dirPath;
    private String[] m_langList = null;
    private ArrayList m_modPage = new ArrayList();
    private ArrayList m_fileType = new ArrayList();
    private int m_pageIndex = 0;
    private PrmptTableListener m_tableListener = new PrmptTableListener();
    private String m_dfltLang = null;
    private int m_dfltLangIndex = 0;
    private Hashtable m_htData = new Hashtable();
    public static HashMap<String, String> m_htFileSize;
    public static HashMap<String, String> m_htMakeFileDate;

    static {
        m_ftpClient = new AppFTPClient();
        m_dirPath = null;
        m_htFileSize = null;
        m_htMakeFileDate = null;
    }

    public P2006Prompt(AppPageInfo pageInfo) {
        this.m_htData.put("en_us", new String[]{"1", AppLang.getText("English, American")});
        this.m_htData.put("kr_kr", new String[]{"2", AppLang.getText("Korean, Korea")});
        this.m_htData.put("sp_ca", new String[]{"3", AppLang.getText("Spanish, Castillian")});
        this.m_htData.put("fr_ca", new String[]{"4", AppLang.getText("French, Canada")});
        this.m_htData.put("da_de", new String[]{"5", AppLang.getText("Danish, Denmark")});
        this.m_htData.put("du_ho", new String[]{"6", AppLang.getText("Dutch, Holland")});
        this.m_htData.put("ge_as", new String[]{"7", AppLang.getText("German, Austria")});
        this.m_htData.put("it_it", new String[]{"8", AppLang.getText("Italian, Italy")});
        this.m_htData.put("po_po", new String[]{"9", AppLang.getText("Portuguese, Portugal")});
        this.m_htData.put("ru_ru", new String[]{"10", AppLang.getText("Russian, Russia")});
        this.m_htData.put("sp_sp", new String[]{"11", AppLang.getText("Spanish, Spain")});
        this.m_htData.put("sw_sw", new String[]{"12", AppLang.getText("Swedish, Sweden")});
        this.m_htData.put("en_gb", new String[]{"13", AppLang.getText("English, British")});
        this.m_htData.put("en_as", new String[]{"14", AppLang.getText("English, Australia")});
        this.m_htData.put("ge_ge", new String[]{"15", AppLang.getText("German, German")});
        this.m_htData.put("fi_fi", new String[]{"16", AppLang.getText("Finnish, Finland")});
        this.m_htData.put("gr_gr", new String[]{"17", AppLang.getText("Greek, Greece")});
        this.m_htData.put("tr_tr", new String[]{"18", AppLang.getText("Turkish, Turkey")});
        this.setPageInfo(pageInfo);
        if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
            m_ftpClient.setServerIP(AppNetwork.m_address_SVMi20i);
            m_ftpClient.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
        }
        m_ftpClient.connect();
        this.getDirList();
        if (AppGlobal.g_2006langNewPage) {
            this.m_dfltLang = this.getDfltLangDir();
            AppGlobal.g_2006langNewPage = false;
        } else {
            this.m_dfltLang = AppGlobal.g_2006reloadLang;
        }
        if (this.m_langList.length > 0) {
            this.m_dfltLangIndex = 0;
            while (this.m_dfltLangIndex < this.m_langList.length) {
                if (this.m_dfltLang.equals(this.getLanguage(this.m_langList[this.m_dfltLangIndex]))) break;
                ++this.m_dfltLangIndex;
            }
            if (this.m_dfltLangIndex >= this.m_langList.length) {
                this.m_dfltLangIndex = 0;
            }
            m_dirPath = String.valueOf(AppGlobal.g_vmDir) + "/pmt/" + this.getLanguage(this.m_langList[this.m_dfltLangIndex]) + "/";
            this.getFileList(m_dirPath);
            this.getFileInfo();
            this.setPageIndex(0);
            this.setButtonPan();
            this.createComponents();
        } else {
            this.m_rowTitle = new String[0][0];
            this.m_colTitle = new String[][]{{"Delete", "No.", "Description", "Length(sec)"}};
        }
        m_ftpClient.disConnect();
        this.createTable();
        this.m_jspTop.setVisible(true);
    }

    private String getDfltLangDir() {
        AppPageInfo pageInfo = new AppPageInfo("2005");
        AppComm comm2 = AppComm.getInstance();
        pageInfo.setReqData(new byte[4]);
        pageInfo.setDownMsgType((byte)-47);
        pageInfo.setUpMsgType((byte)-14);
        if (AppDownRequest.requestDownloadByPageInfo(comm2, pageInfo)) {
            ArrayList data = (ArrayList)pageInfo.getRecvData().get(0);
            String defaultLang = "" + data.get(79);
            if (defaultLang.equals("1")) {
                return "en_us";
            }
            if (defaultLang.equals("2")) {
                return "kr_kr";
            }
            if (defaultLang.equals("3")) {
                return "sp_ca";
            }
            if (defaultLang.equals("4")) {
                return "fr_ca";
            }
            if (defaultLang.equals("5")) {
                return "da_de";
            }
            if (defaultLang.equals("6")) {
                return "du_ho";
            }
            if (defaultLang.equals("7")) {
                return "ge_as";
            }
            if (defaultLang.equals("8")) {
                return "it_it";
            }
            if (defaultLang.equals("9")) {
                return "po_po";
            }
            if (defaultLang.equals("10")) {
                return "ru_ru";
            }
            if (defaultLang.equals("11")) {
                return "sp_sp";
            }
            if (defaultLang.equals("12")) {
                return "sw_sw";
            }
            if (defaultLang.equals("13")) {
                return "en_gb";
            }
            if (defaultLang.equals("14")) {
                return "en_as";
            }
            if (defaultLang.equals("15")) {
                return "ge_ge";
            }
            if (defaultLang.equals("16")) {
                return "fi_fi";
            }
            if (defaultLang.equals("17")) {
                return "gr_gr";
            }
            if (defaultLang.equals("18")) {
                return "tr_tr";
            }
        }
        return "en_us";
    }

    private void getFileInfo() {
        m_htFileSize = null;
        m_htMakeFileDate = null;
        m_htFileSize = m_ftpClient.getFileSize(m_dirPath);
        m_htMakeFileDate = m_ftpClient.getFileDate(m_dirPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLength(String fileName) {
        long length = 0L;
        String size = null;
        if (CODEC_TYPE == 0) {
            size = m_htFileSize.get(String.valueOf(fileName.substring(0, 4)) + ".726");
            if (size == null) return "0";
            length = Long.parseLong(size) / 4096L;
        } else if (CODEC_TYPE == 1) {
            size = m_htFileSize.get(String.valueOf(fileName.substring(0, 4)) + ".729");
            if (size == null) return "0";
            length = Long.parseLong(size) / 1024L;
        } else {
            size = m_htFileSize.get(String.valueOf(fileName.substring(0, 4)) + ".711");
            if (size == null) return "0";
            length = Long.parseLong(size) / 8192L;
        }
        if (length != 0L) return String.format("%s", length);
        return "1";
    }

    private void setPageIndex(int index) {
        this.m_pageIndex = index;
        AppGlobal.g_2006reloadIndex = index;
    }

    private void setPageStatus() {
        if (this.m_modPage.size() > 0) {
            this.m_lbPageStatus.setText(String.valueOf(this.m_pageIndex + 1) + " / " + this.m_modPage.size());
        } else {
            this.m_lbPageStatus.setText("0 / 0");
        }
    }

    private void setButtonPan() {
        this.m_lbPageStatus.setHorizontalAlignment(0);
        this.m_btnFirPage.addActionListener(this);
        this.m_btnPrev.addActionListener(this);
        this.m_btnNext.addActionListener(this);
        this.m_btnLast.addActionListener(this);
        this.m_btnFirPage.setActionCommand("FirstPage");
        this.m_btnPrev.setActionCommand("PrevPage");
        this.m_btnNext.setActionCommand("NextPage");
        this.m_btnLast.setActionCommand("LastPage");
        AppGlobal.fixSize(this.m_cbPage, new Dimension(50, 20));
        AppGlobal.fixSize(this.m_btnFirPage, new Dimension(80, 20));
        AppGlobal.fixSize(this.m_btnPrev, new Dimension(80, 20));
        AppGlobal.fixSize(this.m_lbPageStatus, new Dimension(130, 20));
        AppGlobal.fixSize(this.m_btnNext, new Dimension(80, 20));
        AppGlobal.fixSize(this.m_btnLast, new Dimension(80, 20));
        this.m_btnPanel.add(this.m_cbPage);
        this.m_btnPanel.add(this.m_btnFirPage);
        this.m_btnPanel.add(this.m_btnPrev);
        this.m_btnPanel.add(this.m_lbPageStatus);
        this.m_btnPanel.add(this.m_btnNext);
        this.m_btnPanel.add(this.m_btnLast);
    }

    private void setListener() {
        this.m_cbPage.addActionListener(this);
        this.m_cbPage.setActionCommand("DirPage");
    }

    private void removeListener() {
        this.m_cbPage.removeActionListener(this);
    }

    public void createComponents() {
        try {
            this.removeListener();
            this.m_cbPage.removeAllItems();
            int i2 = 0;
            while (i2 < this.m_modPage.size()) {
                this.m_cbPage.addItem(i2 + 1);
                ++i2;
            }
            if (this.m_modPage.size() != 0) {
                this.m_cbPage.setSelectedIndex(this.m_pageIndex);
            }
            this.setListener();
            this.setPageStatus();
            ArrayList<JComponent> data = null;
            this.m_recvData.clear();
            if (this.m_modPage.size() > 0) {
                ArrayList pageData = (ArrayList)this.m_modPage.get(this.m_pageIndex);
                ArrayList fileType = (ArrayList)this.m_fileType.get(this.m_pageIndex);
                if (pageData.size() > 0) {
                    ArrayList<String> fileDir = new ArrayList<String>();
                    ArrayList<String> tmpFile = new ArrayList<String>();
                    int otherCnt = 0;
                    int i3 = 0;
                    while (i3 < pageData.size()) {
                        if (fileType.get(i3).equals("TXT")) {
                            fileDir.add(String.valueOf(m_dirPath) + (String)pageData.get(i3));
                            tmpFile.add((String)pageData.get(i3));
                        } else {
                            ++otherCnt;
                        }
                        ++i3;
                    }
                    this.m_rowTitle = new String[0][1];
                    Hashtable htContent = m_ftpClient.getFileContentsAll(fileDir, tmpFile);
                    if (htContent.size() + otherCnt == ((ArrayList)this.m_modPage.get(this.m_pageIndex)).size()) {
                        int i4 = 0;
                        while (i4 < pageData.size()) {
                            String str = ((String)pageData.get(i4)).substring(0, 4);
                            data = new ArrayList<JComponent>();
                            JCheckBox cBox = new JCheckBox();
                            cBox.setHorizontalAlignment(0);
                            data.add(cBox);
                            JLabel lbNum = new JLabel("  " + str);
                            lbNum.setHorizontalAlignment(0);
                            data.add(lbNum);
                            String contentData = "";
                            ArrayList tmplist = null;
                            if (fileType.get(i4).equals("TXT")) {
                                tmplist = (ArrayList)htContent.get((String)pageData.get(i4));
                                int j2 = 0;
                                while (j2 < tmplist.size()) {
                                    contentData = String.valueOf(contentData) + (String)tmplist.get(j2) + "\n";
                                    ++j2;
                                }
                                if (tmplist.size() > 0) {
                                    data.add(new JLabel("  " + contentData));
                                } else {
                                    data.add(new JLabel(" "));
                                }
                            } else {
                                data.add(new JLabel(" "));
                            }
                            lbNum = new JLabel(P2006Prompt.getLength((String)pageData.get(i4)));
                            lbNum.setHorizontalAlignment(0);
                            data.add(lbNum);
                            this.m_recvData.add(data);
                            ++i4;
                        }
                    }
                }
            }
            this.m_rowTitle = new String[this.m_recvData.size()][1];
            this.m_colTitle = new String[][]{{"Delete", "No.", "Description", "Length(sec)"}};
            int i5 = 0;
            while (i5 < this.m_rowTitle.length) {
                this.m_rowTitle[i5][0] = "";
                ++i5;
            }
            if (this.m_table != null) {
                this.m_model.setRowHeaderNames(this.m_rowTitle);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, new String[][]{{""}}){

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return (JCheckBox)((ArrayList)P2006Prompt.this.m_recvData.get(row)).get(col);
                }
                return (JLabel)((ArrayList)P2006Prompt.this.m_recvData.get(row)).get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        };
        this.m_model.setRowHeaderHidden();
        this.m_model.setColWidth(new int[]{65, 100, 300, 100});
        this.m_table = new AppTable(this.m_model);
        this.setPrintableComponent(this.m_table);
        this.m_topPanel = new P2006PromptTopPanel(this, this.m_langList);
        this.m_topPanel.setSelectedLanguage(this.m_dfltLangIndex);
        this.m_table.getTable().addMouseListener(this.m_tableListener);
        this.m_jspTop.setPreferredSize(new Dimension(800, 50));
        this.m_jspTop.getViewport().setView(this.m_topPanel);
        JPanel pagePanel = new JPanel(new BorderLayout());
        pagePanel.add((Component)this.m_table, "Center");
        pagePanel.add((Component)this.m_btnPanel, "North");
        this.m_cbPage.setSelectedIndex(AppGlobal.g_2006pageIndex);
        this.m_contentPane.add(pagePanel);
    }

    private void getDirList() {
        ArrayList dirList = m_ftpClient.getDirList(String.valueOf(AppGlobal.g_vmDir) + "/pmt/");
        this.m_langList = new String[dirList.size()];
        int i2 = 0;
        while (i2 < dirList.size()) {
            try {
                this.m_langList[i2] = ((String[])this.m_htData.get(dirList.get(i2)))[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    private void getFileList(String dirPath) {
        ArrayList fileList = m_ftpClient.getFileList(dirPath);
        this.m_modPage.clear();
        this.m_fileType.clear();
        if (fileList != null && fileList.size() > 0) {
            int i2 = 0;
            while (i2 < fileList.size()) {
                if (((String)fileList.get(i2)).indexOf(".TXT") <= -1) {
                    if (((String)fileList.get(i2)).indexOf(".726") > -1) {
                        CODEC_TYPE = 0;
                        break;
                    }
                    if (((String)fileList.get(i2)).indexOf(".729") > -1) {
                        CODEC_TYPE = 1;
                        break;
                    }
                    CODEC_TYPE = 2;
                    break;
                }
                ++i2;
            }
            ArrayList<String> modPage = new ArrayList<String>();
            ArrayList<String> fileType = new ArrayList<String>();
            int i3 = 0;
            while (i3 < fileList.size()) {
                if (((String)fileList.get(i3)).indexOf(".TXT") > -1 || (((String)fileList.get(i3)).indexOf(".711") > -1 || ((String)fileList.get(i3)).indexOf(".726") > -1 || ((String)fileList.get(i3)).indexOf(".729") > -1) && this.fileNamedup((String)fileList.get(i3), fileList)) {
                    if (modPage.size() == 10) {
                        this.m_modPage.add(modPage);
                        this.m_fileType.add(fileType);
                    }
                    if (modPage.size() < 10) {
                        modPage.add(fileList.get(i3).toString());
                        if (((String)fileList.get(i3)).indexOf(".TXT") > -1) {
                            fileType.add("TXT");
                        } else {
                            fileType.add("OTHER");
                        }
                    } else {
                        modPage = new ArrayList();
                        fileType = new ArrayList();
                        modPage.add(fileList.get(i3).toString());
                        if (((String)fileList.get(i3)).indexOf(".TXT") > -1) {
                            fileType.add("TXT");
                        } else {
                            fileType.add("OTHER");
                        }
                    }
                }
                ++i3;
            }
            if (modPage.size() > 0 && modPage.size() < 11) {
                this.m_modPage.add(modPage);
                this.m_fileType.add(fileType);
            }
        }
    }

    private boolean fileNamedup(String filename, ArrayList list) {
        String name = filename.substring(0, filename.lastIndexOf("."));
        String ext = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
        if (!(ext.equals("711") || ext.equals("726") || ext.equals("729"))) {
            return false;
        }
        int i2 = 0;
        while (i2 < list.size()) {
            if (list.contains(String.valueOf(name) + ".TXT")) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private String getLanguage(String lang) {
        for (String key : this.m_htData.keySet()) {
            String[] value = (String[])this.m_htData.get(key);
            if (!value[1].equals(AppLang.getText(lang))) continue;
            return key;
        }
        return null;
    }

    private void reloadTable() {
        if (this.m_langList.length > 0) {
            m_dirPath = String.valueOf(AppGlobal.g_vmDir) + "/pmt/" + this.getLanguage(this.m_topPanel.getLanguage()) + "/";
            this.getFileList(m_dirPath);
            this.createComponents();
            this.m_model.setRowHeaderNames(this.m_rowTitle);
            this.m_table.tableChanged(null);
            this.setMouseListener();
        }
    }

    public void setMouseListener() {
        this.m_table.getTable().removeMouseListener(this.m_tableListener);
        this.m_table.getTable().addMouseListener(this.m_tableListener);
    }

    @Override
    public void actionToolButton(String command) {
        if (command.equals("upload")) {
            new P2006PromptUploadDlg(m_dirPath);
            getFile m_getFile = new getFile();
            m_getFile.start();
        } else if (command.equals("change_language")) {
            this.setPageIndex(0);
            m_dirPath = String.valueOf(AppGlobal.g_vmDir) + "/pmt/" + this.getLanguage(this.m_topPanel.getLanguage()) + "/";
            m_ftpClient.connect();
            this.getFileInfo();
            this.reloadTable();
            m_ftpClient.disConnect();
            AppGlobal.g_2006reloadLang = this.getLanguage(this.m_topPanel.getLanguage());
        } else if (command.equals("search")) {
            String search = this.m_topPanel.getSearch();
            int keyIndex = this.m_topPanel.getSearchIndex() + 1;
            if (search.equals("")) {
                int i2 = 0;
                while (i2 < this.m_recvData.size()) {
                    this.m_table.setRowDisplay(i2, 22);
                    ++i2;
                }
            } else {
                int i3 = 0;
                while (i3 < this.m_recvData.size()) {
                    String temp = ((JLabel)this.m_model.getValueAt(i3, keyIndex)).getText();
                    if (temp.indexOf(search) < 0) {
                        this.m_table.setRowHidden(i3);
                    } else {
                        this.m_table.setRowDisplay(i3, 22);
                    }
                    ++i3;
                }
            }
        } else if (command.equals("call")) {
            String call = this.m_topPanel.getCall();
            if (!call.equals("")) {
                byte[] uploadData = new byte[25];
                AppFunctions.str2byte(uploadData, 0, 24, call);
                uploadData[24] = 0;
                this.m_pageInfo.setDownMsgType((byte)-64);
                this.m_pageInfo.setReqData(uploadData);
                boolean ret = AppComm.getInstance().requestDownload(this.m_pageInfo);
                if (ret) {
                    JOptionPane.showMessageDialog(null, AppLang.getText(String.valueOf(this.m_topPanel.getCall()) + " answered"));
                }
            }
        } else if (command.equals("add")) {
            if (this.m_modPage.size() > 0) {
                ArrayList thisPage = (ArrayList)this.m_modPage.get(this.m_pageIndex);
                new P2006PromptDetailDlg(thisPage, this.m_langList, m_dirPath, 0, this.m_topPanel.getSelectedLanguage(), false);
                m_ftpClient.connect();
                this.reloadTable();
                m_ftpClient.disConnect();
            }
        } else if (command.equals("delete")) {
            ArrayList delData = new ArrayList();
            int i4 = 0;
            while (i4 < this.m_recvData.size()) {
                Object obj = this.m_model.getValueAt(i4, 0);
                if (obj instanceof JCheckBox && ((JCheckBox)obj).isSelected()) {
                    delData.add(this.m_recvData.get(i4));
                }
                ++i4;
            }
            if (delData.size() > 0) {
                new P2006PromptDeleteDlg(delData, m_dirPath);
                m_ftpClient.connect();
                this.getFileList(m_dirPath);
                m_ftpClient.disConnect();
                if (this.m_pageIndex == this.m_modPage.size() - 1) {
                    this.m_cbPage.setSelectedIndex(this.m_pageIndex);
                } else if (this.m_pageIndex - 1 == this.m_modPage.size() - 1) {
                    this.m_cbPage.setSelectedIndex(this.m_pageIndex - 1);
                } else {
                    this.m_cbPage.setSelectedIndex(this.m_pageIndex);
                }
            } else {
                JOptionPane.showMessageDialog(null, AppPageMessage.getErrorMsg(6));
            }
        } else if (command.equals("DirPage")) {
            this.setPageIndex(this.m_cbPage.getSelectedIndex());
            m_ftpClient.connect();
            this.reloadTable();
            m_ftpClient.disConnect();
        } else if (command.equals("FirstPage")) {
            if (this.m_modPage.size() > 0 && this.m_pageIndex != 0) {
                this.setPageIndex(0);
                m_ftpClient.connect();
                this.reloadTable();
                m_ftpClient.disConnect();
            }
        } else if (command.equals("PrevPage")) {
            if (this.m_modPage.size() > 0) {
                if (this.m_pageIndex == 0) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("Previous page not found"));
                    return;
                }
                this.setPageIndex(--this.m_pageIndex);
                m_ftpClient.connect();
                this.reloadTable();
                m_ftpClient.disConnect();
            }
        } else if (command.equals("NextPage")) {
            if (this.m_modPage.size() > 0) {
                if (this.m_pageIndex == this.m_modPage.size() - 1) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("Next page not found"));
                    return;
                }
                this.setPageIndex(++this.m_pageIndex);
                m_ftpClient.connect();
                this.reloadTable();
                m_ftpClient.disConnect();
            }
        } else if (command.equals("LastPage")) {
            if (this.m_modPage.size() > 0 && this.m_pageIndex != this.m_modPage.size() - 1) {
                this.setPageIndex(this.m_modPage.size() - 1);
                m_ftpClient.connect();
                this.reloadTable();
                m_ftpClient.disConnect();
            }
        } else {
            this.actionPageToolButton(command);
        }
    }

    @Override
    public void createPage() {
    }

    private class PrmptTableListener
    extends MouseAdapter {
        private PrmptTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() >= 2 && P2006Prompt.this.m_table.getTable().getSelectedColumn() == 1 && P2006Prompt.this.m_recvData != null) {
                int rowIdx = P2006Prompt.this.m_table.getTable().getSelectedRow();
                ArrayList thisPage = (ArrayList)P2006Prompt.this.m_modPage.get(P2006Prompt.this.m_pageIndex);
                new P2006PromptDetailDlg(thisPage, P2006Prompt.this.m_langList, m_dirPath, rowIdx, P2006Prompt.this.m_topPanel.getSelectedLanguage(), true);
                m_ftpClient.connect();
                P2006Prompt.this.reloadTable();
                m_ftpClient.disConnect();
            }
        }
    }

    class getFile
    extends Thread {
        getFile() {
        }

        @Override
        public void run() {
            AppGlobal.showProgress("", String.valueOf(AppLang.getText("Get File Information")) + "...");
            m_ftpClient.connect();
            P2006Prompt.this.getFileInfo();
            P2006Prompt.this.reloadTable();
            m_ftpClient.disConnect();
            AppGlobal.hideProgress();
        }
    }
}

