/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppFTPClient;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.pages.AppPageMessage;
import com.sec.osdm.pages.AppRequestInfo;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.vmaa.P2006Prompt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class P2006PromptDetailDlg
extends JDialog
implements ActionListener {
    private JPanel m_btnPan = new JPanel(new FlowLayout());
    private P2006PromptDetailDlg m_thisObject = null;
    private boolean m_bBtnflag = false;
    private JButton m_btnClose = new JButton(AppLang.getText("Close"));
    private JButton m_btnSave_Exit = new JButton(AppLang.getText("Save&Exit"));
    private JButton m_btnReload = new JButton(AppLang.getText("Reload"));
    private JButton m_btnSave = new JButton(AppLang.getText("Save"));
    private JButton m_btnPrev = new JButton(AppLang.getText("Prev"));
    private JButton m_btnNext = new JButton(AppLang.getText("Next"));
    private JLabel m_lbtemp = new JLabel("   ");
    private JButton m_btnConfirm = new JButton(AppLang.getText("Confirm"));
    private AppTextBox m_ptnPrompNum = null;
    private AppComboBox m_comboLang = null;
    private AppTextBox m_tfLength = null;
    private AppTextBox m_tfRecord = null;
    private String[][] m_rowName = new String[][]{{"Prompt Number"}, {"Language"}, {"Length(sec)"}, {"Recorded"}};
    private String[][] m_colName = new String[][]{{"Prompt Recording Studio"}};
    private AppTable m_table = null;
    private AppTableModel m_model = null;
    private AppFTPClient m_ftp = new AppFTPClient();
    private JPanel m_pagePanel = new JPanel();
    private JTextArea m_txtArea = new JTextArea();
    private AppLayout m_layout = null;
    private ArrayList m_fileList = null;
    private String[] m_langData = null;
    private String m_dirPath = null;
    private int m_iSelIdx = 0;
    private int m_langIdx = 0;
    private Hashtable m_hmDirectory = new Hashtable();

    public P2006PromptDetailDlg(ArrayList fileList, String[] langData, String dirPath, int selIndex, int langIdx, boolean btnPreNex) {
        super((Frame)AppGlobal.g_frmMain, true);
        this.m_hmDirectory.put(AppLang.getText("English, American"), new String[]{"1", "en_us"});
        this.m_hmDirectory.put(AppLang.getText("Korean, Korea"), new String[]{"2", "kr_kr"});
        this.m_hmDirectory.put(AppLang.getText("Spanish, Castillian"), new String[]{"3", "sp_ca"});
        this.m_hmDirectory.put(AppLang.getText("French, Canada"), new String[]{"4", "fr_ca"});
        this.m_hmDirectory.put(AppLang.getText("Danish, Denmark"), new String[]{"5", "da_de"});
        this.m_hmDirectory.put(AppLang.getText("Dutch, Holland"), new String[]{"6", "du_ho"});
        this.m_hmDirectory.put(AppLang.getText("German, Austria"), new String[]{"7", "ge_as"});
        this.m_hmDirectory.put(AppLang.getText("Italian, Italy"), new String[]{"8", "it_it"});
        this.m_hmDirectory.put(AppLang.getText("Portuguese, Portugal"), new String[]{"9", "po_po"});
        this.m_hmDirectory.put(AppLang.getText("Russian, Russia"), new String[]{"10", "ru_ru"});
        this.m_hmDirectory.put(AppLang.getText("Spanish, Spain"), new String[]{"11", "sp_sp"});
        this.m_hmDirectory.put(AppLang.getText("Swedish, Sweden"), new String[]{"12", "sw_sw"});
        this.m_hmDirectory.put(AppLang.getText("English, British"), new String[]{"13", "en_gb"});
        this.m_hmDirectory.put(AppLang.getText("English, Australia"), new String[]{"14", "en_as"});
        this.m_hmDirectory.put(AppLang.getText("German, German"), new String[]{"15", "ge_ge"});
        this.m_hmDirectory.put(AppLang.getText("Finnish, Finland"), new String[]{"16", "fi_fi"});
        this.m_hmDirectory.put(AppLang.getText("Greek, Greece"), new String[]{"17", "gr_gr"});
        AppGlobal.g_dialogList.add(this);
        this.setIconImage(AppImages.Img_Logo);
        this.m_thisObject = this;
        this.m_bBtnflag = btnPreNex;
        this.m_fileList = fileList;
        this.m_dirPath = dirPath;
        this.m_iSelIdx = selIndex;
        this.m_langData = langData;
        this.m_langIdx = langIdx;
        this.setDialog(btnPreNex);
        this.createComponent();
        if (this.m_bBtnflag) {
            this.sendPromptRecord();
        }
        this.createTable();
        this.setTitleNames(this.m_ptnPrompNum.getText().trim());
        this.add((Component)this.m_pagePanel, "Center");
        this.add((Component)this.m_btnPan, "South");
        this.setVisible(true);
    }

    private String getFileDescription(String Path2) {
        try {
            if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
                this.m_ftp.setServerIP(AppNetwork.m_address_SVMi20i);
                this.m_ftp.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
            }
            this.m_ftp.connect();
            ArrayList m_data = this.m_ftp.getFileContents(Path2);
            this.m_ftp.disConnect();
            if (m_data.size() > 0) {
                String contentData = "";
                int j2 = 0;
                while (j2 < m_data.size()) {
                    contentData = String.valueOf(contentData) + (String)m_data.get(j2) + "\n";
                    ++j2;
                }
                return contentData;
            }
            return "";
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    private void setDialog(boolean btnPreNex) {
        this.setSize(690, 450);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        this.m_btnClose.addActionListener(this);
        this.m_btnClose.setActionCommand("close");
        this.m_btnSave_Exit.addActionListener(this);
        this.m_btnSave_Exit.setActionCommand("save_exit");
        this.m_btnReload.addActionListener(this);
        this.m_btnReload.setActionCommand("reload");
        this.m_btnSave.addActionListener(this);
        this.m_btnSave.setActionCommand("save");
        this.m_btnPrev.addActionListener(this);
        this.m_btnPrev.setActionCommand("prev");
        this.m_btnNext.addActionListener(this);
        this.m_btnNext.setActionCommand("next");
        this.m_btnConfirm.addActionListener(this);
        this.m_btnConfirm.setActionCommand("confirm");
        AppGlobal.fixSize(this.m_btnSave, new Dimension(90, 22));
        AppGlobal.fixSize(this.m_btnSave_Exit, new Dimension(160, 22));
        AppGlobal.fixSize(this.m_btnReload, new Dimension(100, 22));
        AppGlobal.fixSize(this.m_btnClose, new Dimension(90, 22));
        AppGlobal.fixSize(this.m_btnPrev, new Dimension(90, 22));
        AppGlobal.fixSize(this.m_btnNext, new Dimension(90, 22));
        this.m_btnSave.setFont(AppGlobal.g_btnFont);
        this.m_btnSave_Exit.setFont(AppGlobal.g_btnFont);
        this.m_btnReload.setFont(AppGlobal.g_btnFont);
        this.m_btnClose.setFont(AppGlobal.g_btnFont);
        this.m_btnPrev.setFont(AppGlobal.g_btnFont);
        this.m_btnNext.setFont(AppGlobal.g_btnFont);
        if (btnPreNex) {
            this.m_btnPan.add(this.m_btnPrev);
            this.m_btnPan.add(this.m_btnNext);
            this.m_btnPan.add(this.m_lbtemp);
        } else {
            this.m_btnSave.setEnabled(false);
            this.m_btnSave_Exit.setEnabled(false);
        }
        this.m_btnPan.add(this.m_btnSave);
        this.m_btnPan.add(this.m_btnSave_Exit);
        this.m_btnPan.add(this.m_btnReload);
        this.m_btnPan.add(this.m_btnClose);
        this.m_layout = new AppLayout(this.m_pagePanel, this.getWidth(), this.getHeight());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                P2006PromptDetailDlg.this.m_thisObject.dispose();
                if (AppGlobal.g_dialogList.size() > 0) {
                    AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                }
            }
        });
    }

    private void createTable() {
        if (!this.m_bBtnflag) {
            this.m_colName = new String[][]{{"Prompt Recording Studio", "Confirm"}};
        }
        this.m_model = new AppTableModel(this.m_rowName, this.m_colName, ""){

            @Override
            public Object getValueAt(int row, int col) {
                switch (row) {
                    case 0: {
                        if (col == 1) {
                            return P2006PromptDetailDlg.this.m_btnConfirm;
                        }
                        return P2006PromptDetailDlg.this.m_ptnPrompNum;
                    }
                    case 1: {
                        if (col == 1) {
                            return null;
                        }
                        return P2006PromptDetailDlg.this.m_comboLang;
                    }
                    case 2: {
                        if (col == 1) {
                            return null;
                        }
                        return P2006PromptDetailDlg.this.m_tfLength;
                    }
                    case 3: {
                        if (col == 1) {
                            return null;
                        }
                        return P2006PromptDetailDlg.this.m_tfRecord;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (row == 1 && col == 1) {
                    return false;
                }
                return row != 2 && row != 3;
            }
        };
        this.m_model.setRowWidth(new int[]{100});
        this.m_model.setColWidth(new int[]{300, 100});
        this.m_table = new AppTable(this.m_model);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createTitledBorder(AppLang.getText("Description")));
        scrollPane.getViewport().add((Component)this.m_txtArea, null);
        this.m_layout.addComponent(this.m_table, 5, 5, 675, 109);
        this.m_layout.addComponent(scrollPane, 5, 124, 675, 250);
    }

    private void createComponent() {
        this.m_ptnPrompNum = new AppTextBox(9, 4, 0, 9999);
        this.m_comboLang = new AppComboBox(this.m_langData);
        this.m_tfLength = new AppTextBox();
        this.m_tfRecord = new AppTextBox();
        if (this.m_bBtnflag) {
            String tmpstr = (String)this.m_fileList.get(this.m_iSelIdx);
            int idx = tmpstr.indexOf(".");
            this.m_ptnPrompNum.setText(tmpstr.substring(0, idx));
            String ext = tmpstr.substring(idx + 1, tmpstr.length());
            ((JTextField)this.m_ptnPrompNum.getComponent()).setEditable(false);
            this.m_comboLang.setSelectedIndex(this.m_langIdx);
            String temp = P2006Prompt.getLength(tmpstr);
            if (temp != null) {
                this.m_tfLength.setText(temp);
            } else {
                this.m_tfLength.setText("0");
            }
            temp = P2006Prompt.m_htMakeFileDate.get(tmpstr);
            if (temp != null) {
                this.m_tfRecord.setText(temp);
            } else {
                this.m_tfRecord.setText("");
            }
            if (!ext.toUpperCase().equals("TXT")) {
                this.m_txtArea.setText("");
            } else {
                this.m_txtArea.setText(this.getFileDescription(String.valueOf(this.m_dirPath) + (String)this.m_fileList.get(this.m_iSelIdx)));
            }
        } else {
            ((JTextField)this.m_ptnPrompNum.getComponent()).setEditable(true);
            this.m_comboLang.setSelectedIndex(this.m_langIdx);
            this.m_tfLength.setText("");
            this.m_tfRecord.setText("");
            this.m_txtArea.setText("");
        }
    }

    private void setTitleNames(String titleNames) {
        this.setTitle(String.valueOf(AppLang.getText("Prompt Recording Studio")) + "(" + titleNames + ")");
    }

    private boolean writeFileData(String systemPath) {
        File file = new File(String.valueOf(AppProperty.m_runDirectory) + this.m_ptnPrompNum.getText().trim() + ".TXT");
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        String szContent = this.m_txtArea.getText();
        try {
            ((OutputStream)out).write(szContent.getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String localPath = String.valueOf(AppProperty.m_runDirectory) + this.m_ptnPrompNum.getText().trim() + ".TXT";
        try {
            ((OutputStream)out).close();
            if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
                this.m_ftp.setServerIP(AppNetwork.m_address_SVMi20i);
                this.m_ftp.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
            }
            this.m_ftp.connect();
            this.m_ftp.putFile(localPath, String.valueOf(systemPath) + this.m_ptnPrompNum.getText().trim() + ".TXT");
            this.m_ftp.disConnect();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent al) {
        String command = al.getActionCommand();
        if (command.equals("close")) {
            this.m_thisObject.dispose();
            if (AppGlobal.g_dialogList.size() > 0) {
                AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
            }
        } else if (command.equals("save_exit")) {
            this.m_table.getTable().editingStopped(null);
            String path = String.valueOf(AppGlobal.g_vmDir) + "/pmt/" + ((String[])this.m_hmDirectory.get(this.m_comboLang.getSelectedItem()))[1] + "/";
            if (this.writeFileData(path) && this.sendSavePrompt(path)) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Success"));
            }
            this.m_thisObject.dispose();
            if (AppGlobal.g_dialogList.size() > 0) {
                AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
            }
        } else if (command.equals("reload")) {
            this.createComponent();
            if (this.m_bBtnflag) {
                this.sendPromptRecord();
            } else {
                this.m_ptnPrompNum.setText("");
                this.setTitleNames(this.m_ptnPrompNum.getText().trim());
                this.m_comboLang.setSelectedIndex(0);
                this.m_tfLength.setText("");
                this.m_tfRecord.setText("");
                this.m_txtArea.setText("");
                this.m_btnSave.setEnabled(false);
                this.m_btnSave_Exit.setEnabled(false);
            }
            this.m_table.tableChanged(null);
        } else if (command.equals("save")) {
            this.m_table.getTable().editingStopped(null);
            String path = String.valueOf(AppGlobal.g_vmDir) + "/pmt/" + ((String[])this.m_hmDirectory.get(this.m_comboLang.getSelectedItem()))[1] + "/";
            if (this.writeFileData(path) && this.sendSavePrompt(path)) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Success"));
            }
        } else if (command.equals("prev")) {
            --this.m_iSelIdx;
            if (this.m_iSelIdx < 0) {
                JOptionPane.showMessageDialog(null, AppPageMessage.getErrorMsg(14));
                ++this.m_iSelIdx;
                return;
            }
            this.createComponent();
            this.sendPromptRecord();
            this.setTitleNames(this.m_ptnPrompNum.getText().trim());
            this.m_table.tableChanged(null);
        } else if (command.equals("next")) {
            ++this.m_iSelIdx;
            if (this.m_iSelIdx >= this.m_fileList.size()) {
                JOptionPane.showMessageDialog(null, AppPageMessage.getErrorMsg(13));
                --this.m_iSelIdx;
                return;
            }
            this.createComponent();
            this.sendPromptRecord();
            this.setTitleNames(this.m_ptnPrompNum.getText().trim());
            this.m_table.tableChanged(null);
        } else if (command.equals("confirm")) {
            this.m_table.getTable().editingStopped(null);
            String tmpstr = String.valueOf(this.m_ptnPrompNum.getText().trim()) + ".TXT";
            if (tmpstr.equals("")) {
                JOptionPane.showMessageDialog(null, AppPageMessage.getErrorMsg(15));
                return;
            }
            boolean bol = false;
            int i2 = 0;
            while (i2 < this.m_fileList.size()) {
                if (tmpstr.equals((String)this.m_fileList.get(i2))) {
                    this.m_txtArea.setText(this.getFileDescription(String.valueOf(AppGlobal.g_vmDir) + "/pmt/" + ((String[])this.m_hmDirectory.get(this.m_comboLang.getSelectedItem()))[1] + "/" + this.m_ptnPrompNum.getText().trim() + ".TXT"));
                    bol = true;
                    break;
                }
                ++i2;
            }
            if (!bol) {
                this.m_txtArea.setText("");
            }
            this.m_btnSave.setEnabled(true);
            this.m_btnSave_Exit.setEnabled(true);
            this.sendPromptRecord();
            this.setTitleNames(this.m_ptnPrompNum.getText().trim());
            this.m_table.tableChanged(null);
        }
    }

    private void sendPromptRecord() {
        byte[] m_reqData = new byte[12];
        m_reqData[1] = Byte.parseByte(((String[])this.m_hmDirectory.get(this.m_comboLang.getSelectedItem()))[0]);
        AppFunctions.str2byte(m_reqData, 2, 4, this.m_ptnPrompNum.getText().trim());
        AppRequestInfo reqInfo = new AppRequestInfo("2007");
        reqInfo.setDownMsgType((byte)-63);
        reqInfo.setReqData(m_reqData);
        boolean ret = AppComm.getInstance().requestDownload(reqInfo.getPageInfo());
    }

    private boolean sendSavePrompt(String systemPath) {
        byte[] upData = new byte[65];
        upData[0] = 1;
        AppFunctions.str2byte(upData, 1, 64, String.valueOf(systemPath) + this.m_ptnPrompNum.getText().trim() + ".TXT");
        AppRequestInfo m_reqInfo = new AppRequestInfo("2007");
        m_reqInfo.setDownMsgType((byte)-56);
        m_reqInfo.setReqData(upData);
        m_reqInfo.setResult(AppComm.getInstance().requestDownload(m_reqInfo.getPageInfo()));
        return m_reqInfo.getResult();
    }
}

