/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa.openblock;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppDownRequest;
import com.sec.osdm.io.AppFTPClient;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.pages.AppPageInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class AppDescriptionDlg
extends JDialog
implements ActionListener {
    private AppDescriptionDlg m_thisObject = null;
    private JPanel m_btnPan = new JPanel(new FlowLayout());
    private JButton m_btnClose = new JButton(AppLang.getText("Close"));
    private JTextArea m_txtArea = new JTextArea();
    private JLabel m_lbDesc = new JLabel(AppLang.getText("Description"));
    private String m_promptData = "";
    private AppLayout m_lmContent = null;
    private JPanel m_contentPane = new JPanel();
    private AppFTPClient m_ftpClient = new AppFTPClient();
    private String m_dirPath = String.valueOf(AppGlobal.g_vmDir) + "/pmt/";
    private String m_langDir = "en_us";
    public static ArrayList m_fileList = null;
    public static ArrayList m_DirList = null;

    public AppDescriptionDlg() {
        m_fileList = null;
        m_DirList = null;
    }

    public AppDescriptionDlg(String strPrmpt, JDialog dialog) {
        super(dialog, AppLang.getText("Description"), true);
        AppGlobal.g_dialogList.add(this);
        this.setIconImage(AppImages.Img_Logo);
        this.m_contentPane.setBorder(new LineBorder(Color.darkGray));
        this.m_lmContent = new AppLayout(this.m_contentPane, 1024, 720);
        this.m_promptData = strPrmpt;
        this.m_thisObject = this;
        this.m_langDir = this.getLangDir();
        this.initial();
        this.setComponent();
        this.setVisible(true);
    }

    private String getLangDir() {
        AppPageInfo pageInfo = new AppPageInfo("2005");
        AppComm comm2 = AppComm.getInstance();
        pageInfo.setReqData(new byte[4]);
        pageInfo.setDownMsgType((byte)-47);
        pageInfo.setUpMsgType((byte)-14);
        if (AppDownRequest.requestDownloadByPageInfo(comm2, pageInfo)) {
            ArrayList data = (ArrayList)pageInfo.getRecvData().get(0);
            String defaultLang = "" + data.get(79);
            if (defaultLang.equals("1")) {
                return "en_us";
            }
            if (defaultLang.equals("2")) {
                return "kr_kr";
            }
            if (defaultLang.equals("3")) {
                return "sp_ca";
            }
            if (defaultLang.equals("4")) {
                return "fr_ca";
            }
            if (defaultLang.equals("5")) {
                return "da_de";
            }
            if (defaultLang.equals("6")) {
                return "du_ho";
            }
            if (defaultLang.equals("7")) {
                return "ge_as";
            }
            if (defaultLang.equals("8")) {
                return "it_it";
            }
            if (defaultLang.equals("9")) {
                return "po_po";
            }
            if (defaultLang.equals("10")) {
                return "ru_ru";
            }
            if (defaultLang.equals("11")) {
                return "sp_sp";
            }
            if (defaultLang.equals("12")) {
                return "sw_sw";
            }
            if (defaultLang.equals("13")) {
                return "en_gb";
            }
            if (defaultLang.equals("14")) {
                return "en_as";
            }
            if (defaultLang.equals("15")) {
                return "ge_ge";
            }
            if (defaultLang.equals("16")) {
                return "fi_fi";
            }
            if (defaultLang.equals("17")) {
                return "gr_gr";
            }
            if (defaultLang.equals("18")) {
                return "tr_tr";
            }
        }
        return "en_us";
    }

    private void initial() {
        this.m_btnClose.addActionListener(this);
        this.m_btnClose.setActionCommand("close");
        AppGlobal.fixSize(this.m_btnClose, new Dimension(100, 22));
        this.setSize(650, 400);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppDescriptionDlg.this.m_thisObject.dispose();
                if (AppGlobal.g_dialogList.size() > 0) {
                    AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                }
            }
        });
    }

    private void setComponent() {
        this.m_lbDesc.setOpaque(true);
        this.m_lbDesc.setHorizontalAlignment(0);
        this.m_lbDesc.setFont(new Font("Tohoma", 1, 13));
        this.m_lbDesc.setBackground(new Color(237, 244, 236));
        this.m_txtArea.setOpaque(true);
        this.m_txtArea.setBorder(new LineBorder(Color.DARK_GRAY));
        this.m_txtArea.setEditable(false);
        this.m_lmContent.addComponent(this.m_lbDesc, 280, 15, 100, 30);
        this.m_lmContent.addComponent(this.getDescriptionData(this.m_txtArea), 15, 60, 615, 255);
        this.m_btnPan.add(this.m_btnClose);
        this.add((Component)this.m_contentPane, "Center");
        this.add((Component)this.m_btnPan, "South");
    }

    private JTextArea getDescriptionData(JTextArea txtArea) {
        if (this.m_promptData == null) {
            txtArea.setText(AppLang.getText("There is no entry."));
        } else if (this.isExistFile()) {
            txtArea.setText(this.getFileContents(this.m_dirPath, String.valueOf(this.m_promptData) + ".TXT"));
        } else {
            txtArea.setText(AppLang.getText("There is no entry."));
        }
        return txtArea;
    }

    private ArrayList getFileList() {
        if (m_fileList == null) {
            if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
                this.m_ftpClient.setServerIP(AppNetwork.m_address_SVMi20i);
                this.m_ftpClient.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
            }
            this.m_ftpClient.connect();
            ArrayList fileList = this.m_ftpClient.getFileList(String.valueOf(this.m_dirPath) + this.m_langDir);
            this.m_ftpClient.disConnect();
            if (fileList != null && fileList.size() > 0) {
                m_fileList = new ArrayList();
                int i2 = 0;
                while (i2 < fileList.size()) {
                    String tmpStr = ((String)fileList.get(i2)).toUpperCase().toString();
                    if (tmpStr.indexOf(".TXT") > -1) {
                        m_fileList.add(tmpStr);
                    }
                    ++i2;
                }
            }
        }
        return m_fileList;
    }

    private ArrayList getDirList() {
        if (m_DirList == null) {
            if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
                this.m_ftpClient.setServerIP(AppNetwork.m_address_SVMi20i);
                this.m_ftpClient.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
            }
            this.m_ftpClient.connect();
            m_DirList = this.m_ftpClient.getDirList(this.m_dirPath);
            this.m_ftpClient.disConnect();
        }
        return m_DirList;
    }

    private String getFileContents(String dirPath, String fileName) {
        if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
            this.m_ftpClient.setServerIP(AppNetwork.m_address_SVMi20i);
            this.m_ftpClient.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
        }
        this.m_ftpClient.connect();
        ArrayList content = this.m_ftpClient.getFileContents(String.valueOf(dirPath) + this.m_langDir + "/" + fileName);
        this.m_ftpClient.disConnect();
        String contentData = "";
        int i2 = 0;
        while (i2 < content.size()) {
            contentData = String.valueOf(contentData) + (String)content.get(i2) + "\n";
            ++i2;
        }
        return contentData;
    }

    private boolean isExistFile() {
        boolean ret = false;
        ArrayList dirList = this.getDirList();
        ArrayList fileList = this.getFileList();
        int i2 = 0;
        while (i2 < dirList.size()) {
            if (((String)dirList.get(i2)).trim().indexOf(this.m_langDir) < -1) {
                return false;
            }
            ++i2;
        }
        if (fileList != null) {
            i2 = 0;
            while (i2 < fileList.size()) {
                if (((String)fileList.get(i2)).trim().indexOf(this.m_promptData) > -1) {
                    ret = true;
                    break;
                }
                ++i2;
            }
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        if (command.equals("close")) {
            this.m_thisObject.dispose();
            if (AppGlobal.g_dialogList.size() > 0) {
                AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
            }
        }
    }
}

