/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhcpbatch;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.common.DhcpCliPrint;
import com.sun.dhcpmgr.cli.common.DhcpCliProgram;
import com.sun.dhcpmgr.cli.dhcpbatch.DhcpCommand;
import com.sun.dhcpmgr.cli.dhcpbatch.ResourceStrings;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;

public class DhcpBatch
extends DhcpCliProgram {
    public static final String SIGNATURE = "dhcpbatch: ";
    String inputSource = null;
    boolean verbose = false;

    public DhcpBatch() {
    }

    public DhcpBatch(String string) {
        this();
        this.inputSource = string;
    }

    public int execute() {
        int n = 0;
        InputStream inputStream = System.in;
        if (this.inputSource != null) {
            try {
                inputStream = new FileInputStream(this.inputSource);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object[] objectArray = new Object[]{this.inputSource};
                DhcpBatch.printErrMessage(this.getString("dhcpbatch_file_not_found"), objectArray);
                return 4;
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[]{this.inputSource};
                DhcpBatch.printErrMessage(this.getString("dhcpbatch_open_failed"), objectArray);
                DhcpBatch.printErrMessage(DhcpCliFunction.getMessage(throwable));
                return 4;
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("> ");
        DhcpCommand dhcpCommand = new DhcpCommand();
        boolean bl = false;
        while (!bl) {
            try {
                String string = bufferedReader.readLine();
                if (string == null) {
                    bl = true;
                    continue;
                }
                if (string.length() != 0) {
                    if (string.charAt(0) == '#' && stringBuffer.length() == 2) continue;
                    stringBuffer.append(string);
                    if (string.charAt(string.length() - 1) == '\\') continue;
                }
                if (this.verbose) {
                    DhcpCliPrint.printMessage(stringBuffer.toString());
                }
                dhcpCommand.init(stringBuffer.substring(2));
                dhcpCommand.execute();
                stringBuffer.setLength(2);
            }
            catch (BridgeException bridgeException) {
                DhcpBatch.printErrMessage(DhcpCliFunction.getMessage(bridgeException));
                n = 4;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{this.inputSource};
                DhcpBatch.printErrMessage(this.getString("dhcpbatch_read_failed"), objectArray);
                DhcpBatch.printErrMessage(DhcpCliFunction.getMessage(iOException));
                bl = true;
                n = 4;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return n;
    }

    public String getManPage() {
        return null;
    }

    public String getString(String string) {
        return ResourceStrings.getString(string);
    }

    public static void main(String[] stringArray) {
        DhcpBatch dhcpBatch = new DhcpBatch();
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else if (stringArray.length > 1) {
            DhcpCliPrint.printErrMessage(dhcpBatch.getString("dhcpbatch_usage"));
            return;
        }
        dhcpBatch.setInputSource(string);
        dhcpBatch.execute();
    }

    public static void printErrMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer(SIGNATURE);
        stringBuffer.append(string);
        DhcpCliPrint.printErrMessage(stringBuffer.toString());
    }

    public static void printErrMessage(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(SIGNATURE);
        stringBuffer.append(string);
        MessageFormat messageFormat = new MessageFormat(stringBuffer.toString());
        DhcpCliPrint.printErrMessage(messageFormat.format(objectArray));
    }

    public void setInputSource(String string) {
        this.inputSource = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }
}

