/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.pntadm;

import com.sun.dhcpmgr.bridge.NoTableException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.pntadm.PntAdmFunction;
import com.sun.dhcpmgr.data.Network;

public class RemoveNetworkTable
extends PntAdmFunction {
    static final int[] supportedOptions = new int[]{114, 117, 112};

    public RemoveNetworkTable() {
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        int n = 0;
        try {
            Network network = DhcpCliFunction.getNetMgr().getNetwork(this.networkName);
            if (network == null) {
                this.printErrMessage(this.getString("network_name_error"));
                return 3;
            }
            DhcpCliFunction.getNetMgr().deleteNetwork(network.toString(), false, false, this.getDhcpDatastore());
        }
        catch (NoTableException noTableException) {
            this.printErrMessage(DhcpCliFunction.getMessage(noTableException));
            n = 2;
        }
        catch (Throwable throwable) {
            this.printErrMessage(DhcpCliFunction.getMessage(throwable));
            n = 3;
        }
        return n;
    }
}

