/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.bridge.HostExistsException;
import com.sun.dhcpmgr.bridge.NoTableException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.ErrorTable;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.client.ViewMacroDialog;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.ValidationException;
import com.sun.dhcpmgr.server.DhcpNetMgr;
import com.sun.dhcpmgr.ui.ExtendedCellRenderer;
import com.sun.dhcpmgr.ui.FieldLayout;
import com.sun.dhcpmgr.ui.HostnameField;
import com.sun.dhcpmgr.ui.IPAddressField;
import com.sun.dhcpmgr.ui.IntegerField;
import com.sun.dhcpmgr.ui.ProgressManager;
import com.sun.dhcpmgr.ui.Wizard;
import com.sun.dhcpmgr.ui.WizardStep;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;

public class AddressWizard
extends Wizard {
    private Network network;
    private int number = 10;
    private String comment = "";
    private String server = DataManager.get().getShortServerName();
    private IPAddress serverIP;
    private IPAddress startAddress;
    private boolean generateNames = false;
    private String baseName = DataManager.get().getShortServerName();
    private String macro = DataManager.get().getShortServerName();
    private boolean unusable = false;
    private boolean dynamic = true;
    private WizardTableModel addressTableModel;
    private Macro noMacro;
    static /* synthetic */ Class class$com$sun$dhcpmgr$data$IPAddress;
    static /* synthetic */ Class class$java$lang$String;

    public AddressWizard(Frame frame, Network network) {
        super(frame, "");
        Object[] objectArray = new String[]{network.toString()};
        this.setTitle(MessageFormat.format(ResourceStrings.getString("address_wizard_title"), objectArray));
        this.network = network;
        this.startAddress = this.network.getAddress();
        try {
            this.noMacro = new Macro(ResourceStrings.getString("no_macro_item"));
        }
        catch (ValidationException validationException) {
            System.err.println(validationException.getMessage());
        }
        this.addressTableModel = new WizardTableModel();
        this.addStep(new NumberStep());
        this.addStep(new ServerStep());
        this.addStep(new ConfirmStep());
        this.addStep(new ConfigureStep());
        this.addStep(new LeaseStep());
        this.addStep(new ReviewStep());
        this.showFirstStep();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void doFinish() {
        final ProgressManager progressManager = new ProgressManager(this, ResourceStrings.getString("add_wiz_progress"), "", 0, this.addressTableModel.getRowCount());
        final Runnable runnable = new Runnable(){

            public void run() {
                AddressWizard.this.reallyFinish();
            }
        };
        Thread thread = new Thread(){

            public void run() {
                Object object;
                DhcpNetMgr dhcpNetMgr = DataManager.get().getDhcpNetMgr();
                DhcpClientRecord dhcpClientRecord = new DhcpClientRecord();
                dhcpClientRecord.setExpiration(new Date(0L));
                dhcpClientRecord.setUnusable(unusable);
                dhcpClientRecord.setPermanent(dynamic ^ true);
                try {
                    dhcpClientRecord.setServerIP(serverIP);
                }
                catch (ValidationException validationException) {}
                if (macro.equals(noMacro.getKey())) {
                    dhcpClientRecord.setMacro("");
                } else {
                    dhcpClientRecord.setMacro(macro);
                }
                dhcpClientRecord.setComment(comment);
                ErrorTable errorTable = new ErrorTable(ResourceStrings.getString("address_column"), class$com$sun$dhcpmgr$data$IPAddress != null ? class$com$sun$dhcpmgr$data$IPAddress : (class$com$sun$dhcpmgr$data$IPAddress = AddressWizard.class$("com.sun.dhcpmgr.data.IPAddress")));
                int n = 0;
                while (n < addressTableModel.getRowCount()) {
                    object = addressTableModel.getAddressAt(n);
                    try {
                        dhcpClientRecord.setClientIP(((Address)object).addr);
                        dhcpClientRecord.setClientName(((Address)object).name);
                        dhcpNetMgr.addClient(dhcpClientRecord, network.toString());
                        progressManager.update(n + 1, ((Address)object).addr.toString());
                    }
                    catch (InterruptedException interruptedException) {
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                    catch (Throwable throwable) {
                        String string = throwable instanceof ExistsException ? ResourceStrings.getString("address_exists") : (throwable instanceof HostExistsException ? ResourceStrings.getString("host_exists") : throwable.getMessage());
                        errorTable.addError(((Address)object).addr, string);
                    }
                    ++n;
                }
                if (!errorTable.isEmpty()) {
                    object = new Runnable(errorTable, this){
                        private final /* synthetic */ AddressWizard this$0;
                        private final /* synthetic */ ErrorTable val$failedTable;
                        {
                            this.val$failedTable = errorTable;
                            this.this$0 = addressWizard;
                        }

                        public void run() {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = ResourceStrings.getString("add_wiz_error");
                            JScrollPane jScrollPane = new JScrollPane(this.val$failedTable);
                            Dimension dimension = this.val$failedTable.getPreferredScrollableViewportSize();
                            dimension.height = 80;
                            this.val$failedTable.setPreferredScrollableViewportSize(dimension);
                            objectArray[1] = jScrollPane;
                            JOptionPane.showMessageDialog(this.this$0, objectArray, ResourceStrings.getString("server_error_title"), 0);
                        }
                    };
                    try {
                        SwingUtilities.invokeAndWait((Runnable)object);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        thread.start();
    }

    public void doHelp() {
        DhcpmgrApplet.showHelp("address_wizard");
    }

    protected void reallyFinish() {
        super.doFinish();
    }

    class Address {
        IPAddress addr;
        String name;

        public Address() {
            this.addr = null;
            this.name = "";
        }

        public Address(int n, String string) {
            this.name = string;
            this.setAddr(n);
        }

        public Address(String string, String string2) {
            this.name = string2;
            this.setAddr(string);
        }

        public void setAddr(int n) {
            this.addr = new IPAddress(n);
        }

        public void setAddr(String string) {
            try {
                this.addr = new IPAddress(string);
            }
            catch (ValidationException validationException) {}
        }

        public String toString() {
            return this.addr.getHostAddress();
        }
    }

    class WizardTableModel
    extends AbstractTableModel {
        private Vector addrs = new Vector();

        WizardTableModel() {
        }

        public long generateAddresses() {
            if (!AddressWizard.this.network.containsAddress(AddressWizard.this.startAddress)) {
                return 0L;
            }
            int n = AddressWizard.this.network.getAddress().intValue();
            int n2 = AddressWizard.this.network.getMask().intValue();
            int n3 = AddressWizard.this.startAddress.intValue();
            this.addrs.removeAllElements();
            long l = (long)(n + ~n2) & 0xFFFFFFFFL;
            int n4 = 0;
            int n5 = n3 - n;
            if (n5 == 0) {
                ++n5;
            }
            Object[] objectArray = null;
            try {
                objectArray = (DhcpClientRecord[])DataManager.get().getClients(AddressWizard.this.network.getAddress().toString(), false).clone();
                Arrays.sort(objectArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            int n6 = 0;
            long l2 = 0L;
            while (n4 < AddressWizard.this.number) {
                long l3 = (long)(n + n5) & 0xFFFFFFFFL;
                if (l3 == l) break;
                if (objectArray != null) {
                    while (n6 < objectArray.length && (l2 = objectArray[n6].getBinaryAddress()) < l3) {
                        ++n6;
                    }
                }
                if (l2 != l3) {
                    Address address = AddressWizard.this.generateNames ? new Address((int)l3, String.valueOf(AddressWizard.this.baseName) + "-" + String.valueOf(n5)) : new Address((int)l3, "");
                    this.addrs.addElement(address);
                    ++n4;
                }
                ++n5;
            }
            this.fireTableDataChanged();
            return n4;
        }

        public Address getAddressAt(int n) {
            return (Address)this.addrs.elementAt(n);
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$com$sun$dhcpmgr$data$IPAddress != null ? class$com$sun$dhcpmgr$data$IPAddress : (class$com$sun$dhcpmgr$data$IPAddress = AddressWizard.class$("com.sun.dhcpmgr.data.IPAddress"));
            }
            return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AddressWizard.class$("java.lang.String"));
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return ResourceStrings.getString("address_column");
            }
            return ResourceStrings.getString("client_name_column");
        }

        public int getRowCount() {
            return this.addrs.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((Address)this.addrs.elementAt((int)n)).addr;
            }
            return ((Address)this.addrs.elementAt((int)n)).name;
        }
    }

    class NumberStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();
        private IntegerField addressCount;
        private JTextField commentField;

        public NumberStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("add_wiz_explain"), 4, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            this.stepBox.add(Box.createVerticalGlue());
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("add_wiz_count_explain"), 1, 45));
            JLabel jLabel = new JLabel(ResourceStrings.getString("add_wiz_count_label"));
            this.addressCount = new IntegerField();
            this.addressCount.setMaximumSize(this.addressCount.getPreferredSize());
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(10));
            box.add(jLabel);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.addressCount);
            box.add(Box.createHorizontalGlue());
            this.stepBox.add(box);
            this.stepBox.add(Box.createVerticalStrut(10));
            this.stepBox.add(Box.createVerticalGlue());
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("add_wiz_comment_explain"), 2, 45));
            jLabel = new JLabel(ResourceStrings.getString("add_wiz_comment_label"));
            this.commentField = new JTextField("", 20);
            this.commentField.setMaximumSize(this.commentField.getPreferredSize());
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(10));
            box.add(jLabel);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.commentField);
            this.stepBox.add(box);
            this.stepBox.add(Box.createVerticalGlue());
            this.addressCount.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ NumberStep this$1;
                {
                    this.this$1 = numberStep;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    NumberStep.access$0(this.this$1).setForwardEnabled(documentEvent.getDocument().getLength() != 0);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            });
        }

        static /* synthetic */ AddressWizard access$0(NumberStep numberStep) {
            return numberStep.AddressWizard.this;
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("add_wiz_number_desc");
        }

        public void setActive(int n) {
            this.addressCount.setValue(AddressWizard.this.number);
            this.commentField.setText(AddressWizard.this.comment);
            AddressWizard.this.setForwardEnabled(this.addressCount.getValue() != 0);
        }

        public boolean setInactive(int n) {
            AddressWizard.this.number = this.addressCount.getValue();
            if (AddressWizard.this.number == 0) {
                JOptionPane.showMessageDialog(AddressWizard.this, ResourceStrings.getString("add_wiz_count_error"), ResourceStrings.getString("error_message"), 0);
                return false;
            }
            AddressWizard.this.comment = this.commentField.getText();
            return true;
        }
    }

    class ServerStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();
        private IPAddressField startField;
        private HostnameField baseNameField;
        private JCheckBox generateNamesBox;
        private HostnameField serverField;

        public ServerStep() {
            Object object;
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("add_wiz_server_explain"), 1, 45));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(ResourceStrings.getString("add_wiz_server_label")));
            box.add(Box.createHorizontalStrut(5));
            this.serverField = new HostnameField("", 15);
            this.serverField.setMaximumSize(this.serverField.getPreferredSize());
            box.add(this.serverField);
            box.add(Box.createHorizontalGlue());
            this.stepBox.add(box);
            this.stepBox.add(Box.createVerticalStrut(5));
            this.stepBox.add(Box.createVerticalGlue());
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("add_wiz_start_explain"), 2, 45));
            box = Box.createHorizontalBox();
            box.add(new JLabel(ResourceStrings.getString("add_wiz_start_label")));
            box.add(Box.createHorizontalStrut(5));
            this.startField = new IPAddressField();
            this.startField.setMaximumSize(this.startField.getPreferredSize());
            box.add(this.startField);
            this.stepBox.add(box);
            this.stepBox.add(Box.createVerticalStrut(5));
            this.stepBox.add(Box.createVerticalGlue());
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("add_wiz_generate_explain"), 4, 45));
            JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 0));
            this.generateNamesBox = new JCheckBox(ResourceStrings.getString("add_wiz_generate_label"));
            jPanel.add(this.generateNamesBox);
            this.generateNamesBox.setEnabled(true);
            try {
                object = DataManager.get().getDhcpServiceMgr().readDefaults();
                if (object.getHostsResource() == null) {
                    this.generateNamesBox.setEnabled(false);
                }
            }
            catch (BridgeException bridgeException) {}
            this.baseNameField = new HostnameField();
            this.baseNameField.setEnabled(false);
            this.baseNameField.setMaximumSize(this.baseNameField.getPreferredSize());
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(17));
            box.add(new JLabel(ResourceStrings.getString("add_wiz_rootname_label")));
            box.add(Box.createHorizontalStrut(5));
            box.add(this.baseNameField);
            jPanel.add(box);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalGlue());
            this.generateNamesBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServerStep this$1;
                {
                    this.this$1 = serverStep;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerStep.access$0(this.this$1).setEnabled(ServerStep.access$1(this.this$1).isSelected());
                }
            });
            object = new DocumentListener(this){
                private final /* synthetic */ ServerStep this$1;
                {
                    this.this$1 = serverStep;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    ServerStep.access$4(this.this$1).setForwardEnabled(ServerStep.access$2(this.this$1).getText().length() != 0 && ServerStep.access$3(this.this$1).getText().length() != 0);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            };
            this.startField.getDocument().addDocumentListener((DocumentListener)object);
            this.serverField.getDocument().addDocumentListener((DocumentListener)object);
        }

        static /* synthetic */ HostnameField access$0(ServerStep serverStep) {
            return serverStep.baseNameField;
        }

        static /* synthetic */ JCheckBox access$1(ServerStep serverStep) {
            return serverStep.generateNamesBox;
        }

        static /* synthetic */ IPAddressField access$2(ServerStep serverStep) {
            return serverStep.startField;
        }

        static /* synthetic */ HostnameField access$3(ServerStep serverStep) {
            return serverStep.serverField;
        }

        static /* synthetic */ AddressWizard access$4(ServerStep serverStep) {
            return serverStep.AddressWizard.this;
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("add_wiz_server_desc");
        }

        public void setActive(int n) {
            this.serverField.setText(AddressWizard.this.server);
            this.startField.setValue(AddressWizard.this.startAddress);
            this.baseNameField.setText(AddressWizard.this.baseName);
            this.generateNamesBox.setSelected(AddressWizard.this.generateNames);
            AddressWizard.this.setForwardEnabled(true);
        }

        public boolean setInactive(int n) {
            if (n == 1) {
                IPAddress iPAddress = this.startField.getValue();
                if (iPAddress == null) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("add_wiz_invalid_address"));
                    Object[] objectArray = new Object[]{this.startField.getText()};
                    JOptionPane.showMessageDialog(AddressWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return false;
                }
                if (!AddressWizard.this.network.containsAddress(iPAddress)) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("bad_network_address"));
                    Object[] objectArray = new Object[]{this.startField.getText(), AddressWizard.this.network.getAddress()};
                    JOptionPane.showMessageDialog(AddressWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return false;
                }
                try {
                    AddressWizard.this.serverIP = new IPAddress(this.serverField.getText());
                }
                catch (Throwable throwable) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("bad_server_name"));
                    Object[] objectArray = new Object[]{this.serverField.getText()};
                    JOptionPane.showMessageDialog(AddressWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("error_message"), 0);
                    return false;
                }
            }
            AddressWizard.this.server = this.serverField.getText();
            AddressWizard.this.startAddress = this.startField.getValue();
            AddressWizard.this.generateNames = this.generateNamesBox.isSelected();
            AddressWizard.this.baseName = this.baseNameField.getText();
            return true;
        }
    }

    class ConfirmStep
    implements WizardStep {
        private JPanel stepPanel = new JPanel(new BorderLayout(10, 10));
        private JTable addressTable;

        public ConfirmStep() {
            this.stepPanel.add((Component)Wizard.createTextArea(ResourceStrings.getString("add_wiz_confirm_explain"), 3, 45), "North");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
            JLabel jLabel = new JLabel(ResourceStrings.getString("add_wiz_confirm_label"));
            jPanel.add((Component)jLabel, "North");
            this.addressTable = new JTable(AddressWizard.this.addressTableModel);
            this.addressTable.setDefaultRenderer(class$com$sun$dhcpmgr$data$IPAddress != null ? class$com$sun$dhcpmgr$data$IPAddress : (class$com$sun$dhcpmgr$data$IPAddress = AddressWizard.class$("com.sun.dhcpmgr.data.IPAddress")), new ExtendedCellRenderer());
            this.addressTable.setRowSelectionAllowed(false);
            this.addressTable.setColumnSelectionAllowed(false);
            this.addressTable.setCellSelectionEnabled(false);
            JScrollPane jScrollPane = new JScrollPane(this.addressTable);
            jPanel.add((Component)jScrollPane, "Center");
            this.stepPanel.add((Component)jPanel, "Center");
        }

        public Component getComponent() {
            return this.stepPanel;
        }

        public String getDescription() {
            return ResourceStrings.getString("add_wiz_confirm_desc");
        }

        public void setActive(int n) {
            if (n == 1) {
                long l = AddressWizard.this.addressTableModel.generateAddresses();
                if (l == 0L) {
                    JOptionPane.showMessageDialog(AddressWizard.this, ResourceStrings.getString("add_wiz_none_available"), ResourceStrings.getString("error_message"), 0);
                    AddressWizard.this.setForwardEnabled(false);
                } else {
                    if (l != (long)AddressWizard.this.number) {
                        MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("generate_addresses_warning"));
                        Object[] objectArray = new Object[]{new Long(l), new Long(AddressWizard.this.number)};
                        JOptionPane.showMessageDialog(AddressWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("warning"), 2);
                    }
                    AddressWizard.this.setForwardEnabled(true);
                }
            } else {
                AddressWizard.this.setForwardEnabled(true);
            }
        }

        public boolean setInactive(int n) {
            return true;
        }
    }

    class ConfigureStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();
        private JComboBox macroBox;
        private MacroListModel macroBoxModel;
        private JButton viewButton;
        private JCheckBox unusableBox;

        public ConfigureStep() {
            JComponent jComponent = Wizard.createTextArea(ResourceStrings.getString("add_wiz_macro_explain"), 3, 45);
            jComponent.setAlignmentX(0.0f);
            this.stepBox.add(jComponent);
            this.stepBox.add(Box.createVerticalStrut(10));
            JLabel jLabel = new JLabel(ResourceStrings.getString("add_wiz_macro_label"));
            jLabel.setAlignmentX(0.0f);
            this.stepBox.add(jLabel);
            JPanel jPanel = new JPanel(new FlowLayout(0));
            this.macroBoxModel = new MacroListModel();
            this.macroBox = new JComboBox(this.macroBoxModel);
            jPanel.add(this.macroBox);
            this.viewButton = new JButton(ResourceStrings.getString("add_wiz_view_button"));
            jPanel.add(this.viewButton);
            jPanel.setAlignmentX(0.0f);
            this.stepBox.add(jPanel);
            jComponent = Wizard.createTextArea(ResourceStrings.getString("add_wiz_flag_explain"), 2, 45);
            jComponent.setAlignmentX(0.0f);
            this.stepBox.add(jComponent);
            this.unusableBox = new JCheckBox(ResourceStrings.getString("add_wiz_unusable_label"));
            this.unusableBox.setAlignmentX(0.0f);
            this.stepBox.add(this.unusableBox);
            this.stepBox.add(Box.createVerticalGlue());
            this.viewButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ConfigureStep this$1;
                {
                    this.this$1 = configureStep;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ViewMacroDialog viewMacroDialog = new ViewMacroDialog((Dialog)ConfigureStep.access$0(this.this$1), ConfigureStep.access$1(this.this$1), ConfigureStep.access$2(this.this$1).getMacroAt(ConfigureStep.access$3(this.this$1).getSelectedIndex()));
                    viewMacroDialog.pack();
                    viewMacroDialog.show();
                }
            });
        }

        static /* synthetic */ JButton access$1(ConfigureStep configureStep) {
            return configureStep.viewButton;
        }

        static /* synthetic */ MacroListModel access$2(ConfigureStep configureStep) {
            return configureStep.macroBoxModel;
        }

        static /* synthetic */ JComboBox access$3(ConfigureStep configureStep) {
            return configureStep.macroBox;
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("add_wiz_configure_desc");
        }

        public void setActive(int n) {
            this.macroBox.setSelectedItem(AddressWizard.this.macro);
            this.unusableBox.setSelected(AddressWizard.this.unusable);
            AddressWizard.this.setForwardEnabled(true);
        }

        public boolean setInactive(int n) {
            AddressWizard.this.macro = (String)this.macroBox.getSelectedItem();
            AddressWizard.this.unusable = this.unusableBox.isSelected();
            return true;
        }

        class MacroListModel
        extends AbstractListModel
        implements ComboBoxModel {
            private Object currentValue;
            private Macro[] data = null;

            MacroListModel() {
            }

            public Object getElementAt(int n) {
                if (this.data == null) {
                    try {
                        this.data = DataManager.get().getMacros(false);
                    }
                    catch (NoTableException noTableException) {
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                if (n == 0) {
                    return AddressWizard.this.noMacro.getKey();
                }
                return this.data[n - 1].getKey();
            }

            public Macro getMacroAt(int n) {
                if (n == 0) {
                    return AddressWizard.this.noMacro;
                }
                return this.data[n - 1];
            }

            public Object getSelectedItem() {
                return this.currentValue;
            }

            public int getSize() {
                if (this.data == null) {
                    try {
                        this.data = DataManager.get().getMacros(false);
                    }
                    catch (NoTableException noTableException) {
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                if (this.data == null || this.data.length == 0) {
                    return 1;
                }
                return this.data.length + 1;
            }

            public void setSelectedItem(Object object) {
                this.currentValue = AddressWizard.this.noMacro.getKey();
                int n = 0;
                while (this.data != null && n < this.data.length) {
                    if (((String)object).equals(this.data[n].getKey())) {
                        this.currentValue = object;
                    }
                    ++n;
                }
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    class LeaseStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();
        private JRadioButton dynamicButton;
        private JRadioButton permanentButton;
        private ButtonGroup buttonGroup;

        public LeaseStep() {
            JComponent jComponent = Wizard.createTextArea(ResourceStrings.getString("add_wiz_lease_explain"), 0, 45);
            jComponent.setAlignmentX(0.0f);
            this.stepBox.add(jComponent);
            this.stepBox.add(Box.createVerticalStrut(10));
            JLabel jLabel = new JLabel(ResourceStrings.getString("add_wiz_lease_label"));
            JPanel jPanel = new JPanel(new FieldLayout(10, 0));
            jPanel.add("Label", jLabel);
            this.buttonGroup = new ButtonGroup();
            this.dynamicButton = new JRadioButton(ResourceStrings.getString("dynamic"), true);
            this.buttonGroup.add(this.dynamicButton);
            this.permanentButton = new JRadioButton(ResourceStrings.getString("permanent"), false);
            this.buttonGroup.add(this.permanentButton);
            jPanel.add("Field", this.dynamicButton);
            jPanel.add("Label", new JLabel(""));
            jPanel.add("Field", this.permanentButton);
            jPanel.setAlignmentX(0.0f);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalGlue());
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("add_wiz_lease_desc");
        }

        public void setActive(int n) {
            this.dynamicButton.setSelected(AddressWizard.this.dynamic);
            AddressWizard.this.setForwardEnabled(true);
        }

        public boolean setInactive(int n) {
            AddressWizard.this.dynamic = this.dynamicButton.isSelected();
            return true;
        }
    }

    class ReviewStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();
        private JPanel panel;
        private JTable addressTable;
        private JLabel numberLabel;
        private JLabel commentLabel;
        private JLabel serverLabel;
        private JLabel macroLabel;
        private JLabel flagLabel;
        private JLabel leaseLabel;

        public ReviewStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("add_wiz_review_explain"), 4, 45));
            this.panel = new JPanel(new FieldLayout());
            this.addLabel("add_wiz_count_label");
            this.numberLabel = this.addField("20");
            this.addLabel("add_wiz_comment_label");
            this.commentLabel = this.addField("Marketing");
            this.addLabel("add_wiz_server_label");
            this.serverLabel = this.addField("atlantic");
            this.addLabel("add_wiz_macro_label");
            this.macroLabel = this.addField("atlantic");
            this.addLabel("add_wiz_review_unusable");
            this.flagLabel = this.addField("Yes");
            this.addLabel("add_wiz_lease_label");
            this.leaseLabel = this.addField(ResourceStrings.getString("dynamic"));
            this.panel.setAlignmentX(0.0f);
            this.stepBox.add(this.panel);
            this.stepBox.add(Box.createVerticalStrut(5));
            JLabel jLabel = new JLabel(ResourceStrings.getString("add_wiz_confirm_label"));
            this.stepBox.add(jLabel);
            this.stepBox.add(Box.createVerticalStrut(2));
            this.addressTable = new JTable(AddressWizard.this.addressTableModel);
            this.addressTable.setDefaultRenderer(class$com$sun$dhcpmgr$data$IPAddress != null ? class$com$sun$dhcpmgr$data$IPAddress : (class$com$sun$dhcpmgr$data$IPAddress = AddressWizard.class$("com.sun.dhcpmgr.data.IPAddress")), new ExtendedCellRenderer());
            this.addressTable.setRowSelectionAllowed(false);
            this.addressTable.setColumnSelectionAllowed(false);
            this.addressTable.setCellSelectionEnabled(false);
            JScrollPane jScrollPane = new JScrollPane(this.addressTable);
            Dimension dimension = this.addressTable.getPreferredScrollableViewportSize();
            dimension.height = 50;
            this.addressTable.setPreferredScrollableViewportSize(dimension);
            this.stepBox.add(jScrollPane);
            this.stepBox.add(Box.createVerticalGlue());
        }

        private JLabel addField(String string) {
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            this.panel.add("Field", jLabel);
            return jLabel;
        }

        private void addLabel(String string) {
            this.panel.add("Label", new JLabel(ResourceStrings.getString(string)));
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("add_wiz_review_desc");
        }

        public void setActive(int n) {
            this.numberLabel.setText(String.valueOf(AddressWizard.this.addressTableModel.getRowCount()));
            this.commentLabel.setText(AddressWizard.this.comment);
            this.serverLabel.setText(AddressWizard.this.server);
            this.macroLabel.setText(AddressWizard.this.macro);
            if (AddressWizard.this.unusable) {
                this.flagLabel.setText(ResourceStrings.getString("yes"));
            } else {
                this.flagLabel.setText(ResourceStrings.getString("no"));
            }
            if (AddressWizard.this.dynamic) {
                this.leaseLabel.setText(ResourceStrings.getString("dynamic"));
            } else {
                this.leaseLabel.setText(ResourceStrings.getString("permanent"));
            }
            AddressWizard.this.setFinishEnabled(true);
        }

        public boolean setInactive(int n) {
            return true;
        }
    }
}

