/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.DhcpmgrDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import java.awt.Component;
import java.awt.Frame;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DisableServiceDialog
extends DhcpmgrDialog {
    private boolean disable;
    private JLabel message;

    public DisableServiceDialog(Frame frame, boolean bl) {
        super(frame, false);
        this.disable = bl;
        Object[] objectArray = new String[]{DataManager.get().getShortServerName()};
        if (bl) {
            this.setTitle(ResourceStrings.getString("disable_service_title"));
            if (DhcpmgrApplet.modeIsRelay) {
                this.message.setText(MessageFormat.format(ResourceStrings.getString("disable_relay_confirm"), objectArray));
            } else {
                this.message.setText(MessageFormat.format(ResourceStrings.getString("disable_service_confirm"), objectArray));
            }
        } else {
            this.setTitle(ResourceStrings.getString("enable_service_title"));
            if (DhcpmgrApplet.modeIsRelay) {
                this.message.setText(MessageFormat.format(ResourceStrings.getString("enable_relay_confirm"), objectArray));
            } else {
                this.message.setText(MessageFormat.format(ResourceStrings.getString("enable_service_confirm"), objectArray));
            }
        }
    }

    protected void doOk() {
        try {
            DhcpServiceMgr dhcpServiceMgr = DataManager.get().getDhcpServiceMgr();
            DhcpdOptions dhcpdOptions = DataManager.get().getDhcpServiceMgr().readDefaults();
            if (this.disable) {
                dhcpServiceMgr.shutdown();
                dhcpdOptions.setDaemonEnabled(false);
                DataManager.get().getDhcpServiceMgr().writeDefaults(dhcpdOptions);
            } else {
                dhcpdOptions.setDaemonEnabled(true);
                DataManager.get().getDhcpServiceMgr().writeDefaults(dhcpdOptions);
                dhcpServiceMgr.startup();
            }
            this.fireActionPerformed();
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageFormat messageFormat = null;
            Object[] objectArray = new Object[1];
            messageFormat = this.disable ? new MessageFormat(ResourceStrings.getString("disable_service_error")) : new MessageFormat(ResourceStrings.getString("enable_service_error"));
            objectArray[0] = exception.getMessage();
            JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
        }
    }

    protected void fireActionPerformed() {
        String string = this.disable ? "disable" : "enable";
        this.fireActionPerformed(this, string);
    }

    protected String getHelpKey() {
        if (this.disable) {
            return "disable_service";
        }
        return "enable_service";
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
        this.message = new JLabel();
        jPanel.add(this.message);
        this.buttonPanel.setOkEnabled(true);
        return jPanel;
    }
}

