/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.server;

import com.sun.dhcpmgr.bridge.Bridge;
import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.bridge.NoEntryException;
import com.sun.dhcpmgr.bridge.TableExistsException;
import com.sun.dhcpmgr.data.ActionError;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.ExportHeader;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.server.DhcpMgr;
import com.sun.dhcpmgr.server.DhcpNetMgr;
import com.sun.dhcpmgr.server.DhcpNetMgrImpl;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import com.sun.dhcpmgr.server.DhcpServiceMgrImpl;
import com.sun.dhcpmgr.server.DhcptabMgr;
import com.sun.dhcpmgr.server.DhcptabMgrImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DhcpMgrImpl
implements DhcpMgr {
    private Bridge bridge = new Bridge();
    private DhcpNetMgrImpl netMgr;
    private DhcptabMgrImpl dtMgr;
    private DhcpServiceMgrImpl srvMgr;
    private static final String LOCK_FILE = "/var/run/dhcp_import_export_lock";
    private static final File lockFile = new File("/var/run/dhcp_import_export_lock");
    private File currentlyOpenFile = null;
    private Object currentStream = null;

    private synchronized void clearFile(File file) {
        if (this.isFileOpen(file)) {
            this.currentlyOpenFile = null;
            this.currentStream = null;
            lockFile.delete();
        }
    }

    public void closeExportFile(Object object, boolean bl) throws IOException {
        if (!this.isFileOpen((File)object)) {
            throw new FileNotFoundException(((File)object).getName());
        }
        try {
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.currentStream;
            objectOutputStream.flush();
            objectOutputStream.close();
            if (bl) {
                ((File)object).delete();
            }
            Object var4_5 = null;
            this.clearFile((File)object);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.clearFile((File)object);
            throw throwable;
        }
    }

    public void closeImportFile(Object object, boolean bl) throws IOException {
        if (!this.isFileOpen((File)object)) {
            throw new FileNotFoundException(((File)object).getName());
        }
        try {
            ((ObjectInputStream)this.currentStream).close();
            if (bl) {
                ((File)object).delete();
            }
            Object var4_4 = null;
            this.clearFile((File)object);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.clearFile((File)object);
            throw throwable;
        }
    }

    public void exportMacros(Object object, boolean bl, String[] stringArray) throws BridgeException, IOException {
        Object object2;
        if (!this.isFileOpen((File)object)) {
            throw new FileNotFoundException(((File)object).getName());
        }
        Macro[] macroArray = this.getDhcptabMgr().getMacros();
        if (!bl) {
            object2 = this.getSelectedRecs(stringArray, (DhcptabRecord[])macroArray);
            macroArray = ((ArrayList)object2).toArray(new Macro[0]);
        }
        object2 = (ObjectOutputStream)this.currentStream;
        ((ObjectOutputStream)object2).writeObject(macroArray);
    }

    public void exportNetwork(Object object, Network network) throws BridgeException, IOException {
        if (!this.isFileOpen((File)object)) {
            throw new FileNotFoundException(((File)object).getName());
        }
        DhcpClientRecord[] dhcpClientRecordArray = this.getNetMgr().loadNetworkCompletely(network.toString());
        ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.currentStream;
        objectOutputStream.writeObject(dhcpClientRecordArray);
    }

    public void exportOptions(Object object, boolean bl, String[] stringArray) throws BridgeException, IOException {
        Object object2;
        if (!this.isFileOpen((File)object)) {
            throw new FileNotFoundException(((File)object).getName());
        }
        Option[] optionArray = this.getDhcptabMgr().getOptions();
        if (!bl) {
            object2 = this.getSelectedRecs(stringArray, (DhcptabRecord[])optionArray);
            optionArray = ((ArrayList)object2).toArray(new Option[0]);
        }
        object2 = (ObjectOutputStream)this.currentStream;
        ((ObjectOutputStream)object2).writeObject(optionArray);
    }

    public DhcpServiceMgr getDhcpServiceMgr() {
        if (this.srvMgr == null) {
            this.srvMgr = new DhcpServiceMgrImpl(this.bridge);
        }
        return this.srvMgr;
    }

    public DhcptabMgr getDhcptabMgr() {
        if (this.dtMgr == null) {
            this.dtMgr = new DhcptabMgrImpl(this.bridge);
        }
        return this.dtMgr;
    }

    public ExportHeader getExportHeader(Object object) throws IOException, ClassNotFoundException {
        if (!this.isFileOpen((File)object)) {
            throw new FileNotFoundException(((File)object).getName());
        }
        ObjectInputStream objectInputStream = (ObjectInputStream)this.currentStream;
        ExportHeader exportHeader = (ExportHeader)objectInputStream.readObject();
        return exportHeader;
    }

    private synchronized File getFile() {
        return this.currentlyOpenFile;
    }

    public String getLockPath() {
        return LOCK_FILE;
    }

    public DhcpNetMgr getNetMgr() {
        if (this.netMgr == null) {
            this.netMgr = new DhcpNetMgrImpl(this.bridge);
        }
        return this.netMgr;
    }

    private ArrayList getSelectedRecs(String[] stringArray, DhcptabRecord[] dhcptabRecordArray) throws NoEntryException {
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
        ArrayList<DhcptabRecord> arrayList = new ArrayList<DhcptabRecord>();
        int n = 0;
        while (n < dhcptabRecordArray.length) {
            if (treeSet.contains(dhcptabRecordArray[n].getKey())) {
                arrayList.add(dhcptabRecordArray[n]);
                treeSet.remove(dhcptabRecordArray[n].getKey());
            }
            ++n;
        }
        if (!treeSet.isEmpty()) {
            throw new NoEntryException(treeSet.first());
        }
        return arrayList;
    }

    private ActionError[] importDhcptabRecs(String string, Object object, boolean bl) throws IOException, OptionalDataException, ClassNotFoundException {
        Object object2;
        ArrayList<ActionError> arrayList = new ArrayList<ActionError>();
        DhcptabRecord[] dhcptabRecordArray = new DhcptabRecord[]{};
        if (!this.isFileOpen((File)object)) {
            throw new FileNotFoundException(((File)object).getName());
        }
        ObjectInputStream objectInputStream = (ObjectInputStream)this.currentStream;
        dhcptabRecordArray = (DhcptabRecord[])objectInputStream.readObject();
        if (string.equals("m")) {
            object2 = (Macro[])dhcptabRecordArray;
        } else {
            Option[] optionArray = (Option[])dhcptabRecordArray;
        }
        object2 = this.getDhcptabMgr();
        int n = 0;
        while (dhcptabRecordArray != null && n < dhcptabRecordArray.length) {
            try {
                if (bl) {
                    dhcptabRecordArray[n].setSignature("0");
                    object2.deleteRecord(dhcptabRecordArray[n], false);
                }
            }
            catch (Throwable throwable) {}
            try {
                object2.createRecord(dhcptabRecordArray[n], false);
            }
            catch (Exception exception) {
                arrayList.add(new ActionError(dhcptabRecordArray[n].getKey(), exception));
            }
            ++n;
        }
        return arrayList.toArray(new ActionError[0]);
    }

    public ActionError[] importMacros(Object object, boolean bl) throws IOException, OptionalDataException, ClassNotFoundException {
        return this.importDhcptabRecs("m", object, bl);
    }

    public ActionError[] importNetwork(Network network, Object object, boolean bl) throws IOException, OptionalDataException, ClassNotFoundException, BridgeException {
        if (!this.isFileOpen((File)object)) {
            throw new FileNotFoundException(((File)object).getName());
        }
        ArrayList<ActionError> arrayList = new ArrayList<ActionError>();
        DhcpClientRecord[] dhcpClientRecordArray = null;
        ObjectInputStream objectInputStream = (ObjectInputStream)this.currentStream;
        dhcpClientRecordArray = (DhcpClientRecord[])objectInputStream.readObject();
        String string = network.toString();
        DhcpNetMgr dhcpNetMgr = this.getNetMgr();
        boolean bl2 = false;
        try {
            dhcpNetMgr.createNetwork(string);
        }
        catch (TableExistsException tableExistsException) {
            bl2 = true;
        }
        int n = 0;
        while (dhcpClientRecordArray != null && n < dhcpClientRecordArray.length) {
            if (bl && bl2) {
                try {
                    dhcpClientRecordArray[n].setSignature(DhcpClientRecord.DEFAULT_SIGNATURE);
                    dhcpNetMgr.deleteClient(dhcpClientRecordArray[n], string, true);
                }
                catch (Throwable throwable) {}
            }
            try {
                dhcpNetMgr.addClient(dhcpClientRecordArray[n], string);
            }
            catch (Exception exception) {
                String string2 = dhcpClientRecordArray[n].getClientIPAddress();
                arrayList.add(new ActionError(string2, exception));
            }
            ++n;
        }
        return arrayList.toArray(new ActionError[0]);
    }

    public ActionError[] importOptions(Object object, boolean bl) throws IOException, OptionalDataException, ClassNotFoundException {
        return this.importDhcptabRecs("s", object, bl);
    }

    private synchronized boolean isFileOpen(File file) {
        return file == this.currentlyOpenFile;
    }

    public Object openExportFile(String string, String string2, int n, Network[] networkArray, boolean bl) throws ExistsException, IOException {
        File file = this.setFile(string);
        if (file != null) {
            if (!bl && file.exists()) {
                this.clearFile(file);
                throw new ExistsException(string);
            }
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
                ExportHeader exportHeader = new ExportHeader(this.getDhcpServiceMgr().getServerName(), string2, n, networkArray);
                objectOutputStream.writeObject(exportHeader);
                this.currentStream = objectOutputStream;
            }
            catch (IOException iOException) {
                this.clearFile(file);
                throw iOException;
            }
        }
        return file;
    }

    public Object openImportFile(String string) throws IOException {
        File file = this.setFile(string);
        if (file != null) {
            if (!file.exists()) {
                this.clearFile(file);
                throw new FileNotFoundException(string);
            }
            try {
                this.currentStream = new ObjectInputStream(new GZIPInputStream(new FileInputStream(file)));
            }
            catch (IOException iOException) {
                this.clearFile(file);
                throw iOException;
            }
        }
        return file;
    }

    private synchronized File setFile(String string) throws IOException {
        if (this.currentlyOpenFile != null) {
            return null;
        }
        if (!lockFile.createNewFile()) {
            return null;
        }
        this.currentlyOpenFile = new File(string);
        this.currentStream = null;
        return this.currentlyOpenFile;
    }
}

