/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.NumberValue;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionValue;
import com.sun.dhcpmgr.data.OptionsTable;
import com.sun.dhcpmgr.data.ValidationException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class NumberOptionValue
extends OptionValue {
    private String name;
    private Vector nums;
    private boolean valid;
    private int radix;

    protected NumberOptionValue(String string) {
        this.name = string;
        this.nums = null;
        this.valid = false;
    }

    public Object clone() {
        NumberOptionValue numberOptionValue = new NumberOptionValue(this.name);
        if (this.nums != null) {
            numberOptionValue.nums = (Vector)this.nums.clone();
        }
        numberOptionValue.valid = this.valid;
        return numberOptionValue;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.nums == null || this.nums.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.nums.elements();
        while (enumeration.hasMoreElements()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(enumeration.nextElement().toString());
        }
        return stringBuffer.toString();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValue(Object object) throws ValidationException {
        Object[] objectArray;
        Option option = OptionsTable.getTable().get(this.name);
        if (option == null) {
            Object[] objectArray2 = new Object[]{this.name};
            this.throwException("invalid_option", objectArray2);
        }
        byte by = option.getType();
        boolean bl = false;
        int n = option.getGranularity() * 8;
        int n2 = option.getGranularity();
        if (by == Option.types[Option.NUMBER].getCode()) {
            n2 = 1;
        } else if (by == Option.types[Option.SNUMBER8].getCode()) {
            n = 7;
        } else if (by == Option.types[Option.UNUMBER8].getCode()) {
            n = 8;
            bl = true;
        } else if (by == Option.types[Option.SNUMBER16].getCode()) {
            n = 15;
        } else if (by == Option.types[Option.UNUMBER16].getCode()) {
            n = 16;
            bl = true;
        } else if (by == Option.types[Option.SNUMBER32].getCode()) {
            n = 31;
        } else if (by == Option.types[Option.UNUMBER32].getCode()) {
            n = 32;
            bl = true;
        } else if (by == Option.types[Option.SNUMBER64].getCode()) {
            n = 63;
        } else if (by == Option.types[Option.UNUMBER64].getCode()) {
            n = 64;
            bl = true;
        }
        Vector<NumberValue> vector = new Vector<NumberValue>();
        if (object instanceof String) {
            if (((String)object).length() == 0) {
                objectArray = new Object[]{this.name, Option.getTypeDhcptabString(by)};
                this.throwException("invalid_option_value", objectArray);
            }
            objectArray = new StringTokenizer((String)object, " ");
            while (objectArray.hasMoreTokens()) {
                Object[] objectArray3;
                int n3 = 10;
                String string = objectArray.nextToken();
                if (string.startsWith("0x") || string.startsWith("0X")) {
                    n3 = 16;
                    string = string.substring(2);
                } else if (string.startsWith("0") && string.length() > 1) {
                    n3 = 8;
                    string = string.substring(1);
                }
                try {
                    BigInteger bigInteger = new BigInteger(string, n3);
                    if (bigInteger.bitLength() > n) {
                        objectArray3 = new Object[]{this.name, Option.getTypeDhcptabString(by)};
                        this.throwException("invalid_option_value", objectArray3);
                    }
                    if (bl && bigInteger.compareTo(BigInteger.ZERO) < 0) {
                        objectArray3 = new Object[]{this.name, Option.getTypeDhcptabString(by)};
                        this.throwException("invalid_option_value", objectArray3);
                    }
                    vector.addElement(new NumberValue(bigInteger, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    objectArray3 = new Object[]{this.name, Option.getTypeDhcptabString(by)};
                    this.throwException("invalid_option_value", objectArray3);
                }
            }
        } else if (object instanceof Number) {
            vector.addElement(new NumberValue((Number)object, 10));
        } else if (!(object instanceof Vector)) {
            objectArray = new Object[]{this.name, Option.getTypeDhcptabString(by)};
            this.throwException("invalid_option_value", objectArray);
        } else {
            objectArray = ((Vector)object).elements();
            while (objectArray.hasMoreElements()) {
                Object e = objectArray.nextElement();
                if (!(e instanceof Number)) {
                    Object[] objectArray4 = new Object[]{this.name, Option.getTypeDhcptabString(by)};
                    this.throwException("invalid_option_value", objectArray4);
                    continue;
                }
                vector.addElement(new NumberValue((Number)e, 10));
            }
        }
        if (vector.size() % n2 != 0) {
            objectArray = new Object[]{this.name, Integer.toString(n2)};
            this.throwException("invalid_option_granularity", objectArray);
        }
        if (option.getMaximum() != 0 && vector.size() / n2 > option.getMaximum()) {
            objectArray = new Object[]{this.name, Integer.toString(option.getMaximum())};
            this.throwException("invalid_option_maximum", objectArray);
        }
        this.nums = vector;
        this.valid = true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + this.getValue();
    }
}

