/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ExternalClientProviderInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.ViperProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class VRegistry {
    private static final String Trashbase_Dir = "deleted/";
    private static final String Codebase_Dir = "codebase/";
    private static final String Lib_Dir = "lib/";
    private static final String Services_Dir = "services/";
    private static final String Tools_Dir = "tools/";
    private static final String XCProviders_Dir = "xcproviders/";
    private static final String Registry_DB = "/properties/registry.ser";
    private static final String Default_Home = "/usr/sadm/smc";
    private static final String ClassList_DB = "/properties/classlist.txt";
    private static final String Reload_Lock = "/reload";
    public static final String GLOBAL = "ALL";
    public static final String GLOBALTOOL = "ALLTOOL";
    public static final String GLOBALSERVICE = "ALLSERVICE";

    public static LibInfoImpl addEntry(ComponentInfo componentInfo, String[] stringArray) {
        if (componentInfo instanceof ToolInfo) {
            return VRegistry.addEntry((ToolInfo)componentInfo, stringArray);
        }
        if (componentInfo instanceof ServiceInfo) {
            return VRegistry.addEntry((ServiceInfo)componentInfo, stringArray);
        }
        if (componentInfo instanceof ExternalClientProviderInfo) {
            return VRegistry.addEntry((ExternalClientProviderInfo)componentInfo, stringArray);
        }
        return null;
    }

    public static ServiceInfoImpl addEntry(ServiceInfo serviceInfo, String[] stringArray) {
        ServiceInfoImpl[] serviceInfoImplArray = VRegistry.readServices();
        ServiceInfoImpl[] serviceInfoImplArray2 = new ServiceInfoImpl[serviceInfoImplArray.length + 1];
        int n = 0;
        while (n < serviceInfoImplArray.length) {
            serviceInfoImplArray2[n] = serviceInfoImplArray[n];
            if (serviceInfoImplArray[n].getClassName().equals(serviceInfo.getClassName())) {
                int n2 = n;
                while (n2 < serviceInfoImplArray.length - 1) {
                    serviceInfoImplArray[n2] = serviceInfoImplArray[n2 + 1];
                    ++n2;
                }
                serviceInfoImplArray2 = serviceInfoImplArray;
                break;
            }
            ++n;
        }
        serviceInfoImplArray2[serviceInfoImplArray2.length - 1] = new ServiceInfoImpl(serviceInfo);
        serviceInfoImplArray2[serviceInfoImplArray2.length - 1].setNativeLibs(stringArray);
        VRegistry.writeServices(serviceInfoImplArray2);
        return serviceInfoImplArray2[serviceInfoImplArray2.length - 1];
    }

    public static ToolInfoImpl addEntry(ToolInfo toolInfo, String[] stringArray) {
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        ToolInfoImpl[] toolInfoImplArray2 = new ToolInfoImpl[toolInfoImplArray.length + 1];
        int n = 0;
        while (n < toolInfoImplArray.length) {
            toolInfoImplArray2[n] = toolInfoImplArray[n];
            if (toolInfoImplArray[n].getClassName().equals(toolInfo.getClassName())) {
                int n2 = n;
                while (n2 < toolInfoImplArray.length - 1) {
                    toolInfoImplArray[n2] = toolInfoImplArray[n2 + 1];
                    ++n2;
                }
                toolInfoImplArray2 = toolInfoImplArray;
                break;
            }
            ++n;
        }
        toolInfoImplArray2[toolInfoImplArray2.length - 1] = new ToolInfoImpl(toolInfo);
        toolInfoImplArray2[toolInfoImplArray2.length - 1].setNativeLibs(stringArray);
        VRegistry.writeTools(toolInfoImplArray2);
        return toolInfoImplArray2[toolInfoImplArray2.length - 1];
    }

    protected static ExternalClientProviderInfoImpl addEntry(ExternalClientProviderInfo externalClientProviderInfo, String[] stringArray) {
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray = VRegistry.readXCProviders();
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray2 = new ExternalClientProviderInfoImpl[externalClientProviderInfoImplArray.length + 1];
        int n = 0;
        while (n < externalClientProviderInfoImplArray.length) {
            externalClientProviderInfoImplArray2[n] = externalClientProviderInfoImplArray[n];
            if (externalClientProviderInfoImplArray[n].getClassName().equals(externalClientProviderInfo.getClassName())) {
                int n2 = n;
                while (n2 < externalClientProviderInfoImplArray.length - 1) {
                    externalClientProviderInfoImplArray[n2] = externalClientProviderInfoImplArray[n2 + 1];
                    ++n2;
                }
                externalClientProviderInfoImplArray2 = externalClientProviderInfoImplArray;
                break;
            }
            ++n;
        }
        externalClientProviderInfoImplArray2[externalClientProviderInfoImplArray2.length - 1] = new ExternalClientProviderInfoImpl(externalClientProviderInfo);
        externalClientProviderInfoImplArray2[externalClientProviderInfoImplArray2.length - 1].setNativeLibs(stringArray);
        VRegistry.writeXCProviders(externalClientProviderInfoImplArray2);
        return externalClientProviderInfoImplArray2[externalClientProviderInfoImplArray2.length - 1];
    }

    public static String addJarToEntry(String string, String string2, String[] stringArray) {
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray;
        int n;
        ServiceInfoImpl[] serviceInfoImplArray;
        LibInfoImpl[] libInfoImplArray = VRegistry.readAllLibJars();
        if (string.equals(GLOBAL) || string.equals(GLOBALTOOL) || string.equals(GLOBALSERVICE)) {
            String string3 = VRegistry.toAttachedJarName(-1, string, string2);
            LibInfoImpl[] libInfoImplArray2 = new LibInfoImpl[libInfoImplArray.length + 1];
            int n2 = 0;
            while (n2 < libInfoImplArray.length) {
                if (string3.equals(libInfoImplArray[n2].getJarName())) {
                    libInfoImplArray2 = libInfoImplArray;
                    break;
                }
                libInfoImplArray2[n2] = libInfoImplArray[n2];
                ++n2;
            }
            libInfoImplArray2[n2] = new LibInfoImpl(null, null, null, null);
            libInfoImplArray2[n2].setJarName(string3);
            libInfoImplArray2[n2].setNativeLibs(stringArray);
            VRegistry.writeAllLibJars(libInfoImplArray2);
            return libInfoImplArray2[n2].getJarPath();
        }
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        if (toolInfoImplArray != null) {
            serviceInfoImplArray = VRegistry.toAttachedJarName(1, string, string2);
            n = 0;
            while (n < toolInfoImplArray.length) {
                if (toolInfoImplArray[n].getClassName().equals(string)) {
                    LibInfoImpl[] libInfoImplArray3 = toolInfoImplArray[n].getAttachments();
                    int n3 = 0;
                    n3 = libInfoImplArray3 == null ? 1 : libInfoImplArray3.length + 1;
                    LibInfoImpl[] libInfoImplArray4 = new LibInfoImpl[n3];
                    int n4 = 0;
                    while (n4 < n3 - 1) {
                        if (libInfoImplArray3[n4].getJarName().equals(serviceInfoImplArray)) {
                            libInfoImplArray4 = libInfoImplArray3;
                            break;
                        }
                        libInfoImplArray4[n4] = libInfoImplArray3[n4];
                        ++n4;
                    }
                    libInfoImplArray4[n4] = new LibInfoImpl(null, null, null, null);
                    libInfoImplArray4[n4].setJarName((String)serviceInfoImplArray);
                    libInfoImplArray4[n4].setNativeLibs(stringArray);
                    toolInfoImplArray[n].setAttachments(libInfoImplArray4);
                    VRegistry.writeTools(toolInfoImplArray);
                    return libInfoImplArray4[n4].getJarPath();
                }
                ++n;
            }
        }
        if ((serviceInfoImplArray = VRegistry.readServices()) != null) {
            externalClientProviderInfoImplArray = VRegistry.toAttachedJarName(2, string, string2);
            n = 0;
            while (n < serviceInfoImplArray.length) {
                if (serviceInfoImplArray[n].getClassName().equals(string)) {
                    LibInfoImpl[] libInfoImplArray5 = serviceInfoImplArray[n].getAttachments();
                    int n5 = 0;
                    n5 = libInfoImplArray5 == null ? 1 : libInfoImplArray5.length + 1;
                    LibInfoImpl[] libInfoImplArray6 = new LibInfoImpl[n5];
                    int n6 = 0;
                    while (n6 < n5 - 1) {
                        if (libInfoImplArray5[n6].getJarName().equals(externalClientProviderInfoImplArray)) {
                            libInfoImplArray6 = libInfoImplArray5;
                            break;
                        }
                        libInfoImplArray6[n6] = libInfoImplArray5[n6];
                        ++n6;
                    }
                    libInfoImplArray6[n6] = new LibInfoImpl(null, null, null, null);
                    libInfoImplArray6[n6].setJarName((String)externalClientProviderInfoImplArray);
                    libInfoImplArray6[n6].setNativeLibs(stringArray);
                    serviceInfoImplArray[n].setAttachments(libInfoImplArray6);
                    VRegistry.writeServices(serviceInfoImplArray);
                    return libInfoImplArray6[n6].getJarPath();
                }
                ++n;
            }
        }
        if ((externalClientProviderInfoImplArray = VRegistry.readXCProviders()) != null) {
            String string4 = VRegistry.toAttachedJarName(3, string, string2);
            n = 0;
            while (n < externalClientProviderInfoImplArray.length) {
                if (externalClientProviderInfoImplArray[n].getClassName().equals(string)) {
                    LibInfoImpl[] libInfoImplArray7 = externalClientProviderInfoImplArray[n].getAttachments();
                    int n7 = 0;
                    n7 = libInfoImplArray7 == null ? 1 : libInfoImplArray7.length + 1;
                    LibInfoImpl[] libInfoImplArray8 = new LibInfoImpl[n7];
                    int n8 = 0;
                    while (n8 < n7 - 1) {
                        if (libInfoImplArray7[n8].getJarName().equals(string4)) {
                            libInfoImplArray8 = libInfoImplArray7;
                            break;
                        }
                        libInfoImplArray8[n8] = libInfoImplArray7[n8];
                        ++n8;
                    }
                    libInfoImplArray8[n8] = new LibInfoImpl(null, null, null, null);
                    libInfoImplArray8[n8].setJarName(string4);
                    libInfoImplArray8[n8].setNativeLibs(stringArray);
                    externalClientProviderInfoImplArray[n].setAttachments(libInfoImplArray8);
                    VRegistry.writeXCProviders(externalClientProviderInfoImplArray);
                    return libInfoImplArray8[n8].getJarPath();
                }
                ++n;
            }
        }
        return null;
    }

    public static int addProperties(String string, String string2, String string3) {
        boolean bl = false;
        LibInfoImpl[] libInfoImplArray = VRegistry.readAllLibJars();
        if (string2.equals(GLOBAL)) {
            Properties properties = VRegistry.readAllProperties();
            bl = VRegistry.searchAndAddProperties(string3, string, properties, libInfoImplArray);
            if (!bl) {
                return 2;
            }
            VRegistry.writeAllProperties(properties);
            return 0;
        }
        if (string2.equals(GLOBALTOOL)) {
            Properties properties = VRegistry.readAllToolProperties();
            bl = VRegistry.searchAndAddProperties(string3, string, properties, libInfoImplArray);
            if (!bl) {
                return 2;
            }
            VRegistry.writeAllToolProperties(properties);
            return 0;
        }
        if (string2.equals(GLOBALSERVICE)) {
            Properties properties = VRegistry.readAllServiceProperties();
            bl = VRegistry.searchAndAddProperties(string3, string, properties, libInfoImplArray);
            if (!bl) {
                return 2;
            }
            VRegistry.writeAllServiceProperties(properties);
            return 0;
        }
        ServiceInfoImpl[] serviceInfoImplArray = VRegistry.readServices();
        int n = 0;
        while (n < serviceInfoImplArray.length) {
            if (serviceInfoImplArray[n].getClassName().equals(string2)) {
                bl = VRegistry.searchAndAddProperties(string3, string, serviceInfoImplArray[n].getProperties(), serviceInfoImplArray[n].getAttachments());
                if (!bl) {
                    return 2;
                }
                VRegistry.writeServices(serviceInfoImplArray);
                return 0;
            }
            ++n;
        }
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        int n2 = 0;
        while (n2 < toolInfoImplArray.length) {
            if (toolInfoImplArray[n2].getClassName().equals(string2)) {
                bl = VRegistry.searchAndAddProperties(string3, string, toolInfoImplArray[n2].getProperties(), toolInfoImplArray[n2].getAttachments());
                if (!bl) {
                    return 2;
                }
                VRegistry.writeTools(toolInfoImplArray);
                return 0;
            }
            ++n2;
        }
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray = VRegistry.readXCProviders();
        int n3 = 0;
        while (n3 < externalClientProviderInfoImplArray.length) {
            if (externalClientProviderInfoImplArray[n3].getClassName().equals(string2)) {
                bl = VRegistry.searchAndAddProperties(string3, string, externalClientProviderInfoImplArray[n3].getProperties(), new LibInfoImpl[0]);
                if (!bl) {
                    return 2;
                }
                VRegistry.writeXCProviders(externalClientProviderInfoImplArray);
                return 0;
            }
            ++n3;
        }
        return 1;
    }

    private static String baseName(String string) {
        int n = string.indexOf(64);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    protected static int checkBean(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return 1;
        }
        ServiceInfoImpl[] serviceInfoImplArray = VRegistry.readServices();
        String string = serviceInfo.getClassName();
        if (serviceInfoImplArray != null) {
            int n = 0;
            while (n < serviceInfoImplArray.length) {
                if (serviceInfoImplArray[n].getClassName().equals(string)) {
                    return 0;
                }
                ++n;
            }
        }
        return 1;
    }

    protected static int checkBean(ToolInfo toolInfo) {
        if (toolInfo == null) {
            return 1;
        }
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        String string = toolInfo.getClassName();
        if (toolInfoImplArray != null) {
            int n = 0;
            while (n < toolInfoImplArray.length) {
                if (toolInfoImplArray[n].getClassName().equals(string)) {
                    return 0;
                }
                ++n;
            }
        }
        return 1;
    }

    protected static int checkBean(ExternalClientProviderInfo externalClientProviderInfo) {
        if (externalClientProviderInfo == null) {
            return 1;
        }
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray = VRegistry.readXCProviders();
        String string = externalClientProviderInfo.getClassName();
        if (externalClientProviderInfoImplArray != null) {
            int n = 0;
            while (n < externalClientProviderInfoImplArray.length) {
                if (externalClientProviderInfoImplArray[n].getClassName().equals(string)) {
                    return 0;
                }
                ++n;
            }
        }
        return 1;
    }

    protected static int checkJarEntry(String string, String string2) {
        LibInfoImpl[] libInfoImplArray;
        int n;
        ServiceInfoImpl[] serviceInfoImplArray = VRegistry.readServices();
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray = VRegistry.readXCProviders();
        LibInfoImpl[] libInfoImplArray2 = VRegistry.readAllLibJars();
        if (libInfoImplArray2 != null && (string.equals(GLOBAL) || string.equals(GLOBALTOOL) || string.equals(GLOBALSERVICE))) {
            n = 0;
            while (n < libInfoImplArray2.length) {
                libInfoImplArray = VRegistry.toAttachedJarName(-1, string, string2);
                if (libInfoImplArray.equals(libInfoImplArray2[n].getJarName())) {
                    return 0;
                }
                ++n;
            }
        }
        if (toolInfoImplArray != null) {
            n = 0;
            while (n < toolInfoImplArray.length) {
                if (toolInfoImplArray[n].getClassName().equals(string)) {
                    libInfoImplArray = toolInfoImplArray[n].getAttachments();
                    int n2 = 0;
                    while (n2 < libInfoImplArray.length) {
                        if (string2.equals(VRegistry.baseName(libInfoImplArray[n2].getJarName()))) {
                            return 0;
                        }
                        ++n2;
                    }
                    return 2;
                }
                ++n;
            }
        }
        if (serviceInfoImplArray != null) {
            n = 0;
            while (n < serviceInfoImplArray.length) {
                if (serviceInfoImplArray[n].getClassName().equals(string)) {
                    libInfoImplArray = serviceInfoImplArray[n].getAttachments();
                    int n3 = 0;
                    while (n3 < libInfoImplArray.length) {
                        if (string2.equals(VRegistry.baseName(libInfoImplArray[n3].getJarName()))) {
                            return 0;
                        }
                        ++n3;
                    }
                    return 2;
                }
                ++n;
            }
        }
        if (externalClientProviderInfoImplArray != null) {
            n = 0;
            while (n < externalClientProviderInfoImplArray.length) {
                if (externalClientProviderInfoImplArray[n].getClassName().equals(string)) {
                    libInfoImplArray = externalClientProviderInfoImplArray[n].getAttachments();
                    int n4 = 0;
                    while (n4 < libInfoImplArray.length) {
                        if (string2.equals(VRegistry.baseName(libInfoImplArray[n4].getJarName()))) {
                            return 0;
                        }
                        ++n4;
                    }
                    return 2;
                }
                ++n;
            }
        }
        return 1;
    }

    protected static int checkProperties(String string, String string2, String string3) {
        if (string2.equals(GLOBAL) || string2.equals(GLOBALTOOL) || string2.equals(GLOBALSERVICE)) {
            Properties properties = null;
            if (string2.equals(GLOBAL)) {
                properties = VRegistry.readAllProperties();
            } else if (string2.equals(GLOBALTOOL)) {
                properties = VRegistry.readAllToolProperties();
            } else if (string2.equals(GLOBALSERVICE)) {
                properties = VRegistry.readAllServiceProperties();
            }
            return VRegistry.validateProperties(string3, string, properties, VRegistry.readAllLibJars());
        }
        ServiceInfoImpl[] serviceInfoImplArray = VRegistry.readServices();
        int n = 0;
        while (n < serviceInfoImplArray.length) {
            if (serviceInfoImplArray[n].getClassName().equals(string2)) {
                return VRegistry.validateProperties(string3, string, serviceInfoImplArray[n].getProperties(), serviceInfoImplArray[n].getAttachments());
            }
            ++n;
        }
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        int n2 = 0;
        while (n2 < toolInfoImplArray.length) {
            if (toolInfoImplArray[n2].getClassName().equals(string2)) {
                return VRegistry.validateProperties(string3, string, toolInfoImplArray[n2].getProperties(), toolInfoImplArray[n2].getAttachments());
            }
            ++n2;
        }
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray = VRegistry.readXCProviders();
        int n3 = 0;
        while (n3 < externalClientProviderInfoImplArray.length) {
            if (externalClientProviderInfoImplArray[n3].getClassName().equals(string2)) {
                return VRegistry.validateProperties(string3, string, externalClientProviderInfoImplArray[n3].getProperties(), new LibInfoImpl[0]);
            }
            ++n3;
        }
        return 1;
    }

    public static void deleteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }

    private static void deleteLibInfoObject(String string, LibInfoImpl libInfoImpl) {
        String[] stringArray = libInfoImpl.getNativeLibs();
        if (stringArray != null) {
            String string2 = String.valueOf(VRegistry.getViperRTHome()) + "/" + Lib_Dir;
            int n = 0;
            while (n < stringArray.length) {
                String string3 = String.valueOf(string2) + stringArray[n];
                VRegistry.deleteFile(string3);
                ++n;
            }
        }
        VRegistry.deleteFile(string);
        libInfoImpl = null;
    }

    private static String getBackupRegistryFile() {
        return String.valueOf(VRegistry.getViperRTHome()) + Registry_DB + ".backup";
    }

    public static Hashtable getClassList() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(2729, 0.75f);
        String string = VRegistry.getViperRTHome();
        try {
            String string2;
            FileReader fileReader = new FileReader(String.valueOf(string) + ClassList_DB);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String string4;
                String string5;
                String string6;
                int n = (string2 = string2.trim()).length();
                if (n <= 0) continue;
                int n2 = string2.indexOf(58);
                int n3 = string2.indexOf(58, n2 + 1);
                if (n2 <= 0 || n3 <= n2 + 1 || n3 + 1 >= n || (string6 = hashtable.put(string5 = string2.substring(0, n2).trim(), string4 = VRegistry.toFullJarPath(string3 = string2.substring(n2 + 1, n3).trim()))) == null) continue;
                String string7 = "Repository: class: " + string5 + " location is overridden by " + string4;
                Debug.trace((String)"VRegistry", (int)Debug.WARNING, (String)string7, null);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashtable;
    }

    public static String getCodebase() {
        String string = String.valueOf(VRegistry.getViperRTHome()) + "/" + Codebase_Dir;
        File file = new File(String.valueOf(string) + Services_Dir);
        File file2 = new File(String.valueOf(string) + Tools_Dir);
        File file3 = new File(String.valueOf(string) + XCProviders_Dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file3.exists()) {
            file3.mkdirs();
        }
        return string;
    }

    private static String getRegistryFile() {
        return String.valueOf(VRegistry.getViperRTHome()) + Registry_DB;
    }

    public static String getReloadLockFile() {
        return String.valueOf(VRegistry.getViperRTHome()) + Reload_Lock;
    }

    public static String getTrashbase() {
        String string = String.valueOf(VRegistry.getViperRTHome()) + "/" + Trashbase_Dir;
        File file = new File(String.valueOf(string) + Services_Dir);
        File file2 = new File(String.valueOf(string) + Tools_Dir);
        File file3 = new File(String.valueOf(string) + XCProviders_Dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file3.exists()) {
            file3.mkdirs();
        }
        return string;
    }

    private static String getViperRTHome() {
        return ViperProperties.getViperRTHome();
    }

    private static int isThereProperty(String string, Properties properties) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            while (stringTokenizer.hasMoreElements()) {
                int n;
                String string2 = stringTokenizer.nextElement().toString().trim();
                String string3 = string2.substring(0, n = string2.indexOf(61));
                if (((Hashtable)properties).get(string3) == null) continue;
                return 0;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return 1;
    }

    static void makeDirectories() {
        String string = String.valueOf(VRegistry.getViperRTHome()) + "/";
        new File(String.valueOf(string) + Codebase_Dir).mkdir();
        new File(String.valueOf(string) + Lib_Dir).mkdir();
        new File(String.valueOf(string) + "properties").mkdir();
    }

    private static void printProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Key = " + string + " Value = " + properties.getProperty(string));
        }
    }

    protected static LibInfoImpl[] readAllLibJars() {
        return (LibInfoImpl[])VRegistry.readRegistry()[3];
    }

    protected static Properties readAllProperties() {
        return (Properties)VRegistry.readRegistry()[4];
    }

    protected static Properties readAllServiceProperties() {
        return (Properties)VRegistry.readRegistry()[5];
    }

    protected static Properties readAllToolProperties() {
        return (Properties)VRegistry.readRegistry()[6];
    }

    private static Object[] readRegistry() {
        String string = VRegistry.getRegistryFile();
        String string2 = VRegistry.getBackupRegistryFile();
        String string3 = null;
        Object[] objectArray = VRegistry.readRegistryFromFile(string);
        if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null || objectArray[3] == null || objectArray[4] == null || objectArray[5] == null || objectArray[6] == null) {
            File file = new File(string);
            File file2 = new File(string2);
            if (file2.exists()) {
                if (file.exists()) {
                    file.delete();
                }
                file2.renameTo(file);
                string3 = "Roll back to backup registry";
                Debug.trace((String)"VRegistry", (int)Debug.INFORMATION, (String)string3, null);
            }
            objectArray = VRegistry.readRegistryFromFile(string);
        }
        if (objectArray[0] == null) {
            objectArray[0] = new ServiceInfoImpl[0];
        }
        if (objectArray[1] == null) {
            objectArray[1] = new ToolInfoImpl[0];
        }
        if (objectArray[2] == null) {
            objectArray[2] = new ExternalClientProviderInfoImpl[0];
        }
        if (objectArray[3] == null) {
            objectArray[3] = new LibInfoImpl[0];
        }
        if (objectArray[4] == null) {
            objectArray[4] = new Properties();
        }
        if (objectArray[5] == null) {
            objectArray[5] = new Properties();
        }
        if (objectArray[6] == null) {
            objectArray[6] = new Properties();
        }
        return objectArray;
    }

    private static Object[] readRegistryFromFile(String string) {
        Object[] objectArray = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            objectArray = (Object[])objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            String string2 = "Unable to read repository database";
            Debug.trace((String)"VRegistry", (int)Debug.ERROR, (String)string2, (Throwable)exception);
        }
        if (objectArray == null) {
            objectArray = new Object[7];
            int n = 0;
            while (n < 7) {
                objectArray[n] = null;
                ++n;
            }
        }
        return objectArray;
    }

    protected static ServiceInfoImpl[] readServices() {
        return (ServiceInfoImpl[])VRegistry.readRegistry()[0];
    }

    protected static ToolInfoImpl[] readTools() {
        return (ToolInfoImpl[])VRegistry.readRegistry()[1];
    }

    protected static ExternalClientProviderInfoImpl[] readXCProviders() {
        return (ExternalClientProviderInfoImpl[])VRegistry.readRegistry()[2];
    }

    public static boolean removeEntry(String string) {
        String string2;
        String string3;
        Object object;
        Object[] objectArray;
        int n;
        LibInfoImpl[] libInfoImplArray;
        boolean bl = false;
        ServiceInfoImpl[] serviceInfoImplArray = VRegistry.readServices();
        if (serviceInfoImplArray.length > 0) {
            libInfoImplArray = new ServiceInfoImpl[serviceInfoImplArray.length - 1];
            n = 0;
            while (n < serviceInfoImplArray.length) {
                bl = serviceInfoImplArray[n].getJarName().endsWith(string);
                if (serviceInfoImplArray[n].getClassName().equals(string) || bl) {
                    int n2;
                    objectArray = serviceInfoImplArray[n].getNativeLibs();
                    if (objectArray != null) {
                        object = String.valueOf(VRegistry.getViperRTHome()) + "/" + Lib_Dir;
                        n2 = 0;
                        while (n2 < objectArray.length) {
                            string3 = String.valueOf(object) + (String)objectArray[n2];
                            VRegistry.deleteFile(string3);
                            ++n2;
                        }
                    }
                    if ((object = serviceInfoImplArray[n].getAttachments()) != null) {
                        n2 = 0;
                        while (n2 < ((ExternalClientProviderInfoImpl[])object).length) {
                            string2 = object[n2].getJarPath();
                            VRegistry.deleteLibInfoObject(string2, object[n2]);
                            ++n2;
                        }
                    }
                    n2 = n + 1;
                    while (n2 < serviceInfoImplArray.length) {
                        libInfoImplArray[n2 - 1] = serviceInfoImplArray[n2];
                        ++n2;
                    }
                    break;
                }
                if (n < serviceInfoImplArray.length - 1) {
                    libInfoImplArray[n] = serviceInfoImplArray[n];
                }
                ++n;
            }
            if (n < serviceInfoImplArray.length) {
                if (!bl) {
                    VRegistry.deleteFile(serviceInfoImplArray[n].getJarPath());
                }
                VRegistry.writeServices((ServiceInfoImpl[])libInfoImplArray);
                return true;
            }
        }
        if ((libInfoImplArray = VRegistry.readTools()).length > 0) {
            objectArray = new ToolInfoImpl[libInfoImplArray.length - 1];
            n = 0;
            while (n < libInfoImplArray.length) {
                bl = libInfoImplArray[n].getJarName().endsWith(string);
                if (((ToolInfoImpl)libInfoImplArray[n]).getClassName().equals(string) || bl) {
                    LibInfoImpl[] libInfoImplArray2;
                    object = libInfoImplArray[n].getNativeLibs();
                    if (object != null) {
                        String string4 = String.valueOf(VRegistry.getViperRTHome()) + "/" + Lib_Dir;
                        int n3 = 0;
                        while (n3 < ((ExternalClientProviderInfoImpl[])object).length) {
                            string3 = String.valueOf(string4) + (String)((Object)object[n3]);
                            VRegistry.deleteFile(string3);
                            ++n3;
                        }
                    }
                    if ((libInfoImplArray2 = ((ToolInfoImpl)libInfoImplArray[n]).getAttachments()) != null) {
                        int n4 = 0;
                        while (n4 < libInfoImplArray2.length) {
                            String string5 = libInfoImplArray2[n4].getJarPath();
                            VRegistry.deleteLibInfoObject(string5, libInfoImplArray2[n4]);
                            ++n4;
                        }
                    }
                    int n5 = n + 1;
                    while (n5 < libInfoImplArray.length) {
                        objectArray[n5 - 1] = libInfoImplArray[n5];
                        ++n5;
                    }
                    break;
                }
                if (n < libInfoImplArray.length - 1) {
                    objectArray[n] = libInfoImplArray[n];
                }
                ++n;
            }
            if (n < libInfoImplArray.length) {
                object = libInfoImplArray[n].getJarPath();
                if (!bl) {
                    VRegistry.deleteFile((String)object);
                }
                VRegistry.writeTools((ToolInfoImpl[])objectArray);
                return true;
            }
        }
        if ((objectArray = VRegistry.readXCProviders()).length > 0) {
            object = new ExternalClientProviderInfoImpl[objectArray.length - 1];
            n = 0;
            while (n < objectArray.length) {
                bl = objectArray[n].getJarName().endsWith(string);
                if (((ExternalClientProviderInfoImpl)objectArray[n]).getClassName().equals(string) || bl) {
                    String[] stringArray = ((LibInfoImpl)objectArray[n]).getNativeLibs();
                    if (stringArray != null) {
                        string2 = String.valueOf(VRegistry.getViperRTHome()) + "/" + Lib_Dir;
                        int n6 = 0;
                        while (n6 < stringArray.length) {
                            string3 = String.valueOf(string2) + stringArray[n6];
                            VRegistry.deleteFile(string3);
                            ++n6;
                        }
                    }
                    int n7 = n + 1;
                    while (n7 < objectArray.length) {
                        object[n7 - 1] = objectArray[n7];
                        ++n7;
                    }
                    break;
                }
                if (n < objectArray.length - 1) {
                    object[n] = objectArray[n];
                }
                ++n;
            }
            if (n < objectArray.length) {
                String string6 = objectArray[n].getJarPath();
                if (!bl) {
                    VRegistry.deleteFile(string6);
                }
                VRegistry.writeXCProviders(object);
                return true;
            }
        }
        return false;
    }

    public static String removeJarFromEntry(String string, String string2) {
        String string3;
        int n;
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray;
        ServiceInfoImpl[] serviceInfoImplArray;
        LibInfoImpl[] libInfoImplArray = VRegistry.readAllLibJars();
        if (string.equals(GLOBAL) || string.equals(GLOBALTOOL) || string.equals(GLOBALSERVICE)) {
            if (libInfoImplArray.length == 0) {
                return null;
            }
            LibInfoImpl[] libInfoImplArray2 = new LibInfoImpl[libInfoImplArray.length - 1];
            String string4 = VRegistry.toAttachedJarName(-1, string, string2);
            String string5 = VRegistry.toFullJarPath(string4);
            int n2 = 0;
            int n3 = 0;
            while (n2 < libInfoImplArray.length) {
                String string6 = libInfoImplArray[n2].getJarName();
                if (!string6.equals(string4)) {
                    if (n3 == libInfoImplArray.length - 1) {
                        return null;
                    }
                    libInfoImplArray2[n3++] = libInfoImplArray[n2];
                } else {
                    VRegistry.deleteLibInfoObject(string5, libInfoImplArray[n2]);
                }
                ++n2;
            }
            VRegistry.writeAllLibJars(libInfoImplArray2);
            return string5;
        }
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        if (toolInfoImplArray != null) {
            serviceInfoImplArray = VRegistry.toAttachedJarName(1, string, string2);
            externalClientProviderInfoImplArray = VRegistry.toFullJarPath((String)serviceInfoImplArray);
            n = 0;
            while (n < toolInfoImplArray.length) {
                if (toolInfoImplArray[n].getClassName().equals(string)) {
                    LibInfoImpl[] libInfoImplArray3 = toolInfoImplArray[n].getAttachments();
                    LibInfoImpl[] libInfoImplArray4 = null;
                    int n4 = 0;
                    if (libInfoImplArray3 == null || libInfoImplArray3.length == 0) {
                        return null;
                    }
                    n4 = libInfoImplArray3.length - 1;
                    libInfoImplArray4 = new LibInfoImpl[n4];
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < libInfoImplArray3.length) {
                        if (libInfoImplArray3[n5].getJarName().equals(serviceInfoImplArray)) {
                            VRegistry.deleteLibInfoObject((String)externalClientProviderInfoImplArray, libInfoImplArray3[n5]);
                        } else if (n6 < n4) {
                            libInfoImplArray4[n6++] = libInfoImplArray3[n5];
                        } else {
                            return null;
                        }
                        ++n5;
                    }
                    toolInfoImplArray[n].setAttachments(libInfoImplArray4);
                    VRegistry.writeTools(toolInfoImplArray);
                    return externalClientProviderInfoImplArray;
                }
                ++n;
            }
        }
        if ((serviceInfoImplArray = VRegistry.readServices()) != null) {
            externalClientProviderInfoImplArray = VRegistry.toAttachedJarName(2, string, string2);
            string3 = VRegistry.toFullJarPath((String)externalClientProviderInfoImplArray);
            n = 0;
            while (n < serviceInfoImplArray.length) {
                if (serviceInfoImplArray[n].getClassName().equals(string)) {
                    LibInfoImpl[] libInfoImplArray5 = serviceInfoImplArray[n].getAttachments();
                    LibInfoImpl[] libInfoImplArray6 = null;
                    int n7 = 0;
                    if (libInfoImplArray5 == null || libInfoImplArray5.length == 0) {
                        return null;
                    }
                    n7 = libInfoImplArray5.length - 1;
                    libInfoImplArray6 = new LibInfoImpl[n7];
                    int n8 = 0;
                    int n9 = 0;
                    while (n8 < libInfoImplArray5.length) {
                        if (libInfoImplArray5[n8].getJarName().equals(externalClientProviderInfoImplArray)) {
                            VRegistry.deleteLibInfoObject(string3, libInfoImplArray5[n8]);
                        } else if (n9 < n7) {
                            libInfoImplArray6[n9++] = libInfoImplArray5[n8];
                        } else {
                            return null;
                        }
                        ++n8;
                    }
                    serviceInfoImplArray[n].setAttachments(libInfoImplArray6);
                    VRegistry.writeServices(serviceInfoImplArray);
                    return string3;
                }
                ++n;
            }
        }
        if ((externalClientProviderInfoImplArray = VRegistry.readXCProviders()) != null) {
            string3 = VRegistry.toAttachedJarName(3, string, string2);
            String string7 = VRegistry.toFullJarPath(string3);
            n = 0;
            while (n < externalClientProviderInfoImplArray.length) {
                if (externalClientProviderInfoImplArray[n].getClassName().equals(string)) {
                    LibInfoImpl[] libInfoImplArray7 = externalClientProviderInfoImplArray[n].getAttachments();
                    LibInfoImpl[] libInfoImplArray8 = null;
                    int n10 = 0;
                    if (libInfoImplArray7 == null || libInfoImplArray7.length == 0) {
                        return null;
                    }
                    n10 = libInfoImplArray7.length - 1;
                    libInfoImplArray8 = new LibInfoImpl[n10];
                    int n11 = 0;
                    int n12 = 0;
                    while (n11 < libInfoImplArray7.length) {
                        if (libInfoImplArray7[n11].getJarName().equals(string3)) {
                            VRegistry.deleteLibInfoObject(string7, libInfoImplArray7[n11]);
                        } else if (n12 < n10) {
                            libInfoImplArray8[n12++] = libInfoImplArray7[n11];
                        } else {
                            return null;
                        }
                        ++n11;
                    }
                    externalClientProviderInfoImplArray[n].setAttachments(libInfoImplArray8);
                    VRegistry.writeXCProviders(externalClientProviderInfoImplArray);
                    return string7;
                }
                ++n;
            }
        }
        return null;
    }

    public static int removeProperties(String string, String string2, String string3) {
        ServiceInfoImpl[] serviceInfoImplArray = null;
        ToolInfoImpl[] toolInfoImplArray = null;
        ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray = null;
        Properties properties = null;
        LibInfoImpl[] libInfoImplArray = VRegistry.readAllLibJars();
        if (string2.equals(GLOBAL)) {
            properties = VRegistry.readAllProperties();
            int n = VRegistry.searchAndRemoveProperties(string3, string, properties, libInfoImplArray);
            if (n != 0) {
                return n;
            }
            VRegistry.writeAllProperties(properties);
            return 0;
        }
        if (string2.equals(GLOBALTOOL)) {
            properties = VRegistry.readAllToolProperties();
            int n = VRegistry.searchAndRemoveProperties(string3, string, properties, libInfoImplArray);
            if (n != 0) {
                return n;
            }
            VRegistry.writeAllToolProperties(properties);
            return 0;
        }
        if (string2.equals(GLOBALSERVICE)) {
            properties = VRegistry.readAllServiceProperties();
            int n = VRegistry.searchAndRemoveProperties(string3, string, properties, libInfoImplArray);
            if (n != 0) {
                return n;
            }
            VRegistry.writeAllServiceProperties(properties);
            return 0;
        }
        serviceInfoImplArray = VRegistry.readServices();
        int n = 0;
        while (n < serviceInfoImplArray.length) {
            if (serviceInfoImplArray[n].getClassName().equals(string2)) {
                int n2 = VRegistry.searchAndRemoveProperties(string3, string, serviceInfoImplArray[n].getProperties(), serviceInfoImplArray[n].getAttachments());
                if (n2 != 0) {
                    return n2;
                }
                VRegistry.writeServices(serviceInfoImplArray);
                return 0;
            }
            ++n;
        }
        toolInfoImplArray = VRegistry.readTools();
        int n3 = 0;
        while (n3 < toolInfoImplArray.length) {
            if (toolInfoImplArray[n3].getClassName().equals(string2)) {
                int n4 = VRegistry.searchAndRemoveProperties(string3, string, toolInfoImplArray[n3].getProperties(), toolInfoImplArray[n3].getAttachments());
                if (n4 != 0) {
                    return n4;
                }
                VRegistry.writeTools(toolInfoImplArray);
                return 0;
            }
            ++n3;
        }
        externalClientProviderInfoImplArray = VRegistry.readXCProviders();
        int n5 = 0;
        while (n5 < externalClientProviderInfoImplArray.length) {
            if (externalClientProviderInfoImplArray[n5].getClassName().equals(string2)) {
                int n6 = VRegistry.searchAndRemoveProperties(string3, string, externalClientProviderInfoImplArray[n5].getProperties(), new LibInfoImpl[0]);
                if (n6 != 0) {
                    return n6;
                }
                VRegistry.writeXCProviders(externalClientProviderInfoImplArray);
                return 0;
            }
            ++n5;
        }
        return 2;
    }

    private static boolean searchAndAddProperties(String string, String string2, Properties properties, LibInfoImpl[] libInfoImplArray) {
        if (string == null || string.trim().length() == 0) {
            VRegistry.setProperties(string2, properties);
            return true;
        }
        int n = 0;
        while (n < libInfoImplArray.length) {
            String string3 = libInfoImplArray[n].getJarName();
            String string4 = VRegistry.baseName(string3);
            if (string4.equals(string)) {
                VRegistry.setProperties(string2, libInfoImplArray[n].getProperties());
                return true;
            }
            ++n;
        }
        return false;
    }

    private static int searchAndRemoveProperties(String string, String string2, Properties properties, LibInfoImpl[] libInfoImplArray) {
        if (string == null || string.trim().length() == 0) {
            return VRegistry.unsetProperties(string2, properties);
        }
        int n = 0;
        while (n < libInfoImplArray.length) {
            String string3 = libInfoImplArray[n].getJarName();
            String string4 = VRegistry.baseName(string3);
            if (string4.equals(string)) {
                return VRegistry.unsetProperties(string2, libInfoImplArray[n].getProperties());
            }
            ++n;
        }
        return 3;
    }

    private static void setProperties(String string, Properties properties) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextElement().toString().trim();
                int n = string2.indexOf(61);
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 2, string2.length() - 1);
                properties.setProperty(string3, string4);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public static String toAttachedJarName(int n, String string, String string2) {
        String string3;
        if (string.equals(GLOBAL)) {
            return "ALL@" + string2;
        }
        if (string.equals(GLOBALTOOL)) {
            return "tools/ALLTOOL@" + string2;
        }
        if (string.equals(GLOBALSERVICE)) {
            return "services/ALLSERVICE@" + string2;
        }
        switch (n) {
            case 1: {
                string3 = Tools_Dir;
                break;
            }
            case 2: {
                string3 = Services_Dir;
                break;
            }
            case 3: {
                string3 = XCProviders_Dir;
                break;
            }
            default: {
                string3 = "";
            }
        }
        return String.valueOf(string3) + string + "@" + string2;
    }

    public static String toFullJarPath(String string) {
        if (string == null) {
            return null;
        }
        return String.valueOf(VRegistry.getCodebase()) + string;
    }

    public static String toJarName(int n, String string) {
        String string2;
        switch (n) {
            case 1: {
                string2 = Tools_Dir;
                break;
            }
            case 2: {
                string2 = Services_Dir;
                break;
            }
            case 3: {
                string2 = XCProviders_Dir;
                break;
            }
            default: {
                string2 = "";
            }
        }
        return String.valueOf(string2) + string + ".jar";
    }

    private static int unsetProperties(String string, Properties properties) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            while (stringTokenizer.hasMoreElements()) {
                String string3;
                string2 = string3 = stringTokenizer.nextElement().toString().trim();
                int n = string3.indexOf(61);
                if (n >= 0) {
                    string2 = string3.substring(0, n);
                }
                if (((Hashtable)properties).get(string2) == null) {
                    return 1;
                }
                ((Hashtable)properties).remove(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return 0;
    }

    private static int validateProperties(String string, String string2, Properties properties, LibInfoImpl[] libInfoImplArray) {
        if (string == null || string.trim().length() == 0) {
            return VRegistry.isThereProperty(string2, properties);
        }
        int n = 0;
        while (n < libInfoImplArray.length) {
            String string3 = VRegistry.baseName(libInfoImplArray[n].getJarName());
            if (string3.equals(string)) {
                return VRegistry.isThereProperty(string2, libInfoImplArray[n].getProperties());
            }
            ++n;
        }
        return 1;
    }

    protected static void writeAllLibJars(LibInfoImpl[] libInfoImplArray) {
        VRegistry.writeRegistrySection(3, libInfoImplArray);
    }

    protected static void writeAllProperties(Properties properties) {
        VRegistry.writeRegistrySection(4, properties);
    }

    protected static void writeAllServiceProperties(Properties properties) {
        VRegistry.writeRegistrySection(5, properties);
    }

    protected static void writeAllToolProperties(Properties properties) {
        VRegistry.writeRegistrySection(6, properties);
    }

    private static void writeRegistry(Object[] objectArray) {
        String string = VRegistry.getRegistryFile();
        String string2 = VRegistry.getBackupRegistryFile();
        try {
            File file;
            File file2 = new File(string2);
            if (file2.exists()) {
                file2.delete();
            }
            if ((file = new File(string)).exists()) {
                file.renameTo(file2);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(objectArray);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            String string3 = "Unable to open repository for write";
            Debug.trace((String)"VRegistry", (int)Debug.WARNING, (String)string3, (Throwable)iOException);
        }
    }

    private static void writeRegistrySection(int n, Object object) {
        Object[] objectArray = VRegistry.readRegistry();
        objectArray[n] = object;
        VRegistry.writeRegistry(objectArray);
    }

    protected static void writeServices(ServiceInfoImpl[] serviceInfoImplArray) {
        VRegistry.writeRegistrySection(0, serviceInfoImplArray);
    }

    protected static void writeTools(ToolInfoImpl[] toolInfoImplArray) {
        VRegistry.writeRegistrySection(1, toolInfoImplArray);
    }

    protected static void writeXCProviders(ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray) {
        VRegistry.writeRegistrySection(2, externalClientProviderInfoImplArray);
    }
}

