/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.Utils;

import com.sun.pdasync.Conduits.Utils.DesktopManager;
import com.sun.pdasync.Logger.Logger;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Category;
import palm.conduit.Log;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class SUNWCatManager {
    public int db;
    public DesktopManager desktopMgr;
    public SyncProperties props;
    public byte[] bytes;
    private static Locale theLocale;
    private static ResourceBundle messages;
    private static final String UNDELETE_CAT_MSG1 = "The following category was deleted on the Palm, but new/modified records are found ";
    private static final String UNDELETE_CAT_MSG2 = "in the same category on the Desktop: ";
    private static final String UNDELETE_CAT_MSG3 = "The category will be retained. Modified records in this directory on desktop will be duplicated ";
    private static final String UNDELETE_CAT_MSG4 = "(UnFiled and the above category) on each platform. Delete the unwanted record(s) and HotSync again.";

    static {
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"PDASync: can't find properties", (boolean)true);
            Logger.doLogging((String)("PDASync:" + e.getMessage()), (boolean)true);
            System.exit(1);
        }
    }

    public SUNWCatManager(SyncProperties props, int db) {
        this(props, db, null);
    }

    public SUNWCatManager(SyncProperties props, int db, DesktopManager desktopMgr) {
        this.props = props;
        this.db = db;
        this.desktopMgr = desktopMgr;
    }

    public void copyHHCategoryToPC(Vector hhCategories) {
        int i = 0;
        while (i < hhCategories.size()) {
            Category hhCat = (Category)hhCategories.elementAt(i);
            if (i > 0 && !hhCat.getName().equals("") && this.desktopMgr != null) {
                this.desktopMgr.createCategory(hhCat.getName());
            }
            hhCat.setIsModified(false);
            ++i;
        }
    }

    public Vector getHHCategories() throws IOException {
        this.bytes = SyncManager.readDBAppInfoBlock((int)this.db, (String)this.props.remoteNames[0]);
        return Category.parseCategories((byte[])this.bytes);
    }

    private int getNextHHIndex(Vector hhCategories) {
        int nextIndex = -1;
        int i = 1;
        while (i < hhCategories.size()) {
            Category tempCategory = (Category)hhCategories.elementAt(i);
            if (tempCategory.getName().equals("")) {
                nextIndex = tempCategory.getIndex();
                return nextIndex;
            }
            ++i;
        }
        return nextIndex;
    }

    private Category matchId(int id, Vector categories) {
        int i = 0;
        while (i < categories.size()) {
            Category category = (Category)categories.elementAt(i);
            if (id == category.getId() && id != 0) {
                return category;
            }
            ++i;
        }
        return null;
    }

    private Category matchName(String name, Vector categories) {
        int i = 0;
        while (i < categories.size()) {
            Category category = (Category)categories.elementAt(i);
            String categoryName = category.getName();
            if (categoryName != "" && name.equals(categoryName)) {
                return category;
            }
            ++i;
        }
        return null;
    }

    private void setDirtyCategoryFlags(Vector hhCategories) {
        int i = 0;
        while (i < hhCategories.size()) {
            Category tempCategory = (Category)hhCategories.elementAt(i);
            tempCategory.setIsModified(true);
            ++i;
        }
    }

    public Vector synchronize(Vector pcCategories, Vector bkCategories) throws IOException {
        Vector hhCategories = this.getHHCategories();
        if (this.props.syncType == 2) {
            this.copyHHCategoryToPC(hhCategories);
            return hhCategories;
        }
        if (pcCategories == null || pcCategories.size() == 0) {
            this.copyHHCategoryToPC(hhCategories);
            this.writeHHCategories(hhCategories);
            return hhCategories;
        }
        if (this.props.syncType == 3) {
            Category pcCat;
            Category hhCat;
            int i = 0;
            while (i < hhCategories.size()) {
                hhCat = (Category)hhCategories.elementAt(i);
                if (i != 0 && !hhCat.getName().equals("")) {
                    pcCat = this.matchName(hhCat.getName(), pcCategories);
                    if (pcCat != null) {
                        pcCategories.removeElement(pcCat);
                    } else {
                        hhCat.setName("");
                    }
                }
                hhCat.setIsModified(false);
                ++i;
            }
            int i2 = 0;
            while (i2 < pcCategories.size()) {
                pcCat = (Category)pcCategories.elementAt(i2);
                int nextIndex = this.getNextHHIndex(hhCategories);
                if (nextIndex == -1) break;
                hhCat = (Category)hhCategories.elementAt(nextIndex);
                String pc = pcCat.getName();
                if (!pc.equals("Unfiled")) {
                    hhCat.setName(pcCat.getName());
                }
                ++i2;
            }
            this.writeHHCategories(hhCategories);
        } else {
            Category pcCat;
            boolean newCat;
            if (this.props.firstDevice == 1 || this.props.syncType == 1) {
                this.setDirtyCategoryFlags(hhCategories);
            }
            Category hhCat = (Category)hhCategories.elementAt(0);
            hhCat.setIsModified(false);
            int i = 1;
            while (i < hhCategories.size()) {
                hhCat = (Category)hhCategories.elementAt(i);
                if (!hhCat.getName().equals("") && this.matchName(hhCat.getName(), pcCategories) == null) {
                    if (!hhCat.isModified()) {
                        Logger.doDebugLogging((String)("SUNWCatManager: Hand-Held Category Deleted - " + hhCat.getName()), (int)5);
                        hhCat.setName("");
                    } else {
                        String catName;
                        Category bkCat;
                        newCat = true;
                        if (bkCategories != null && (bkCat = this.matchId(hhCat.getId(), bkCategories)) != null && !(catName = bkCat.getName()).equals("") && (pcCat = this.matchName(catName, pcCategories)) != null) {
                            if (this.desktopMgr != null) {
                                this.desktopMgr.renameCategory(pcCat, hhCat.getName());
                            }
                            pcCategories.removeElement(pcCat);
                            newCat = false;
                        }
                        if (newCat && this.desktopMgr != null) {
                            this.desktopMgr.createCategory(hhCat.getName());
                        }
                        hhCat.setIsModified(false);
                    }
                }
                ++i;
            }
            int i3 = 0;
            while (i3 < pcCategories.size()) {
                pcCat = (Category)pcCategories.elementAt(i3);
                if (!pcCat.getName().equals("")) {
                    hhCat = this.matchName(pcCat.getName(), hhCategories);
                    if (hhCat != null) {
                        pcCat.setIndex(hhCat.getIndex());
                    } else {
                        newCat = false;
                        if (bkCategories != null && bkCategories.size() != 0 && this.matchName(pcCat.getName(), bkCategories) != null) {
                            Logger.doDebugLogging((String)("SUNWCatManager: Desktop Category Deleted - " + pcCat.getName()), (int)5);
                            Log.sunwAddEntry((String)"Desktop Category Deleted: ");
                            boolean removeSuccess = true;
                            if (this.desktopMgr != null) {
                                removeSuccess = this.desktopMgr.deleteCategory(pcCat);
                            }
                            if (removeSuccess) {
                                pcCat.delete();
                            } else {
                                Logger.doLogging((String)" ");
                                Logger.doLogging((String)messages.getString(UNDELETE_CAT_MSG1));
                                Logger.doLogging((String)(String.valueOf(messages.getString(UNDELETE_CAT_MSG2)) + pcCat.getName()));
                                Logger.doLogging((String)messages.getString(UNDELETE_CAT_MSG3));
                                Logger.doLogging((String)messages.getString(UNDELETE_CAT_MSG4));
                                Logger.doLogging((String)" ");
                                newCat = true;
                            }
                        } else {
                            newCat = true;
                        }
                        if (newCat) {
                            int nextIndex = this.getNextHHIndex(hhCategories);
                            if (nextIndex == -1) {
                                Logger.doLogging((String)(String.valueOf(messages.getString("Too Many Categories. category not added to HH - ")) + pcCat.getName()));
                            } else {
                                pcCat.setIndex(nextIndex);
                                hhCat = (Category)hhCategories.elementAt(nextIndex);
                                hhCat.setName(pcCat.getName());
                                hhCat.setId(nextIndex);
                            }
                        }
                    }
                }
                ++i3;
            }
        }
        pcCategories = hhCategories;
        this.writeHHCategories(hhCategories);
        return hhCategories;
    }

    public void writeHHCategories(Vector hhCategories) throws IOException {
        byte[] tmp = Category.toBytes((Vector)hhCategories);
        System.arraycopy(tmp, 0, this.bytes, 0, tmp.length);
        SyncManager.writeDBAppInfoBlock((int)this.db, (String)this.props.remoteNames[0], (byte[])this.bytes);
    }
}

