/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Registry;

import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncUtils.ObjDump;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.Serializable;
import java.util.StringTokenizer;

public class ConduitRegInfo
implements Serializable,
ObjDump {
    private static int CLASSNAME = 0;
    private static int CLASSPATH = 1;
    private static int CONDUIT = 2;
    private static int CREATOR_ID = 3;
    private static int DIRECTORY = 4;
    private static int FILE_0 = 5;
    private static int INTEGRATE = 6;
    private static int MODULE = 7;
    private static int NAME = 8;
    private static int REMOTE_0 = 9;
    private static int VM = 10;
    private static int PRIORITY = 11;
    private static int DEF_SYNC_TYPE = 12;
    private static int ACTIVE = 13;
    private static int FIELD_NUM = 14;
    public static final int MIN_PRIORITY = 0;
    public static final int DEF_PRIORITY = 2;
    public static final int MAX_PRIORITY = 4;
    protected String className;
    protected String classPath;
    protected String conduit;
    protected int creatorID;
    protected String directory;
    protected String file0;
    protected int integrate;
    protected int module;
    protected String name;
    protected String remote0;
    protected String vm;
    protected int priority;
    protected int defaultSyncType;
    protected boolean activeFlag;
    public static final String DELIMITER = "|";

    public ConduitRegInfo() {
        this.className = null;
        this.classPath = null;
        this.conduit = null;
        this.creatorID = -1;
        this.directory = null;
        this.file0 = null;
        this.integrate = 0;
        this.module = -1;
        this.name = null;
        this.remote0 = null;
        this.vm = "Java";
        this.priority = 2;
        this.defaultSyncType = 0;
        this.activeFlag = true;
    }

    public ConduitRegInfo(ConduitRegInfo aConduit) {
        this.className = aConduit.getClassName();
        this.classPath = aConduit.getClassPath();
        this.conduit = aConduit.getConduit();
        this.creatorID = aConduit.getCreatorID();
        this.directory = aConduit.getDirectory();
        this.file0 = aConduit.getFile0();
        this.integrate = aConduit.getIntegrate();
        this.name = aConduit.getName();
        this.module = aConduit.getModule();
        this.remote0 = aConduit.getRemote0();
        this.vm = aConduit.getVM();
        this.priority = aConduit.getPriority();
        this.defaultSyncType = aConduit.getDefaultSyncType();
        this.activeFlag = aConduit.getDefaultActiveState();
    }

    public String dump() {
        return "<Conduit File: " + this.conduit + "> <Conduit Name: " + this.name + "> <Class Name: " + this.className + "> <Classpath: " + this.classPath + "> <Creator ID: " + this.creatorID + " (" + Integer.toHexString(this.creatorID) + ")" + "> <Directory: " + this.directory + "> <File0: " + this.file0 + "> <Integrate: " + this.integrate + "> <Module: " + this.module + "> <Remote0: " + this.remote0 + "> <Virtual Machine: " + this.vm + "> <Priority: " + this.priority + "> <Default Sync Type: " + ConduitRegInfo.getDefaultSyncTypeString(this.defaultSyncType) + "> <Default Active Flag: " + this.activeFlag + ">\n";
    }

    public String dumpFormatted() {
        return this.dumpFormatted(0);
    }

    public String dumpFormatted(int numTabs) {
        String tabs = SyncUtils.makeTabsString((int)numTabs);
        return String.valueOf(tabs) + "ConduitRegInfo\n" + tabs + "  {\n" + tabs + "    Conduit File      : " + this.conduit + "\n" + tabs + "    Conduit Name      : " + this.name + "\n" + tabs + "    Classname         : " + this.className + "\n" + tabs + "    Classpath         : " + this.classPath + "\n" + tabs + "    Creator ID        : " + this.creatorID + " (" + Integer.toHexString(this.creatorID) + ")" + "\n" + tabs + "    Directory         : " + this.directory + "\n" + tabs + "    File0             : " + this.file0 + "\n" + tabs + "    Integrate         : " + this.integrate + "\n" + tabs + "    Module            : " + this.module + "\n" + tabs + "    Remote0           : " + this.remote0 + "\n" + tabs + "    Virt. Machine     : " + this.vm + "\n" + tabs + "    Priority          : " + this.priority + "\n" + tabs + "    Default Sync Type : " + ConduitRegInfo.getDefaultSyncTypeString(this.defaultSyncType) + "\n" + tabs + "    Default Active    : " + this.activeFlag + "\n" + tabs + "  }\n";
    }

    public String encodeConduitInfo() {
        String encoded = new String(String.valueOf(this.className) + DELIMITER + this.classPath + DELIMITER + this.conduit + DELIMITER + this.creatorID + DELIMITER + this.directory + DELIMITER + this.file0 + DELIMITER + this.integrate + DELIMITER + this.module + DELIMITER + this.name + DELIMITER + this.remote0 + DELIMITER + this.vm + DELIMITER + this.priority + DELIMITER + this.defaultSyncType + DELIMITER + this.activeFlag);
        return encoded;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getConduit() {
        return this.conduit;
    }

    public int getCreatorID() {
        return this.creatorID;
    }

    public boolean getDefaultActiveState() {
        return this.activeFlag;
    }

    public int getDefaultSyncType() {
        return this.defaultSyncType;
    }

    public static String getDefaultSyncTypeString(int type) {
        switch (type) {
            case 0: {
                return "SYNC_FAST";
            }
            case 1: {
                return "SYNC_SLOW";
            }
            case 2: {
                return "SYNC_HH_TO_PC";
            }
            case 3: {
                return "SYNC_PC_TO_HH";
            }
            case 4: {
                return "SYNC_INSTALL";
            }
            case 5: {
                return "SYNC_BACKUP";
            }
            case 6: {
                return "SYNC_DO_NOTHING";
            }
            case 7: {
                return "SYNC_PROFILE_INSTALL";
            }
        }
        return "UNKNOWN";
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFile0() {
        return this.file0;
    }

    public int getIntegrate() {
        return this.integrate;
    }

    public int getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getRemote0() {
        return this.remote0;
    }

    public String getVM() {
        return this.vm;
    }

    public boolean isSame(ConduitRegInfo someConduit) {
        if (!this.getClassName().equals(someConduit.getClassName())) {
            return false;
        }
        if (!this.getClassPath().equals(someConduit.getClassPath())) {
            return false;
        }
        if (!this.getName().equals(someConduit.getName())) {
            return false;
        }
        if (this.getCreatorID() != someConduit.getCreatorID()) {
            return false;
        }
        Logger.doDebugLogging((String)("Conduit found in vector: " + someConduit.getName()), (int)4);
        return true;
    }

    public static void main(String[] args) {
    }

    public boolean parseLine(String line) {
        StringTokenizer strTok = new StringTokenizer(line, DELIMITER);
        String[] tokens = new String[FIELD_NUM];
        int counter = 0;
        while (strTok.hasMoreTokens()) {
            tokens[counter] = new String(strTok.nextToken());
            ++counter;
        }
        if (counter != FIELD_NUM) {
            Logger.doDebugLogging((String)("Conduit registry entry is invalid:\n\t" + line), (int)4);
            return false;
        }
        this.className = tokens[CLASSNAME];
        this.classPath = tokens[CLASSPATH];
        this.conduit = tokens[CONDUIT];
        this.creatorID = Integer.parseInt(tokens[CREATOR_ID]);
        this.directory = tokens[DIRECTORY];
        this.file0 = tokens[FILE_0];
        this.integrate = Integer.parseInt(tokens[INTEGRATE]);
        this.module = Integer.parseInt(tokens[MODULE]);
        this.name = tokens[NAME];
        this.remote0 = tokens[REMOTE_0];
        this.vm = tokens[VM];
        this.priority = Integer.parseInt(tokens[PRIORITY]);
        this.defaultSyncType = Integer.parseInt(tokens[DEF_SYNC_TYPE]);
        this.activeFlag = Boolean.valueOf(tokens[ACTIVE]);
        return true;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public void setClassPath(String path) {
        this.classPath = path;
    }

    public void setConduit(String cond) {
        this.conduit = cond;
    }

    public void setCreatorID(int dbID) {
        this.creatorID = dbID;
    }

    public void setDefaultActiveFlag(boolean flag) {
        this.activeFlag = flag;
    }

    public void setDefaultSyncType(int sType) {
        this.defaultSyncType = sType < 0 || sType > 7 ? 0 : sType;
    }

    public void setDirectory(String dir) {
        this.directory = dir;
    }

    public void setFile0(String f0) {
        this.file0 = f0;
    }

    public void setIntegrate(int ntg) {
        this.integrate = ntg;
    }

    public void setModule(int mod) {
        this.module = mod;
    }

    public void setName(String cname) {
        this.name = cname;
    }

    public void setPriority(int pri) {
        this.priority = pri < 0 || pri > 4 ? 2 : pri;
    }

    public void setRemote0(String r0) {
        this.remote0 = r0;
    }

    public void setVM(String jvm) {
        this.vm = jvm;
    }
}

