/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.AddressSync;

import com.sun.pdasync.Conduits.AddressSync.AddressSyncConstants;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncRecord;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncUtils.SyncConstants;
import java.io.File;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import palm.conduit.Category;
import palm.conduit.Log;
import palm.conduit.Record;

public final class AddressSyncUtils {
    public static final String NEWLINE_ENCODE_ATTR = "ENCODING=QUOTED-PRINTABLE";
    public static final String NEWLINE_ENCODE = "=0A=";

    public static void debugVectorOfRecords(Vector records) {
        int num = records.size();
        AddressSyncUtils.doDebug("Num Records: " + num);
        int i = 0;
        while (i < num) {
            AddressSyncRecord one = (AddressSyncRecord)records.elementAt(i);
            AddressSyncUtils.doDebug(one.toFormattedString());
            ++i;
        }
    }

    public static void doDebug(String message) {
        Logger.doDebugLogging((String)("AddressSync Conduit: " + message), (int)5);
    }

    public static void doLog(String message) {
        Log.sunwAddEntry((String)("AddressSync Conduit: " + message));
    }

    public static String emptyIfNull(String field) {
        if (field == null) {
            return "";
        }
        return field;
    }

    public static String fixSlash(String str, char newChar) {
        StringBuffer sbuf = new StringBuffer(str);
        int i = 0;
        while (i < sbuf.length()) {
            if (sbuf.charAt(i) == '/') {
                sbuf.setCharAt(i, newChar);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String getCategoryName(Record record, Vector categories) {
        int i = 0;
        while (i < categories.size()) {
            Category category = (Category)categories.elementAt(i);
            if (category.getIndex() == record.getCategoryIndex()) {
                return category.getName();
            }
            ++i;
        }
        return null;
    }

    public static boolean hasNewline(String str) {
        return str.indexOf("\n") >= 0;
    }

    public static boolean isEmptyField(String field) {
        return field == null || field.length() == 0 || field.trim().length() == 0;
    }

    public static boolean isValidField(String fieldName) {
        int i = 0;
        while (i < AddressSyncConstants.MAPPED_FIELDS.length) {
            if (fieldName.equals(AddressSyncConstants.MAPPED_FIELDS[i]) || fieldName.equals(AddressSyncConstants.MAPPED_FIELDS[i].toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String lastAndFirstName(AddressSyncRecord addrRecord) {
        String firstName = addrRecord.getFirstName();
        String lastName = addrRecord.getName();
        String name = String.valueOf(lastName != null ? String.valueOf(lastName) + "," : "") + (firstName != null ? firstName : "");
        if (name != null && (name = name.trim()).length() == 0) {
            return null;
        }
        if (name.endsWith(",")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static Vector makeDefaultCategories(ResourceBundle addrRes) {
        String catName = null;
        Vector<Category> cats = new Vector<Category>(16);
        int i = 0;
        while (i < 3) {
            catName = addrRes.getString(AddressSyncConstants.HH_CATEGORIES[i]);
            cats.addElement(new Category(catName, i, i, false));
            ++i;
        }
        int i2 = 3;
        while (i2 < 16) {
            cats.addElement(new Category("", i2, i2, false));
            ++i2;
        }
        return cats;
    }

    public static Hashtable[] makeHashtablesOfExtraPalmPilotFields() {
        Hashtable[] ht = new Hashtable[]{new Hashtable(AddressSyncConstants.EXTRA_PALMPILOT_FIELDS.length, 0.95f), new Hashtable(AddressSyncConstants.EXTRA_PALMPILOT_FIELDS.length, 0.95f)};
        int i = 0;
        while (i < AddressSyncConstants.EXTRA_PALMPILOT_FIELDS.length) {
            ht[0].put(AddressSyncConstants.EXTRA_PALMPILOT_FIELDS[i][0], Boolean.FALSE);
            ht[1].put(AddressSyncConstants.EXTRA_PALMPILOT_FIELDS[i][0], AddressSyncConstants.EXTRA_PALMPILOT_FIELDS[i][1]);
            ++i;
        }
        return ht;
    }

    public static String makeHeuristicCardName(AddressSyncRecord addrRecord, Vector categories) {
        String card = null;
        String sep = SyncConstants.SEPARATOR;
        String suffix = "";
        String person = AddressSyncUtils.lastAndFirstName(addrRecord);
        String company = addrRecord.getCompany();
        String home = AddressSyncConstants.USER_OWN_VCARDS_DIR;
        String category = AddressSyncUtils.getCategoryName((Record)addrRecord, categories);
        if (category == null || category.compareTo("Unfiled") == 0) {
            category = "";
        }
        String dir = String.valueOf(home) + (category == null || category.length() == 0 ? "" : String.valueOf(category) + sep);
        if (!(person != null && person.length() != 0 || company != null && company.length() != 0)) {
            card = String.valueOf(dir) + "Unnamed-" + suffix;
        } else if ((person == null || person.length() == 0) && company != null && company.length() != 0) {
            card = String.valueOf(dir) + AddressSyncUtils.fixSlash(company, '_') + suffix;
        } else if (person != null && person.length() != 0) {
            card = String.valueOf(dir) + AddressSyncUtils.fixSlash(person, '_') + suffix;
        }
        return card;
    }

    public static String makeUniqueCardName(AddressSyncRecord addrRecord, Vector categories) {
        String card;
        String cardName = card = AddressSyncUtils.makeHeuristicCardName(addrRecord, categories);
        File file = new File(cardName);
        int n = 1;
        while (file.exists()) {
            cardName = String.valueOf(card) + ":" + n;
            ++n;
            file = new File(cardName);
        }
        return cardName;
    }

    public static void nameFreshRecords(Vector records, Vector categories) {
        int i = 0;
        while (i < records.size()) {
            AddressSyncUtils.nameThisRecord((AddressSyncRecord)records.elementAt(i), categories);
            ++i;
        }
    }

    public static void nameThisRecord(AddressSyncRecord record, Vector categories) {
        if (record.getCardFilename() == null) {
            record.setCardFilename(AddressSyncUtils.makeHeuristicCardName(record, categories));
        }
    }

    public static String nullIfQuotedNullString(String field) {
        String name = field;
        if (field == null || field.length() == 0) {
            name = null;
        } else if (field.equals("null")) {
            name = null;
        }
        return name;
    }

    public static String nullIfSemicolon(String str) {
        if (str == null || str.equals(";")) {
            return null;
        }
        return str;
    }

    public static void printVectorOfRecords(Vector records) {
        int num = records.size();
        System.out.println("Num Records: " + num);
        int i = 0;
        while (i < num) {
            AddressSyncRecord one = (AddressSyncRecord)records.elementAt(i);
            System.out.println(one.toFormattedString());
            ++i;
        }
    }

    public static String replaceNewline(String str) {
        int index = 0;
        while ((index = str.indexOf("\n", index)) >= 0) {
            str = String.valueOf(str.substring(0, index)) + NEWLINE_ENCODE + str.substring(index);
            index += NEWLINE_ENCODE.length() + "\n".length();
        }
        return str;
    }

    public String replaceNewline2(String line) {
        if (line.indexOf(10) != -1) {
            int size = 256;
            int[] newlineIndex = new int[size];
            StringBuffer strBuffer = new StringBuffer(line);
            int n = 0;
            int i = 0;
            while (i < strBuffer.length()) {
                if (strBuffer.charAt(i) == '\n') {
                    if (n < size) {
                        newlineIndex[n] = i;
                    } else {
                        int[] tempArray = newlineIndex;
                        newlineIndex = new int[size += 256];
                        int j = 0;
                        while (j < tempArray.length) {
                            newlineIndex[j] = tempArray[j];
                            ++j;
                        }
                        newlineIndex[n] = i;
                    }
                    ++n;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < n) {
                int offset = newlineIndex[i2] + i2 * NEWLINE_ENCODE.length();
                strBuffer.insert(offset, NEWLINE_ENCODE);
                ++i2;
            }
            return strBuffer.toString();
        }
        return line;
    }

    public static String semicolonIfEmpty(String field) {
        String name = ";";
        if (field != null && (field.length() != 0 || field.trim().length() != 0)) {
            name = field;
        }
        return name;
    }

    public static String[] tokenizeFields(String field) {
        if (field == null) {
            return null;
        }
        StringTokenizer falseTokenizer = new StringTokenizer(field, ";", false);
        int count = falseTokenizer.countTokens();
        String[] elements = new String[count];
        int i = 0;
        while (i < count) {
            elements[i] = (String)falseTokenizer.nextElement();
            ++i;
        }
        return elements;
    }
}

