/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.extension;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.util.DialogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.ExtensionInfo;
import sun.misc.ExtensionInstallationException;
import sun.misc.ExtensionInstallationProvider;
import sun.plugin.extension.ExtensionInstaller;
import sun.plugin.extension.ExtensionUtils;
import sun.plugin.extension.JavaExtensionInstaller;
import sun.plugin.extension.NativeExtensionInstaller;
import sun.plugin.extension.RawExtensionInstaller;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.Trace;
import sun.security.action.GetPropertyAction;

public class ExtensionInstallationImpl
implements ExtensionInstallationProvider {
    public boolean installExtension(final ExtensionInfo extensionInfo, final ExtensionInfo extensionInfo2) throws ExtensionInstallationException {
        Trace.msgExtPrintln("optpkg.install.info", new Object[]{extensionInfo});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ExtensionInstallationException, CertificateException, CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, KeyStoreException, NoSuchAlgorithmException, IOException, InterruptedException {
                    String string = ExtensionUtils.makePlatformDependent(ExtensionUtils.extractJarFileName(extensionInfo.url));
                    String string2 = ExtensionUtils.makePlatformDependent(extensionInfo.url);
                    if (ExtensionInstallationImpl.this.askUserForAcknowledgment(extensionInfo, extensionInfo2) == 1) {
                        throw new ExtensionInstallationException("User denied installation of " + string2);
                    }
                    URL uRL = new URL(string2);
                    URLConnection uRLConnection = uRL.openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    String string3 = ExtensionUtils.getTempDir() + File.separator + string;
                    File file = new File(string3);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    ExtensionUtils.copy(bufferedInputStream, bufferedOutputStream);
                    bufferedInputStream.close();
                    inputStream.close();
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    ExtensionInstallationImpl.this.verifyJar(string2, string3);
                    ExtensionInstallationImpl.this.installJarFile(string2, string3);
                    if (file.exists()) {
                        file.delete();
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            String string = null;
            string = throwable instanceof PrivilegedActionException ? ((throwable2 = ((PrivilegedActionException)throwable).getException()) instanceof CertificateExpiredException ? ResourceHandler.getMessage("optpkg.cert_expired") : (throwable2 instanceof CertificateNotYetValidException ? ResourceHandler.getMessage("optpkg.cert_notyieldvalid") : (throwable2 instanceof CertificateException ? ResourceHandler.getMessage("optpkg.cert_notverify") : ResourceHandler.getMessage("optpkg.general_error")))) : ResourceHandler.getMessage("optpkg.general_error");
            Trace.extPrintException(throwable2, string, ResourceHandler.getMessage("optpkg.caption"));
            Trace.msgExtPrintln("optpkg.install.fail");
            return true;
        }
        Trace.msgExtPrintln("optpkg.install.ok");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyJar(String string, String string2) throws ExtensionInstallationException, CertificateException, CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, KeyStoreException, NoSuchAlgorithmException, IOException {
        ZipFile zipFile = null;
        try {
            try {
                Certificate[] certificateArray;
                Object object;
                Object object2;
                Cloneable cloneable;
                HashMap<Certificate[], CodeSource> hashMap = new HashMap<Certificate[], CodeSource>();
                byte[] byArray = new byte[8192];
                Certificate[] certificateArray2 = null;
                zipFile = new JarFile(string2, true);
                Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                while (enumeration.hasMoreElements()) {
                    CodeSource codeSource;
                    boolean bl;
                    int n;
                    cloneable = enumeration.nextElement();
                    object2 = ((ZipEntry)cloneable).getName();
                    object = ((JarFile)zipFile).getInputStream((ZipEntry)cloneable);
                    while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                    }
                    ((InputStream)object).close();
                    if (((String)object2).startsWith("META-INF/") || ((String)object2).endsWith("/") || ((ZipEntry)cloneable).getSize() == 0L) continue;
                    certificateArray = ((JarEntry)cloneable).getCertificates();
                    boolean bl2 = bl = certificateArray != null && certificateArray.length > 0;
                    if (!bl) throw new ExtensionInstallationException("Optional package installer is unsigned. (signatures missing or not parsable)");
                    if (certificateArray2 == null) {
                        if (this.hasMultipleSigners(certificateArray)) {
                            throw new ExtensionInstallationException("Error: one entry has multiple certificates");
                        }
                        certificateArray2 = certificateArray;
                    } else if (!this.equalChains(certificateArray2, certificateArray)) {
                        throw new ExtensionInstallationException("Error: Entries signed by different signer");
                    }
                    if ((codeSource = (CodeSource)hashMap.get(certificateArray)) != null) continue;
                    codeSource = new CodeSource(new URL(string), certificateArray);
                    hashMap.put(certificateArray, codeSource);
                    if (TrustDecider.isAllPermissionGranted((CodeSource)codeSource)) continue;
                    throw new ExtensionInstallationException("User deny optional package installer to be launched.");
                }
                cloneable = ((JarFile)zipFile).getManifest();
                if (cloneable == null) throw new ExtensionInstallationException("No manifest in the optional package installer.");
                object2 = ((Manifest)cloneable).getEntries().entrySet();
                object = object2.iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    certificateArray = (Certificate[])entry.getKey();
                    if (((JarFile)zipFile).getEntry((String)certificateArray) != null) continue;
                    throw new ExtensionInstallationException("Manifest entry not in the JAR file");
                }
                Object var16_17 = null;
                if (zipFile == null) return;
            }
            catch (IOException iOException) {
                throw new ExtensionInstallationException("IO Error. Unable to verify optional package installer.");
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (zipFile == null) throw throwable;
            zipFile.close();
            throw throwable;
        }
        zipFile.close();
    }

    private boolean hasMultipleSigners(Certificate[] certificateArray) {
        Certificate certificate = certificateArray[0];
        for (int i = 1; i < certificateArray.length; ++i) {
            Certificate certificate2 = certificateArray[i];
            if (!this.isSigner(certificate, certificate2)) {
                return true;
            }
            certificate = certificate2;
        }
        return false;
    }

    private boolean isSigner(Certificate certificate, Certificate certificate2) {
        try {
            certificate.verify(certificate2.getPublicKey());
            return true;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    private boolean equalChains(Certificate[] certificateArray, Certificate[] certificateArray2) {
        if (certificateArray.length != certificateArray2.length) {
            return false;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            if (certificateArray[i].equals(certificateArray2[i])) continue;
            return false;
        }
        return true;
    }

    private int askUserForAcknowledgment(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) {
        Object object;
        String string = null;
        if (extensionInfo2 != null) {
            object = extensionInfo.name;
            if (extensionInfo.title != null) {
                object = extensionInfo.title;
            }
            int n = extensionInfo2.isCompatibleWith(extensionInfo);
            switch (n) {
                case 1: {
                    MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage("optpkg.prompt_user.new_spec.text"));
                    Object[] objectArray = new Object[]{extensionInfo.specVersion, object, extensionInfo.url};
                    string = messageFormat.format(objectArray);
                    break;
                }
                case 2: {
                    MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage("optpkg.prompt_user.new_impl.text"));
                    Object[] objectArray = new Object[]{extensionInfo.implementationVersion, object, extensionInfo.url};
                    string = messageFormat.format(objectArray);
                    break;
                }
                case 3: {
                    MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage("optpkg.prompt_user.new_vendor.text"));
                    Object[] objectArray = new Object[]{extensionInfo.vendor, extensionInfo.vendorId, object, extensionInfo.url};
                    string = messageFormat.format(objectArray);
                    break;
                }
                default: {
                    MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage("optpkg.prompt_user.default.text"));
                    Object[] objectArray = new Object[]{extensionInfo.name, extensionInfo.url};
                    string = messageFormat.format(objectArray);
                    break;
                }
            }
        } else {
            object = new MessageFormat(ResourceHandler.getMessage("optpkg.prompt_user.default.text"));
            Object[] objectArray = new Object[]{extensionInfo.name, extensionInfo.url};
            string = ((Format)object).format(objectArray);
        }
        int n = 0;
        if (!Trace.isAutomationEnabled()) {
            n = DialogFactory.showDownloadDialog((int)3, (String)string);
        } else {
            Trace.msgExtPrintln("optpkg.install.automation");
            n = 0;
        }
        if (n == 0) {
            Trace.msgExtPrintln("optpkg.install.granted", new Object[]{extensionInfo.url});
        } else {
            Trace.msgExtPrintln("optpkg.install.deny");
        }
        return n;
    }

    private void installJarFile(String string, String string2) throws ExtensionInstallationException, IOException, InterruptedException {
        Trace.msgExtPrintln("optpkg.install.begin", new Object[]{string2});
        JarFile jarFile = new JarFile(string2);
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            String string3 = AccessController.doPrivileged(new GetPropertyAction("java.ext.dirs"));
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            String string4 = stringTokenizer.nextToken();
            Attributes attributes = manifest.getMainAttributes();
            ExtensionInstaller extensionInstaller = new RawExtensionInstaller();
            if (attributes != null) {
                if (attributes.getValue(Attributes.Name.MAIN_CLASS) != null) {
                    extensionInstaller = new JavaExtensionInstaller();
                } else if (attributes.getValue(Attributes.Name.EXTENSION_INSTALLATION) != null) {
                    extensionInstaller = new NativeExtensionInstaller();
                }
            }
            jarFile = null;
            extensionInstaller.install(string, string2, string4);
        }
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage((String)string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey((String)string);
    }
}

