/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

final class DHKeyExchange {
    private BigInteger modulus;
    private BigInteger base;
    private PrivateKey privateKey;
    private BigInteger publicValue;
    private static final byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    private static final BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
    private static final BigInteger skip1024Base = BigInteger.valueOf(2L);
    private static final byte[] export512ModulusBytes = new byte[]{-84, -56, 20, -98, -122, 43, -77, 43, 30, -10, -71, 114, 84, -8, 67, -70, 71, -8, -111, 80, 119, 34, -95, 107, 89, 124, 64, 127, 37, 118, 76, -60, -15, -95, -48, 105, 2, -123, -35, 16, -65, -27, 117, -124, -107, 111, 37, -87, -40, -127, -99, -94, 51, -112, 37, -92, -97, -97, 56, 83, 103, -20, 21, 5};
    private static final BigInteger export512Modulus = new BigInteger(1, export512ModulusBytes);
    private static final BigInteger export512Base = BigInteger.valueOf(2L);

    DHKeyExchange(boolean bl) {
        if (bl) {
            this.modulus = skip1024Modulus;
            this.base = skip1024Base;
        } else {
            this.modulus = export512Modulus;
            this.base = export512Base;
        }
    }

    DHKeyExchange(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.base = bigInteger2;
    }

    BigInteger getModulus() {
        return this.modulus;
    }

    BigInteger getBase() {
        return this.base;
    }

    void generateKeyPair(SecureRandom secureRandom, int n) {
        try {
            DHParameterSpec dHParameterSpec = new DHParameterSpec(this.modulus, this.base, n);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DiffieHellman");
            keyPairGenerator.initialize(dHParameterSpec);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            if (publicKey instanceof DHPublicKey) {
                this.publicValue = ((DHPublicKey)publicKey).getY();
            } else {
                KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman", keyPairGenerator.getProvider());
                DHPublicKeySpec dHPublicKeySpec = keyFactory.getKeySpec(publicKey, DHPublicKeySpec.class);
                this.publicValue = dHPublicKeySpec.getY();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
        }
    }

    BigInteger getPublicKey() {
        return this.publicValue;
    }

    byte[] getAgreedSecret(BigInteger bigInteger) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman");
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, this.modulus, this.base);
            PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
            KeyAgreement keyAgreement = KeyAgreement.getInstance("DiffieHellman");
            keyAgreement.init(this.privateKey);
            keyAgreement.doPhase(publicKey, true);
            byte[] byArray = keyAgreement.generateSecret();
            return byArray;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate secret", generalSecurityException);
        }
    }
}

