/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;

class PersistentStore {
    private FileInputStream in;
    private FileOutputStream out;
    private String fileName;
    private long fileLength;
    private Object[] maps = new Object[4];
    private TreeMap deletedObjectsBySize = new TreeMap();
    private HashMap deletedObjectsByOffset = new HashMap();
    private HashMap deletedObjectsByEnd = new HashMap();
    private HashMap objectIdMap = new HashMap();
    private boolean inrecovery = false;

    public PersistentStore(String string) throws IOException {
        this.fileName = string;
        this.fileLength = 0L;
        this.maps[0] = this.deletedObjectsBySize;
        this.maps[1] = this.deletedObjectsByOffset;
        this.maps[2] = this.deletedObjectsByEnd;
        this.maps[3] = this.objectIdMap;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        this.fileLength = randomAccessFile.length();
        randomAccessFile.close();
    }

    private void addDeleteObject(PersistObject persistObject) {
        if (persistObject.length == 0) {
            return;
        }
        Long l = new Long(persistObject.offset + (long)persistObject.length);
        this.deletedObjectsBySize.put(persistObject, persistObject);
        this.deletedObjectsByOffset.put(new Long(persistObject.offset), persistObject);
        this.deletedObjectsByEnd.put(l, persistObject);
    }

    public void addPersistObject(PersistObject persistObject) {
        this.putObjectToIdMap(persistObject);
    }

    public void addToSnapshot(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(PersistObject.currentID);
        objectOutputStream.writeObject(this.maps);
    }

    private PersistObject createPersistObject(byte[] byArray) {
        int n = byArray.length;
        PersistObject persistObject = new PersistObject(this.fileLength, n);
        if (this.deletedObjectsBySize.isEmpty()) {
            return persistObject;
        }
        PersistObject persistObject2 = (PersistObject)this.deletedObjectsBySize.lastKey();
        if (persistObject2.length < persistObject.length) {
            return persistObject;
        }
        persistObject.offset = persistObject2.offset;
        persistObject2.offset = persistObject.offset + (long)n;
        this.removeDeleteObject(persistObject2);
        PersistObject persistObject3 = persistObject2;
        persistObject3.length = persistObject3.length - persistObject.length;
        this.addDeleteObject(persistObject2);
        return persistObject;
    }

    public void deleteObject(long l) {
        PersistObject persistObject = this.getObjectFromId(l);
        if (persistObject == null) {
            System.out.println("invaid object id: " + l);
            return;
        }
        this.removeObjectFromIdMap(l);
        Long l2 = new Long(persistObject.offset + (long)persistObject.length);
        PersistObject persistObject2 = (PersistObject)this.deletedObjectsByOffset.get(l2);
        if (persistObject2 != null) {
            System.out.println("join id: " + persistObject2.id);
            this.removeDeleteObject(persistObject2);
            PersistObject persistObject3 = persistObject;
            persistObject3.length = persistObject3.length + persistObject2.length;
            this.addDeleteObject(persistObject);
        }
        if ((persistObject2 = (PersistObject)this.deletedObjectsByEnd.get(new Long(persistObject.offset))) != null) {
            this.removeDeleteObject(persistObject);
            this.removeDeleteObject(persistObject2);
            PersistObject persistObject4 = persistObject2;
            persistObject4.length = persistObject4.length + persistObject.length;
            this.addDeleteObject(persistObject2);
        }
    }

    private PersistObject getObjectFromId(long l) {
        return (PersistObject)this.objectIdMap.get(new Long(l));
    }

    public PersistObject getPersistObject(long l) {
        return this.getObjectFromId(l);
    }

    private void putObjectToIdMap(PersistObject persistObject) {
        this.objectIdMap.put(new Long(persistObject.id), persistObject);
    }

    private void read(byte[] byArray, long l) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.fileName, "r");
        randomAccessFile.seek(l);
        randomAccessFile.read(byArray);
        randomAccessFile.close();
    }

    public byte[] readObjectBytes(long l) throws IOException {
        PersistObject persistObject = this.getObjectFromId(l);
        byte[] byArray = new byte[persistObject.length];
        this.read(byArray, persistObject.offset);
        return byArray;
    }

    public void recoverFromSnapshot(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        PersistObject.currentID = objectInputStream.readLong();
        this.maps = (Object[])objectInputStream.readObject();
        this.deletedObjectsBySize = (TreeMap)this.maps[0];
        this.deletedObjectsByOffset = (HashMap)this.maps[1];
        this.deletedObjectsByEnd = (HashMap)this.maps[2];
        this.objectIdMap = (HashMap)this.maps[3];
    }

    private void removeDeleteObject(PersistObject persistObject) {
        this.deletedObjectsBySize.remove(persistObject);
        this.deletedObjectsByOffset.remove(new Long(persistObject.offset));
    }

    private void removeObjectFromIdMap(long l) {
        this.objectIdMap.remove(new Long(l));
    }

    public void setNextID(long l) {
        PersistObject.currentID = l + 1L;
    }

    private void write(long l, byte[] byArray) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.fileName, "rw");
        if (l != this.fileLength) {
            System.out.println("write offset:" + l);
        }
        randomAccessFile.seek(l);
        randomAccessFile.write(byArray);
        this.fileLength = randomAccessFile.length();
        randomAccessFile.close();
    }

    public long writeObjectBytes(byte[] byArray) throws IOException {
        int n = byArray.length;
        PersistObject persistObject = this.createPersistObject(byArray);
        this.write(persistObject.offset, byArray);
        this.putObjectToIdMap(persistObject);
        return persistObject.id;
    }

    static class PersistObject
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -8265199713085209820L;
        static long currentID = 0L;
        private long id = currentID++;
        private long offset;
        private int length;

        public PersistObject(long l, int n) {
            this.offset = l;
            this.length = n;
        }

        public int compareTo(Object object) {
            PersistObject persistObject = (PersistObject)object;
            if (this == persistObject) {
                return 0;
            }
            return this.length > persistObject.length ? 1 : -1;
        }

        public long getID() {
            return this.id;
        }
    }
}

