/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.ContentEvent;
import com.sun.admin.usermgr.client.ContentListener;
import com.sun.admin.usermgr.client.UserActionsListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.RoleContent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class UMgrRoleTBar
extends JToolBar
implements PropertyChangeListener {
    VUserMgr theApp;
    private ResourceBundle bundle;
    private JButton addRoleBtn;
    private JButton assignRoleBtn;
    private ContentListener contentListener;
    private Border defaultBorder;
    private Border bevelBorder = BorderFactory.createBevelBorder(1);
    UserActionsListener buttonClickListener;
    private VConsoleProperties properties;
    private ImageIcon newRoleIcon;
    private ImageIcon assignRoleIcon;
    private static String NEW_ROLE_TEXT;
    private static String ASSIGN_ROLE_TEXT;
    private Insets textMargin = new Insets(0, 2, 0, 2);

    public UMgrRoleTBar(VUserMgr vUserMgr, RoleContent roleContent) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        NEW_ROLE_TEXT = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_addRole");
        ASSIGN_ROLE_TEXT = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_assignRole");
        this.buttonClickListener = new UserActionsListener(vUserMgr);
        ((Container)this).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addRoleBtn = new JButton();
        this.setUpButton(this.addRoleBtn, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_addRole"), "New");
        this.defaultBorder = this.addRoleBtn.getBorder();
        Constraints.constrain((Container)this, (Component)this.addRoleBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)1.0, (int)0, (int)11, (int)0, (int)0);
        this.assignRoleBtn = new JButton();
        this.setUpButton(this.assignRoleBtn, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_assignRole"), "Assign");
        Constraints.constrain((Container)this, (Component)this.assignRoleBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)10.0, (double)1.0, (int)0, (int)2, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                UMgrRoleTBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        roleContent.addContentListener(this.contentListener);
        this.newRoleIcon = vUserMgr.loadImageIcon("add_admin_role.gif", "");
        this.assignRoleIcon = vUserMgr.loadImageIcon("assign_admin_role.gif", "");
    }

    private void installIcon(AbstractButton abstractButton, ImageIcon imageIcon) {
        if (abstractButton != null) {
            abstractButton.setIcon(imageIcon);
        }
    }

    private void installString(AbstractButton abstractButton, String string) {
        if (abstractButton != null) {
            abstractButton.setFont(ResourceManager.bodyFont);
            abstractButton.setText(string);
            if (string != null) {
                abstractButton.setMargin(this.textMargin);
            } else {
                abstractButton.setMargin(null);
            }
        }
    }

    private void notifySelectionChange(int n) {
        this.properties = this.theApp.getProperties();
        if (n == 1) {
            this.properties.setProperty("vconsole.propertiesenabled", "true");
        } else {
            this.properties.setProperty("vconsole.propertiesenabled", "false");
        }
        this.properties.setProperty("vconsole.propertiesenabled", "true");
        this.properties.setProperty("vconsole.filterenabled", "false");
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        this.properties.setProperty("vconsole.deleteenabled", bl ? "true" : "false");
        if (!this.theApp.getUserMgr().hasRoleMgrWriteAuth()) {
            this.addRoleBtn.setEnabled(false);
            this.properties.setProperty("vconsole.deleteenabled", "false");
        }
        if (this.theApp.getUserMgr().hasRoleMgrAssignAuth() || this.theApp.getUserMgr().hasRoleMgrDelegateAuth()) {
            this.assignRoleBtn.setEnabled(true);
        } else {
            this.assignRoleBtn.setEnabled(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.buttondisplay")) {
            this.setButtonDisplay(this.theApp.getProperties().getProperty("vconsole.buttondisplay"));
        }
    }

    public void setButtonDisplay(String string) {
        if (string.equals("vconsole.textonly")) {
            this.installString(this.addRoleBtn, NEW_ROLE_TEXT);
            this.installIcon(this.addRoleBtn, null);
            this.installString(this.assignRoleBtn, ASSIGN_ROLE_TEXT);
            this.installIcon(this.assignRoleBtn, null);
        } else if (string.equals("vconsole.icononly")) {
            this.installString(this.addRoleBtn, null);
            this.installIcon(this.addRoleBtn, this.newRoleIcon);
            this.installString(this.assignRoleBtn, null);
            this.installIcon(this.assignRoleBtn, this.assignRoleIcon);
        } else if (string.equals("vconsole.textandicon")) {
            this.installString(this.addRoleBtn, NEW_ROLE_TEXT);
            this.installIcon(this.addRoleBtn, this.newRoleIcon);
            this.installString(this.assignRoleBtn, ASSIGN_ROLE_TEXT);
            this.installIcon(this.assignRoleBtn, this.assignRoleIcon);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.setButtonDisplay(vConsoleProperties.getProperty("vconsole.buttondisplay"));
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void setUpButton(JButton jButton, String string, String string2) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setActionCommand(string2);
        jButton.addActionListener(this.buttonClickListener);
    }
}

