/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import com.sun.opencard.opt.security.PrivateKeyAlias;
import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.OCFCode;
import com.sun.opencard.service.common.ServiceUtil;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import opencard.core.OpenCardException;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.security.PrivateKeyRef;
import opencard.opt.terminal.ISOCommandAPDU;
import sun.security.util.DerOutputStream;
import sun.security.x509.AlgorithmId;

public abstract class SignatureCardService
extends CardService {
    private int MOD_LEN = 128;
    protected OCFCode ocf_codes;

    protected byte[] hashPadData(byte[] byArray) throws NoSuchAlgorithmException, CardServiceException {
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("SHA1");
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        System.out.println("length of hash " + byArray2.length);
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        AlgorithmId algorithmId = AlgorithmId.get("SHA1");
        byte[] byArray3 = null;
        try {
            algorithmId.encode(derOutputStream2);
            derOutputStream2.putOctetString(byArray2);
            derOutputStream.write((byte)48, derOutputStream2);
            byArray3 = derOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new CardServiceException(exception.getMessage());
        }
        return this.padHash(byArray3, this.MOD_LEN);
    }

    protected byte[] padHash(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        byArray2[0] = 0;
        byArray2[1] = 1;
        int n2 = 2;
        while (n2 < n - 1 - byArray.length) {
            byArray2[n2] = -1;
            ++n2;
        }
        byArray2[byArray2.length - byArray.length] = 0;
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        return byArray2;
    }

    public abstract ResponseAPDU sendAPDU(ISOCommandAPDU var1) throws OpenCardException, OCFCardException;

    public abstract void setup() throws OpenCardException, OCFCardException;

    public byte[] sign(byte[] byArray, PrivateKeyRef privateKeyRef, String string, byte[] byArray2) throws CardServiceException, InvalidKeyException, CardTerminalException {
        ResponseAPDU responseAPDU;
        try {
            System.out.println("into Signature card service :");
            byArray = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
            if (!string.equals("RSA")) {
                throw new CardServiceException(String.valueOf(string) + " not supported");
            }
            this.setup();
            byte[] byArray3 = ((PrivateKeyAlias)privateKeyRef).getAlias().getBytes();
            byte[] byArray4 = new byte[byArray.length + 1];
            byArray4[0] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), (int)this.ocf_codes.GET_ALIAS_Byte(), 0, 0, byArray4);
            responseAPDU = this.sendAPDU(iSOCommandAPDU);
            System.out.println("alias1... ");
            int n = 0;
            while (n < byArray3.length) {
                System.out.print(Integer.toHexString(byArray3[n]));
                ++n;
            }
            System.out.println("alias2... ");
            int n2 = 0;
            while (n2 < responseAPDU.data().length) {
                System.out.print(Integer.toHexString(responseAPDU.data()[n2]));
                ++n2;
            }
            if (!Arrays.equals(responseAPDU.data(), byArray3)) {
                throw new CardServiceException("wrong alias");
            }
            System.out.println("valid alias");
            byte[] byArray5 = this.hashPadData(byArray2);
            byte[] byArray6 = ServiceUtil.arrayJoin(byArray, byArray5);
            iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 21, 0, 0, byArray6, 0);
            responseAPDU = this.sendAPDU(iSOCommandAPDU);
            if (responseAPDU.data() != null) {
                int n3 = 0;
                while (n3 < responseAPDU.data().length) {
                    System.out.print(Integer.toHexString(responseAPDU.data()[n3]));
                    ++n3;
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CardServiceException(noSuchAlgorithmException.getMessage());
        }
        catch (OpenCardException openCardException) {
            throw new CardServiceException(openCardException.getMessage());
        }
        return responseAPDU.data();
    }
}

