/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardHolderVerificationGUI;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardNotPresentException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.VerifiedAPDUInterface;
import opencard.core.util.Tracer;

public class CardChannel {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$CardChannel != null ? class$opencard$core$service$CardChannel : (class$opencard$core$service$CardChannel = CardChannel.class$("opencard.core.service.CardChannel")));
    private static Tracer ctracer = new Tracer(class$opencard$core$service$CardChannel != null ? class$opencard$core$service$CardChannel : (class$opencard$core$service$CardChannel = CardChannel.class$("opencard.core.service.CardChannel")));
    private SlotChannel slot_channel = null;
    private boolean is_open = false;
    private boolean is_jammed = false;
    private Object channel_state = null;
    static /* synthetic */ Class class$opencard$core$service$CardChannel;

    protected CardChannel(SlotChannel slotChannel) {
        this.slot_channel = slotChannel;
        this.is_open = false;
        this.is_jammed = false;
        ctracer.debug("<init>", "(" + slotChannel + ")");
    }

    private void assertCardChannelOpen() throws CardNotPresentException, InvalidCardChannelException {
        if (this.is_jammed) {
            throw new CardNotPresentException(null, null, null);
        }
        if (!this.is_open) {
            throw new InvalidCardChannelException("CardChannel not open");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        this.is_open = false;
        this.itracer.debug("close", "CardChannel closed");
    }

    protected void closeFinal() {
        this.itracer.debug("closeFinal", "closing for good");
        this.close();
        this.is_jammed = true;
    }

    public void finalize() {
        this.closeFinal();
    }

    public CardTerminal getCardTerminal() throws CardNotPresentException, InvalidCardChannelException {
        this.assertCardChannelOpen();
        return this.slot_channel.getCardTerminal();
    }

    public final Object getState() {
        return this.channel_state;
    }

    public final boolean isOpen() {
        return this.is_open;
    }

    public void open() throws InvalidCardChannelException {
        this.itracer.debug("open", "opening CardChannel");
        if (this.is_jammed) {
            throw new InvalidCardChannelException("cannot be opened anymore");
        }
        if (this.is_open) {
            throw new InvalidCardChannelException("already open");
        }
        this.is_open = true;
    }

    public ResponseAPDU sendCommandAPDU(CommandAPDU commandAPDU) throws InvalidCardChannelException, CardTerminalException {
        this.assertCardChannelOpen();
        this.itracer.debug("sendCommandAPDU", commandAPDU.toString());
        ResponseAPDU responseAPDU = this.slot_channel.sendAPDU(commandAPDU);
        this.itracer.debug("response: ", responseAPDU.toString());
        return responseAPDU;
    }

    public final ResponseAPDU sendVerifiedAPDU(CommandAPDU commandAPDU, CHVControl cHVControl, CHVDialog cHVDialog, int n) throws InvalidCardChannelException, CardTerminalException, CardServiceInvalidCredentialException {
        this.assertCardChannelOpen();
        this.itracer.debug("sendVerifiedAPDU", "(" + commandAPDU + ")");
        ResponseAPDU responseAPDU = null;
        if (this.getCardTerminal() instanceof VerifiedAPDUInterface) {
            VerifiedAPDUInterface verifiedAPDUInterface = (VerifiedAPDUInterface)((Object)this.getCardTerminal());
            responseAPDU = n == -1 ? verifiedAPDUInterface.sendVerifiedCommandAPDU(this.slot_channel, commandAPDU, cHVControl) : verifiedAPDUInterface.sendVerifiedCommandAPDU(this.slot_channel, commandAPDU, cHVControl, n);
        } else {
            CardHolderVerificationGUI cardHolderVerificationGUI = new CardHolderVerificationGUI();
            responseAPDU = cardHolderVerificationGUI.sendVerifiedAPDU(this.slot_channel, commandAPDU, cHVControl, cHVDialog, n);
        }
        this.itracer.debug("sendVerifiedAPDU", "response: " + responseAPDU);
        return responseAPDU;
    }

    public final void setState(Object object) {
        this.channel_state = object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(", ").append(this.is_open ? "is" : "not").append(" open");
        stringBuffer.append(", ").append(this.is_jammed ? "is" : "not").append(" jammed");
        return stringBuffer.toString();
    }
}

