/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardNotPresentException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Slot;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;

public final class CardServiceScheduler
implements CTListener {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$CardServiceScheduler != null ? class$opencard$core$service$CardServiceScheduler : (class$opencard$core$service$CardServiceScheduler = CardServiceScheduler.class$("opencard.core.service.CardServiceScheduler")));
    private static Tracer ctracer = new Tracer(class$opencard$core$service$CardServiceScheduler != null ? class$opencard$core$service$CardServiceScheduler : (class$opencard$core$service$CardServiceScheduler = CardServiceScheduler.class$("opencard.core.service.CardServiceScheduler")));
    private SlotChannel slot_channel = null;
    private Slot card_slot = null;
    private CardChannel current_channel = null;
    private int smartcard_refs = 0;
    private boolean is_alive = false;
    private CardChannel free_channel = null;
    private boolean is_customized = false;
    static /* synthetic */ Class class$opencard$core$service$CardServiceScheduler;

    public CardServiceScheduler(SlotChannel slotChannel) {
        ctracer.debug("<init>", "slotChannel " + slotChannel);
        this.slot_channel = slotChannel;
        this.card_slot = slotChannel.getSlot();
        this.is_alive = true;
        this.free_channel = new CardChannel(slotChannel);
        CardTerminalRegistry.getRegistry().addCTListener(this);
    }

    public synchronized CardChannel allocateCardChannel(Object object, boolean bl) throws CardTerminalException, InvalidCardChannelException {
        this.itracer.debug("allocateCardChannel", "applicant " + object);
        if (this.free_channel == null) {
            if (!bl) {
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            if (!this.isAlive()) {
                throw new CardNotPresentException(null, null, null);
            }
        }
        this.free_channel.open();
        this.current_channel = this.free_channel;
        this.free_channel = null;
        return this.current_channel;
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) throws CardTerminalException {
        if (cardTerminalEvent.getSlot() == this.card_slot) {
            this.itracer.debug("cardRemoved", "event " + cardTerminalEvent);
            this.closeDown();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void closeDown() throws CardTerminalException {
        this.itracer.debug("closeDown", "closing down scheduler");
        if (!this.is_alive) {
            return;
        }
        SmartCard.releaseScheduler(this);
        this.is_alive = false;
        if (this.current_channel != null) {
            this.itracer.warning("closeDown", "closing " + this.current_channel);
            this.releaseCardChannel(this.current_channel);
        }
        this.free_channel.closeFinal();
        CardTerminalRegistry.getRegistry().removeCTListener(this);
        if (this.slot_channel.isOpen()) {
            this.slot_channel.close();
            this.slot_channel = null;
        }
    }

    protected synchronized SmartCard createSmartCard(CardID cardID) throws CardTerminalException {
        this.itracer.debug("createSmartCard", "creating SmartCard");
        SmartCard smartCard = null;
        if (!this.isAlive()) {
            return null;
        }
        smartCard = new SmartCard(this, cardID);
        ++this.smartcard_refs;
        return smartCard;
    }

    public final SlotChannel getSlotChannel() {
        return this.slot_channel;
    }

    protected final boolean isAlive() throws CardTerminalException {
        if (this.is_alive && (this.slot_channel == null || !this.slot_channel.isOpen())) {
            this.closeDown();
        }
        return this.is_alive;
    }

    public final boolean isCustomized() {
        return this.is_customized;
    }

    public synchronized void releaseCardChannel(CardChannel cardChannel) throws InvalidCardChannelException {
        this.itracer.debug("releaseCardChannel", "releasing " + cardChannel);
        if (this.current_channel != cardChannel && this.is_alive) {
            throw new InvalidCardChannelException("channel not current channel");
        }
        cardChannel.close();
        this.current_channel = null;
        this.free_channel = cardChannel;
        this.notify();
    }

    protected synchronized void releaseSmartCard(SmartCard smartCard) throws CardTerminalException {
        this.itracer.debug("releaseSmartCard", "releasing " + smartCard);
        --this.smartcard_refs;
        if (this.smartcard_refs < 1) {
            this.itracer.info("releaseSmartCard", "no more SmartCards, closing down");
            this.closeDown();
        }
    }

    public void setCustomChannel(CardChannel cardChannel) throws InvalidCardChannelException {
        if (this.is_customized) {
            throw new InvalidCardChannelException("scheduler already customized");
        }
        if (this.free_channel == null) {
            throw new InvalidCardChannelException("channel in use");
        }
        this.free_channel.closeFinal();
        this.free_channel = cardChannel;
        this.is_customized = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(", ").append(this.is_alive ? "is" : "not").append(" alive");
        return stringBuffer.toString();
    }

    public void useDefaultChannel() throws InvalidCardChannelException {
        if (!this.is_customized) {
            return;
        }
        if (this.free_channel == null) {
            throw new InvalidCardChannelException("custom channel in use");
        }
        this.free_channel.closeFinal();
        this.free_channel = new CardChannel(this.slot_channel);
        this.is_customized = false;
    }
}

