/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;

public class KeyGenAlgorithm
extends Algorithm {
    private static final OBJECT_IDENTIFIER PKCS5 = OBJECT_IDENTIFIER.PKCS5;
    private static final OBJECT_IDENTIFIER PKCS12_PBE = OBJECT_IDENTIFIER.PKCS12.subBranch(1L);
    private static Hashtable oidMap = new Hashtable();
    private KeyStrengthValidator keyStrengthValidator;
    public static final KeyGenAlgorithm DES = new KeyGenAlgorithm(15, "DES", new FixedKeyStrengthValidator(56), null, null);
    public static final KeyGenAlgorithm DES3;
    public static final KeyGenAlgorithm DESede;
    public static final KeyGenAlgorithm RC4;
    public static final KeyGenAlgorithm PBA_SHA1_HMAC;
    public static final KeyGenAlgorithm AES;
    public static final KeyGenAlgorithm RC2;
    static /* synthetic */ Class class$org$mozilla$jss$crypto$PBEKeyGenParams;

    protected KeyGenAlgorithm(int n, String string, KeyStrengthValidator keyStrengthValidator, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, Class clazz) {
        super(n, string, oBJECT_IDENTIFIER, clazz);
        this.keyStrengthValidator = keyStrengthValidator;
        if (oBJECT_IDENTIFIER != null) {
            oidMap.put(oBJECT_IDENTIFIER, this);
        }
    }

    public static KeyGenAlgorithm fromOID(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) throws NoSuchAlgorithmException {
        Object v = oidMap.get(oBJECT_IDENTIFIER);
        if (v == null) {
            throw new NoSuchAlgorithmException(oBJECT_IDENTIFIER.toString());
        }
        return (KeyGenAlgorithm)v;
    }

    public boolean isValidStrength(int n) {
        return this.keyStrengthValidator.isValidKeyStrength(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DESede = DES3 = new KeyGenAlgorithm(16, "DESede", new FixedKeyStrengthValidator(168), null, null);
        RC4 = new KeyGenAlgorithm(17, "RC4", new KeyStrengthValidator(){

            public boolean isValidKeyStrength(int n) {
                return true;
            }
        }, null, null);
        PBA_SHA1_HMAC = new KeyGenAlgorithm(31, "PBA/SHA1/HMAC", new FixedKeyStrengthValidator(160), null, class$org$mozilla$jss$crypto$PBEKeyGenParams == null ? (class$org$mozilla$jss$crypto$PBEKeyGenParams = KeyGenAlgorithm.class$("org.mozilla.jss.crypto.PBEKeyGenParams")) : class$org$mozilla$jss$crypto$PBEKeyGenParams);
        AES = new KeyGenAlgorithm(32, "AES", new KeyStrengthValidator(){

            public boolean isValidKeyStrength(int n) {
                return n == 128 || n == 192 || n == 256;
            }
        }, null, null);
        RC2 = new KeyGenAlgorithm(37, "RC2", new KeyStrengthValidator(){

            public boolean isValidKeyStrength(int n) {
                return n >= 8 && n <= 1024;
            }
        }, null, null);
    }

    protected static class FixedKeyStrengthValidator
    implements KeyStrengthValidator {
        private int strength;

        public FixedKeyStrengthValidator(int n) {
            this.strength = n;
        }

        public boolean isValidKeyStrength(int n) {
            return this.strength == n;
        }
    }

    protected static interface KeyStrengthValidator {
        public boolean isValidKeyStrength(int var1);
    }
}

