/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import org.mozilla.jss.util.Password;

public class PBEKeyGenParams
implements AlgorithmParameterSpec,
KeySpec {
    private Password pass;
    private byte[] salt;
    private int iterations;
    private static final int DEFAULT_SALT_LENGTH = 8;
    private static final int DEFAULT_ITERATIONS = 1;

    private PBEKeyGenParams() {
    }

    public PBEKeyGenParams(Password password, byte[] byArray, int n) {
        if (password == null || byArray == null) {
            throw new NullPointerException();
        }
        this.pass = (Password)password.clone();
        this.salt = byArray;
        this.iterations = n;
    }

    public PBEKeyGenParams(char[] cArray, byte[] byArray, int n) {
        if (cArray == null || byArray == null) {
            throw new NullPointerException();
        }
        this.pass = new Password((char[])cArray.clone());
        this.salt = byArray;
        this.iterations = n;
    }

    public Password getPassword() {
        return this.pass;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void clear() {
        this.pass.clear();
    }

    protected void finalize() throws Throwable {
        this.pass.clear();
    }
}

