/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class POPOPrivKey
implements ASN1Value {
    public static final Type THIS_MESSAGE = Type.THIS_MESSAGE;
    public static final Type SUBSEQUENT_MESSAGE = Type.SUBSEQUENT_MESSAGE;
    public static final Type DHMAC = Type.DHMAC;
    public static final int ENCR_CERT = 0;
    public static final int CHALLENGE_RESP = 1;
    private Type type;
    private BIT_STRING thisMessage;
    private INTEGER subsequentMessage;
    private BIT_STRING dhMAC;
    private static final Template templateInstance = new Template();

    public Type getType() {
        return this.type;
    }

    public BIT_STRING getThisMessage() {
        return this.thisMessage;
    }

    public INTEGER getSubsequentMessage() {
        return this.subsequentMessage;
    }

    public BIT_STRING getDhMAC() {
        return this.dhMAC;
    }

    private POPOPrivKey() {
    }

    private POPOPrivKey(Type type, BIT_STRING bIT_STRING, INTEGER iNTEGER, BIT_STRING bIT_STRING2) {
        this.type = type;
        this.thisMessage = bIT_STRING;
        this.subsequentMessage = iNTEGER;
        this.dhMAC = bIT_STRING2;
    }

    public static POPOPrivKey createThisMessage(BIT_STRING bIT_STRING) {
        return new POPOPrivKey(THIS_MESSAGE, bIT_STRING, null, null);
    }

    public static POPOPrivKey createSubsequentMessage(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal subsequentMessage value: " + n);
        }
        return new POPOPrivKey(SUBSEQUENT_MESSAGE, null, new INTEGER(n), null);
    }

    public static POPOPrivKey createDhMAC(BIT_STRING bIT_STRING) {
        return new POPOPrivKey(DHMAC, null, null, bIT_STRING);
    }

    public Tag getTag() {
        if (this.type == THIS_MESSAGE) {
            return Tag.get(0L);
        }
        if (this.type == SUBSEQUENT_MESSAGE) {
            return Tag.get(1L);
        }
        Assert._assert(this.type == DHMAC);
        return Tag.get(2L);
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.type == THIS_MESSAGE) {
            this.thisMessage.encode(Tag.get(0L), outputStream);
        } else if (this.type == SUBSEQUENT_MESSAGE) {
            this.subsequentMessage.encode(Tag.get(1L), outputStream);
        } else {
            Assert._assert(this.type == DHMAC);
            this.dhMAC.encode(Tag.get(2L), outputStream);
        }
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        Assert.notReached("POPOPrivKey is a CHOICE and cannot have an implicit tag");
        this.encode(outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get(0L), BIT_STRING.getTemplate());
            this.choicet.addElement(Tag.get(1L), INTEGER.getTemplate());
            this.choicet.addElement(Tag.get(2L), BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            Assert.notReached("POPOPrivKey is a CHOICE and cannot have an implicitTag");
            return this.decode(inputStream);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            CHOICE cHOICE = (CHOICE)this.choicet.decode(inputStream);
            Tag tag = cHOICE.getTag();
            if (tag.equals(Tag.get(0L))) {
                return POPOPrivKey.createThisMessage((BIT_STRING)cHOICE.getValue());
            }
            if (tag.equals(Tag.get(1L))) {
                INTEGER iNTEGER = (INTEGER)cHOICE.getValue();
                int n = iNTEGER.intValue();
                if (n != 0 && n != 1) {
                    throw new InvalidBERException("SubsequentMessage has invalid value: " + n);
                }
                return POPOPrivKey.createSubsequentMessage(n);
            }
            Assert._assert(tag.equals(Tag.get(2L)));
            return POPOPrivKey.createDhMAC((BIT_STRING)cHOICE.getValue());
        }
    }

    public static class Type {
        static final Type THIS_MESSAGE = new Type();
        static final Type SUBSEQUENT_MESSAGE = new Type();
        static final Type DHMAC = new Type();

        private Type() {
        }
    }
}

