/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.util.Hashtable;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.PrintOutputStreamWriter;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.ServerHandshakeCB;

public class SSLServer {
    boolean handshakeEventHappened = false;
    boolean doClientAuth = false;
    Hashtable args;
    PrintStream results;
    String versionStr;
    String[] argNames = new String[]{"filename", "port", "filesize", "clientauth", "nickname"};
    String[] values = new String[]{"data1k.txt", "2000", "1024", "false", "SSLServer"};
    private static String htmlHeader = "SSL Server Tester";
    private static String htmlTail = "\n";
    String okay = "okay";
    String failed = "FAILED";
    static final int[] cipherSuites = new int[]{4, 10, 9, 3, 6, 1, 0};

    private boolean isInvalid(String string) {
        return string == null || string.equals("");
    }

    private String getArgument(String string) {
        return (String)this.args.get(string);
    }

    private String cmp(String string, String string2) {
        if (string == string2) {
            return this.okay;
        }
        if (string == null) {
            return this.failed;
        }
        if (string.equals(string2)) {
            return this.okay;
        }
        return this.failed;
    }

    private String cmp(String string, int n) {
        return this.cmp(string, new Integer(n).toString());
    }

    public void run() {
        try {
            this.results.println(htmlHeader);
            String string = this.getArgument("port");
            int n = this.isInvalid(string) ? 443 : Integer.valueOf(string);
            this.results.println("here");
            String string2 = this.getArgument("clientauth");
            if (!this.isInvalid(string2)) {
                this.doClientAuth = !(string2 = string2.toLowerCase()).equals("off") && !string2.equals("false") && !string2.equals("0");
            }
            SSLServerSocket sSLServerSocket = new SSLServerSocket(n);
            this.results.println("Listening " + sSLServerSocket.toString());
            String string3 = this.getArgument("nickname");
            this.results.println("Getting Cert:" + string3 + "");
            sSLServerSocket.setServerCertNickname(string3);
            if (this.doClientAuth) {
                sSLServerSocket.setNeedClientAuth(true);
            }
            SSLSocket sSLSocket = (SSLSocket)sSLServerSocket.accept();
            this.results.println("Accepted.");
            this.handleConnection(sSLSocket);
            sSLSocket = null;
            sSLServerSocket.close();
            sSLServerSocket = null;
        }
        catch (Exception exception) {
            this.results.println("***** TEST FAILED *****");
            exception.printStackTrace(this.results);
            this.results.println("If there is no stack trace, try disabling the JIT and trying again.");
        }
        this.results.println("END OF TEST");
    }

    public void handleConnection(SSLSocket sSLSocket) throws Exception {
        ServerHandshakeCB serverHandshakeCB = null;
        serverHandshakeCB = new ServerHandshakeCB(this);
        sSLSocket.addHandshakeCompletedListener(serverHandshakeCB);
        this.results.println("Connected to " + sSLSocket.toString());
        InputStream inputStream = sSLSocket.getInputStream();
        byte[] byArray = new byte[4096];
        int n = 0;
        int n2 = 0;
        try {
            boolean bl = false;
            block2: while (!bl && n < byArray.length) {
                this.results.println("Calling Read.");
                int n3 = inputStream.read(byArray, n, byArray.length - n);
                if (n3 == -1) {
                    this.results.println("EOF found.");
                    break;
                }
                if (n3 == 0) {
                    this.results.println("Zero bytes read?");
                    break;
                }
                ++n2;
                this.results.println("Read " + n3 + " bytes of data");
                n += n3;
                int n4 = 0;
                while (n4 + 3 < byArray.length) {
                    if (byArray[n4] == 13 && byArray[n4 + 1] == 10 && byArray[n4 + 2] == 13 && byArray[n4 + 3] == 10) {
                        this.results.println("Empty line found.");
                        bl = true;
                        continue block2;
                    }
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            this.results.println("IOException while reading from pipe?  Actually got " + n + " bytes total");
            iOException.printStackTrace(this.results);
            this.results.println("");
            throw iOException;
        }
        this.results.println("Number of read() calls: " + n2);
        this.results.println("Total bytes read:       " + n);
        String string = null;
        if (n > 0) {
            string = new String(byArray, 0, n, "8859_1");
            this.results.println("Request received:");
            this.results.println(string);
            this.results.println("");
        }
        SSLSecurityStatus sSLSecurityStatus = sSLSocket.getStatus();
        this.results.println("Security status of session:");
        this.results.println(sSLSecurityStatus.toString());
        this.results.println("Handshake callback event happened: " + (this.handshakeEventHappened ? this.okay : this.failed));
        OutputStream outputStream = sSLSocket.getOutputStream();
        PrintOutputStreamWriter printOutputStreamWriter = new PrintOutputStreamWriter(outputStream);
        outputStream = null;
        String string2 = "HTTP/1.0 200 OK\r\nServer: Netscape-Enterprise/2.0a\r\nDate: Tue, 01 Apr 1998 22:10:05 GMT\r\nContent-type: text/plain\r\n\r\n" + string;
        printOutputStreamWriter.println(string2);
        inputStream.close();
        inputStream = null;
        if (serverHandshakeCB != null) {
            sSLSocket.removeHandshakeCompletedListener(serverHandshakeCB);
            serverHandshakeCB = null;
        }
        printOutputStreamWriter.close();
        printOutputStreamWriter = null;
        sSLSocket.close();
        sSLSocket = null;
    }

    private String escapeHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block5;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public SSLServer(PrintStream printStream, String string) {
        this.args = new Hashtable();
        this.results = printStream;
        this.versionStr = string;
        for (int i = 0; i < this.argNames.length; ++i) {
            String string2 = this.values[i];
            if (string2 == null) continue;
            this.args.put(this.argNames[i], string2);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        System.out.println("SSLServer started\n");
        try {
            CryptoManager.initialize(".");
        }
        catch (KeyDatabaseException keyDatabaseException) {
            System.out.println("Couldn't open the key database\n");
            return;
        }
        catch (CertDatabaseException certDatabaseException) {
            System.out.println("Couldn't open the certificate database");
            return;
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            System.out.println("CryptoManager already initialized???");
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            System.out.println("General security exception while initializing");
            return;
        }
        SSLServerSocket.configServerSessionIDCache(10, 0, 0, null);
        for (n = 65281; n <= 65287; ++n) {
            SSLSocket.setCipherPreferenceDefault(n, true);
        }
        n = 0;
        while (cipherSuites[n] != 0) {
            SSLSocket.setCipherPreferenceDefault(cipherSuites[n], true);
            ++n;
        }
        SSLServer sSLServer = new SSLServer(System.out, "Stand alone Ver 0.01");
        sSLServer.run();
    }
}

