/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.ConstantsBase;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.tests.TestCertificateApprovalCallback;
import org.mozilla.jss.util.Debug;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.PasswordCallback;

public class JSS_SelfServClient
implements ConstantsBase,
Constants {
    private String clientCertNick = "default";
    private String serverHost = "localhost";
    private String ciphersuiteTested = null;
    private boolean TestCertCallBack = false;
    private boolean success = true;
    private int fCipher = -1;
    private int aWorkingCipher = 0;
    private boolean bTestCiphers = true;
    private String CipherName = null;
    private int port = 29754;
    private String EOF = "test";
    private boolean handshakeCompleted = false;
    private boolean bVerbose = false;
    private boolean bFipsMode = false;
    private boolean bBypassPKCS11 = false;
    private ArrayList ciphersToTest = new ArrayList();
    private CryptoManager cm = null;
    private CryptoToken tok = null;
    private PasswordCallback cb = null;
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private ArrayList sockList = new ArrayList();
    private ArrayList h_ciphers = new ArrayList();
    private ArrayList f_ciphers = new ArrayList();
    private int sockID = 0;
    private static boolean bJSS = false;
    private ThreadGroup socketThreads = new ThreadGroup("SSLSockets");

    public void setTestCiphers(boolean bl) {
        this.bTestCiphers = bl;
    }

    public boolean getTestCiphers() {
        return this.bTestCiphers;
    }

    public void setVerbose(boolean bl) {
        this.bVerbose = bl;
    }

    public void setBypassPKCS11(boolean bl) {
        this.bBypassPKCS11 = bl;
    }

    public boolean getBypassPKCS11() {
        return this.bBypassPKCS11;
    }

    public boolean testJSSCiphersMatchNSS() {
        this.initJSS();
        boolean bl = true;
        int[] nArray = SSLSocket.getImplementedCipherSuites();
        for (int i = 0; i < nArray.length; ++i) {
            if (Constants.cipher.cipherToString(nArray[i]) != null) continue;
            bl = false;
            System.out.println("JSS does not support ciphersuite: " + Integer.toHexString(nArray[i]));
        }
        if (!bl) {
            System.out.println("ERROR: NSS has implemented ciphersuites that JSS does not support!\n");
            System.out.println("see http://mxr.mozilla.org/security/source/security/nss/lib/ssl/sslproto.h");
            System.out.println("Update org/mozilla/jss/ssl/SSLSocket.java");
            System.out.println("Update org/mozilla/jss/tests/Constants.java");
            System.out.println("NSS implemented Ciphersuites missing from JSS");
        }
        return bl;
    }

    public void configureDefaultSSLOptions() {
        this.initJSS();
        try {
            SSLSocket.enableSSL2Default(false);
            if (this.bFipsMode) {
                SSLSocket.enableSSL3Default(false);
            }
            if (this.bBypassPKCS11 && !this.bFipsMode) {
                SSLSocket.bypassPKCS11Default(true);
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            System.exit(1);
        }
    }

    public void configureCipherSuites(String string) {
        int[] nArray = SSLSocket.getImplementedCipherSuites();
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = Constants.cipher.cipherToString(nArray[i]);
            boolean bl = true;
            if (this.bVerbose) {
                System.out.print(string2);
            }
            if (string.equalsIgnoreCase("JSS") && (string2.indexOf("_DHE_") != -1 || string2.indexOf("SSL2") != -1 || string2.indexOf("RSA") != -1 && string2.indexOf("_ECDH_") != -1)) {
                if (this.bVerbose) {
                    System.out.print(" -");
                }
                bl = false;
            }
            if (string.equalsIgnoreCase("JSSE") && (string2.indexOf("SSL2_") != -1 || string2.indexOf("_ECDHE_") != -1 || string2.indexOf("_ECDH_") != -1 || string2.indexOf("_CAMELLIA_") != -1 || string2.indexOf("_DHE_DSS_") != -1 || string2.indexOf("_EXPORT1024_") != -1 || string2.indexOf("_RSA_FIPS_") != -1 || string2.indexOf("EXPORT_WITH_RC2") != -1 || string2.indexOf("_ECDSA_") != -1 || string2.indexOf("_256_") != -1)) {
                if (this.bVerbose) {
                    System.out.print(" -");
                }
                bl = false;
            }
            if (string.equalsIgnoreCase("Mozilla-JSS") && (string2.indexOf("SSL2_") != -1 || string2.indexOf("_ECDHE_") != -1 || string2.indexOf("_ECDH_") != -1 || string2.indexOf("_CAMELLIA_") != -1 || string2.indexOf("_DHE_DSS_") != -1 || string2.indexOf("_EXPORT1024_") != -1 || string2.indexOf("_RSA_FIPS_") != -1 || string2.indexOf("EXPORT_WITH_RC2") != -1 || string2.indexOf("_ECDSA_") != -1 || string2.indexOf("SSL3_DHE_RSA_WITH_3DES_EDE_CBC_SHA") != -1 || string2.indexOf("SSL3_RSA_WITH_3DES_EDE_CBC_SHA") != -1 || string2.indexOf("SSL3_DHE_RSA_WITH_DES_CBC_SHA") != -1 || string2.indexOf("SSL3_RSA_WITH_DES_CBC_SHA") != -1 || string2.indexOf("SSL3_RSA_EXPORT_WITH_RC4_40_MD5") != -1 || string2.indexOf("_256_") != -1)) {
                if (this.bVerbose) {
                    System.out.print(" -");
                }
                bl = false;
            }
            if (!bl) continue;
            if (this.bFipsMode) {
                try {
                    if (SSLSocket.isFipsCipherSuite(nArray[i])) {
                        this.ciphersToTest.add(new Integer(nArray[i]));
                        if (!this.bVerbose) continue;
                        System.out.print(" - FIPS Testing");
                        continue;
                    }
                    if (!this.bVerbose) continue;
                    System.out.print(" -");
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                }
                continue;
            }
            this.ciphersToTest.add(new Integer(nArray[i]));
            if (!this.bVerbose) continue;
            System.out.print(" - Testing");
        }
        if (this.bVerbose) {
            System.out.print("\n");
        }
        if (this.bVerbose) {
            System.out.println("\nTesting " + this.ciphersToTest.size() + " ciphersuites.");
        }
    }

    public void testCiphersuites(int n) {
        Iterator iterator = this.ciphersToTest.iterator();
        this.setTestCiphers(true);
        while (iterator.hasNext()) {
            this.setCipher((Integer)iterator.next());
            try {
                this.createSSLConnections(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void setCipher(int n) {
        this.initJSS();
        int[] nArray = SSLSocket.getImplementedCipherSuites();
        this.ciphersuiteTested = Constants.cipher.cipherToString(n);
        if (this.bVerbose || !this.bTestCiphers) {
            System.out.println("Testing " + Integer.toHexString(n) + " " + this.ciphersuiteTested);
        }
        if (this.ciphersuiteTested != null) {
            this.fCipher = n;
        } else {
            System.out.print("ciphersuite not supported");
            System.exit(1);
        }
        try {
            if (this.cm.FIPSEnabled() && !SSLSocket.isFipsCipherSuite(n)) {
                System.out.println("You are trying to test a non FIPS ciphersuite when FIPS is enabled!");
                System.exit(1);
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        for (int i = 0; i < nArray.length; ++i) {
            try {
                if (!SSLSocket.getCipherPreferenceDefault(nArray[i])) continue;
                SSLSocket.setCipherPreferenceDefault(nArray[i], false);
                continue;
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
        }
    }

    public void setHostName(String string) {
        this.serverHost = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setPasswordFile(String string) {
        this.fPasswordFile = string;
    }

    public void setCertDbPath(String string) {
        this.fCertDbPath = string;
    }

    public void setTestCertCallback(boolean bl) {
        this.TestCertCallBack = bl;
    }

    public void setClientCertNick(String string) {
        this.clientCertNick = string;
        try {
            X509Certificate[] x509CertificateArray = this.cm.findCertsByNickname(this.clientCertNick);
            if (x509CertificateArray.length == 0) {
                System.out.println("unable to find cert nickname: " + this.clientCertNick);
                System.exit(1);
            }
        }
        catch (TokenException tokenException) {
            tokenException.printStackTrace();
            System.exit(1);
        }
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public void setHandshakeCompleted() {
        this.handshakeCompleted = true;
    }

    public void clearHandshakeCompleted() {
        this.handshakeCompleted = false;
    }

    public int getSockTotal() {
        return this.sockID;
    }

    private void initJSS() {
        if (bJSS) {
            return;
        }
        try {
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(this.fCertDbPath);
            CryptoManager.initialize(initializationValues);
            this.cm = CryptoManager.getInstance();
            if (this.cm.FIPSEnabled()) {
                System.out.println("The database is in FIPSMODE");
                this.bFipsMode = true;
            }
            this.tok = this.cm.getInternalKeyStorageToken();
            this.cb = new FilePasswordCallback(this.fPasswordFile);
            this.tok.login(this.cb);
            bJSS = true;
            if (this.bVerbose) {
                Debug.setLevel(10);
            }
        }
        catch (KeyDatabaseException keyDatabaseException) {
            keyDatabaseException.printStackTrace();
            System.exit(1);
        }
        catch (CertDatabaseException certDatabaseException) {
            certDatabaseException.printStackTrace();
            System.exit(1);
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            notInitializedException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            alreadyInitializedException.printStackTrace();
            System.exit(1);
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
            System.exit(1);
        }
        catch (TokenException tokenException) {
            tokenException.printStackTrace();
            System.exit(1);
        }
        catch (IncorrectPasswordException incorrectPasswordException) {
            incorrectPasswordException.printStackTrace();
            System.exit(1);
        }
    }

    public boolean isServerAlive() {
        boolean bl = false;
        try {
            SSLSocket sSLSocket = null;
            if (this.bVerbose) {
                System.out.println("Confirming Server is alive ");
            }
            this.setCipher(47);
            System.out.println("Testing Connection:" + this.serverHost + ":" + this.port);
            for (int i = 0; i < 20 && (sSLSocket = this.createSSLSocket()) == null; ++i) {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            if (sSLSocket != null) {
                sSLSocket.close();
                bl = true;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        return bl;
    }

    public void sendServerShutdownMsg() {
        try {
            SSLSocket sSLSocket = null;
            if (this.bVerbose) {
                System.out.println("Sending shutdown message to server.");
            }
            if (this.aWorkingCipher == 0) {
                System.out.println("no ciphersuite was able to connect to the server!");
                System.exit(1);
            }
            this.setCipher(this.aWorkingCipher);
            sSLSocket = this.createSSLSocket();
            if (sSLSocket == null) {
                throw new IOException("Unable to connect to server");
            }
            OutputStream outputStream = sSLSocket.getOutputStream();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
            printWriter.println("shutdown");
            printWriter.flush();
            printWriter.close();
            sSLSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public void closeAllSockets() {
        try {
            SSLSocket sSLSocket;
            Iterator iterator = this.sockList.iterator();
            long l = System.currentTimeMillis();
            while (iterator.hasNext()) {
                sSLSocket = (SSLSocket)iterator.next();
                sSLSocket.close();
            }
            iterator = this.sockList.iterator();
            while (iterator.hasNext()) {
                sSLSocket = (SSLSocket)iterator.next();
                sSLSocket.close();
            }
            System.out.println("Waiting till all threads are dead");
            int n = 0;
            while (this.socketThreads.activeCount() > 0) {
                Thread.currentThread();
                Thread.sleep(10L);
                System.out.println("ActiveCount" + this.socketThreads.activeCount());
                if (n == 100) {
                    System.out.println("It is taking too long for the threads to die. Exiting the program");
                    System.out.println("Time taken: " + (System.currentTimeMillis() - l) + " Millieseconds");
                    System.exit(1);
                }
                ++n;
            }
            System.out.println("All threads are dead. Time taken: " + (System.currentTimeMillis() - l) + " Milliseconds.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            System.exit(1);
        }
    }

    private SSLSocket createSSLSocket() {
        SSLSocket sSLSocket = null;
        try {
            if (this.bVerbose) {
                System.out.println("client about to connect...");
            }
            String string = InetAddress.getByName(this.serverHost).getHostAddress();
            if (this.bVerbose) {
                System.out.println("the host " + this.serverHost + " and the address " + string);
            }
            if (this.TestCertCallBack) {
                if (this.bVerbose) {
                    System.out.println("calling approvalCallBack");
                }
                sSLSocket = new SSLSocket(InetAddress.getByName(string), this.port, null, 0, (SSLCertificateApprovalCallback)new TestCertificateApprovalCallback(), null);
            } else {
                if (this.bVerbose) {
                    System.out.println("NOT calling approvalCallBack");
                }
                sSLSocket = new SSLSocket(InetAddress.getByName(string), this.port);
            }
            if (this.clientCertNick.equalsIgnoreCase("default")) {
                sSLSocket.setClientCertNickname("Client_RSA");
                sSLSocket.setClientCertNickname("Client_ECDSA");
                sSLSocket.setClientCertNickname("Client_DSS");
            } else {
                sSLSocket.setClientCertNickname(this.clientCertNick);
                if (this.bVerbose) {
                    System.out.println("Client specified cert by nickname");
                }
            }
            if (sSLSocket.getCipherPreference(this.fCipher)) {
                System.out.println("Ciphersuite should have been disabled?");
                System.exit(1);
            } else {
                sSLSocket.setCipherPreference(this.fCipher, true);
            }
            sSLSocket.addHandshakeCompletedListener(new HandshakeListener("client", this));
            sSLSocket.forceHandshake();
            sSLSocket.setSoTimeout(10000);
            this.sockList.add(sSLSocket);
            ++this.sockID;
            this.aWorkingCipher = this.fCipher;
            if (this.bVerbose) {
                System.out.println("client connected");
            }
        }
        catch (SocketException socketException) {
            if (this.bTestCiphers) {
                sSLSocket = null;
            } else {
                socketException.printStackTrace();
                System.exit(1);
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        return sSLSocket;
    }

    public void outputCipherResults() {
        Iterator iterator;
        String string = new String("\n-------------------------------------------------------\n");
        System.out.println(string);
        System.out.println("JSS has " + SSLSocket.getImplementedCipherSuites().length + " ciphersuites and " + this.ciphersToTest.size() + " were configured and tested.");
        if (this.ciphersToTest.size() == this.h_ciphers.size()) {
            System.out.println("All " + this.ciphersToTest.size() + " configured ciphersuites tested Successfully!\n");
        }
        if (!this.h_ciphers.isEmpty()) {
            if (!this.f_ciphers.isEmpty()) {
                System.out.println(string);
                System.out.println(this.h_ciphers.size() + " ciphersuites successfully connected to the " + "server\n");
            }
            iterator = this.h_ciphers.iterator();
            while (iterator.hasNext()) {
                System.out.println((String)iterator.next());
            }
        }
        if (this.bFipsMode) {
            System.out.println("Note: ciphersuites that have the prefix \"SSL\" or \"SSL3\" were used in TLS mode.");
        }
        if (this.ciphersToTest.size() != this.h_ciphers.size() + this.f_ciphers.size()) {
            System.out.println("ERROR: did not test all expected ciphersuites");
        }
        if (!this.f_ciphers.isEmpty()) {
            System.out.println(string);
            System.out.println(this.f_ciphers.size() + " ciphersuites that did not connect to the " + "server\n\n");
            iterator = this.f_ciphers.iterator();
            while (iterator.hasNext()) {
                System.out.println((String)iterator.next());
            }
            System.out.println("we should have no failed ciphersuites!");
            System.exit(1);
        }
        System.out.println(string);
    }

    public void createSSLConnections(int n) throws Exception {
        SSLSocket sSLSocket = null;
        this.initJSS();
        for (int i = 1; i <= n; ++i) {
            sSLSocket = this.createSSLSocket();
            if (sSLSocket != null) {
                String string = new String(this.sockID + "-" + i);
                readWriteThread readWriteThread2 = new readWriteThread(this.socketThreads, string, this.ciphersuiteTested, sSLSocket);
                readWriteThread2.start();
                if (i != 1) continue;
                this.h_ciphers.add(this.ciphersuiteTested);
                continue;
            }
            if (!this.bTestCiphers) break;
            this.f_ciphers.add(this.ciphersuiteTested);
            break;
        }
        if (this.bVerbose) {
            System.out.println("Active thread count: " + this.socketThreads.activeCount());
            System.out.println("Total threads created: " + this.getSockTotal());
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static void main(String[] stringArray) {
        String string = "default";
        int n = -1;
        String string2 = "localhost";
        int n2 = 29754;
        int n3 = 10;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string5 = "JSS";
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        String string6 = "\nUSAGE:\njava org.mozilla.jss.tests.JSS_SelfServClient [# sockets] [JSS cipher hex code \"0xC013\" value or -1] \n\nOptional:\n[certdb path] [password file] [server host] [server port][bypass] [verbose] [server = JSS or JSSE] [ClientCert]";
        try {
            if (stringArray.length <= 0 || stringArray[0].toLowerCase().equals("-h")) {
                System.out.println(string6);
                System.exit(1);
            } else {
                n3 = new Integer(stringArray[0]);
                System.out.println("Number of Threads to create: " + n3);
            }
            if (stringArray.length >= 2) {
                n = stringArray[1].startsWith("0x") || stringArray[1].startsWith("0X") ? Integer.decode(stringArray[1]).intValue() : new Integer(stringArray[1]).intValue();
            }
            if (stringArray.length >= 3) {
                string3 = stringArray[2];
            }
            if (stringArray.length >= 4) {
                string4 = stringArray[3];
            }
            if (stringArray.length >= 5) {
                string2 = stringArray[4];
            }
            if (stringArray.length >= 6) {
                n2 = new Integer(stringArray[5]);
            }
            if (stringArray.length >= 7 && stringArray[6].equalsIgnoreCase("bypass")) {
                bl = true;
            }
            if (stringArray.length >= 8 && stringArray[7].equalsIgnoreCase("verbose")) {
                System.out.println("verbose mode enabled.");
                bl2 = true;
            }
            if (stringArray.length >= 9) {
                string5 = stringArray[8].toUpperCase();
            }
            if (stringArray.length >= 10) {
                string = stringArray[9];
                System.out.println("certnickname: " + string);
            }
        }
        catch (Exception exception) {
            System.out.println("Unknown exception : " + exception.getMessage());
            System.exit(1);
        }
        System.out.println("Client connecting to server: " + string2 + ":" + n2);
        JSS_SelfServClient jSS_SelfServClient = new JSS_SelfServClient();
        try {
            if (!string2.equals("localhost")) {
                jSS_SelfServClient.setHostName(string2);
            }
            if (n2 != 29754) {
                jSS_SelfServClient.setPort(n2);
            }
            jSS_SelfServClient.setPasswordFile(string4);
            jSS_SelfServClient.setCertDbPath(string3);
            jSS_SelfServClient.setVerbose(bl2);
            jSS_SelfServClient.initJSS();
            if (!jSS_SelfServClient.testJSSCiphersMatchNSS()) {
                System.out.println("JSS needs to update the ciphersuites!");
                System.exit(1);
            }
            jSS_SelfServClient.setTestCertCallback(true);
            jSS_SelfServClient.setBypassPKCS11(bl);
            jSS_SelfServClient.configureDefaultSSLOptions();
            if (string3 != null) {
                jSS_SelfServClient.setCertDbPath(string3);
            }
            if (string4 != null) {
                jSS_SelfServClient.setPasswordFile(string4);
            }
            if (!jSS_SelfServClient.isServerAlive()) {
                System.out.println("Unable to connect to " + string2 + ":" + n2 + " exiting.");
                System.exit(1);
            }
            if (n != -1) {
                jSS_SelfServClient.setClientCertNick(string);
                jSS_SelfServClient.setTestCiphers(false);
                jSS_SelfServClient.setCipher(n);
                jSS_SelfServClient.createSSLConnections(n3);
            } else {
                jSS_SelfServClient.configureCipherSuites(string5);
                jSS_SelfServClient.testCiphersuites(n3);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        if (jSS_SelfServClient.getSockTotal() == 0) {
            System.out.println("No SSLSockets created check your configuration.");
            System.exit(1);
        }
        System.out.println(jSS_SelfServClient.getSockTotal() + " SSLSockets created.");
        System.out.println("Each created SSLSocket is reading/writing to the SSLServer.");
        if (jSS_SelfServClient.getTestCiphers()) {
            try {
                Thread.currentThread();
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                System.exit(1);
            }
            jSS_SelfServClient.closeAllSockets();
            jSS_SelfServClient.sendServerShutdownMsg();
            jSS_SelfServClient.outputCipherResults();
            System.exit(0);
        }
        System.out.println("You can choose to exit the program enter:\n\t'A' to abort with out closing the sockets.\n\t'C' to close all client sockets (server will not quit)\n\tor any other letter to close all sockets and tell theserver to quit.");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string7 = bufferedReader.readLine();
            if (string7.equalsIgnoreCase("a")) {
                System.out.println("Aborting with out closing SSLSockets.");
            } else {
                jSS_SelfServClient.closeAllSockets();
                if (!string7.equalsIgnoreCase("c")) {
                    jSS_SelfServClient.sendServerShutdownMsg();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SelfServClient boss;

        public HandshakeListener(String string, JSS_SelfServClient jSS_SelfServClient2) {
            this.who = string;
            this.boss = jSS_SelfServClient2;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
                if (JSS_SelfServClient.this.bVerbose) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
            JSS_SelfServClient.this.setHandshakeCompleted();
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket clientSock = null;
        private String socketID = null;
        private String ciphersuite;

        public readWriteThread(ThreadGroup threadGroup, String string, String string2, SSLSocket sSLSocket) {
            super(threadGroup, string);
            if (JSS_SelfServClient.this.bVerbose) {
                System.out.println("New thread: " + this);
            }
            this.ciphersuite = string2;
            this.clientSock = sSLSocket;
            this.socketID = string;
        }

        public void run() {
            try {
                String string = null;
                String string2 = null;
                InputStream inputStream = this.clientSock.getInputStream();
                OutputStream outputStream = this.clientSock.getOutputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
                while (true) {
                    string = this.ciphersuite + ":" + this.socketID + "\n";
                    if (JSS_SelfServClient.this.bVerbose) {
                        System.out.println("Sending: " + string);
                    }
                    printWriter.print(string);
                    printWriter.flush();
                    string2 = bufferedReader.readLine();
                    if (JSS_SelfServClient.this.bVerbose) {
                        System.out.println("Received: " + string2 + " on Client-" + this.socketID);
                    }
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                socketTimeoutException.printStackTrace();
            }
            catch (IOException iOException) {
                if (!iOException.getMessage().equalsIgnoreCase("SocketException cannot read on socket") && !iOException.getMessage().equalsIgnoreCase("Socket has been closed, and cannot be reused.")) {
                    iOException.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

