/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.wbemadmin;

import com.sun.wbem.apps.common.AboutDialog;
import com.sun.wbem.apps.common.AddSecurityUserDialog;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.ColumnLayout;
import com.sun.wbem.apps.common.HorizontalSeparator;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.LAYOUT_ALIGNMENT;
import com.sun.wbem.apps.common.NameSpaceDialog;
import com.sun.wbem.apps.common.NameSpaceSelectionDialog;
import com.sun.wbem.apps.common.Util;
import com.sun.wbem.apps.wbemadmin.AdmLoginDialog;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMVersion;
import com.sun.wbem.client.CIMClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class AdminFrame
extends JFrame
implements ActionListener,
WindowListener {
    protected JButton ok;
    protected JButton cancel;
    protected JButton apply;
    protected JButton addUser;
    protected JButton deleteUser;
    protected JButton addNS;
    protected JButton deleteNS;
    protected JTable userTable;
    protected ArrayList userTableHeading;
    protected UserTableModel userModel;
    protected Vector userAclList;
    protected Vector nameSpaceList;
    protected Vector deletedUsers;
    protected JTable nsTable;
    protected ArrayList nsTableHeading;
    protected NameSpaceTableModel nsModel;
    protected Vector nsAclList;
    protected Vector deletedNS;
    private boolean userCanWrite = true;
    private String adminUser = "root";
    protected CIMClient cimClient;

    public AdminFrame() {
        this.setTitle(I18N.loadStringFormat("TTL_WBEM_ADMIN", I18N.loadString("LBL_NOT_CONNECTED")));
        JPanel jPanel = (JPanel)this.getContentPane();
        this.deletedUsers = new Vector();
        this.userAclList = new Vector();
        this.userTableHeading = new ArrayList();
        this.userTableHeading.add(I18N.loadString("LBL_USERNAME", "com.sun.wbem.apps.common.common"));
        this.userTableHeading.add(I18N.loadString("LBL_NAMESPACE"));
        this.userTableHeading.add(I18N.loadString("LBL_READ"));
        this.userTableHeading.add(I18N.loadString("LBL_WRITE"));
        this.userModel = new UserTableModel();
        this.userTable = new JTable(this.userModel);
        this.userModel.addTableModelListener(new UserTableModelListener());
        this.userTable.setBackground(((Component)this).getBackground());
        this.userTable.getSelectionModel().setSelectionMode(0);
        this.userTable.getSelectionModel().addListSelectionListener(new UserSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.userTable){

            public Dimension getPreferredSize() {
                return new Dimension(450, 100);
            }
        };
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jScrollPane.setBackground(((Component)this).getBackground());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel2.setBackground(((Component)this).getBackground());
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel3.add("West", jPanel2);
        JPanel jPanel4 = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        this.addUser = new JButton(I18N.loadString("MNU_ADD", "com.sun.wbem.apps.common.common"));
        this.addUser.setActionCommand("addUser");
        this.addUser.addActionListener(this);
        this.deleteUser = new JButton(I18N.loadString("MNU_DELETE", "com.sun.wbem.apps.common.common"));
        this.deleteUser.setActionCommand("deleteUser");
        this.deleteUser.addActionListener(this);
        jPanel4.add(this.addUser);
        jPanel4.add(this.deleteUser);
        jPanel3.add("East", jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel5.setBorder(BorderFactory.createTitledBorder(I18N.loadString("LBL_USERS_ACCESS")));
        jPanel5.add(jPanel3);
        this.deletedNS = new Vector();
        this.nsAclList = new Vector();
        this.nsTableHeading = new ArrayList();
        this.nsTableHeading.add(I18N.loadString("LBL_NAMESPACE"));
        this.nsTableHeading.add(I18N.loadString("LBL_READ"));
        this.nsTableHeading.add(I18N.loadString("LBL_WRITE"));
        this.nsModel = new NameSpaceTableModel();
        this.nsTable = new JTable(this.nsModel);
        this.nsModel.addTableModelListener(new NameSpaceTableModelListener());
        this.nsTable.setBackground(((Component)this).getBackground());
        this.nsTable.getSelectionModel().setSelectionMode(0);
        this.nsTable.getSelectionModel().addListSelectionListener(new NameSpaceSelectionListener());
        JScrollPane jScrollPane2 = new JScrollPane(this.nsTable){

            public Dimension getPreferredSize() {
                return new Dimension(450, 100);
            }
        };
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jScrollPane2.setBackground(((Component)this).getBackground());
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel7 = new JPanel();
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel7.setBackground(((Component)this).getBackground());
        jPanel7.add(jScrollPane2);
        jPanel6.add("West", jPanel7);
        JPanel jPanel8 = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        this.addNS = new JButton(I18N.loadString("MNU_ADD", "com.sun.wbem.apps.common.common"));
        this.addNS.setActionCommand("addNS");
        this.addNS.addActionListener(this);
        this.deleteNS = new JButton(I18N.loadString("MNU_DELETE", "com.sun.wbem.apps.common.common"));
        this.deleteNS.setActionCommand("deleteNS");
        this.deleteNS.addActionListener(this);
        jPanel8.add(this.addNS);
        jPanel8.add(this.deleteNS);
        jPanel6.add("East", jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel9.setBorder(BorderFactory.createTitledBorder(I18N.loadString("LBL_NAMESPACE_ACCESS")));
        jPanel9.add(jPanel6);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        jPanel10.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        jPanel10.add(jPanel5);
        jPanel10.add(jPanel9);
        this.apply = new JButton(I18N.loadString("LBL_APPLY", "com.sun.wbem.apps.common.common"));
        this.apply.setActionCommand("apply");
        this.apply.addActionListener(this);
        this.ok = new JButton(I18N.loadString("LBL_OK", "com.sun.wbem.apps.common.common"));
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        this.cancel = new JButton(I18N.loadString("LBL_CANCEL", "com.sun.wbem.apps.common.common"));
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayout(1, 3, 7, 0));
        jPanel11.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel11.add(this.apply);
        jPanel11.add(this.ok);
        jPanel11.add(this.cancel);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.add("North", new HorizontalSeparator());
        jPanel12.add("East", jPanel11);
        jPanel.add("Center", jPanel10);
        jPanel.add("South", jPanel12);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu(I18N.loadString("MNU_HELP", "com.sun.wbem.apps.common.common"));
        jMenuBar.add((Component)jMenu);
        JMenuItem jMenuItem = new JMenuItem(I18N.loadString("MNU_ABOUT_WBEM_ADMIN"));
        jMenuItem.setActionCommand("helpAbout");
        jMenuItem.addActionListener(this);
        ((Container)jMenu).add(jMenuItem);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.addWindowListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point(dimension.width / 2, dimension.height / 2);
        ((Component)this).setLocation(point.x - this.getSize().width / 2, point.y - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            if (this.writeChangedValues()) {
                this.apply.setEnabled(false);
            }
        } else if (string.equals("ok")) {
            if (!this.writeChangedValues()) {
                return;
            }
            try {
                if (this.cimClient != null) {
                    this.cimClient.close();
                }
            }
            catch (CIMException cIMException) {
                CIMErrorDialog.display(this, cIMException);
                return;
            }
            this.dispose();
            System.exit(0);
        } else if (string.equals("cancel")) {
            try {
                if (this.cimClient != null) {
                    this.cimClient.close();
                }
            }
            catch (CIMException cIMException) {
                CIMErrorDialog.display(this, cIMException);
            }
            this.dispose();
            System.exit(0);
        } else if (string.equals("addUser")) {
            AddSecurityUserDialog addSecurityUserDialog = new AddSecurityUserDialog(Util.getFrame(this), this.nameSpaceList);
            if (addSecurityUserDialog.getUserName() != null) {
                UserInfo userInfo = new UserInfo(addSecurityUserDialog.getUserName(), addSecurityUserDialog.getNameSpace());
                this.insertUser(userInfo);
            }
        } else if (string.equals("deleteUser")) {
            int n = this.userTable.getSelectedRow();
            UserInfo userInfo = (UserInfo)this.userAclList.elementAt(n);
            int n2 = JOptionPane.showConfirmDialog(this, Util.wrapText(I18N.loadStringFormat("ASK_DELETE_USER_ACL", userInfo.getUserName(), (Object)userInfo.getNameSpace())), I18N.loadString("TTL_USER_ACCESS"), 2, 3);
            if (n2 == 0) {
                this.userAclList.removeElementAt(n);
                if (userInfo.preExists()) {
                    this.deletedUsers.add(userInfo);
                }
                this.userModel.setNumRows(this.userAclList.size());
            }
        } else if (string.equals("addNS")) {
            NameSpaceSelectionDialog nameSpaceSelectionDialog = new NameSpaceSelectionDialog((Frame)this, this.nameSpaceList);
            CIMObjectPath cIMObjectPath = (CIMObjectPath)nameSpaceSelectionDialog.getSelectedObject();
            if (cIMObjectPath != null) {
                NameSpaceInfo nameSpaceInfo = new NameSpaceInfo(cIMObjectPath.getNameSpace());
                this.insertNS(nameSpaceInfo);
            }
        } else if (string.equals("deleteNS")) {
            int n = this.nsTable.getSelectedRow();
            NameSpaceInfo nameSpaceInfo = (NameSpaceInfo)this.nsAclList.elementAt(n);
            int n3 = JOptionPane.showConfirmDialog(this, Util.wrapText(I18N.loadStringFormat("ASK_DELETE_NAMESPACE_ACL", nameSpaceInfo.getNameSpace())), I18N.loadString("TTL_NAMESPACE_ACCESS"), 2, 3);
            if (n3 == 0) {
                this.nsAclList.removeElementAt(n);
                if (nameSpaceInfo.preExists()) {
                    this.deletedNS.add(nameSpaceInfo);
                }
                this.nsModel.setNumRows(this.nsAclList.size());
            }
        } else if (string.equals("helpAbout")) {
            CIMVersion cIMVersion = new CIMVersion();
            String string2 = I18N.loadString("MNU_WBEM_ADMIN");
            AboutDialog aboutDialog = new AboutDialog(this, string2, CIMVersion.getVersion(), cIMVersion.getCopyright(), "");
        }
    }

    public void getDefaultInfo() {
        NameSpaceInfo nameSpaceInfo;
        String string;
        String string2;
        CIMInstance cIMInstance;
        CIMObjectPath cIMObjectPath;
        Enumeration enumeration;
        try {
            this.cimClient = CIMClientObject.getClient();
            enumeration = this.cimClient.enumInstances(new CIMObjectPath("Solaris_UserAcl"), false);
            while (enumeration.hasMoreElements()) {
                cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                cIMInstance = this.cimClient.getInstance(cIMObjectPath, false);
                String string3 = (String)cIMInstance.getProperty("username").getValue().getValue();
                string2 = (String)cIMInstance.getProperty("nspace").getValue().getValue();
                string = (String)cIMInstance.getProperty("capability").getValue().getValue();
                nameSpaceInfo = new UserInfo(string3, string2, string, true);
                this.insertUser((UserInfo)nameSpaceInfo);
            }
        }
        catch (CIMException cIMException) {
            JOptionPane.showMessageDialog(this, Util.wrapText(I18N.loadString("ERR_USER_ACL"), 55), I18N.loadString("TIP_ADMIN"), 1);
            System.exit(0);
        }
        try {
            enumeration = this.cimClient.enumInstances(new CIMObjectPath("Solaris_NamespaceAcl"), false);
            while (enumeration.hasMoreElements()) {
                cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                cIMInstance = this.cimClient.getInstance(cIMObjectPath, false);
                string2 = (String)cIMInstance.getProperty("nspace").getValue().getValue();
                string = (String)cIMInstance.getProperty("capability").getValue().getValue();
                nameSpaceInfo = new NameSpaceInfo(string2, string, true);
                this.insertNS(nameSpaceInfo);
            }
        }
        catch (CIMException cIMException) {
            JOptionPane.showMessageDialog(this, Util.wrapText(I18N.loadString("ERR_USR_ACL"), 55), I18N.loadString("TIP_ADMIN"), 1);
            System.exit(0);
        }
    }

    public int getIndex(Vector vector, NameSpaceInfo nameSpaceInfo) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            NameSpaceInfo nameSpaceInfo2 = (NameSpaceInfo)enumeration.nextElement();
            if (!nameSpaceInfo2.equals(nameSpaceInfo)) continue;
            return n;
        }
        return -1;
    }

    private void insertNS(NameSpaceInfo nameSpaceInfo) {
        int n = this.nsAclList.size();
        int n2 = 0;
        while (n2 < n) {
            NameSpaceInfo nameSpaceInfo2 = (NameSpaceInfo)this.nsAclList.elementAt(n2);
            int n3 = nameSpaceInfo.getNameSpace().compareTo(nameSpaceInfo2.getNameSpace());
            if (n3 < 0) {
                this.insertNSAtIndex(nameSpaceInfo, n2);
                return;
            }
            if (n3 == 0) {
                JOptionPane.showMessageDialog(this, Util.wrapText(I18N.loadStringFormat("MSG_NAMESPACE_EXISTS", nameSpaceInfo.getNameSpace())), I18N.loadString("TIP_ADMIN"), 1);
                return;
            }
            ++n2;
        }
        this.insertNSAtIndex(nameSpaceInfo, n);
    }

    private void insertNSAtIndex(NameSpaceInfo nameSpaceInfo, int n) {
        int n2 = this.getIndex(this.deletedNS, nameSpaceInfo);
        if (n2 >= 0) {
            nameSpaceInfo.setPreExists(true);
            this.deletedNS.removeElementAt(n2);
        }
        this.nsAclList.add(n, nameSpaceInfo);
        this.nsModel.setNumRows(this.nsAclList.size());
    }

    private void insertUser(UserInfo userInfo) {
        int n = this.userAclList.size();
        boolean bl = false;
        String string = userInfo.getUserName();
        String string2 = userInfo.getNameSpace();
        int n2 = 0;
        while (n2 < n) {
            UserInfo userInfo2 = (UserInfo)this.userAclList.elementAt(n2);
            int n3 = string.compareTo(userInfo2.getUserName());
            if (n3 < 0) {
                this.insertUserAtIndex(userInfo, n2);
                return;
            }
            if (n3 == 0) {
                bl = true;
                int n4 = string2.compareTo(userInfo2.getNameSpace());
                if (n4 == 0) {
                    JOptionPane.showMessageDialog(this, Util.wrapText(I18N.loadStringFormat("MSG_USER_NAMESPACE_EXISTS", string, (Object)string2)), I18N.loadString("TIP_ADMIN"), 1);
                    return;
                }
                if (n4 < 0) {
                    this.insertUserAtIndex(userInfo, n2);
                    return;
                }
            } else if (bl) {
                this.insertUserAtIndex(userInfo, n2);
                return;
            }
            ++n2;
        }
        this.insertUserAtIndex(userInfo, n);
    }

    private void insertUserAtIndex(UserInfo userInfo, int n) {
        int n2 = this.getIndex(this.deletedUsers, userInfo);
        if (n2 >= 0) {
            userInfo.setPreExists(true);
            this.deletedUsers.removeElementAt(n2);
        }
        this.userAclList.add(n, userInfo);
        this.userModel.setNumRows(this.userAclList.size());
    }

    public boolean login() {
        AdmLoginDialog admLoginDialog;
        boolean bl = false;
        Util.waitOn(this);
        do {
            if (!(admLoginDialog = new AdmLoginDialog(this)).getLoggedIn()) {
                return false;
            }
            if (!CIMClientObject.userHasReadPermission()) {
                JOptionPane.showMessageDialog(this, Util.wrapText(I18N.loadStringFormat("ERR_ADMIN_READ_ACCESS", CIMClientObject.getUserName())), I18N.loadString("TIP_ADMIN"), 2);
                continue;
            }
            if (!CIMClientObject.userHasWritePermission()) {
                int n = JOptionPane.showConfirmDialog(this, Util.wrapText(I18N.loadStringFormat("ASK_ADMIN_READ_ONLY", CIMClientObject.getUserName())), I18N.loadString("TIP_ADMIN"), 2, 2);
                if (n != 0) continue;
                bl = true;
                this.userCanWrite = false;
                this.addUser.setEnabled(false);
                this.addNS.setEnabled(false);
                this.deleteUser.setEnabled(false);
                this.deleteNS.setEnabled(false);
                continue;
            }
            bl = true;
        } while (!bl);
        admLoginDialog = new CIMNameSpace();
        this.setTitle(I18N.loadStringFormat("TTL_WBEM_ADMIN", admLoginDialog.getHost()));
        this.getDefaultInfo();
        this.nameSpaceList = Util.enumToVector(NameSpaceDialog.getAllNameSpaces());
        Util.waitOff(this);
        return true;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.apply.setEnabled(false);
    }

    private boolean writeChangedNSValues() {
        CIMInstance cIMInstance = null;
        boolean bl = true;
        try {
            NameSpaceInfo nameSpaceInfo;
            CIMClass cIMClass = this.cimClient.getClass(new CIMObjectPath("Solaris_NamespaceAcl"), false);
            Enumeration enumeration = this.deletedNS.elements();
            while (enumeration.hasMoreElements()) {
                nameSpaceInfo = (NameSpaceInfo)enumeration.nextElement();
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("nspace", new CIMValue((Object)nameSpaceInfo.getNameSpace()));
                CIMObjectPath cIMObjectPath = new CIMObjectPath();
                cIMObjectPath.setObjectName("Solaris_NamespaceAcl");
                cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
                this.cimClient.deleteInstance(cIMObjectPath);
            }
            this.deletedNS.clear();
            enumeration = this.nsAclList.elements();
            while (enumeration.hasMoreElements()) {
                nameSpaceInfo = (NameSpaceInfo)enumeration.nextElement();
                if (!nameSpaceInfo.preExists() || nameSpaceInfo.isModified()) {
                    cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty("nspace", new CIMValue((Object)nameSpaceInfo.getNameSpace()));
                    cIMInstance.setProperty("capability", new CIMValue((Object)nameSpaceInfo.getAccess()));
                }
                if (!nameSpaceInfo.preExists()) {
                    this.cimClient.createInstance(new CIMObjectPath("", ""), cIMInstance);
                    nameSpaceInfo.setPreExists(true);
                    nameSpaceInfo.setModified(false);
                    continue;
                }
                if (!nameSpaceInfo.isModified()) continue;
                this.cimClient.setInstance(new CIMObjectPath("", ""), cIMInstance);
                nameSpaceInfo.setModified(false);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
            bl = false;
        }
        return bl;
    }

    private boolean writeChangedUserValues() {
        boolean bl = true;
        CIMInstance cIMInstance = null;
        try {
            UserInfo userInfo;
            CIMClass cIMClass = this.cimClient.getClass(new CIMObjectPath("Solaris_UserAcl"), false);
            Enumeration enumeration = this.deletedUsers.elements();
            while (enumeration.hasMoreElements()) {
                userInfo = (UserInfo)enumeration.nextElement();
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("username", new CIMValue((Object)userInfo.getUserName()));
                cIMInstance.setProperty("nspace", new CIMValue((Object)userInfo.getNameSpace()));
                CIMObjectPath cIMObjectPath = new CIMObjectPath();
                cIMObjectPath.setObjectName("Solaris_UserAcl");
                cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
                this.cimClient.deleteInstance(cIMObjectPath);
            }
            this.deletedUsers.clear();
            enumeration = this.userAclList.elements();
            while (enumeration.hasMoreElements()) {
                userInfo = (UserInfo)enumeration.nextElement();
                if (!userInfo.preExists() || userInfo.isModified()) {
                    cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty("username", new CIMValue((Object)userInfo.getUserName()));
                    cIMInstance.setProperty("nspace", new CIMValue((Object)userInfo.getNameSpace()));
                    cIMInstance.setProperty("capability", new CIMValue((Object)userInfo.getAccess()));
                }
                if (!userInfo.preExists()) {
                    this.cimClient.createInstance(new CIMObjectPath("", ""), cIMInstance);
                    userInfo.setPreExists(true);
                    userInfo.setModified(false);
                    continue;
                }
                if (!userInfo.isModified()) continue;
                this.cimClient.setInstance(new CIMObjectPath("", ""), cIMInstance);
                userInfo.setModified(false);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
            bl = false;
        }
        return bl;
    }

    private boolean writeChangedValues() {
        if (!this.userCanWrite) {
            return true;
        }
        boolean bl = this.writeChangedUserValues();
        if (bl) {
            bl = this.writeChangedNSValues();
        }
        return bl;
    }

    class UserTableModelListener
    implements TableModelListener {
        UserTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!AdminFrame.this.userCanWrite) {
                return;
            }
            AdminFrame.this.apply.setEnabled(true);
            int n = AdminFrame.this.userTable.getRowCount();
            if (tableModelEvent.getType() == -1) {
                if (n > 0) {
                    int n2 = AdminFrame.this.userTable.getSelectedRow();
                    if (n2 < 0 || n2 >= n) {
                        AdminFrame.this.userTable.setRowSelectionInterval(n - 1, n - 1);
                    }
                } else {
                    AdminFrame.this.deleteUser.setEnabled(false);
                }
            } else {
                int n3 = AdminFrame.this.userTable.getSelectedRow();
                if (n3 < 0) {
                    n3 = n - 1;
                }
                AdminFrame.this.userTable.setRowSelectionInterval(n3, n3);
                AdminFrame.this.deleteUser.setEnabled(true);
            }
        }
    }

    class NameSpaceTableModelListener
    implements TableModelListener {
        NameSpaceTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!AdminFrame.this.userCanWrite) {
                return;
            }
            AdminFrame.this.apply.setEnabled(true);
            int n = AdminFrame.this.nsTable.getRowCount();
            if (tableModelEvent.getType() == -1) {
                if (n > 0) {
                    int n2 = AdminFrame.this.nsTable.getSelectedRow();
                    if (n2 < 0 || n2 >= n) {
                        AdminFrame.this.nsTable.setRowSelectionInterval(n - 1, n - 1);
                    }
                } else {
                    AdminFrame.this.deleteNS.setEnabled(false);
                }
            } else {
                int n3 = AdminFrame.this.nsTable.getSelectedRow();
                if (n3 < 0) {
                    n3 = n - 1;
                }
                AdminFrame.this.nsTable.setRowSelectionInterval(n3, n3);
                AdminFrame.this.deleteNS.setEnabled(true);
            }
        }
    }

    class UserSelectionListener
    implements ListSelectionListener {
        UserSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = listSelectionEvent.getFirstIndex();
            boolean bl = !AdminFrame.this.userAclList.isEmpty() && n >= 0 && n < AdminFrame.this.userAclList.size() && AdminFrame.this.userCanWrite;
            AdminFrame.this.deleteUser.setEnabled(bl);
        }
    }

    class NameSpaceSelectionListener
    implements ListSelectionListener {
        NameSpaceSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = listSelectionEvent.getFirstIndex();
            boolean bl = !AdminFrame.this.nsAclList.isEmpty() && n >= 0 && n < AdminFrame.this.nsAclList.size() && AdminFrame.this.userCanWrite;
            AdminFrame.this.deleteNS.setEnabled(bl);
        }
    }

    class UserTableModel
    extends DefaultTableModel {
        UserTableModel() {
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            if (AdminFrame.this.userTableHeading != null) {
                return AdminFrame.this.userTableHeading.size();
            }
            return 0;
        }

        public String getColumnName(int n) {
            return (String)AdminFrame.this.userTableHeading.get(n);
        }

        public Object getValueAt(int n, int n2) {
            UserInfo userInfo = (UserInfo)AdminFrame.this.userAclList.elementAt(n);
            switch (n2) {
                case 0: {
                    return userInfo.getUserName();
                }
                case 1: {
                    return userInfo.getNameSpace();
                }
                case 2: {
                    return new Boolean(userInfo.isRead());
                }
                case 3: {
                    return new Boolean(userInfo.isWrite());
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 > 1 && AdminFrame.this.userCanWrite;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 < 2) {
                return;
            }
            UserInfo userInfo = (UserInfo)AdminFrame.this.userAclList.elementAt(n);
            userInfo.setModified();
            if (n2 == 2) {
                userInfo.setRead((Boolean)object);
            } else {
                userInfo.setWrite((Boolean)object);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }

    class NameSpaceTableModel
    extends DefaultTableModel {
        NameSpaceTableModel() {
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            if (AdminFrame.this.nsTableHeading != null) {
                return AdminFrame.this.nsTableHeading.size();
            }
            return 0;
        }

        public String getColumnName(int n) {
            return (String)AdminFrame.this.nsTableHeading.get(n);
        }

        public Object getValueAt(int n, int n2) {
            NameSpaceInfo nameSpaceInfo = (NameSpaceInfo)AdminFrame.this.nsAclList.elementAt(n);
            switch (n2) {
                case 0: {
                    return nameSpaceInfo.getNameSpace();
                }
                case 1: {
                    return new Boolean(nameSpaceInfo.isRead());
                }
                case 2: {
                    return new Boolean(nameSpaceInfo.isWrite());
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 > 0 && AdminFrame.this.userCanWrite;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 < 1) {
                return;
            }
            NameSpaceInfo nameSpaceInfo = (NameSpaceInfo)AdminFrame.this.nsAclList.elementAt(n);
            nameSpaceInfo.setModified();
            if (n2 == 1) {
                nameSpaceInfo.setRead((Boolean)object);
            } else {
                nameSpaceInfo.setWrite((Boolean)object);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }

    private class NameSpaceInfo {
        protected String namespace;
        protected boolean read;
        protected boolean write;
        protected boolean preExists;
        protected boolean modified;

        public NameSpaceInfo(String string) {
            this(string, true, false, false);
        }

        public NameSpaceInfo(String string, String string2) {
            this.namespace = string;
            this.read = string2.equalsIgnoreCase("r") || string2.equalsIgnoreCase("rw");
            this.write = string2.equalsIgnoreCase("w") || string2.equalsIgnoreCase("rw");
        }

        public NameSpaceInfo(String string, String string2, boolean bl) {
            this.namespace = string;
            this.read = string2.equalsIgnoreCase("r") || string2.equalsIgnoreCase("rw");
            this.write = string2.equalsIgnoreCase("w") || string2.equalsIgnoreCase("rw");
            this.preExists = bl;
        }

        public NameSpaceInfo(String string, boolean bl, boolean bl2) {
            this(string, bl, bl2, false);
        }

        public NameSpaceInfo(String string, boolean bl, boolean bl2, boolean bl3) {
            this.namespace = string;
            this.read = bl;
            this.write = bl2;
            this.preExists = bl3;
            this.modified = this.preExists ^ true;
        }

        public boolean equals(NameSpaceInfo nameSpaceInfo) {
            return this.equals(nameSpaceInfo.getNameSpace());
        }

        public boolean equals(String string) {
            return this.namespace.equalsIgnoreCase(string);
        }

        public String getAccess() {
            String string = "";
            if (this.read) {
                string = String.valueOf(string) + "r";
            }
            if (this.write) {
                string = String.valueOf(string) + "w";
            }
            return string;
        }

        public String getNameSpace() {
            return this.namespace;
        }

        public boolean isModified() {
            return this.modified;
        }

        public boolean isRead() {
            return this.read;
        }

        public boolean isReadWrite() {
            return this.read && this.write;
        }

        public boolean isWrite() {
            return this.write;
        }

        public boolean preExists() {
            return this.preExists;
        }

        public void setAccess(String string) {
            this.read = string.equalsIgnoreCase("r") || string.equalsIgnoreCase("rw");
            this.write = string.equalsIgnoreCase("w") || string.equalsIgnoreCase("rw");
        }

        public void setAccess(boolean bl, boolean bl2) {
            this.read = bl;
            this.write = bl2;
        }

        public void setModified() {
            this.modified = true;
        }

        public void setModified(boolean bl) {
            this.modified = bl;
        }

        public void setPreExists(boolean bl) {
            this.preExists = bl;
        }

        public void setRead(boolean bl) {
            this.read = bl;
        }

        public void setWrite(boolean bl) {
            this.write = bl;
        }
    }

    private class UserInfo
    extends NameSpaceInfo {
        private String username;

        public UserInfo(String string, String string2) {
            super(string2);
            this.username = string;
        }

        public UserInfo(String string, String string2, String string3) {
            super(string2, string3);
            this.username = string;
        }

        public UserInfo(String string, String string2, String string3, boolean bl) {
            super(string2, string3, bl);
            this.username = string;
        }

        public UserInfo(String string, String string2, boolean bl, boolean bl2) {
            this(string, string2, bl, bl2, false);
        }

        public UserInfo(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
            super(string2, bl, bl2, bl3);
            this.username = string;
        }

        public boolean equals(UserInfo userInfo) {
            return this.equals(userInfo.getUserName(), userInfo.getNameSpace());
        }

        public boolean equals(String string, String string2) {
            return this.username.equalsIgnoreCase(string) && this.namespace.equalsIgnoreCase(string2);
        }

        public String getUserName() {
            return this.username;
        }
    }
}

