/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class LraPopWitness
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    private INTEGER pkiDataBodyid;
    private SEQUENCE bodyIds;
    private SEQUENCE sequence;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private LraPopWitness() {
    }

    public LraPopWitness(INTEGER iNTEGER, SEQUENCE sEQUENCE) {
        if (iNTEGER == null || sEQUENCE == null) {
            throw new IllegalArgumentException("parameter to LraPopWitness constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.pkiDataBodyid = iNTEGER;
        this.sequence.addElement(iNTEGER);
        this.bodyIds = sEQUENCE;
        this.sequence.addElement(sEQUENCE);
    }

    public void addBodyPartId(int n) {
        INTEGER iNTEGER = new INTEGER(n);
        Assert._assert(iNTEGER.compareTo(BODYIDMAX) <= 0);
        this.bodyIds.addElement(iNTEGER);
    }

    public INTEGER getPKIDataBodyid() {
        return this.pkiDataBodyid;
    }

    public SEQUENCE getBodyIds() {
        return this.bodyIds;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new SEQUENCE.OF_Template(INTEGER.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new LraPopWitness((INTEGER)sEQUENCE.elementAt(0), (SEQUENCE)sEQUENCE.elementAt(1));
        }
    }
}

