/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cms.ContentInfo;

public class TaggedContentInfo
implements ASN1Value {
    private INTEGER bodyPartID;
    private ContentInfo contentInfo;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public INTEGER getBodyPartID() {
        return this.bodyPartID;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    private TaggedContentInfo() {
    }

    public TaggedContentInfo(INTEGER iNTEGER, ContentInfo contentInfo) {
        if (iNTEGER == null || contentInfo == null) {
            throw new IllegalArgumentException("parameter to TaggedContentInfo constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.bodyPartID = iNTEGER;
        this.sequence.addElement(iNTEGER);
        this.contentInfo = contentInfo;
        this.sequence.addElement(contentInfo);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(ContentInfo.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new TaggedContentInfo((INTEGER)sEQUENCE.elementAt(0), (ContentInfo)sEQUENCE.elementAt(1));
        }
    }
}

