/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class EncapsulatedContentInfo
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private OBJECT_IDENTIFIER contentType;
    private OCTET_STRING content;
    private SEQUENCE sequence = new SEQUENCE();
    private static Template templateInstance = new Template();

    private EncapsulatedContentInfo() {
    }

    public EncapsulatedContentInfo(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value) {
        this.contentType = oBJECT_IDENTIFIER;
        this.sequence.addElement(oBJECT_IDENTIFIER);
        if (aSN1Value != null) {
            this.content = aSN1Value instanceof OCTET_STRING ? (OCTET_STRING)aSN1Value : new OCTET_STRING(ASN1Util.encode(aSN1Value));
            this.sequence.addElement(new EXPLICIT(new Tag(0L), this.content));
        }
    }

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public OCTET_STRING getContent() {
        return this.content;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public Template() {
            this.seqt.addElement(new OBJECT_IDENTIFIER.Template());
            this.seqt.addOptionalElement(new EXPLICIT.Template(new Tag(0L), new OCTET_STRING.Template()));
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert._assert(sEQUENCE.size() == 2);
            ASN1Value aSN1Value = sEQUENCE.elementAt(1) == null ? null : ((EXPLICIT)sEQUENCE.elementAt(1)).getContent();
            return new EncapsulatedContentInfo((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), aSN1Value);
        }
    }
}

