/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cms.EncryptedContentInfo;

public class EncryptedData
implements ASN1Value {
    private INTEGER version;
    private EncryptedContentInfo encryptedContentInfo;
    private SEQUENCE sequence;
    public static final INTEGER DEFAULT_VERSION = new INTEGER(0L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private EncryptedData() {
    }

    public EncryptedData(INTEGER iNTEGER, EncryptedContentInfo encryptedContentInfo) {
        if (iNTEGER == null || encryptedContentInfo == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sequence = new SEQUENCE();
        this.version = iNTEGER;
        this.sequence.addElement(iNTEGER);
        this.encryptedContentInfo = encryptedContentInfo;
        this.sequence.addElement(encryptedContentInfo);
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo) {
        this(DEFAULT_VERSION, encryptedContentInfo);
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(EncryptedContentInfo.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new EncryptedData((INTEGER)sEQUENCE.elementAt(0), (EncryptedContentInfo)sEQUENCE.elementAt(1));
        }
    }
}

