/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.Debug;

public class JCASigTest {
    public static void usage() {
        System.out.println("Usage: java org.mozilla.jss.tests.JCASigTest <dbdir> <passwordFile>");
    }

    public static void sigTest(String string, KeyPair keyPair) {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        try {
            Signature signature = Signature.getInstance(string);
            System.out.println("Created a signing context");
            Provider provider = signature.getProvider();
            System.out.println("The provider used for the signer " + provider.getName() + " and the algorithm was " + string);
            if (!provider.getName().equalsIgnoreCase("Mozilla-JSS")) {
                System.out.println("Mozilla-JSS is supposed to be the default provider for JCASigTest");
                System.exit(1);
            }
            signature.initSign((PrivateKey)keyPair.getPrivate());
            System.out.println("initialized the signing operation");
            signature.update(byArray);
            System.out.println("updated signature with data");
            byte[] byArray2 = signature.sign();
            System.out.println("Successfully signed!");
            signature.initVerify(keyPair.getPublic());
            System.out.println("initialized verification");
            signature.update(byArray);
            System.out.println("updated verification with data");
            if (signature.verify(byArray2)) {
                System.out.println("Signature Verified Successfully!");
            } else {
                System.out.println("ERROR: Signature failed to verify.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            JCASigTest.usage();
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string);
            initializationValues.removeSunProvider = true;
            CryptoManager.initialize(initializationValues);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            cryptoManager.setPasswordCallback(new FilePasswordCallback(string2));
            Debug.setLevel(10);
            Provider[] providerArray = Security.getProviders();
            for (int i = 0; i < providerArray.length; ++i) {
                System.out.println("Provider " + i + ": " + providerArray[i].getName());
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Provider provider = keyPairGenerator.getProvider();
            System.out.println("The provider used to Generate the Keys was " + provider.getName());
            System.out.println("provider info " + provider.getInfo());
            if (!provider.getName().equalsIgnoreCase("Mozilla-JSS")) {
                System.out.println("Mozilla-JSS is supposed to be the default provider for JCASigTest");
                System.exit(1);
            }
            JCASigTest.sigTest("MD5/RSA", keyPair);
            JCASigTest.sigTest("MD2/RSA", keyPair);
            JCASigTest.sigTest("SHA-1/RSA", keyPair);
            JCASigTest.sigTest("SHA-256/RSA", keyPair);
            JCASigTest.sigTest("SHA-384/RSA", keyPair);
            JCASigTest.sigTest("SHA-512/RSA", keyPair);
            keyPairGenerator = KeyPairGenerator.getInstance("DSA");
            keyPairGenerator.initialize(1024);
            keyPair = keyPairGenerator.generateKeyPair();
            provider = keyPairGenerator.getProvider();
            System.out.println("The provider used to Generate the Keys was " + provider.getName());
            System.out.println("provider info " + provider.getInfo());
            if (!provider.getName().equalsIgnoreCase("Mozilla-JSS")) {
                System.out.println("Mozilla-JSS is supposed to be the default provider for JCASigTest");
                System.exit(1);
            }
            JCASigTest.sigTest("SHA-1/DSA", keyPair);
            keyPairGenerator = KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(256);
            keyPair = keyPairGenerator.generateKeyPair();
            provider = keyPairGenerator.getProvider();
            System.out.println("The provider used to Generate the Keys was " + provider.getName());
            System.out.println("provider info " + provider.getInfo());
            if (!provider.getName().equalsIgnoreCase("Mozilla-JSS")) {
                System.out.println("Mozilla-JSS is supposed to be the default provider for JCASigTest");
                System.exit(1);
            }
            JCASigTest.sigTest("SHA-1/EC", keyPair);
            JCASigTest.sigTest("SHA-256/EC", keyPair);
            JCASigTest.sigTest("SHA-384/EC", keyPair);
            JCASigTest.sigTest("SHA-512/EC", keyPair);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

