/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java2d.DemoGroup;
import java2d.DemoPanel;
import java2d.Java2Demo;
import java2d.TextureChooser;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GlobalControls
extends JPanel
implements ItemListener,
ChangeListener {
    static String[] screenNames = new String[]{"Auto Screen", "On Screen", "Off Screen", "INT_xRGB", "INT_ARGB", "INT_ARGB_PRE", "INT_BGR", "3BYTE_BGR", "4BYTE_ABGR", "4BYTE_ABGR_PRE", "USHORT_565_RGB", "USHORT_x555_RGB", "BYTE_GRAY", "USHORT_GRAY", "BYTE_BINARY", "BYTE_INDEXED", "BYTE_BINARY 2 bit", "BYTE_BINARY 4 bit", "INT_RGBx", "USHORT_555x_RGB"};
    static JComboBox screenCombo;
    public TextureChooser texturechooser;
    public JCheckBox aliasCB;
    public JCheckBox renderCB;
    public JCheckBox toolBarCB;
    public JCheckBox compositeCB;
    public JCheckBox textureCB;
    public JSlider slider;
    public Object obj;
    private Font font = new Font("serif", 0, 12);

    public GlobalControls() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Global Controls"));
        this.aliasCB = this.createCheckBox("Anti-Aliasing", true, 0);
        this.renderCB = this.createCheckBox("Rendering Quality", false, 1);
        this.textureCB = this.createCheckBox("Texture", false, 2);
        this.compositeCB = this.createCheckBox("AlphaComposite", false, 3);
        screenCombo = new JComboBox();
        screenCombo.setPreferredSize(new Dimension(120, 18));
        screenCombo.setLightWeightPopupEnabled(true);
        screenCombo.setFont(this.font);
        for (int i = 0; i < screenNames.length; ++i) {
            screenCombo.addItem(screenNames[i]);
        }
        screenCombo.addItemListener(this);
        Java2Demo.addToGridBag(this, screenCombo, 0, 4, 1, 1, 0.0, 0.0);
        this.toolBarCB = this.createCheckBox("Tools", false, 5);
        this.slider = new JSlider(0, 0, 200, 30);
        this.slider.addChangeListener(this);
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
        titledBorder.setTitleFont(this.font);
        titledBorder.setTitle("Anim delay = 30 ms");
        this.slider.setBorder(titledBorder);
        this.slider.setMinimumSize(new Dimension(80, 46));
        Java2Demo.addToGridBag(this, this.slider, 0, 6, 1, 1, 1.0, 1.0);
        this.texturechooser = new TextureChooser(0);
        Java2Demo.addToGridBag(this, this.texturechooser, 0, 7, 1, 1, 1.0, 1.0);
    }

    private JCheckBox createCheckBox(String string, boolean bl, int n) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        jCheckBox.setFont(this.font);
        jCheckBox.setHorizontalAlignment(2);
        jCheckBox.addItemListener(this);
        Java2Demo.addToGridBag(this, jCheckBox, 0, n, 1, 1, 1.0, 1.0);
        return jCheckBox;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getValue();
        TitledBorder titledBorder = (TitledBorder)this.slider.getBorder();
        titledBorder.setTitle("Anim delay = " + String.valueOf(n) + " ms");
        int n2 = Java2Demo.tabbedPane.getSelectedIndex() - 1;
        DemoGroup demoGroup = Java2Demo.group[n2];
        JPanel jPanel = demoGroup.getPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(i);
            if (demoPanel.tools == null || demoPanel.tools.slider == null) continue;
            demoPanel.tools.slider.setValue(n);
        }
        this.slider.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (Java2Demo.tabbedPane.getSelectedIndex() != 0) {
            this.obj = itemEvent.getSource();
            int n = Java2Demo.tabbedPane.getSelectedIndex() - 1;
            Java2Demo.group[n].setup(true);
            this.obj = null;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(135, 260);
    }
}

