/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.Context;
import com.sun.web.core.LookupResult;
import com.sun.web.core.ServletLoader;
import com.sun.web.core.ServletWrapper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class Container {
    private Context context;
    private ServletLoader loader = new ServletLoader(this);
    private Hashtable servlets = new Hashtable();
    private Hashtable pathMappedServlets = new Hashtable();
    private Hashtable extnMappedServlets = new Hashtable();
    private URL servletBase;

    Container(Context context) {
        this.context = context;
    }

    public void addMapping(String string, String string2) {
        ServletWrapper servletWrapper = (ServletWrapper)this.servlets.get(string);
        if (servletWrapper == null) {
            this.addServlet(string, string);
            servletWrapper = (ServletWrapper)this.servlets.get(string);
        }
        if (servletWrapper != null) {
            if (string2.startsWith(".")) {
                this.extnMappedServlets.put(string2, servletWrapper);
            } else {
                this.pathMappedServlets.put(string2, servletWrapper);
            }
        }
    }

    public void addServlet(String string, Class clazz) {
        ServletWrapper servletWrapper = new ServletWrapper(this);
        servletWrapper.setServletClass(clazz);
        this.servlets.put(string, servletWrapper);
    }

    public void addServlet(String string, String string2) {
        ServletWrapper servletWrapper = new ServletWrapper(this);
        servletWrapper.setServletClass(string2);
        this.servlets.put(string, servletWrapper);
    }

    Context getContext() {
        return this.context;
    }

    ServletLoader getLoader() {
        return this.loader;
    }

    public URL getServletBase() {
        return this.servletBase;
    }

    ServletWrapper loadServlet(String string) {
        ServletWrapper servletWrapper = new ServletWrapper(this);
        servletWrapper.setServletClass(string);
        this.servlets.put(string, servletWrapper);
        return servletWrapper;
    }

    LookupResult lookupServlet(String string) {
        ServletWrapper servletWrapper = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.lastIndexOf(".");
        if (n > -1) {
            string2 = string.substring(n, string.length());
        }
        String string5 = string;
        do {
            if (string5.length() > 1) {
                servletWrapper = (ServletWrapper)this.pathMappedServlets.get(string5);
                if (servletWrapper != null) {
                    string3 = string5;
                    string4 = string.substring(string3.length(), string.length());
                    continue;
                }
                string5 = string5.substring(0, string5.lastIndexOf("/"));
                continue;
            }
            if (string2 != null) {
                servletWrapper = (ServletWrapper)this.extnMappedServlets.get(string2);
                string4 = string;
            }
            if (servletWrapper != null) continue;
            servletWrapper = (ServletWrapper)this.servlets.get("default");
            string4 = string;
        } while (servletWrapper == null);
        return new LookupResult(servletWrapper, string3, string4);
    }

    LookupResult lookupServletAndLoadByName(String string) {
        ServletWrapper servletWrapper = new ServletWrapper(this);
        servletWrapper.setServletClass(string);
        this.servlets.put(string, servletWrapper);
        return new LookupResult(servletWrapper, null, "");
    }

    LookupResult lookupServletByName(String string) {
        ServletWrapper servletWrapper = (ServletWrapper)this.servlets.get(string);
        if (servletWrapper != null) {
            return new LookupResult(servletWrapper, null, "");
        }
        return null;
    }

    public void setServletBase(URL uRL) {
        String string = uRL.getFile();
        if (!string.endsWith("/")) {
            try {
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(string) + "/");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("SHOULD NEVER HAPPEN: " + malformedURLException);
            }
        }
        this.servletBase = uRL;
    }

    public void setServletInitParams(String string, Hashtable hashtable) {
        ServletWrapper servletWrapper = (ServletWrapper)this.servlets.get(string);
        if (servletWrapper != null) {
            servletWrapper.setInitArgs(hashtable);
        }
    }

    void shutdown() {
        Enumeration enumeration = this.servlets.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ServletWrapper servletWrapper = (ServletWrapper)this.servlets.get(string);
            this.servlets.remove(string);
            servletWrapper.destroy();
        }
    }
}

