/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.Request;
import com.sun.web.util.StringManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpServletRequestFacade
implements HttpServletRequest {
    private StringManager sm = StringManager.getManager("com.sun.web.core");
    private Request request;
    private boolean usingStream = false;
    private boolean usingReader = false;

    public HttpServletRequestFacade(Request request) {
        this.request = request;
    }

    public Object getAttribute(String string) {
        return this.request.getAttribute(string);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public Cookie[] getCookies() {
        Vector vector = this.request.getCookies();
        Cookie[] cookieArray = new Cookie[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            cookieArray[n] = (Cookie)vector.elementAt(n);
            ++n;
        }
        return cookieArray;
    }

    public long getDateHeader(String string) {
        return this.request.getDateHeader(string);
    }

    public String getHeader(String string) {
        return this.request.getHeader(string);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            String string = this.sm.getString("reqfac.getinstream.ise");
            throw new IllegalStateException(string);
        }
        this.usingStream = true;
        return this.request.getInputStream();
    }

    public int getIntHeader(String string) {
        return this.request.getIntHeader(string);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String string) {
        String[] stringArray = this.getParameterValues(string);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String string) {
        return this.request.getParameterValues(string);
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        String string = this.getPathInfo();
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            string = "/";
        }
        try {
            URL uRL = this.request.getContext().getFacade().getResource(string);
            if (uRL != null && uRL.getProtocol().equals("file")) {
                return uRL.getFile();
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingStream) {
            String string = this.sm.getString("reqfac.getreader.ise");
            throw new IllegalStateException(string);
        }
        this.usingReader = true;
        return this.request.getReader();
    }

    public String getRealPath(String string) {
        return this.request.getContext().getFacade().getRealPath(string);
    }

    Request getRealRequest() {
        return this.request;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean bl) {
        return this.request.getSession(bl);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession httpSession = this.getSession(false);
        return httpSession != null;
    }

    public void removeAttribute(String string) {
        this.request.removeAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this.request.setAttribute(string, object);
    }
}

