/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.util.ArrayList;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanTree;

public class XTree
extends XMBeanTree {
    private HashMap<String, DefaultMutableTreeNode> nodes = new HashMap();
    private boolean treeView;
    private boolean treeViewInit = false;
    private boolean treeToolTip;
    private boolean treeToolTipInit = false;

    public XTree() {
        this(new DefaultMutableTreeNode(Resources.getText("Tree", new Object[0])));
    }

    public XTree(TreeNode treeNode) {
        super(treeNode);
        if (this.isTreeToolTip()) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    public void removeAll() {
        super.removeAll();
        this.nodes.clear();
    }

    public synchronized void delMBeanFromView(ObjectName objectName) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Dn dn = this.buildDn(objectName);
        if (dn.size() > 0) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            String string = dn.getHashKey(dn.getToken(0));
            defaultMutableTreeNode = this.nodes.get(string);
            if (defaultMutableTreeNode != null && !defaultMutableTreeNode.isRoot()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                this.nodes.remove(string);
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.delParentFromView(dn, 1, defaultMutableTreeNode2);
                if (defaultMutableTreeNode3 != null) {
                    // empty if block
                }
            }
        }
    }

    protected DefaultMutableTreeNode delParentFromView(Dn dn, int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!defaultMutableTreeNode.isRoot() && defaultMutableTreeNode.isLeaf() && !(defaultMutableTreeNode.getUserObject() instanceof XMBean)) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.removeChildNode(defaultMutableTreeNode);
            String string = dn.getHashKey(dn.getToken(n));
            this.nodes.remove(string);
            this.delParentFromView(dn, n + 1, defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public synchronized void addMBeanToView(MBeansTab mBeansTab, ObjectName objectName) throws InstanceNotFoundException {
        Dn dn = this.buildDn(objectName);
        if (dn.size() == 0) {
            return;
        }
        Token token = dn.getToken(0);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        boolean bl = true;
        String string = dn.getHashKey(token);
        if (this.nodes.containsKey(string)) {
            defaultMutableTreeNode = this.nodes.get(string);
            this.changeNodeValue(defaultMutableTreeNode, this.createNodeValue(objectName, mBeansTab, token));
            bl = false;
        } else {
            defaultMutableTreeNode = this.createDnNode(dn, token, mBeansTab, objectName);
            if (defaultMutableTreeNode != null) {
                this.nodes.put(string, defaultMutableTreeNode);
                bl = true;
            } else {
                return;
            }
        }
        for (int i = 1; i < dn.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            token = dn.getToken(i);
            string = dn.getHashKey(token);
            if (this.nodes.containsKey(string)) {
                if (bl) {
                    defaultMutableTreeNode2 = this.nodes.get(string);
                    this.addChildNode(defaultMutableTreeNode2, defaultMutableTreeNode);
                    return;
                }
                return;
            }
            if (token.getKeyDn().equals("domain")) {
                defaultMutableTreeNode2 = this.createDomainNode(dn, token);
                if (defaultMutableTreeNode2 != null) {
                    this.addChildNode(this.getRoot(), defaultMutableTreeNode2);
                }
            } else {
                defaultMutableTreeNode2 = this.createSubDnNode(dn, token);
                if (defaultMutableTreeNode2 == null) continue;
            }
            this.nodes.put(string, defaultMutableTreeNode2);
            this.addChildNode(defaultMutableTreeNode2, defaultMutableTreeNode);
            bl = true;
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
    }

    public synchronized void changeNodeValue(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        if (defaultMutableTreeNode instanceof Comparable) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
            defaultMutableTreeNode2.setUserObject(object);
            if (((Comparable)((Object)defaultMutableTreeNode)).compareTo(defaultMutableTreeNode2) == 0) {
                super.changeNodeValue(defaultMutableTreeNode, object);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                this.removeChildNode(defaultMutableTreeNode);
                defaultMutableTreeNode.setUserObject(object);
                this.addChildNode(defaultMutableTreeNode3, defaultMutableTreeNode);
            }
        } else {
            super.changeNodeValue(defaultMutableTreeNode, object);
        }
    }

    public synchronized void addChildNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        int n = defaultMutableTreeNode.getChildCount();
        if (n == 0) {
            super.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2);
        } else if (defaultMutableTreeNode2 instanceof Comparable) {
            int n2 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                if (((Comparable)((Object)defaultMutableTreeNode2)).compareTo(defaultMutableTreeNode3) < 0) {
                    super.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n2);
                    break;
                }
                if (((Comparable)((Object)defaultMutableTreeNode2)).compareTo(defaultMutableTreeNode3) != 0) continue;
                super.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n2);
                break;
            }
            if (n2 == n) {
                super.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n);
            }
        } else {
            super.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n);
        }
    }

    public DefaultMutableTreeNode createDomainNode(Dn dn, Token token) {
        OrderedDefaultMutableTreeNode orderedDefaultMutableTreeNode = new OrderedDefaultMutableTreeNode(dn.getDomain());
        return orderedDefaultMutableTreeNode;
    }

    public DefaultMutableTreeNode createDnNode(Dn dn, Token token, MBeansTab mBeansTab, ObjectName objectName) throws InstanceNotFoundException {
        return new OrderedDefaultMutableTreeNode(this.createNodeValue(objectName, mBeansTab, token));
    }

    public DefaultMutableTreeNode createSubDnNode(Dn dn, Token token) {
        return new OrderedDefaultMutableTreeNode(token.getValue());
    }

    public Object createNodeValue(ObjectName objectName, MBeansTab mBeansTab, Token token) throws InstanceNotFoundException {
        String string = token.getValue();
        XMBean xMBean = new XMBean(objectName, mBeansTab);
        if (string != null) {
            xMBean.setText(string);
        }
        return xMBean;
    }

    public final Dn buildDn(ObjectName objectName) {
        String string = objectName.getDomain();
        String string2 = objectName.getKeyPropertyListString();
        Dn dn = this.buildDn(string, string2, objectName);
        this.updateDn(dn, objectName);
        dn.reverseOrder();
        dn.computeHashDn();
        return dn;
    }

    public Dn buildDn(String string, String string2, ObjectName objectName) {
        Dn dn = new Dn(string, string2);
        String string3 = "no_key";
        if (this.isTreeView()) {
            String string4 = string2;
            int n = string4.indexOf("=");
            while (n != -1) {
                String string5 = string4.substring(0, n);
                String string6 = objectName.getKeyProperty(string5);
                dn.addToken(new Token(string3, string5 + "=" + string6));
                string4 = string4.substring(string5.length() + 1 + string6.length());
                if (string4.startsWith(",")) {
                    string4 = string4.substring(1);
                }
                n = string4.indexOf("=");
            }
        } else {
            dn.addToken(new Token(string3, "properties=" + string2));
        }
        return dn;
    }

    public void updateDn(Dn dn, ObjectName objectName) {
        dn.addToken(0, new Token("domain", "domain=" + dn.getDomain()));
    }

    protected Object getExpandedPathKey(TreePath treePath) {
        return super.getExpandedPathKey(treePath);
    }

    protected void expandNodePath(TreePath treePath) {
        super.expandNodePath(treePath);
    }

    public String buildHashKey(Dn dn, Token token) {
        int n = dn.getHashDn().indexOf(token.getHashToken());
        return dn.getHashDn().substring(n, dn.getHashDn().length());
    }

    public boolean isTreeView() {
        if (!this.treeViewInit) {
            this.treeView = this.getTreeViewValue();
            this.treeViewInit = true;
        }
        return this.treeView;
    }

    public boolean isTreeToolTip() {
        if (!this.treeToolTipInit) {
            this.treeToolTip = this.getTreeToolTipValue();
            this.treeToolTipInit = true;
        }
        return this.treeToolTip;
    }

    private boolean getTreeViewValue() {
        String string = System.getProperties().getProperty("treeView");
        return string == null ? true : !string.equals("false");
    }

    private boolean getTreeToolTipValue() {
        String string = System.getProperties().getProperty("treeToolTip");
        return string == null ? false : string.equals("true");
    }

    public static class Token {
        private String keyDn;
        private String token;
        private String hashToken;
        private String key;
        private String value;

        public Token(String string, String string2) {
            this.keyDn = string;
            this.token = string2;
            this.buildKeyValue();
        }

        public Token(String string, String string2, String string3) {
            this.keyDn = string;
            this.token = string2;
            this.hashToken = string3;
            this.buildKeyValue();
        }

        public String getKeyDn() {
            return this.keyDn;
        }

        public String getToken() {
            return this.token;
        }

        public void setValue(String string) {
            this.value = string;
            this.token = this.key + "=" + string;
        }

        public void setKey(String string) {
            this.key = string;
            this.token = string + ":" + this.value;
        }

        public void setKeyDn(String string) {
            this.keyDn = string;
        }

        public void setHashToken(String string) {
            this.hashToken = string;
        }

        public String getHashToken() {
            return this.hashToken;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getToken();
        }

        public boolean equals(Object object) {
            if (object instanceof Token) {
                return this.token.equals((Token)object);
            }
            return false;
        }

        private void buildKeyValue() {
            int n = this.token.indexOf("=");
            if (n < 0) {
                this.key = this.token;
                this.value = this.token;
            } else {
                this.key = this.token.substring(0, n);
                this.value = this.token.substring(n + 1, this.token.length());
            }
        }
    }

    public static class Dn {
        private ArrayList<Token> tokens = new ArrayList(8);
        private String domain;
        private String hashDn;
        private String dn;

        public Dn(String string, String string2) {
            this.domain = string;
            this.dn = string2;
        }

        public void clearTokens() {
            this.tokens.clear();
        }

        public void addToken(Token token) {
            this.tokens.add(token);
        }

        public void addToken(int n, Token token) {
            this.tokens.add(n, token);
        }

        public void setToken(int n, Token token) {
            this.tokens.set(n, token);
        }

        public void removeToken(int n) {
            this.tokens.remove(n);
        }

        public Token getToken(int n) {
            return this.tokens.get(n);
        }

        public void reverseOrder() {
            ArrayList<Token> arrayList = new ArrayList<Token>(this.tokens.size());
            for (int i = this.tokens.size() - 1; i >= 0; --i) {
                arrayList.add(this.tokens.get(i));
            }
            this.tokens = arrayList;
        }

        public int size() {
            return this.tokens.size();
        }

        public String getDomain() {
            return this.domain;
        }

        public String getDn() {
            return this.dn;
        }

        public String getHashDn() {
            return this.hashDn;
        }

        public String getHashKey(Token token) {
            int n = this.getHashDn().indexOf(token.getHashToken());
            return this.getHashDn().substring(n, this.getHashDn().length());
        }

        public void computeHashDn() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.tokens.size(); ++i) {
                Token token = this.tokens.get(i);
                String string = token.getHashToken();
                if (string == null) {
                    string = token.getToken() + "" + (this.tokens.size() - i);
                    token.setHashToken(string);
                }
                stringBuffer.append(string);
                stringBuffer.append(",");
            }
            this.hashDn = this.tokens.size() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : "";
        }

        public String toString() {
            return this.tokens.toString();
        }
    }

    public static class OrderedDefaultMutableTreeNode
    extends DefaultMutableTreeNode
    implements Comparable {
        public OrderedDefaultMutableTreeNode(Object object) {
            super(object);
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }
    }
}

