/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.query.AttributeExp;
import com.sun.wbem.query.BinaryRelQueryExp;
import com.sun.wbem.query.DateTimeExp;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.NumericValue;
import com.sun.wbem.query.QualifiedAttributeExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.StringValueExp;
import com.sun.wbem.query.ValueExp;
import com.sun.wbem.query.WQLParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ProviderFilter {
    private CIMClass qClass;
    private String query = null;
    private String className;
    private SelectList slist;
    private List canList;
    private String sortProp;
    private int sortOrder;
    private Vector selectProps;
    private boolean allSelected;

    public ProviderFilter(CIMClass cIMClass, String string) throws CIMException {
        this.qClass = cIMClass;
        this.query = string;
        this.slist = null;
        this.canList = null;
        this.sortProp = null;
        this.sortOrder = 0;
        this.selectProps = null;
        this.allSelected = true;
        this.parseQuery(string);
    }

    public boolean apply(CIMInstance cIMInstance) throws CIMException {
        if (this.canList == null || this.canList.size() == 0) {
            return true;
        }
        boolean bl = false;
        Iterator iterator = this.canList.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            if (list == null || list.size() <= 0) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                bl = true;
                BinaryRelQueryExp binaryRelQueryExp = null;
                try {
                    binaryRelQueryExp = (BinaryRelQueryExp)iterator2.next();
                }
                catch (Exception exception) {
                    binaryRelQueryExp = null;
                }
                if (binaryRelQueryExp != null && binaryRelQueryExp.apply((CIMElement)cIMInstance)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public List getCanonicalWhere() {
        return this.canList;
    }

    public String getClassName() {
        return this.className;
    }

    public Vector getSelectedPropertyNames() {
        if (this.allSelected) {
            return null;
        }
        return this.selectProps;
    }

    public CIMProperty getSortProperty() {
        CIMProperty cIMProperty = null;
        if (this.sortProp != null) {
            cIMProperty = this.qClass.getProperty(this.sortProp);
        }
        return cIMProperty;
    }

    public boolean isAllSelected() {
        return this.allSelected;
    }

    public boolean isSortAscending() {
        return this.sortOrder == 1;
    }

    private void parseQuery(String string) throws CIMException {
        SelectExp selectExp = null;
        NonJoinExp nonJoinExp = null;
        QueryExp queryExp = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        try {
            selectExp = (SelectExp)wQLParser.querySpecification();
            this.slist = selectExp.getSelectList();
            nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            queryExp = selectExp.getWhereClause();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        this.setSelectedPropertyNames(this.slist);
        String string2 = null;
        QualifiedAttributeExp qualifiedAttributeExp = nonJoinExp.getAttribute();
        if (qualifiedAttributeExp != null) {
            string2 = qualifiedAttributeExp.getAttrClassName();
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        this.className = new String(string2);
        if (queryExp != null) {
            this.canList = queryExp.canonizeDOC();
        }
        if (this.canList != null && this.canList.size() > 0) {
            Iterator iterator = this.canList.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                if (list != null && list.size() > 0) {
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        BinaryRelQueryExp binaryRelQueryExp = null;
                        try {
                            binaryRelQueryExp = (BinaryRelQueryExp)iterator2.next();
                        }
                        catch (Exception exception) {
                            binaryRelQueryExp = null;
                        }
                        if (binaryRelQueryExp != null) {
                            this.verifyExpression(binaryRelQueryExp);
                            continue;
                        }
                        throw new CIMException("CIM_ERR_INVALID_QUERY");
                    }
                    continue;
                }
                throw new CIMException("CIM_ERR_INVALID_QUERY");
            }
        }
        this.sortProp = null;
        this.sortOrder = 0;
    }

    public CIMInstance project(CIMInstance cIMInstance) throws CIMException {
        if (this.allSelected) {
            return cIMInstance;
        }
        return (CIMInstance)this.slist.apply((CIMElement)cIMInstance);
    }

    private void setSelectedPropertyNames(SelectList selectList) {
        Vector<String> vector = new Vector<String>();
        this.allSelected = false;
        if (selectList != null) {
            Enumeration enumeration = selectList.elements();
            while (enumeration.hasMoreElements()) {
                AttributeExp attributeExp = (AttributeExp)enumeration.nextElement();
                String string = attributeExp.getAttributeName();
                if (string.equals("*")) {
                    this.allSelected = true;
                    continue;
                }
                vector.addElement(string);
            }
        }
        if (vector.size() == 0) {
            this.allSelected = true;
        }
        if (!this.allSelected) {
            this.selectProps = vector;
        }
    }

    private void verifyExpression(BinaryRelQueryExp binaryRelQueryExp) throws CIMException {
        ValueExp valueExp = binaryRelQueryExp.getLeftValue();
        ValueExp valueExp2 = binaryRelQueryExp.getRightValue();
        int n = binaryRelQueryExp.getOperator();
        String string = ((AttributeExp)valueExp).getAttributeName();
        CIMProperty cIMProperty = this.qClass.getProperty(string);
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)binaryRelQueryExp.toString());
        }
        if (!(valueExp2 instanceof StringValueExp || valueExp2 instanceof NumericValue || valueExp2 instanceof DateTimeExp)) {
            throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)binaryRelQueryExp.toString());
        }
        switch (n) {
            default: {
                throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)binaryRelQueryExp.toString());
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
    }
}

