/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.diskdrive;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.diskdrive.DiskData;
import com.sun.wbem.solarisprovider.diskdrive.SolarisDisksNative;
import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.common.ProcLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Solaris_DiskDrive
implements InstanceProvider,
MethodProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private static String FMTHARD = new String("/usr/sbin/fmthard");
    private static String NAME_SWITCH = new String("-n");
    private static String DUMMY_SLICE = new String("s2");
    private static String FDISK = new String("/usr/sbin/fdisk");
    private static String FILE_SWITCH = new String("-F");
    private static String DEFAULT_SWITCH = new String("-B");
    private static String CREATE_FILE_SWITCH = new String("-W");
    private static String DATA_SEP = new String(":");
    private static String SPACE = new String(" ");
    private static String STAR = new String("*");
    private static String RAW_PATH = new String("/dev/rdsk/");
    public static final String DISK_WRITE_RIGHT = "solaris.admin.diskmgr.write";
    public static final String DISK_READ_RIGHT = "solaris.admin.diskmgr.read";

    static {
        System.loadLibrary("solprov");
    }

    public static native int GetDiskCount();

    private String buildFdiskFile(Vector vector) {
        try {
            String string = null;
            String string2 = ":0:0:0:0:0:0:";
            File file = new File("/tmp");
            File file2 = File.createTempFile("wbem", "fdisk", file);
            if (file2.isFile() && file2.canWrite()) {
                string = file2.getAbsolutePath();
                FileWriter fileWriter = new FileWriter(string);
                int n = 0;
                while (vector != null && n < vector.size()) {
                    fileWriter.write((String)vector.elementAt(n));
                    fileWriter.flush();
                    fileWriter.write(DATA_SEP);
                    fileWriter.flush();
                    fileWriter.write((String)vector.elementAt(n + 1));
                    fileWriter.flush();
                    fileWriter.write(string2);
                    fileWriter.flush();
                    fileWriter.write((String)vector.elementAt(n + 2));
                    fileWriter.flush();
                    fileWriter.write(DATA_SEP);
                    fileWriter.flush();
                    fileWriter.write((String)vector.elementAt(n + 3));
                    fileWriter.flush();
                    fileWriter.write("\n");
                    fileWriter.flush();
                    n += 4;
                }
                fileWriter.close();
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            Vector vector2 = SolarisDisksNative.getDisks();
            if (vector2 == null) {
                this.provUtil.writeLog(2, "LM_9302", "LM_9303", null, null, null, null);
            }
            int n = 0;
            while (vector2 != null && n < vector2.size()) {
                DiskData diskData = (DiskData)vector2.elementAt(n);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_DiskDrive"));
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)diskData.getDiskName()));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9304", "LM_9305", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            Vector vector2 = SolarisDisksNative.getDisks();
            if (vector2 == null) {
                this.provUtil.writeLog(2, "LM_9302", "LM_9303", null, null, null, null);
            }
            int n = 0;
            while (vector2 != null && n < vector2.size()) {
                DiskData diskData = (DiskData)vector2.elementAt(n);
                CIMInstance cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMInstance.setProperty("DiskLabel", new CIMValue((Object)diskData.getDiskLabel()));
                cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_DiskDrive"));
                cIMInstance.setProperty("DeviceID", new CIMValue((Object)diskData.getDiskName()));
                cIMInstance.setProperty("DiskType", new CIMValue((Object)diskData.getDiskType()));
                cIMInstance.setProperty("BytesPerCylinder", new CIMValue((Object)new UnsignedInt32((long)diskData.getBytesPerCylinder())));
                cIMInstance.setProperty("DataCylinders", new CIMValue((Object)new UnsignedInt32((long)diskData.getDataCylinders())));
                cIMInstance.setProperty("PhysicalCylinders", new CIMValue((Object)new UnsignedInt32((long)diskData.getPhysicalCylinders())));
                cIMInstance.setProperty("ActualCylinders", new CIMValue((Object)new UnsignedInt32((long)diskData.getActualCylinders())));
                cIMInstance.setProperty("AlternateCylinders", new CIMValue((Object)new UnsignedInt32((long)diskData.getAlternateCylinders())));
                cIMInstance.setProperty("HeadsPerCylinder", new CIMValue((Object)new UnsignedInt32((long)diskData.getHeadsACylinder())));
                cIMInstance.setProperty("SectorsPerTrack", new CIMValue((Object)new UnsignedInt32((long)diskData.getSectorsATrack())));
                if (diskData.isFdiskPresent()) {
                    cIMInstance.setProperty("FdiskPresent", CIMValue.TRUE);
                } else {
                    cIMInstance.setProperty("FdiskPresent", CIMValue.FALSE);
                }
                if (diskData.isFdiskRequired()) {
                    cIMInstance.setProperty("FdiskRequired", CIMValue.TRUE);
                } else {
                    cIMInstance.setProperty("FdiskRequired", CIMValue.FALSE);
                }
                vector.addElement(cIMInstance);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9304", "LM_9305", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) {
        return null;
    }

    private CIMValue getFdisk(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        try {
            this.provUtil.checkRights(DISK_READ_RIGHT, cIMObjectPath);
            string = this.getKeyValue(cIMObjectPath, "deviceid");
            if (string == null) {
                this.provUtil.writeLog(2, "LM_9310", "LM_9311", null, null, null, null);
                return CIMValue.FALSE;
            }
            String string2 = new String();
            string2 = string2.concat(FDISK);
            string2 = string2.concat(SPACE);
            string2 = string2.concat(CREATE_FILE_SWITCH);
            string2 = string2.concat(SPACE);
            String string3 = this.buildFdiskFile(vector);
            if (string3 == null) {
                this.provUtil.writeLog(2, "LM_9312", "LM_9313", null, null, null, null);
                return CIMValue.FALSE;
            }
            string2 = string2.concat(string3);
            string2 = string2.concat(SPACE);
            string2 = string2.concat(RAW_PATH);
            string2 = string2.concat(string);
            string2 = string2.concat("p0");
            Vector vector2 = CommonTools.CMN_exec((String)string2, (boolean)true);
            String[] stringArray = (String[])vector2.elementAt(1);
            if (stringArray.length != 0) {
                this.provUtil.writeLog(2, "LM_9312", "LM_9313", null, null, null, null);
                return CIMValue.FALSE;
            }
            if (this.parseFdiskFile(vector, string3)) {
                return CIMValue.TRUE;
            }
            this.provUtil.writeLog(2, "LM_9312", "LM_9313", null, null, null, null);
            return CIMValue.FALSE;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9312", "LM_9313", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return CIMValue.FALSE;
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        try {
            String string = "";
            string = this.getKeyValue(cIMObjectPath, "deviceid");
            Vector vector = new Vector();
            Vector vector2 = SolarisDisksNative.getDisks();
            if (vector2 == null) {
                this.provUtil.writeLog(2, "LM_9302", "LM_9303", null, null, null, null);
            }
            DiskData diskData = (DiskData)vector2.elementAt(0);
            int n = 0;
            while (vector2 != null && n < vector2.size()) {
                diskData = (DiskData)vector2.elementAt(n);
                if (string.equalsIgnoreCase(diskData.getDiskName())) break;
                ++n;
            }
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("DiskType", new CIMValue((Object)diskData.getDiskType()));
            cIMInstance.setProperty("DiskLabel", new CIMValue((Object)diskData.getDiskLabel()));
            cIMInstance.setProperty("DeviceID", new CIMValue((Object)string));
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_DiskDrive"));
            cIMInstance.setProperty("DataCylinders", new CIMValue((Object)new UnsignedInt32((long)diskData.getDataCylinders())));
            cIMInstance.setProperty("PhysicalCylinders", new CIMValue((Object)new UnsignedInt32((long)diskData.getPhysicalCylinders())));
            cIMInstance.setProperty("AlternateCylinders", new CIMValue((Object)new UnsignedInt32((long)diskData.getAlternateCylinders())));
            cIMInstance.setProperty("ActualCylinders", new CIMValue((Object)new UnsignedInt32((long)diskData.getActualCylinders())));
            cIMInstance.setProperty("BytesPerCylinder", new CIMValue((Object)new UnsignedInt32((long)diskData.getBytesPerCylinder())));
            cIMInstance.setProperty("HeadsPerCylinder", new CIMValue((Object)new UnsignedInt32((long)diskData.getHeadsACylinder())));
            cIMInstance.setProperty("SectorsPerTrack", new CIMValue((Object)new UnsignedInt32((long)diskData.getSectorsATrack())));
            if (diskData.isFdiskPresent()) {
                cIMInstance.setProperty("FdiskPresent", CIMValue.TRUE);
            } else {
                cIMInstance.setProperty("FdiskPresent", CIMValue.FALSE);
            }
            if (diskData.isFdiskRequired()) {
                cIMInstance.setProperty("FdiskRequired", CIMValue.TRUE);
            } else {
                cIMInstance.setProperty("FdiskRequired", CIMValue.FALSE);
            }
            return cIMInstance;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9300", "LM_9301", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return null;
        }
    }

    private String getKeyValue(CIMObjectPath cIMObjectPath, String string) {
        String string2 = "";
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase(string)) continue;
            string2 = (String)cIMProperty.getValue().getValue();
        }
        return string2;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, "Disk Manager");
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        try {
            if (string.equalsIgnoreCase("CreateFdiskPartitions")) {
                return this.setFdisk(vector, cIMObjectPath);
            }
            if (string.equalsIgnoreCase("CreateDefaultFdiskPartition")) {
                return this.setDefaultFdisk(vector, cIMObjectPath);
            }
            if (string.equalsIgnoreCase("GetFdiskPartitions")) {
                return this.getFdisk(vector2, cIMObjectPath);
            }
            if (string.equalsIgnoreCase("LabelDisk")) {
                return this.writeVolumeName(vector, cIMObjectPath);
            }
            this.provUtil.writeLog(1, "LM_9306", "LM_9307", string, null, null, null);
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9308", "LM_9309", null, null, null, null);
            this.provUtil.writeLog(2, exception);
        }
        return null;
    }

    private boolean parseFdiskFile(Vector vector, String string) {
        try {
            String string2 = "";
            String string3 = "";
            int n = 0;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith(STAR) || string2.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (n == 0 || n == 1 || n == 8 || n == 9) {
                        Integer n2 = Integer.valueOf(string3);
                        CIMDataType cIMDataType = new CIMDataType(5);
                        CIMValue cIMValue = new CIMValue((Object)n2, cIMDataType);
                        vector.addElement(cIMValue);
                    }
                    ++n;
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private CIMValue setDefaultFdisk(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            this.provUtil.checkRights(DISK_WRITE_RIGHT, cIMObjectPath);
            String string = "";
            Object var4_5 = null;
            String string2 = "";
            String string3 = new String();
            string = this.getKeyValue(cIMObjectPath, "deviceid");
            if (string.equalsIgnoreCase("")) {
                this.provUtil.writeLog(2, "LM_9316", "LM_9317", null, null, null, null);
                return CIMValue.FALSE;
            }
            string3 = string3.concat(FDISK);
            string3 = string3.concat(SPACE);
            string3 = string3.concat(DEFAULT_SWITCH);
            string3 = string3.concat(SPACE);
            string3 = string3.concat(RAW_PATH);
            string3 = string3.concat(string);
            Vector vector2 = CommonTools.CMN_exec((String)(string3 = string3.concat("p0")), (boolean)true);
            String[] stringArray = (String[])vector2.elementAt(1);
            if (stringArray.length != 0) {
                this.provUtil.writeLog(2, "LM_9318", "LM_9319", null, null, null, null);
                return CIMValue.FALSE;
            }
            this.provUtil.writeLog(0, "LM_9320", "LM_9321", string, null, null, null);
            return CIMValue.TRUE;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9318", "LM_9319", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return CIMValue.FALSE;
        }
    }

    private CIMValue setFdisk(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            this.provUtil.checkRights(DISK_WRITE_RIGHT, cIMObjectPath);
            String string = "";
            Object var4_5 = null;
            String string2 = "";
            String string3 = new String();
            string = this.getKeyValue(cIMObjectPath, "deviceid");
            if (string.equalsIgnoreCase("")) {
                this.provUtil.writeLog(2, "LM_9316", "LM_9317", null, null, null, null);
                return CIMValue.FALSE;
            }
            string3 = string3.concat(FDISK);
            string3 = string3.concat(SPACE);
            string3 = string3.concat(FILE_SWITCH);
            string3 = string3.concat(SPACE);
            String string4 = this.buildFdiskFile(vector);
            if (string4 == null) {
                this.provUtil.writeLog(2, "LM_9318", "LM_9319", null, null, null, null);
                return CIMValue.FALSE;
            }
            string3 = string3.concat(string4);
            string3 = string3.concat(SPACE);
            string3 = string3.concat(RAW_PATH);
            string3 = string3.concat(string);
            string3 = string3.concat("p0");
            Vector vector2 = CommonTools.CMN_exec((String)string3, (boolean)true);
            String[] stringArray = (String[])vector2.elementAt(1);
            if (stringArray.length != 0) {
                this.provUtil.writeLog(2, "LM_9318", "LM_9319", null, null, null, null);
                return CIMValue.FALSE;
            }
            this.provUtil.writeLog(0, "LM_9320", "LM_9321", string, null, null, null);
            return CIMValue.TRUE;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9318", "LM_9319", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return CIMValue.FALSE;
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMValue writeVolumeName(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            this.provUtil.checkRights(DISK_WRITE_RIGHT, cIMObjectPath);
            String string = "";
            String string2 = new String();
            String string3 = "";
            if (vector.isEmpty()) {
                this.provUtil.writeLog(2, "LM_9322", "LM_9323", null, null, null, null);
                return CIMValue.FALSE;
            }
            string3 = (String)vector.elementAt(0);
            if (string3.length() > 8) {
                this.provUtil.writeLog(2, "LM_9322", "LM_9324", null, null, null, null);
                return CIMValue.FALSE;
            }
            string = this.getKeyValue(cIMObjectPath, "deviceid");
            if (string.equalsIgnoreCase("")) {
                this.provUtil.writeLog(2, "LM_9322", "LM_9325", null, null, null, null);
                return CIMValue.FALSE;
            }
            string2 = string2.concat(FMTHARD);
            string2 = string2.concat(SPACE);
            string2 = string2.concat(NAME_SWITCH);
            string2 = string2.concat(SPACE);
            string2 = string2.concat(string3);
            string2 = string2.concat(SPACE);
            string2 = string2.concat(RAW_PATH);
            string2 = string2.concat(string);
            string2 = string2.concat(DUMMY_SLICE);
            string2 = string2.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            stringTokenizer.nextToken();
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n + 1];
            String[] stringArray2 = new String[1];
            stringArray[0] = FMTHARD;
            try {
                int n2 = 1;
                while (n2 <= n) {
                    stringArray[n2] = stringTokenizer.nextToken();
                    ++n2;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.provUtil.writeLog(2, "LM_9322", "LM_9325", null, null, null, null);
                return CIMValue.FALSE;
            }
            ProcLauncher procLauncher = new ProcLauncher(FMTHARD, "root", stringArray, stringArray2, false);
            int n3 = procLauncher.getStatus();
            if (n3 != 0) {
                this.provUtil.writeLog(2, "LM_9322", "LM_9326", null, null, null, null);
                return CIMValue.FALSE;
            }
            this.provUtil.writeLog(0, "LM_9327", "LM_9328", string, null, null, null);
            return CIMValue.TRUE;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9322", "LM_9322", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return CIMValue.FALSE;
        }
    }
}

