/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.client.ReadersWriter;
import com.sun.wbem.solarisprovider.common.PropertyUtil;
import com.sun.wbem.solarisprovider.common.PropertyUtilException;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.Buffer;
import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.DataStore;
import com.sun.wbem.solarisprovider.logsvc.FilterThread;
import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.InvalidRecordException;
import com.sun.wbem.solarisprovider.logsvc.LogFileNotFoundException;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogRecordNotFoundException;
import com.sun.wbem.solarisprovider.logsvc.LogServiceInterface;
import com.sun.wbem.solarisprovider.logsvc.LogSvcNative;
import com.sun.wbem.solarisprovider.logsvc.ReadThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class LogService
implements LogServiceInterface {
    public static final String LOG_SERVICE_FILE_DIR = "wbem.logging.file.dir";
    public static final String LOG_SERVICE_FILE_NAME = "wbem.logging.file.name";
    public static final String LOG_SERVICE_FILE_SIZE = "wbem.logging.file.size";
    public static final String LOG_SERVICE_FILE_NUM = "wbem.logging.file.num";
    public static final String LOG_SERVICE_SYSLOG = "wbem.logging.syslog";
    public static final String LOG_FILE_DIR = "/var/sadm/wbem/log";
    public static final String LOG_FILE_NAME = "wbem_log";
    public static final int LOG_FILE_SIZE = 5;
    public static final int LOG_FILE_NUM = 5;
    public static final String SYSLOG_SWITCH = "on";
    public static final String TYPE_SYSLOG = "Syslog";
    public static final String TYPE_WBEMLOG = "WBEM Log";
    public static final String IDENTITY = "Wbem Logging Service";
    public static final String LOGSVC_APPNAME = "Log Viewer";
    public static final int MEG = 0x100000;
    public static final int EIGHT_K = 8192;
    private static final String CONF = "/etc/syslog.conf";
    private static final String DEV = "/dev";
    private static ReadersWriter lock = null;
    private HashMap logFilesHash = new HashMap();
    private HashMap syslogFilesHash = new HashMap();
    private DataStore storage;
    private long fileSize = 0L;
    private int numOfLogFiles = 0;
    private String dirName = null;
    private String fileName = null;
    private String logFileName = null;
    private long currentFileSize = 0L;
    private String currentViewerFileName = null;
    private boolean serverSyslogSwitch = true;
    private boolean syslogEx = false;
    private PropertyUtil props = null;
    public static LogService theOnlyService = null;

    private LogService() throws AdminLogException {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            this.props = new PropertyUtil("propdir", "WbemServices.properties", 1);
            this.fileName = this.props.getProp(LOG_SERVICE_FILE_NAME);
            this.dirName = this.props.getProp(LOG_SERVICE_FILE_DIR);
            string = this.props.getProp(LOG_SERVICE_FILE_SIZE);
            string2 = this.props.getProp(LOG_SERVICE_FILE_NUM);
            string3 = this.props.getProp(LOG_SERVICE_SYSLOG);
        }
        catch (PropertyUtilException propertyUtilException) {
            throw new AdminLogException(propertyUtilException.getMessage());
        }
        if (this.fileName == null) {
            this.fileName = LOG_FILE_NAME;
        }
        if (this.dirName == null) {
            this.dirName = LOG_FILE_DIR;
        }
        this.fileSize = string == null ? 5L : Long.parseLong(string);
        this.fileSize *= 0x100000L;
        this.numOfLogFiles = string2 == null ? 5 : Integer.parseInt(string2);
        if (string3 == null) {
            string3 = SYSLOG_SWITCH;
        }
        this.serverSyslogSwitch = string3.equalsIgnoreCase(SYSLOG_SWITCH);
        File file = new File(this.dirName);
        if (!file.exists() && !file.mkdirs()) {
            throw new AdminLogException("EXLOG_DIR", this.dirName);
        }
        this.logFileName = String.valueOf(this.dirName) + File.separator + this.fileName;
        this.initHash();
        this.fillSyslogHash();
        if (lock == null) {
            lock = new ReadersWriter();
        }
    }

    public void clearLog(String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        try {
            lock.writeLock();
            this.synchronizedClearLog(string);
        }
        finally {
            Object var3_2 = null;
            lock.writeUnlock();
        }
    }

    private void do_cascaded_backup() throws AdminLogException {
        File file;
        File file2;
        int n = 0;
        boolean bl = false;
        Collection collection = this.logFilesHash.values();
        Object[] objectArray = collection.toArray();
        n = 0;
        while (n < objectArray.length) {
            DataStore dataStore;
            Vector vector = (Vector)objectArray[n];
            if (vector != null && (dataStore = (DataStore)vector.elementAt(1)) != null) {
                dataStore.close();
            }
            ++n;
        }
        n = this.numOfLogFiles;
        while (n > 1) {
            file2 = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n));
            file = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n - 1));
            try {
                if (file.exists()) {
                    file.renameTo(file2);
                }
            }
            catch (SecurityException securityException) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            --n;
        }
        file2 = new File(this.logFileName);
        file = new File(String.valueOf(this.logFileName) + ".1");
        try {
            if (file2.exists()) {
                file2.renameTo(file);
            }
        }
        catch (SecurityException securityException) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        this.initHash();
        this.fillSyslogHash();
    }

    private boolean do_copy(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        byte[] byArray = new byte[8192];
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 8192);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        }
        catch (Exception exception) {
            return false;
        }
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void fillSyslogHash() {
        int n;
        boolean bl = false;
        this.syslogFilesHash.clear();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(CONF, "r");
        }
        catch (Exception exception) {
            this.syslogEx = true;
            bl = true;
            return;
        }
        String string = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            string = randomAccessFile.readLine();
            if (string == null) {
                System.out.println("Empty conf file");
            }
            n = 0;
            while (randomAccessFile.getFilePointer() < randomAccessFile.length()) {
                String string2;
                if (string == null || string.trim().length() == 0 || string.startsWith("#")) {
                    string = randomAccessFile.readLine();
                    continue;
                }
                int n2 = string.indexOf("/");
                if (n2 == -1) {
                    string = randomAccessFile.readLine();
                    continue;
                }
                int n3 = string.indexOf(", ", n2);
                if (n3 == -1) {
                    n3 = string.indexOf(" ", n2);
                }
                if (n3 == -1) {
                    n3 = string.indexOf("\n", n2);
                }
                if (n3 == -1) {
                    n3 = string.length();
                }
                if (!hashMap.containsValue(string2 = string.substring(n2, n3))) {
                    hashMap.put(String.valueOf(n), string2);
                    ++n;
                }
                string = randomAccessFile.readLine();
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        n = 0;
        while (n < hashMap.size()) {
            block20: {
                int n4;
                String string3;
                String string4 = (String)hashMap.get(String.valueOf(n));
                File file = null;
                try {
                    file = new File(string4);
                }
                catch (Exception exception) {
                    bl = true;
                    break block20;
                }
                if (!(file.isDirectory() || !file.isFile() || (string3 = string4.substring(0, n4 = string4.lastIndexOf("/"))) != null && string3.equalsIgnoreCase(DEV))) {
                    try {
                        file = new File(string3);
                    }
                    catch (Exception exception) {
                        bl = true;
                        break block20;
                    }
                    n4 = string4.lastIndexOf("/");
                    string3 = string4.substring(n4 + 1);
                    File[] fileArray = file.listFiles();
                    int n5 = 0;
                    while (fileArray != null && n5 < fileArray.length) {
                        String string5 = fileArray[n5].getName();
                        if (!fileArray[n5].isDirectory() && string5.startsWith(string3)) {
                            this.syslogFilesHash.put(fileArray[n5].toString(), fileArray[n5]);
                        }
                        ++n5;
                    }
                }
            }
            ++n;
        }
        this.syslogEx = bl && this.syslogFilesHash.size() == 0;
    }

    private void flush_dir(String string, int n) {
        File file = null;
        int n2 = 0;
        int n3 = this.numOfLogFiles;
        if (n == -1) {
            file = new File(string);
        } else if (n == 0) {
            file = new File(String.valueOf(string) + "." + String.valueOf(1));
        } else {
            file = new File(String.valueOf(string) + "." + String.valueOf(1));
            n3 = n - 1;
        }
        while (n2 <= n3) {
            try {
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {}
            file = new File(String.valueOf(string) + "." + String.valueOf(++n2));
        }
    }

    public String getCurrentLogFileName() {
        String string;
        try {
            lock.readLock();
            string = this.synchronizedGetCurrentLogFileName();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return string;
    }

    public static LogService getInstance() throws AdminLogException {
        if (theOnlyService == null) {
            theOnlyService = new LogService();
        }
        return theOnlyService;
    }

    public Vector getList(int n, Filterable filterable, long l, String string) throws LogFileNotFoundException, AdminLogException {
        Vector vector;
        try {
            lock.readLock();
            vector = this.synchronizedGetList(n, filterable, l, string);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return vector;
    }

    public String getLogFileDir() {
        String string;
        try {
            lock.readLock();
            string = this.synchronizedGetLogFileDir();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogFileName(String string) {
        String string2;
        block5: {
            String string3;
            block6: {
                String string4;
                block4: {
                    try {
                        Map.Entry entry;
                        Vector vector;
                        String string5;
                        lock.readLock();
                        if (this.syslogFilesHash.get(string) != null) {
                            string4 = string;
                            Object var4_5 = null;
                            break block4;
                        }
                        Set set = this.logFilesHash.entrySet();
                        Iterator iterator = set.iterator();
                        do {
                            if (iterator.hasNext()) continue;
                            string2 = null;
                            break block5;
                        } while (!(string5 = (String)(vector = (Vector)(entry = (Map.Entry)iterator.next()).getValue()).elementAt(0)).equalsIgnoreCase(string));
                        string3 = (String)entry.getKey();
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        lock.readUnlock();
                        throw throwable;
                    }
                }
                lock.readUnlock();
                return string4;
            }
            Object var4_6 = null;
            lock.readUnlock();
            return string3;
        }
        Object var4_7 = null;
        lock.readUnlock();
        return string2;
    }

    public long getLogFileSize(String string) throws AdminLogException {
        long l;
        try {
            lock.readLock();
            l = this.synchronizedGetLogFileSize(string);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogHeaderFormat(String string) throws AdminLogException {
        String string2;
        block6: {
            String string3;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        string3 = "";
                        Object var4_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    string2 = dataStore.getLogHeaderFormat();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return string3;
        }
        Object var4_8 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLogHeaderSize(String string) throws AdminLogException {
        long l;
        block6: {
            long l2;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = 0L;
                        Object var5_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    l = dataStore.getLogHeaderSize();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var5_8 = null;
        lock.readUnlock();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLogPercentageFull(String string) throws AdminLogException {
        int n;
        block8: {
            int n2;
            block7: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        n2 = 0;
                        Object var4_7 = null;
                        break block7;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    try {
                        double d = dataStore.getFileSize();
                        Double d2 = new Double(d / (double)this.fileSize * 100.0);
                        n = d2.intValue();
                        break block8;
                    }
                    catch (IOException iOException) {
                        throw new AdminLogException("EXLOG_IO", string);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return n2;
        }
        Object var4_8 = null;
        lock.readUnlock();
        return n;
    }

    public String getLogStorageName() {
        String string;
        try {
            lock.readLock();
            string = this.synchronizedGetLogStorageName();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogStorageName(String string) {
        String string2;
        block5: {
            String string3;
            block6: {
                String string4;
                block4: {
                    try {
                        String string5;
                        Map.Entry entry;
                        String string6;
                        lock.readLock();
                        if (this.syslogFilesHash.get(string) != null) {
                            string4 = string;
                            Object var4_5 = null;
                            break block4;
                        }
                        Set set = this.logFilesHash.entrySet();
                        Iterator iterator = set.iterator();
                        do {
                            if (iterator.hasNext()) continue;
                            string2 = null;
                            break block5;
                        } while (!(string6 = (String)(entry = (Map.Entry)iterator.next()).getKey()).equalsIgnoreCase(string));
                        Vector vector = (Vector)entry.getValue();
                        string3 = string5 = (String)vector.elementAt(0);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        lock.readUnlock();
                        throw throwable;
                    }
                }
                lock.readUnlock();
                return string4;
            }
            Object var4_6 = null;
            lock.readUnlock();
            return string3;
        }
        Object var4_7 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogType(String string) throws AdminLogException {
        String string2;
        block6: {
            String string3;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        if (!file.exists()) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        string3 = TYPE_SYSLOG;
                        Object var4_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    string2 = TYPE_WBEMLOG;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return string3;
        }
        Object var4_8 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogVersion(String string) throws AdminLogException {
        String string2;
        block6: {
            String string3;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        if (!file.exists()) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        string3 = "N/A";
                        Object var4_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    string2 = dataStore.getVersion();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return string3;
        }
        Object var4_8 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaxLogFileSize(String string) throws AdminLogException {
        long l;
        block6: {
            long l2;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = 0L;
                        Object var5_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    l = this.fileSize;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var5_8 = null;
        lock.readUnlock();
        return l;
    }

    public int getNumLogFiles() {
        int n;
        try {
            lock.readLock();
            n = this.synchronizedGetNumLogFiles();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return n;
    }

    public long getNumRecords(String string) throws AdminLogException {
        long l;
        try {
            lock.readLock();
            l = this.synchronizedGetNumRecords(string);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRecordHeaderFormat(String string) throws AdminLogException {
        String string2;
        block6: {
            String string3;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        string3 = null;
                        Object var4_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    string2 = dataStore.getRecordHeaderFormat();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return string3;
        }
        Object var4_8 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getRecordHeaderSize(String string) throws AdminLogException {
        long l;
        block6: {
            long l2;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = 0L;
                        Object var5_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    l = dataStore.getRecordHeaderSize();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var5_8 = null;
        lock.readUnlock();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStartDate(String string) throws AdminLogException {
        long l;
        block10: {
            long l2;
            block9: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = -1L;
                        Object var5_7 = null;
                        break block9;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    String string2 = (String)vector.elementAt(0);
                    if (string2 == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    File file = new File(string2);
                    try {
                        if (!file.exists()) {
                            throw new LogFileNotFoundException("EXLOG_DEL", string);
                        }
                    }
                    catch (Exception exception) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    l = dataStore.getFileDate();
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var5_8 = null;
        lock.readUnlock();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getSyslogRecords(String string) throws AdminLogException {
        String[] stringArray;
        block9: {
            String[] stringArray2;
            block8: {
                try {
                    lock.readLock();
                    this.fillSyslogHash();
                    if (this.syslogEx && this.syslogFilesHash.size() == 0) {
                        throw new AdminLogException("EXLOG_SYSLOGEX");
                    }
                    if (string != null) {
                        String[] stringArray3;
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new AdminLogException("EXLOG_FNF", string);
                        if (!file.exists()) {
                            throw new AdminLogException("EXLOG_FNF", string);
                        }
                        ArrayList<String> arrayList = new ArrayList<String>();
                        try {
                            stringArray3 = new FileInputStream(file);
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)stringArray3);
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            while (bufferedReader.ready()) {
                                String string2 = bufferedReader.readLine();
                                arrayList.add(string2);
                            }
                        }
                        catch (Exception exception) {
                            throw new AdminLogException(exception.getMessage());
                        }
                        stringArray3 = new String[arrayList.size()];
                        arrayList.toArray(stringArray3);
                        stringArray2 = stringArray3;
                        Object var4_11 = null;
                        break block8;
                    }
                    stringArray = null;
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_13 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return stringArray2;
        }
        Object var4_12 = null;
        lock.readUnlock();
        return stringArray;
    }

    public String getSyslogSwitch() {
        String string;
        try {
            lock.readLock();
            string = this.synchronizedGetSyslogSwitch();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTimeOfLastChange(String string) throws AdminLogException {
        long l;
        block6: {
            long l2;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = 0L;
                        Object var5_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    l = dataStore.getTimeOfLastChange();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var5_8 = null;
        lock.readUnlock();
        return l;
    }

    private void initHash() throws AdminLogException {
        Comparable<File> comparable;
        Vector<Object> vector = new Vector<Object>();
        this.logFilesHash.clear();
        try {
            this.storage = new DataStore(this.logFileName);
        }
        catch (EOFException eOFException) {
            comparable = new File(this.logFileName);
            try {
                if (comparable.exists()) {
                    comparable.renameTo(new File(String.valueOf(this.logFileName) + ".corrupted"));
                }
                this.storage = new DataStore(this.logFileName);
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", this.logFileName);
        }
        long l = this.storage.getFileDate();
        if (l <= 0L) {
            throw new AdminLogException("EXLOG_COR", this.logFileName);
        }
        comparable = new Date(l);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1);
        simpleDateFormat.applyPattern("MM/dd/yyyy.HH:mm:ss");
        String string = simpleDateFormat.format((Date)comparable);
        if (string == null) {
            string = String.valueOf(l);
        }
        vector.addElement(this.logFileName);
        vector.addElement(this.storage);
        this.currentViewerFileName = "Log." + string;
        this.logFilesHash.put(this.currentViewerFileName, vector.clone());
        vector.removeAllElements();
        int n = 0;
        DataStore dataStore = null;
        n = 1;
        while (n <= this.numOfLogFiles) {
            block21: {
                block20: {
                    File file = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                    try {
                        if (file.exists()) {
                            try {
                                dataStore = new DataStore(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                            }
                            catch (EOFException eOFException) {
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception exception) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    if (dataStore == null) break block20;
                    l = dataStore.getFileDate();
                    if (l <= 0L) break block21;
                    comparable = new Date(l);
                    simpleDateFormat.applyPattern("MM/dd/yyyy.HH:mm:ss");
                    string = simpleDateFormat.format((Date)comparable);
                    if (string == null) {
                        string = String.valueOf(l);
                    }
                    vector.addElement(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                    vector.addElement(dataStore);
                    this.logFilesHash.put("Log." + string, vector.clone());
                }
                dataStore = null;
                vector.removeAllElements();
            }
            ++n;
        }
    }

    public String[] listLogFiles() throws AdminLogException {
        String[] stringArray;
        try {
            lock.readLock();
            stringArray = this.synchronizedListLogFiles();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return stringArray;
    }

    public String[] listSyslogFiles() throws AdminLogException {
        String[] stringArray;
        try {
            lock.readLock();
            this.fillSyslogHash();
            if (this.syslogEx && this.syslogFilesHash.size() == 0) {
                throw new AdminLogException("EXLOG_SYSLOGEX");
            }
            String[] stringArray2 = new String[this.syslogFilesHash.size()];
            Set set = this.syslogFilesHash.keySet();
            set.toArray(stringArray2);
            stringArray = stringArray2;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return stringArray;
    }

    public LogRecord readRecord(long l, int n, String string) throws AdminLogException {
        LogRecord logRecord;
        try {
            lock.readLock();
            logRecord = this.synchronizedReadRecord(l, n, string);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return logRecord;
    }

    public void setProperties(int n, int n2, String string, String string2) throws AdminLogException {
        try {
            lock.writeLock();
            this.synchronizedSetProperties(n, n2, string, string2);
        }
        finally {
            Object var6_5 = null;
            lock.writeUnlock();
        }
    }

    private void synchronizedClearLog(String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if (!this.logFilesHash.containsKey(string)) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        Vector vector = (Vector)this.logFilesHash.get(string);
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new AdminLogException("EXLOG_ACT", (Object)string2, string);
        }
        if (string2.compareTo(this.logFileName) == 0) {
            this.do_cascaded_backup();
        } else {
            try {
                File file = new File(string2);
                if (file.exists()) {
                    vector = (Vector)this.logFilesHash.get(string);
                    if (vector == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore != null) {
                        dataStore.close();
                    }
                    this.logFilesHash.remove(string);
                    file.delete();
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    private String synchronizedGetCurrentLogFileName() {
        return this.currentViewerFileName;
    }

    private Vector synchronizedGetList(int n, Filterable filterable, long l, String string) throws LogFileNotFoundException, AdminLogException {
        Vector vector;
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        Buffer buffer = new Buffer();
        FilterThread filterThread = new FilterThread(buffer, filterable, n);
        ReadThread readThread = new ReadThread(buffer, l, n, filterable.getSortDirection(), dataStore);
        Thread thread = new Thread(filterThread);
        Thread thread2 = new Thread(readThread);
        thread2.start();
        thread.start();
        try {
            thread2.join();
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
        AdminLogException adminLogException = buffer.getException();
        if (adminLogException != null && (adminLogException instanceof CorruptDataException || adminLogException instanceof InvalidRecordException)) {
            String string3 = dataStore.getFileName();
            File file2 = new File(string3);
            try {
                if (file2.exists()) {
                    file2.renameTo(new File(String.valueOf(dataStore.getFileName()) + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            this.fillSyslogHash();
            throw new AdminLogException("EXLOG_COR", string);
        }
        return buffer.getVect();
    }

    private String synchronizedGetLogFileDir() {
        return this.dirName;
    }

    private long synchronizedGetLogFileSize(String string) throws AdminLogException {
        Vector vector;
        if (this.fileName == null) {
            this.fileName = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            File file = (File)this.syslogFilesHash.get(string);
            if (file != null) {
                return file.length();
            }
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        try {
            return dataStore.getFileSize();
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", string);
        }
    }

    private String synchronizedGetLogStorageName() {
        return this.fileName;
    }

    private int synchronizedGetNumLogFiles() {
        return this.numOfLogFiles;
    }

    private long synchronizedGetNumRecords(String string) throws AdminLogException {
        Vector vector;
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            File file = (File)this.syslogFilesHash.get(string);
            if (file != null) {
                try {
                    lock.readUnlock();
                    String[] stringArray = this.getSyslogRecords(string);
                    lock.readLock();
                    if (stringArray != null) {
                        return stringArray.length;
                    }
                    return 0L;
                }
                catch (Exception exception) {
                    return 0L;
                }
            }
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        return dataStore.getNumRecords();
    }

    private String synchronizedGetSyslogSwitch() {
        if (this.serverSyslogSwitch) {
            return SYSLOG_SWITCH;
        }
        return "off";
    }

    private String[] synchronizedListLogFiles() {
        String[] stringArray = new String[this.logFilesHash.size()];
        Set set = this.logFilesHash.keySet();
        Object[] objectArray = set.toArray();
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        return stringArray;
    }

    private LogRecord synchronizedReadRecord(long l, int n, String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        DataRecord dataRecord = null;
        Vector vector = (Vector)this.logFilesHash.get(string);
        if (vector == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        try {
            dataRecord = dataStore.readSpecificRecordAsStr(l, n);
        }
        catch (CorruptDataException corruptDataException) {
            String string3 = dataStore.getFileName();
            File file2 = new File(string3);
            try {
                if (file2.exists()) {
                    file2.renameTo(new File(String.valueOf(dataStore.getFileName()) + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_COR", string);
        }
        catch (InvalidRecordException invalidRecordException) {
            throw new LogRecordNotFoundException(invalidRecordException.getMessage());
        }
        catch (EOFException eOFException) {
            String string4 = dataStore.getFileName();
            File file3 = new File(string4);
            try {
                if (file3.exists()) {
                    file3.renameTo(new File(String.valueOf(dataStore.getFileName()) + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_IO", string);
        }
        catch (IOException iOException) {
            String string5 = dataStore.getFileName();
            File file4 = new File(string5);
            try {
                if (file4.exists()) {
                    file4.renameTo(new File(String.valueOf(dataStore.getFileName()) + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_IO", string);
        }
        if (dataRecord == null) {
            String string6 = dataStore.getFileName();
            File file5 = new File(string6);
            try {
                if (file5.exists()) {
                    file5.renameTo(new File(String.valueOf(dataStore.getFileName()) + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_COR", string);
        }
        LogRecord logRecord = (LogRecord)dataRecord.getRecord();
        logRecord.setRecordId(dataRecord.getOffset());
        logRecord.setHashCode(dataRecord.getHash());
        return logRecord;
    }

    /*
     * Unable to fully structure code
     */
    private void synchronizedSetProperties(int var1_1, int var2_2, String var3_3, String var4_4) throws AdminLogException {
        var5_5 = false;
        if (var3_3 == null) {
            var3_3 = "on";
        } else if (var3_3.equalsIgnoreCase("on")) {
            this.serverSyslogSwitch = true;
        } else if (var3_3.equalsIgnoreCase("off")) {
            this.serverSyslogSwitch = false;
        } else {
            var3_3 = "on";
        }
        if (var4_4 != null) {
            var6_6 = new File(var4_4);
            if (!var6_6.exists() && !var6_6.mkdirs()) {
                var5_5 = true;
            }
            if (var6_6.isDirectory()) {
                var10_8 = this.logFilesHash.values();
                var11_9 = var10_8.toArray();
                var12_10 = 0;
                while (var12_10 < var11_9.length) {
                    var7_11 = (Vector)var11_9[var12_10];
                    if (var7_11 != null && (var8_12 = (DataStore)var7_11.elementAt(1)) != null) {
                        var8_12.close();
                    }
                    ++var12_10;
                }
                var13_13 = 1;
                while (var13_13 <= this.numOfLogFiles) {
                    var14_14 = String.valueOf(var4_4) + File.separator + this.fileName;
                    var15_15 = this.logFileName;
                    var16_16 = new File(String.valueOf(var14_14) + "." + String.valueOf(var13_13));
                    var17_17 = new File(String.valueOf(var15_15) + "." + String.valueOf(var13_13));
                    try {
                        if (var17_17.exists() && !var17_17.renameTo(var16_16) && !this.do_copy(var17_17, var16_16)) {
                            this.flush_dir((String)var14_14, var13_13);
                            var5_5 = true;
                        }
                    }
                    catch (SecurityException v0) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    ++var13_13;
                }
                if (!var5_5) {
                    var14_14 = new File(this.logFileName);
                    var15_15 = String.valueOf(var4_4) + File.separator + this.fileName;
                    var16_16 = new File(var15_15);
                    try {
                        if (!var14_14.exists()) ** GOTO lbl63
                        if (!var14_14.renameTo(var16_16)) {
                            if (!this.do_copy((File)var14_14, var16_16)) {
                                this.flush_dir(var15_15, 0);
                                var5_5 = true;
                            }
                            this.flush_dir(this.logFileName, -1);
                            this.logFileName = String.valueOf(var4_4) + File.separator + this.fileName;
                            this.dirName = var4_4;
                        }
                        this.logFileName = String.valueOf(var4_4) + File.separator + this.fileName;
                        this.dirName = var4_4;
                    }
                    catch (SecurityException v1) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                }
            } else {
                var5_5 = true;
            }
        }
lbl63:
        // 8 sources

        if (var1_1 > 0) {
            this.fileSize = var1_1 * 0x100000;
        }
        if (var2_2 > 0) {
            this.numOfLogFiles = var2_2;
        }
        if (var4_4 != null) {
            this.initHash();
            this.fillSyslogHash();
        }
        if (var5_5) {
            throw new AdminLogException("EXLOG_PROP_DIR", (Object)this.dirName, var4_4);
        }
        try {
            this.props.putProp("wbem.logging.file.size", String.valueOf(var1_1));
            this.props.putProp("wbem.logging.file.num", String.valueOf(var2_2));
            this.props.putProp("wbem.logging.file.dir", var4_4);
            this.props.putProp("wbem.logging.syslog", var3_3);
            this.props.saveProps("Wbem Services properties file");
        }
        catch (PropertyUtilException var6_7) {
            throw new AdminLogException(var6_7.getMessage());
        }
    }

    public void writeRecord(LogRecord logRecord, boolean bl) throws AdminLogException {
        try {
            lock.writeLock();
            try {
                this.currentFileSize = this.storage.writeRecord(logRecord.formatRecord(), this.fileSize);
            }
            catch (CorruptDataException corruptDataException) {
                File file = new File(this.logFileName);
                try {
                    if (file.exists()) {
                        file.renameTo(new File(String.valueOf(this.logFileName) + ".corrupted"));
                    }
                    this.storage = new DataStore(this.logFileName);
                }
                catch (Exception exception) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
                this.initHash();
                throw new AdminLogException("EXLOG_COR", this.logFileName);
            }
            catch (InvalidRecordException invalidRecordException) {
            }
            catch (IOException iOException) {
                File file = new File(this.logFileName);
                try {
                    if (file.exists()) {
                        file.renameTo(new File(String.valueOf(this.logFileName) + ".corrupted"));
                    }
                    this.storage = new DataStore(this.logFileName);
                }
                catch (Exception exception) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
                this.initHash();
                throw new AdminLogException("EXLOG_IO", this.logFileName);
            }
            if (this.currentFileSize < 0L) {
                try {
                    this.synchronizedClearLog(this.currentViewerFileName);
                }
                catch (AdminLogException adminLogException) {
                    throw new AdminLogException("EXLOG_WR", this.logFileName);
                }
                try {
                    this.currentFileSize = this.storage.writeRecord(logRecord.formatRecord(), this.fileSize);
                }
                catch (InvalidRecordException invalidRecordException) {
                    throw new AdminLogException("EXLOG_IO", this.logFileName);
                }
                catch (IOException iOException) {
                    throw new AdminLogException("EXLOG_IO", this.logFileName);
                }
            }
            if (this.currentFileSize == this.fileSize) {
                try {
                    this.synchronizedClearLog(this.currentViewerFileName);
                }
                catch (AdminLogException adminLogException) {
                    throw new AdminLogException("EXLOG_WR", this.logFileName);
                }
            }
            if (bl && this.serverSyslogSwitch) {
                int n;
                String string = logRecord.getDetailedMesg(true);
                if (string == null) {
                    string = logRecord.getSummaryMesg(true);
                }
                if ((n = logRecord.getSeverity()) == -1) {
                    n = 0;
                }
                try {
                    LogSvcNative.writeToSyslog(string, IDENTITY, n);
                }
                catch (AdminLogException adminLogException) {
                }
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            lock.writeUnlock();
            throw throwable;
        }
        lock.writeUnlock();
    }
}

