/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.ProviderCIMOMHandle;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.AndQueryExp;
import com.sun.wbem.query.AttributeExp;
import com.sun.wbem.query.BinaryRelQueryExp;
import com.sun.wbem.query.DateTimeExp;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.NotQueryExp;
import com.sun.wbem.query.OrQueryExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.StringValueExp;
import com.sun.wbem.query.ValueExp;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_LogEntry
implements InstanceProvider,
Authorizable {
    public static final String MARKER = "@%#";
    public static final String LOG_CCN = "LogCreationClassName";
    public static final String LOG_NAME = "LogName";
    public static final String RECORD_ID = "RecordID";
    public static final String RECORD_CCN = "CreationClassName";
    public static final String RECORD_TIME = "MessageTimestamp";
    public static final String RECORD_FORMAT = "DataFormat";
    public static final String RECORD_DATA = "RecordData";
    public static final String RECORD_CATEGORY = "Category";
    public static final String RECORD_SEVERITY = "Severity";
    public static final String RECORD_SOURCE = "Source";
    public static final String RECORD_USER = "UserName";
    public static final String RECORD_CLIENT = "ClientMachineName";
    public static final String RECORD_SERVER = "ServerMachineName";
    public static final String RECORD_SUMMARY = "SummaryMessage";
    public static final String RECORD_DETAIL = "DetailedMessage";
    public static final String RECORD_SYSLOG = "SyslogFlag";
    private ProviderUtility provUtil = null;
    private LogService logsvc = null;
    private ProviderCIMOMHandle cimomhandle = null;

    private LogRecord cimToLog(CIMInstance cIMInstance, String string) throws CIMException {
        LogRecord logRecord = new LogRecord();
        logRecord.setCategory((Integer)cIMInstance.getProperty(RECORD_CATEGORY).getValue().getValue());
        logRecord.setSeverity((Integer)cIMInstance.getProperty(RECORD_SEVERITY).getValue().getValue());
        logRecord.setAppName((String)cIMInstance.getProperty(RECORD_SOURCE).getValue().getValue());
        logRecord.setUserName(this.provUtil.getClientUserName());
        String string2 = this.cimomhandle.getCurrentClientHost();
        String string3 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            string3 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            string3 = string2;
        }
        if (string3 == null) {
            string3 = string2;
        }
        logRecord.setClientHostName(string3);
        try {
            logRecord.setAgentHostName(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            logRecord.setAgentHostName((String)cIMInstance.getProperty(RECORD_SERVER).getValue().getValue());
        }
        logRecord.setSummaryMesgId((String)cIMInstance.getProperty(RECORD_SUMMARY).getValue().getValue());
        logRecord.setDetailedMesgId((String)cIMInstance.getProperty(RECORD_DETAIL).getValue().getValue());
        logRecord.addData((String)cIMInstance.getProperty(RECORD_DATA).getValue().getValue());
        boolean bl = (Boolean)cIMInstance.getProperty(RECORD_SYSLOG).getValue().getValue();
        logRecord.setSyslog(bl);
        return logRecord;
    }

    public void cleanup() throws CIMException {
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.provUtil.checkAuthenticated();
        LogRecord logRecord = new LogRecord();
        String string = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
                string = this.logsvc.getCurrentLogFileName();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        logRecord = this.cimToLog(cIMInstance, string);
        boolean bl = (Boolean)cIMInstance.getProperty(RECORD_SYSLOG).getValue().getValue();
        try {
            this.logsvc.writeRecord(logRecord, bl);
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        long l = logRecord.getRecordId();
        int n = (int)logRecord.getHashCode();
        String string2 = String.valueOf(l);
        String string3 = String.valueOf(n);
        String string4 = String.valueOf(string2) + MARKER + string3;
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_LogEntry");
        cIMObjectPath2.setNameSpace("root/cimv2");
        cIMObjectPath2.addKey(RECORD_ID, new CIMValue((Object)string4));
        cIMObjectPath2.addKey(LOG_NAME, new CIMValue((Object)logRecord.getFileName()));
        cIMObjectPath2.addKey(RECORD_TIME, new CIMValue((Object)new CIMDateTime(logRecord.getDate())));
        cIMObjectPath2.addKey(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
        cIMObjectPath2.addKey(RECORD_CCN, new CIMValue((Object)"Solaris_LogEntry"));
        return cIMObjectPath2;
    }

    public synchronized void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Object object;
        int n;
        String string;
        this.provUtil.checkAuthenticated();
        Vector<String> vector = new Vector<String>();
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Vector<Vector> vector2 = new Vector<Vector>();
        try {
            LogFilter logFilter = new LogFilter();
            int n2 = 0;
            long l = 0L;
            string = "";
            String[] stringArray = this.logsvc.listLogFiles();
            int n3 = 0;
            while (n3 < stringArray.length) {
                n2 = (int)((long)n2 + this.logsvc.getNumRecords(stringArray[n3]));
                ++n3;
            }
            n = 0;
            while (n < stringArray.length) {
                object = this.logsvc.getList(n2, logFilter, l, stringArray[n]);
                if (object != null) {
                    ((Vector)object).addElement(stringArray[n]);
                    vector2.addElement((Vector)object);
                }
                ++n;
            }
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        int n4 = 0;
        while (n4 < vector2.size()) {
            Vector vector3 = (Vector)vector2.elementAt(n4);
            int n5 = 0;
            while (n5 < vector3.size() - 1) {
                LogRecord logRecord = (LogRecord)vector3.elementAt(n5);
                string = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                long l = logRecord.getRecordId();
                n = (int)logRecord.getHashCode();
                object = String.valueOf(l);
                String string2 = String.valueOf(n);
                String string3 = String.valueOf(object) + MARKER + string2;
                string.addKey(RECORD_ID, new CIMValue((Object)string3));
                string.addKey(RECORD_TIME, new CIMValue((Object)new CIMDateTime(logRecord.getDate())));
                string.addKey(LOG_NAME, new CIMValue(vector3.elementAt(vector3.size() - 1)));
                string.addKey(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
                string.addKey(RECORD_CCN, new CIMValue((Object)"Solaris_LogEntry"));
                vector.addElement(string);
                ++n5;
            }
            ++n4;
        }
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        this.provUtil.checkAuthenticated();
        Vector vector = new Vector();
        Vector<CIMInstance> vector2 = new Vector<CIMInstance>();
        CIMInstance cIMInstance = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Vector<Vector> vector3 = new Vector<Vector>();
        try {
            LogFilter logFilter = new LogFilter();
            int n = 0;
            long l = 0L;
            String string = "";
            String[] stringArray = this.logsvc.listLogFiles();
            int n2 = 0;
            while (n2 < stringArray.length) {
                n = (int)((long)n + this.logsvc.getNumRecords(stringArray[n2]));
                ++n2;
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                Vector vector4 = this.logsvc.getList(n, logFilter, l, stringArray[n3]);
                if (vector4 != null) {
                    vector4.addElement(stringArray[n3]);
                    vector3.addElement(vector4);
                }
                ++n3;
            }
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        int n = 0;
        while (n < vector3.size()) {
            Vector vector5 = (Vector)vector3.elementAt(n);
            int n4 = 0;
            while (n4 < vector5.size() - 1) {
                LogRecord logRecord = (LogRecord)vector5.elementAt(n4);
                cIMInstance = this.logToCim(cIMClass, logRecord, (String)vector5.elementAt(vector5.size() - 1));
                vector2.addElement(cIMInstance);
                ++n4;
            }
            ++n;
        }
        return vector2;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkAuthenticated();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            String string2 = null;
            try {
                string2 = (String)this.getAttributeValueInQuery(queryExp, "FileName");
            }
            catch (Exception exception) {
                string2 = null;
            }
            Vector vector2 = new Vector();
            vector2 = string2 != null ? this.myEnum(cIMObjectPath, cIMClass, string2) : this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
        return vector;
    }

    private Object getAttributeValueInQuery(QueryExp queryExp, String string) throws Exception {
        if (queryExp instanceof AndQueryExp) {
            QueryExp queryExp2 = ((AndQueryExp)queryExp).getLeftExp();
            QueryExp queryExp3 = ((AndQueryExp)queryExp).getRightExp();
            Object object = this.getAttributeValueInQuery(queryExp2, string);
            if (object != null) {
                return object;
            }
            object = this.getAttributeValueInQuery(queryExp3, string);
            return object;
        }
        if (queryExp instanceof OrQueryExp) {
            QueryExp queryExp4 = ((OrQueryExp)queryExp).getLeftExp();
            QueryExp queryExp5 = ((OrQueryExp)queryExp).getRightExp();
            Object object = this.getAttributeValueInQuery(queryExp4, string);
            if (object != null) {
                return object;
            }
            object = this.getAttributeValueInQuery(queryExp5, string);
            return object;
        }
        if (queryExp instanceof NotQueryExp) {
            throw new Exception();
        }
        if (queryExp instanceof BinaryRelQueryExp) {
            ValueExp valueExp = ((BinaryRelQueryExp)queryExp).getLeftValue();
            ValueExp valueExp2 = ((BinaryRelQueryExp)queryExp).getRightValue();
            if (valueExp instanceof AttributeExp) {
                String string2 = ((AttributeExp)valueExp).getAttributeName();
                if (string2.equalsIgnoreCase(string)) {
                    if (valueExp2 instanceof StringValueExp) {
                        return ((StringValueExp)valueExp2).getValue();
                    }
                    if (valueExp2 instanceof DateTimeExp) {
                        return ((DateTimeExp)valueExp2).getValue();
                    }
                    return null;
                }
                return null;
            }
            if (valueExp2 instanceof AttributeExp) {
                String string3 = ((AttributeExp)valueExp2).getAttributeName();
                if (string3.equalsIgnoreCase(string)) {
                    if (valueExp instanceof StringValueExp) {
                        return ((StringValueExp)valueExp).getValue();
                    }
                    if (valueExp instanceof DateTimeExp) {
                        return ((DateTimeExp)valueExp).getValue();
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        String string;
        Object object;
        this.provUtil.checkAuthenticated();
        long l = 0L;
        int n = 0;
        String string2 = "";
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (object.getName().equalsIgnoreCase(RECORD_ID)) {
                string = (String)object.getValue().getValue();
                int n2 = string.indexOf(MARKER);
                String string3 = string.substring(0, n2);
                String string4 = string.substring(n2 + MARKER.length());
                l = Long.parseLong(string3);
                n = Integer.parseInt(string4);
            }
            if (!object.getName().equalsIgnoreCase(LOG_NAME)) continue;
            string2 = (String)object.getValue().getValue();
        }
        object = null;
        try {
            object = this.logsvc.readRecord(l, n, string2);
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        string = this.logToCim(cIMClass, (LogRecord)object, string2);
        return string;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, "Logging Service");
    }

    private CIMInstance logToCim(CIMClass cIMClass, LogRecord logRecord, String string) throws CIMException {
        CIMInstance cIMInstance = cIMClass.newInstance();
        long l = logRecord.getRecordId();
        int n = (int)logRecord.getHashCode();
        String string2 = String.valueOf(l);
        String string3 = String.valueOf(n);
        String string4 = String.valueOf(string2) + MARKER + string3;
        cIMInstance.setProperty(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
        cIMInstance.setProperty(RECORD_CCN, new CIMValue((Object)"Solaris_LogEntry"));
        cIMInstance.setProperty(RECORD_ID, new CIMValue((Object)string4));
        cIMInstance.setProperty(LOG_NAME, new CIMValue((Object)string));
        cIMInstance.setProperty(RECORD_TIME, new CIMValue((Object)new CIMDateTime(logRecord.getDate())));
        cIMInstance.setProperty(RECORD_CATEGORY, new CIMValue((Object)new Integer(logRecord.getCategory())));
        cIMInstance.setProperty(RECORD_SEVERITY, new CIMValue((Object)new Integer(logRecord.getSeverity())));
        cIMInstance.setProperty(RECORD_SOURCE, new CIMValue((Object)logRecord.getAppName()));
        cIMInstance.setProperty(RECORD_USER, new CIMValue((Object)logRecord.getUserName()));
        cIMInstance.setProperty(RECORD_CLIENT, new CIMValue((Object)logRecord.getClientHostName()));
        cIMInstance.setProperty(RECORD_SERVER, new CIMValue((Object)logRecord.getAgentHostName()));
        cIMInstance.setProperty(RECORD_SUMMARY, new CIMValue((Object)logRecord.getSummaryMesg(true)));
        cIMInstance.setProperty(RECORD_DETAIL, new CIMValue((Object)logRecord.getDetailedMesg(true)));
        cIMInstance.setProperty(RECORD_DATA, new CIMValue((Object)logRecord.getData()));
        cIMInstance.setProperty(RECORD_SYSLOG, new CIMValue((Object)new Boolean(logRecord.getSyslog())));
        return cIMInstance;
    }

    private Vector myEnum(CIMObjectPath cIMObjectPath, CIMClass cIMClass, String string) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        CIMInstance cIMInstance = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Vector vector2 = new Vector();
        try {
            LogFilter logFilter = new LogFilter();
            int n = 0;
            long l = 0L;
            n = (int)((long)n + this.logsvc.getNumRecords(string));
            vector2 = this.logsvc.getList(n, logFilter, l, string);
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        int n = 0;
        while (vector2 != null && n < vector2.size()) {
            LogRecord logRecord = (LogRecord)vector2.elementAt(n);
            cIMInstance = this.logToCim(cIMClass, logRecord, string);
            vector.addElement(cIMInstance);
            ++n;
        }
        return vector;
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

