/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.osserver;

import com.sun.wbem.solarisprovider.osserver.BootparamsObject;
import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class BootparamsTable {
    private String table = new String("bootparams");
    private String clientNameCol = "clientname";
    private String identifiersCol = "identifiers";
    private String scope;

    public BootparamsTable(String string) {
        this.scope = string;
    }

    public void addBootparamsEntry(BootparamsObject bootparamsObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = bootparamsObject.getClientName();
        String string2 = bootparamsObject.getIDBoottype();
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0) {
            throw new DBTableException("EXM_BOOTPENTRY_BAD", string, string2);
        }
        try {
            directoryTable = this.openBootparamsTable();
            directoryRow = this.checkBootparamsEntry(directoryTable, bootparamsObject);
            if (directoryRow != null) {
                BootparamsObject bootparamsObject2 = this.makeBootparamsObject(directoryTable, directoryRow);
                directoryTable.close();
                if (bootparamsObject2.equals(bootparamsObject)) {
                    return;
                }
                throw new DBTableException("EXM_ADD_EXIST", this.table);
            }
            directoryRow = this.makeRow(directoryTable, bootparamsObject);
            directoryTable.addRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    private DirectoryRow checkBootparamsEntry(DirectoryTable directoryTable, BootparamsObject bootparamsObject) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        String string = bootparamsObject.getClientName();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.clientNameCol), string);
        directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
        return directoryRow;
    }

    public void deleteBootparamsEntry(BootparamsObject bootparamsObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = bootparamsObject.getClientName();
        String string2 = bootparamsObject.getIDBoottype();
        if (string == null || string.trim().length() == 0) {
            throw new DBTableException("EXM_DEL_INV", this.table);
        }
        try {
            directoryTable = this.openBootparamsTable();
            directoryRow = this.checkBootparamsEntry(directoryTable, bootparamsObject);
            if (directoryRow == null) {
                directoryTable.close();
                return;
            }
            directoryTable.deleteRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    public void deleteBootparamsEntry(String string) throws DBTableException, DirectoryTableException {
        BootparamsObject bootparamsObject = new BootparamsObject(string, "", "");
        this.deleteBootparamsEntry(bootparamsObject);
    }

    public BootparamsObject getBootparamsEntry(BootparamsObject bootparamsObject) throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        BootparamsObject bootparamsObject2 = null;
        try {
            directoryTable = this.openBootparamsTable();
            directoryRow = this.checkBootparamsEntry(directoryTable, bootparamsObject);
            if (directoryRow != null) {
                bootparamsObject2 = this.makeBootparamsObject(directoryTable, directoryRow);
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return bootparamsObject2;
    }

    public BootparamsObject getBootparamsEntry(String string) throws DirectoryTableException {
        BootparamsObject bootparamsObject = new BootparamsObject(string, "", "");
        return this.getBootparamsEntry(bootparamsObject);
    }

    private String getInput(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            return new String("");
        }
    }

    public Vector list() throws DirectoryTableException {
        Vector<BootparamsObject> vector = new Vector<BootparamsObject>();
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        try {
            directoryTable = this.openBootparamsTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                vector.addElement(this.makeBootparamsObject(directoryTable, directoryRow));
                directoryRow = directoryTable.getNextRow();
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return vector;
    }

    public static void main(String[] stringArray) {
        BootparamsTable bootparamsTable = new BootparamsTable("File://poseidon");
        boolean bl = false;
        while (!bl) {
            System.out.println("1 - Add bootparams entry");
            System.out.println("2 - Delete bootparams entry");
            System.out.println("3 - List bootparams table");
            System.out.println("9 - Exit");
            System.out.print("Enter option: ");
            try {
                byte[] byArray = new byte[100];
                char c = (char)System.in.read(byArray);
                System.out.println("");
                if (c != '\u0002') {
                    bl = true;
                    continue;
                }
                char c2 = (char)byArray[0];
                switch (c2) {
                    case '1': {
                        bootparamsTable.testAdd();
                        break;
                    }
                    case '2': {
                        bootparamsTable.testDelete();
                        break;
                    }
                    case '3': {
                        bootparamsTable.testList();
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
            System.out.println("");
        }
    }

    private BootparamsObject makeBootparamsObject(DirectoryTable directoryTable, DirectoryRow directoryRow) throws DirectoryTableException {
        BootparamsObject bootparamsObject = null;
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.clientNameCol));
        String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.identifiersCol));
        String string3 = "";
        bootparamsObject = new BootparamsObject(string, string2, string3);
        return bootparamsObject;
    }

    private DirectoryRow makeRow(DirectoryTable directoryTable, BootparamsObject bootparamsObject) throws DirectoryTableException {
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
        String string = bootparamsObject.getClientName();
        if (string != null && string.trim().length() != 0) {
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.clientNameCol), string);
        }
        if ((string = bootparamsObject.getIdentifiers()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.identifiersCol), string);
        }
        return directoryRow;
    }

    public void modifyBootparamsEntry(BootparamsObject bootparamsObject, BootparamsObject bootparamsObject2) throws DBTableException, DirectoryTableException {
        this.deleteBootparamsEntry(bootparamsObject);
        this.addBootparamsEntry(bootparamsObject2);
    }

    public void modifyBootparamsEntry(String string, BootparamsObject bootparamsObject) throws DBTableException, DirectoryTableException {
        this.deleteBootparamsEntry(string);
        this.addBootparamsEntry(bootparamsObject);
    }

    private DirectoryTable openBootparamsTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(this.table);
            return directoryTable;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            directoryTable.create(this.table);
            return directoryTable;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    private void testAdd() throws Exception {
        System.out.println("****Start testAdd****");
        String string = this.getInput("Client Name: ");
        String string2 = this.getInput("Identifiers (space separated): ");
        String string3 = this.getInput("Comment: ");
        BootparamsObject bootparamsObject = new BootparamsObject(string, string2, string3);
        this.addBootparamsEntry(bootparamsObject);
        System.out.println("****testAdd2****");
        string = this.getInput("Client Name: ");
        String string4 = this.getInput("FileServer: ");
        String string5 = this.getInput("Root: ");
        String string6 = this.getInput("Swap: ");
        String string7 = this.getInput("Swap size: ");
        String string8 = this.getInput("Dump: ");
        String string9 = this.getInput("Dump size: ");
        String string10 = this.getInput("Boottype: ");
        string3 = this.getInput("Comment: ");
        bootparamsObject = new BootparamsObject(string, string4, string5, string6, string7, string8, string9, string10, string3);
        this.addBootparamsEntry(bootparamsObject);
        System.out.println("****testAdd3****");
        string = this.getInput("Client Name: ");
        boolean bl = false;
        String[] stringArray = new String[20];
        int n = 0;
        stringArray[n++] = this.getInput("Enter identifiers (<ret> to end): ");
        while (!bl) {
            stringArray[n] = this.getInput("Next id : ");
            if (stringArray[n].length() > 1) {
                ++n;
                continue;
            }
            bl = true;
        }
        string3 = this.getInput("Comment: ");
        bootparamsObject = new BootparamsObject(string, stringArray, string3);
        this.addBootparamsEntry(bootparamsObject);
        System.out.println("****End of test****");
    }

    private void testDelete() throws Exception {
        System.out.println("****Start testDelete****");
        String string = this.getInput("Client Name: ");
        this.deleteBootparamsEntry(string);
        System.out.println("****End of test****");
    }

    private void testList() throws Exception {
        System.out.println("****Start testList****");
        Vector vector = this.list();
        System.out.println("Bootparams Table (" + vector.size() + " entries) :::");
        int n = 0;
        while (vector != null && n < vector.size()) {
            BootparamsObject bootparamsObject = (BootparamsObject)vector.elementAt(n);
            System.out.println(bootparamsObject);
            ++n;
        }
        System.out.println("****End of test****");
    }
}

