/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.osserver;

import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.solarisprovider.osserver.EtherObject;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class EtherTable {
    private String table = new String("ethers");
    private String ethernetCol = "addr";
    private String hostNameCol = "name";
    private String commentCol = "comment";
    private int ethernetColNum = 0;
    private int hostNameColNum = 0;
    private int commentColNum = 0;
    private String scope;

    public EtherTable(String string) throws DirectoryTableException {
        this.scope = string;
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)string);
        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
        tableDefinitions.loadTableDefinitions("ethers");
        this.ethernetColNum = tableDefinitions.getColumnNumber(this.ethernetCol);
        this.hostNameColNum = tableDefinitions.getColumnNumber(this.hostNameCol);
        this.commentColNum = tableDefinitions.getColumnNumber(this.commentCol);
    }

    public void addEtherEntry(EtherObject etherObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = etherObject.getHostName();
        String string2 = etherObject.getEthernetAddr();
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0 || !etherObject.isEthernetAddr(string2)) {
            throw new DBTableException("EXM_ETHERENTRY_BAD", string, string2);
        }
        try {
            directoryTable = this.openEtherTable();
            directoryRow = this.checkEtherEntry(directoryTable, etherObject, false);
            if (directoryRow != null) {
                EtherObject etherObject2 = this.makeEtherObject(directoryRow);
                directoryTable.close();
                if (etherObject2.equals(etherObject)) {
                    return;
                }
                throw new DBTableException("EXM_ADD_EXIST", this.table);
            }
            directoryRow = this.makeRow(directoryTable, etherObject);
            directoryTable.addRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    private DirectoryRow checkEtherEntry(DirectoryTable directoryTable, EtherObject etherObject, boolean bl) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        String string = etherObject.getHostName();
        String string2 = etherObject.getEthernetAddr();
        if (!(string != null && string.trim().length() != 0 || string2 != null && string2.trim().length() != 0)) {
            return null;
        }
        directoryRow = directoryTable.getRowInstance();
        if (bl) {
            if (string != null && string.trim().length() != 0) {
                directoryRow.putColumn(this.hostNameColNum, string);
            }
            if (string2 != null && string2.trim().length() != 0) {
                directoryRow.putColumn(this.ethernetColNum, string2);
            }
            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            return directoryRow;
        }
        if (string != null && string.trim().length() != 0) {
            directoryRow.putColumn(this.hostNameColNum, string);
            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow != null) {
                return directoryRow;
            }
        }
        if (string2 != null && string2.trim().length() != 0) {
            directoryRow = directoryTable.getRowInstance();
            directoryRow.putColumn(this.ethernetColNum, string2);
            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow != null) {
                return directoryRow;
            }
        }
        return null;
    }

    public void deleteEtherEntry(EtherObject etherObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = etherObject.getHostName();
        String string2 = etherObject.getEthernetAddr();
        if (!(string != null && string.trim().length() != 0 || string2 != null && string2.trim().length() != 0)) {
            throw new DBTableException("EXM_DEL_INV", this.table);
        }
        try {
            directoryTable = this.openEtherTable();
            directoryRow = this.checkEtherEntry(directoryTable, etherObject, true);
            if (directoryRow == null) {
                directoryTable.close();
                return;
            }
            directoryTable.deleteRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    public void deleteEtherEntry(String string) throws DBTableException, DirectoryTableException {
        EtherObject etherObject = new EtherObject(string);
        this.deleteEtherEntry(etherObject);
    }

    public EtherObject getEtherEntry(EtherObject etherObject) throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        EtherObject etherObject2 = null;
        try {
            directoryTable = this.openEtherTable();
            directoryRow = this.checkEtherEntry(directoryTable, etherObject, true);
            if (directoryRow != null) {
                etherObject2 = this.makeEtherObject(directoryRow);
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return etherObject2;
    }

    public EtherObject getEtherEntry(String string) throws DirectoryTableException {
        EtherObject etherObject = new EtherObject(string);
        return this.getEtherEntry(etherObject);
    }

    public EtherObject getEtherEntryByAddr(String string) throws DirectoryTableException {
        EtherObject etherObject = new EtherObject(string, null, null);
        return this.getEtherEntry(etherObject);
    }

    public EtherObject getEtherEntryByName(String string) throws DirectoryTableException {
        EtherObject etherObject = new EtherObject(null, string, null);
        return this.getEtherEntry(etherObject);
    }

    private String getInput(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            return new String("");
        }
    }

    public Vector list() throws DirectoryTableException {
        Vector<EtherObject> vector = new Vector<EtherObject>();
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        try {
            directoryTable = this.openEtherTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                vector.addElement(this.makeEtherObject(directoryRow));
                directoryRow = directoryTable.getNextRow();
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        var1_1 = null;
        var2_2 = false;
        try {
            var1_1 = new EtherTable("File://poseidon");
            if (true) ** GOTO lbl44
        }
        catch (Exception var3_3) {
            System.out.println("Exception: " + var3_3);
            return;
        }
        do {
            System.out.println("1 - Add ethers entry");
            System.out.println("2 - Delete ethers entry");
            System.out.println("3 - Get ethers entry");
            System.out.println("4 - List ethers table");
            System.out.println("9 - Exit");
            System.out.print("Enter option: ");
            try {
                var3_4 = new byte[100];
                var4_6 = (char)System.in.read(var3_4);
                System.out.println("");
                if (var4_6 != '\u0002') {
                    var2_2 = true;
                    continue;
                }
                var5_7 = (char)var3_4[0];
                switch (var5_7) {
                    case '1': {
                        var1_1.testAdd();
                        break;
                    }
                    case '2': {
                        var1_1.testDelete();
                        break;
                    }
                    case '3': {
                        var1_1.testGet();
                        break;
                    }
                    case '4': {
                        var1_1.testList();
                        break;
                    }
                    default: {
                        var2_2 = true;
                        break;
                    }
                }
            }
            catch (Exception var3_5) {
                System.out.println("Exception: " + var3_5);
            }
            System.out.println("");
lbl44:
            // 3 sources

        } while (!var2_2);
    }

    private EtherObject makeEtherObject(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = directoryRow.getColumn(this.ethernetColNum);
        String string2 = directoryRow.getColumn(this.hostNameColNum);
        String string3 = directoryRow.getColumn(this.commentColNum);
        EtherObject etherObject = new EtherObject(string, string2, string3);
        return etherObject;
    }

    private DirectoryRow makeRow(DirectoryTable directoryTable, EtherObject etherObject) throws DirectoryTableException {
        DirectoryRow directoryRow = directoryTable.getRowInstance();
        String string = etherObject.getEthernetAddr();
        if (string != null && string.trim().length() != 0) {
            directoryRow.putColumn(this.ethernetColNum, string);
        }
        if ((string = etherObject.getHostName()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(this.hostNameColNum, string);
        }
        if ((string = etherObject.getComment()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(this.commentColNum, string);
        }
        return directoryRow;
    }

    public void modifyEtherEntry(EtherObject etherObject, EtherObject etherObject2) throws DBTableException, DirectoryTableException {
        String string = etherObject2.getHostName();
        String string2 = etherObject2.getEthernetAddr();
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0 || !etherObject2.isEthernetAddr(string2)) {
            throw new DBTableException("EXM_MODIFYETHER_BAD", string, string2);
        }
        string = etherObject.getHostName();
        string2 = etherObject.getEthernetAddr();
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0 || !etherObject.isEthernetAddr(string2)) {
            throw new DBTableException("EXM_MODIFYETHER_BAD", string, string2);
        }
        this.deleteEtherEntry(etherObject);
        this.addEtherEntry(etherObject2);
    }

    public void modifyEtherEntry(String string, EtherObject etherObject) throws DBTableException, DirectoryTableException {
        String string2 = etherObject.getHostName();
        String string3 = etherObject.getEthernetAddr();
        if (string2 == null || string2.trim().length() == 0 || string3 == null || string3.trim().length() == 0 || !etherObject.isEthernetAddr(string3)) {
            throw new DBTableException("EXM_MODIFYETHER_BAD", string2, string3);
        }
        if (string == null || string.trim().length() == 0) {
            throw new DBTableException("EXM_MODDC_NULL");
        }
        this.deleteEtherEntry(string);
        this.addEtherEntry(etherObject);
    }

    private DirectoryTable openEtherTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(this.table);
            return directoryTable;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            directoryTable.create(this.table);
            return directoryTable;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    private void testAdd() throws Exception {
        System.out.println("****Start testAdd****");
        String string = this.getInput("Ethernet Address: ");
        String string2 = this.getInput("Host Name: ");
        String string3 = this.getInput("Comment: ");
        EtherObject etherObject = new EtherObject(string, string2, string3);
        this.addEtherEntry(etherObject);
        System.out.println("****End of test****");
    }

    private void testDelete() throws Exception {
        System.out.println("****Start testDelete****");
        System.out.println("(Only Ethernet Address or Host Name required)");
        String string = this.getInput("Ethernet Address: ");
        String string2 = this.getInput("Host Name: ");
        String string3 = this.getInput("Comment: ");
        EtherObject etherObject = new EtherObject(string, string2, string3);
        this.deleteEtherEntry(etherObject);
        System.out.println("****End of test****");
    }

    private void testGet() throws Exception {
        System.out.println("****Start testGet****");
        String string = this.getInput("Ethernet Address or Host Name: ");
        EtherObject etherObject = this.getEtherEntry(string);
        System.out.println("    Got:\t" + etherObject);
        string = this.getInput("Ethernet Address: ");
        etherObject = this.getEtherEntryByAddr(string);
        System.out.println("    Got:\t" + etherObject);
        string = this.getInput("Host Name:");
        etherObject = this.getEtherEntryByName(string);
        System.out.println("    Got:\t" + etherObject);
        System.out.println("****End of test****");
    }

    private void testList() throws Exception {
        System.out.println("****Start testList****");
        Vector vector = this.list();
        System.out.println("Ether Table (" + vector.size() + " entries) :::");
        int n = 0;
        while (vector != null && n < vector.size()) {
            EtherObject etherObject = (EtherObject)vector.elementAt(n);
            System.out.println(etherObject);
            ++n;
        }
        System.out.println("****End of test****");
    }
}

