/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.SerialPortInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_SerialPort
implements InstanceProvider,
MethodProvider,
Authorizable {
    public static final String SERIAL_MODIFY_RIGHT = "solaris.admin.serialmgr.modify";
    public static final String SERIAL_DELETE_RIGHT = "solaris.admin.serialmgr.delete";
    public static final String SERIAL_READ_RIGHT = "solaris.admin.serialmgr.read";
    public static final String PROVIDER_NAME = "SerialPort";
    SerialPortInfo dat = null;
    LogUtil util = null;
    int num_ports;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;

    public Boolean DisablePortService(CIMObjectPath cIMObjectPath) throws CIMException {
        this.dat = this.initData();
        String string = "";
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("DeviceID")) continue;
            string = (String)cIMProperty.getValue().getValue();
        }
        try {
            this.dat.synchronizedDeletePort(string);
        }
        catch (SerialPortException serialPortException) {
            String string2 = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        catch (Exception exception) {
            String string3 = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string3);
        }
        return new Boolean(true);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        this.dat = this.initData();
        int n = 0;
        while (n < this.num_ports) {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            try {
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)this.dat.getPortName(n)));
            }
            catch (Exception exception) {
                String string = this.provUtil.writeLog(2, exception);
                throw new CIMException("CIM_ERR_FAILED", (Object)string);
            }
            cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {}
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
            vector.addElement(cIMObjectPath2);
            ++n;
        }
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        SerialPortData serialPortData = null;
        CIMInstance cIMInstance = null;
        this.dat = this.initData();
        int n = 0;
        while (n < this.num_ports) {
            cIMInstance = cIMClass.newInstance();
            try {
                serialPortData = this.dat.getPortData(this.dat.getPortName(n));
                cIMInstance.setProperty("DeviceID", new CIMValue((Object)this.dat.getPortName(n)));
            }
            catch (SerialPortException serialPortException) {
                String string = serialPortException.getLocalizedMessage();
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
            }
            catch (Exception exception) {
                String string = this.provUtil.writeLog(2, exception);
                throw new CIMException("CIM_ERR_FAILED", (Object)string);
            }
            cIMInstance.setProperty("SettableBaudRate", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableDataBits", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableFlowControl", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableParity", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableParityCheck", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableStopBits", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SupportsParityCheck", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SupportsXOnXOff", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SupportsXOnXOffSet", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("PortMonitor", new CIMValue((Object)serialPortData.getPortMonTag()));
            cIMInstance.setProperty("ServiceTag", new CIMValue((Object)serialPortData.getServiceTag()));
            cIMInstance.setProperty("Comment", new CIMValue((Object)serialPortData.getComment()));
            cIMInstance.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(serialPortData.isEnableSet())));
            if (bl2) {
                vector.addElement(cIMInstance);
            } else {
                cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception exception) {}
                cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
                vector.addElement(cIMInstance);
            }
            ++n;
        }
        return vector;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = new Vector();
            vector2 = this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return vector;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        CIMProperty cIMProperty;
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        String string = "";
        SerialPortData serialPortData = null;
        this.dat = this.initData();
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("DeviceID")) continue;
            string = (String)cIMProperty.getValue().getValue();
        }
        try {
            serialPortData = this.dat.getPortData(string);
        }
        catch (SerialPortException serialPortException) {
            String string2 = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        catch (Exception exception) {
            String string3 = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string3);
        }
        cIMProperty = cIMClass.newInstance();
        cIMProperty.setProperty("DeviceID", new CIMValue((Object)string));
        cIMProperty.setProperty("SettableBaudRate", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableDataBits", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableFlowControl", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableParity", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableParityCheck", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableStopBits", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SupportsParityCheck", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SupportsXOnXOff", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SupportsXOnXOffSet", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("PortMonitor", new CIMValue((Object)serialPortData.getPortMonTag()));
        cIMProperty.setProperty("ServiceTag", new CIMValue((Object)serialPortData.getServiceTag()));
        cIMProperty.setProperty("Comment", new CIMValue((Object)serialPortData.getComment()));
        cIMProperty.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(serialPortData.isEnableSet())));
        if (bl) {
            return cIMProperty;
        }
        cIMProperty.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        try {
            cIMProperty.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception exception) {}
        cIMProperty.setProperty("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
        return cIMProperty;
    }

    private SerialPortInfo initData() throws CIMException {
        try {
            SerialPortInfo serialPortInfo = new SerialPortInfo(this.util);
            this.num_ports = serialPortInfo.initData();
            return serialPortInfo;
        }
        catch (SerialPortException serialPortException) {
            String string = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        catch (Exception exception) {
            String string = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string);
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.util = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        String string = this.util.getMessage("LM_SERIAL_APP_NAME");
        this.provUtil = new ProviderUtility(cIMOMHandle, string);
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        if (string.equalsIgnoreCase("disableportservice")) {
            this.provUtil.checkRights(SERIAL_DELETE_RIGHT, cIMObjectPath);
            return new CIMValue((Object)this.DisablePortService(cIMObjectPath));
        }
        return null;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

