/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.BreakIterator;
import java.util.Vector;

public class WordWrapLabel
extends Canvas {
    String text;
    int lineLength;
    Vector lines;
    FontMetrics fm;
    int maxwidth;
    int nlines;
    int padding = 6;

    public WordWrapLabel(String string) {
        this.text = string;
        this.lineLength = 64 + string.length() / 32;
        Font font = new Font("Dialog", 0, 12);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.wrapMe();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.maxwidth + this.padding * 2, this.nlines * this.fm.getHeight() + this.padding * 2);
    }

    public void paint(Graphics graphics) {
        int n = this.fm.getAscent();
        int n2 = this.fm.getHeight();
        int n3 = 0;
        while (n3 < this.nlines) {
            graphics.drawString((String)this.lines.elementAt(n3), this.padding, this.padding + n + n3 * n2);
            ++n3;
        }
    }

    private void wrapMe() {
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(this.text);
        int n = 0;
        this.lines = new Vector();
        while (n + this.lineLength < this.text.length()) {
            int n2 = breakIterator.following(n + this.lineLength);
            if (n2 == -1) break;
            this.lines.addElement(this.text.substring(n, n2));
            n = n2;
        }
        String string = this.text.substring(n);
        this.lines.addElement(string);
        this.fm = this.getFontMetrics(this.getFont());
        this.nlines = this.lines.size();
        this.maxwidth = 0;
        int n3 = 0;
        while (n3 < this.nlines) {
            this.maxwidth = Math.max(this.maxwidth, this.fm.stringWidth((String)this.lines.elementAt(n3)));
            ++n3;
        }
    }
}

