/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NoSuchSymbolException;
import sun.jvm.hotspot.types.CIntegerType;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.basic.BasicCIntegerField;
import sun.jvm.hotspot.types.basic.BasicCIntegerType;
import sun.jvm.hotspot.types.basic.BasicField;
import sun.jvm.hotspot.types.basic.BasicJBooleanField;
import sun.jvm.hotspot.types.basic.BasicJByteField;
import sun.jvm.hotspot.types.basic.BasicJCharField;
import sun.jvm.hotspot.types.basic.BasicJDoubleField;
import sun.jvm.hotspot.types.basic.BasicJFloatField;
import sun.jvm.hotspot.types.basic.BasicJIntField;
import sun.jvm.hotspot.types.basic.BasicJLongField;
import sun.jvm.hotspot.types.basic.BasicJShortField;
import sun.jvm.hotspot.types.basic.BasicOopField;
import sun.jvm.hotspot.types.basic.BasicPointerType;
import sun.jvm.hotspot.types.basic.BasicType;
import sun.jvm.hotspot.types.basic.BasicTypeDataBase;
import sun.jvm.hotspot.types.basic.VtblAccess;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class HotSpotTypeDataBase
extends BasicTypeDataBase {
    private Debugger symbolLookup;
    private String[] jvmLibNames;
    private static final int UNINITIALIZED_SIZE = -1;
    private static final int C_INT8_SIZE = 1;
    private static final int C_INT32_SIZE = 4;
    private static final int C_INT64_SIZE = 8;
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.HotSpotTypeDataBase.DEBUG") != null;

    public HotSpotTypeDataBase(MachineDescription machDesc, VtblAccess vtblAccess, Debugger symbolLookup, String[] jvmLibNames) throws NoSuchSymbolException {
        super(machDesc, vtblAccess);
        this.symbolLookup = symbolLookup;
        this.jvmLibNames = jvmLibNames;
        this.readVMTypes();
        this.initializePrimitiveTypes();
        this.readVMStructs();
        this.readVMIntConstants();
        this.readVMLongConstants();
        this.maybeDo15Workaround();
    }

    private void readVMTypes() {
        long typeEntryTypeNameOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntryTypeNameOffset");
        long typeEntrySuperclassNameOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntrySuperclassNameOffset");
        long typeEntryIsOopTypeOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntryIsOopTypeOffset");
        long typeEntryIsIntegerTypeOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntryIsIntegerTypeOffset");
        long typeEntryIsUnsignedOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntryIsUnsignedOffset");
        long typeEntrySizeOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntrySizeOffset");
        long typeEntryArrayStride = this.getLongValueFromProcess("gHotSpotVMTypeEntryArrayStride");
        Address entryAddr = this.lookupInProcess("gHotSpotVMTypes");
        if ((entryAddr = entryAddr.getAddressAt(0L)) == null) {
            throw new RuntimeException("gHotSpotVMTypes was not initialized properly in the remote process; can not continue");
        }
        Address typeNameAddr = null;
        do {
            if ((typeNameAddr = entryAddr.getAddressAt(typeEntryTypeNameOffset)) != null) {
                String typeName = CStringUtilities.getString(typeNameAddr);
                String superclassName = null;
                Address superclassNameAddr = entryAddr.getAddressAt(typeEntrySuperclassNameOffset);
                if (superclassNameAddr != null) {
                    superclassName = CStringUtilities.getString(superclassNameAddr);
                }
                boolean isOopType = entryAddr.getCIntegerAt(typeEntryIsOopTypeOffset, 4L, false) != 0L;
                boolean isIntegerType = entryAddr.getCIntegerAt(typeEntryIsIntegerTypeOffset, 4L, false) != 0L;
                boolean isUnsigned = entryAddr.getCIntegerAt(typeEntryIsUnsignedOffset, 4L, false) != 0L;
                long size = entryAddr.getCIntegerAt(typeEntrySizeOffset, 8L, true);
                this.createType(typeName, superclassName, isOopType, isIntegerType, isUnsigned, size);
            }
            entryAddr = entryAddr.addOffsetTo(typeEntryArrayStride);
        } while (typeNameAddr != null);
    }

    private void initializePrimitiveTypes() {
        this.setJBooleanType(this.lookupPrimitiveType("jboolean"));
        this.setJByteType(this.lookupPrimitiveType("jbyte"));
        this.setJCharType(this.lookupPrimitiveType("jchar"));
        this.setJDoubleType(this.lookupPrimitiveType("jdouble"));
        this.setJFloatType(this.lookupPrimitiveType("jfloat"));
        this.setJIntType(this.lookupPrimitiveType("jint"));
        this.setJLongType(this.lookupPrimitiveType("jlong"));
        this.setJShortType(this.lookupPrimitiveType("jshort"));
        ((BasicType)this.getJBooleanType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJByteType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJCharType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJDoubleType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJFloatType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJIntType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJLongType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJShortType()).setIsJavaPrimitiveType(true);
    }

    private Type lookupPrimitiveType(String typeName) {
        Type type = this.lookupType(typeName, false);
        if (type == null) {
            throw new RuntimeException("Error initializing the HotSpotDataBase: could not find the primitive type \"" + typeName + "\" in the remote VM's VMStructs table. This type is required in " + "order to determine the size of Java primitive types. Can not continue.");
        }
        return type;
    }

    private void readVMStructs() {
        long structEntryTypeNameOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryTypeNameOffset");
        long structEntryFieldNameOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryFieldNameOffset");
        long structEntryTypeStringOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryTypeStringOffset");
        long structEntryIsStaticOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryIsStaticOffset");
        long structEntryOffsetOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryOffsetOffset");
        long structEntryAddressOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryAddressOffset");
        long structEntryArrayStride = this.getLongValueFromProcess("gHotSpotVMStructEntryArrayStride");
        Address entryAddr = this.lookupInProcess("gHotSpotVMStructs");
        if ((entryAddr = entryAddr.getAddressAt(0L)) == null) {
            throw new RuntimeException("gHotSpotVMStructs was not initialized properly in the remote process; can not continue");
        }
        Address fieldNameAddr = null;
        String typeName = null;
        String fieldName = null;
        String typeString = null;
        boolean isStatic = false;
        long offset = 0L;
        Address staticFieldAddr = null;
        long size = 0L;
        long index = 0L;
        String opaqueName = "<opaque>";
        this.lookupOrCreateClass(opaqueName, false, false, false);
        do {
            if ((fieldNameAddr = entryAddr.getAddressAt(structEntryFieldNameOffset)) != null) {
                fieldName = CStringUtilities.getString(fieldNameAddr);
                Address addr = entryAddr.getAddressAt(structEntryTypeNameOffset);
                if (addr == null) {
                    throw new RuntimeException("gHotSpotVMStructs unexpectedly had a NULL type name at index " + index);
                }
                typeName = CStringUtilities.getString(addr);
                addr = entryAddr.getAddressAt(structEntryTypeStringOffset);
                typeString = addr == null ? opaqueName : CStringUtilities.getString(addr);
                boolean bl = isStatic = entryAddr.getCIntegerAt(structEntryIsStaticOffset, 4L, false) != 0L;
                if (isStatic) {
                    staticFieldAddr = entryAddr.getAddressAt(structEntryAddressOffset);
                    offset = 0L;
                } else {
                    offset = entryAddr.getCIntegerAt(structEntryOffsetOffset, 8L, true);
                    staticFieldAddr = null;
                }
                BasicType containingType = this.lookupOrFail(typeName);
                BasicType fieldType = this.lookupOrFail(typeString);
                this.createField(containingType, fieldName, fieldType, isStatic, offset, staticFieldAddr);
            }
            ++index;
            entryAddr = entryAddr.addOffsetTo(structEntryArrayStride);
        } while (fieldNameAddr != null);
    }

    private void readVMIntConstants() {
        long intConstantEntryNameOffset = this.getLongValueFromProcess("gHotSpotVMIntConstantEntryNameOffset");
        long intConstantEntryValueOffset = this.getLongValueFromProcess("gHotSpotVMIntConstantEntryValueOffset");
        long intConstantEntryArrayStride = this.getLongValueFromProcess("gHotSpotVMIntConstantEntryArrayStride");
        Address entryAddr = this.lookupInProcess("gHotSpotVMIntConstants");
        if ((entryAddr = entryAddr.getAddressAt(0L)) == null) {
            throw new RuntimeException("gHotSpotVMIntConstants was not initialized properly in the remote process; can not continue");
        }
        Address nameAddr = null;
        do {
            if ((nameAddr = entryAddr.getAddressAt(intConstantEntryNameOffset)) != null) {
                String name = CStringUtilities.getString(nameAddr);
                int value = (int)entryAddr.getCIntegerAt(intConstantEntryValueOffset, 4L, false);
                Integer oldValue = this.lookupIntConstant(name, false);
                if (oldValue == null) {
                    this.addIntConstant(name, value);
                } else {
                    if (oldValue != value) {
                        throw new RuntimeException("Error: the integer constant \"" + name + "\" had its value redefined (old was " + oldValue + ", new is " + value + ". Aborting.");
                    }
                    System.err.println("Warning: the int constant \"" + name + "\" (declared in the remote VM in VMStructs::localHotSpotVMIntConstants) " + "had its value declared as " + value + " twice. Continuing.");
                }
            }
            entryAddr = entryAddr.addOffsetTo(intConstantEntryArrayStride);
        } while (nameAddr != null);
    }

    private void readVMLongConstants() {
        long longConstantEntryNameOffset = this.getLongValueFromProcess("gHotSpotVMLongConstantEntryNameOffset");
        long longConstantEntryValueOffset = this.getLongValueFromProcess("gHotSpotVMLongConstantEntryValueOffset");
        long longConstantEntryArrayStride = this.getLongValueFromProcess("gHotSpotVMLongConstantEntryArrayStride");
        Address entryAddr = this.lookupInProcess("gHotSpotVMLongConstants");
        if ((entryAddr = entryAddr.getAddressAt(0L)) == null) {
            throw new RuntimeException("gHotSpotVMLongConstants was not initialized properly in the remote process; can not continue");
        }
        Address nameAddr = null;
        do {
            if ((nameAddr = entryAddr.getAddressAt(longConstantEntryNameOffset)) != null) {
                String name = CStringUtilities.getString(nameAddr);
                int value = (int)entryAddr.getCIntegerAt(longConstantEntryValueOffset, 8L, true);
                Long oldValue = this.lookupLongConstant(name, false);
                if (oldValue == null) {
                    this.addLongConstant(name, value);
                } else {
                    if (oldValue != (long)value) {
                        throw new RuntimeException("Error: the long constant \"" + name + "\" had its value redefined (old was " + oldValue + ", new is " + value + ". Aborting.");
                    }
                    System.err.println("Warning: the long constant \"" + name + "\" (declared in the remote VM in VMStructs::localHotSpotVMLongConstants) " + "had its value declared as " + value + " twice. Continuing.");
                }
            }
            entryAddr = entryAddr.addOffsetTo(longConstantEntryArrayStride);
        } while (nameAddr != null);
    }

    private BasicType lookupOrFail(String typeName) {
        BasicType type = (BasicType)this.lookupType(typeName, false);
        if (type == null) {
            throw new RuntimeException("Type \"" + typeName + "\", referenced in VMStructs::localHotSpotVMStructs in the remote VM, " + "was not present in the remote VMStructs::localHotSpotVMTypes table (should have been caught " + "in the debug build of that VM). Can not continue.");
        }
        return type;
    }

    private void maybeDo15Workaround() {
        BasicType permGenType = (BasicType)this.lookupType("CompactingPermGenGen");
        if (permGenType != null) {
            Type virtSpaceType = this.lookupType("VirtualSpace");
            Type charPtrType = this.lookupType("char*");
            long charPtrSize = charPtrType.getSize();
            Field mcVsField = permGenType.getField("_mc_vs");
            long offset = mcVsField.getOffset() + virtSpaceType.getSize() + 2L * charPtrSize;
            if (permGenType.getField("_ro_space", false, false) == null) {
                this.createField(permGenType, "_ro_space", charPtrType, false, offset, null);
            }
            offset += charPtrSize;
            if (permGenType.getField("_rw_space", false, false) == null) {
                this.createField(permGenType, "_rw_space", charPtrType, false, offset, null);
            }
        }
    }

    private long getLongValueFromProcess(String symbol) {
        return this.lookupInProcess(symbol).getCIntegerAt(0L, 8L, true);
    }

    private Address lookupInProcess(String symbol) throws NoSuchSymbolException {
        for (int i = 0; i < this.jvmLibNames.length; ++i) {
            Address addr = this.symbolLookup.lookup(this.jvmLibNames[i], symbol);
            if (addr == null) continue;
            return addr;
        }
        String errStr = "(";
        for (int i = 0; i < this.jvmLibNames.length; ++i) {
            errStr = errStr + this.jvmLibNames[i];
            if (i >= this.jvmLibNames.length - 1) continue;
            errStr = errStr + ", ";
        }
        errStr = errStr + ")";
        throw new NoSuchSymbolException(symbol, "Could not find symbol \"" + symbol + "\" in any of the known library names " + errStr);
    }

    private BasicType lookupOrCreateClass(String typeName, boolean isOopType, boolean isIntegerType, boolean isUnsigned) {
        BasicType type = (BasicType)this.lookupType(typeName, false);
        if (type == null) {
            type = this.createBasicType(typeName, isOopType, isIntegerType, isUnsigned);
        }
        return type;
    }

    private BasicType createBasicType(String typeName, boolean isOopType, boolean isIntegerType, boolean isUnsigned) {
        BasicType type = null;
        if (isIntegerType) {
            type = new BasicCIntegerType((BasicTypeDataBase)this, typeName, isUnsigned);
        } else {
            type = this.typeNameIsPointerType(typeName) ? this.recursiveCreateBasicPointerType(typeName) : new BasicType(this, typeName);
            if (isOopType) {
                if (typeName.equals("markOop")) {
                    type = new BasicCIntegerType((BasicTypeDataBase)this, typeName, true);
                } else {
                    type.setIsOopType(true);
                }
            }
        }
        type.setSize(-1L);
        this.addType(type);
        return type;
    }

    private BasicPointerType recursiveCreateBasicPointerType(String typeName) {
        String targetTypeName = typeName.substring(0, typeName.lastIndexOf(42)).trim();
        Type targetType = null;
        if (this.typeNameIsPointerType(targetTypeName)) {
            targetType = this.recursiveCreateBasicPointerType(targetTypeName);
        } else {
            targetType = this.lookupType(targetTypeName, false);
            if (targetType == null) {
                if (targetTypeName.equals("char") || targetTypeName.equals("const char")) {
                    BasicType basicTargetType = this.createBasicType(targetTypeName, false, true, false);
                    basicTargetType.setSize(1L);
                    targetType = basicTargetType;
                } else if (targetTypeName.equals("u_char")) {
                    BasicType basicTargetType = this.createBasicType(targetTypeName, false, true, true);
                    basicTargetType.setSize(1L);
                    targetType = basicTargetType;
                } else {
                    if (DEBUG) {
                        System.err.println("WARNING: missing target type \"" + targetTypeName + "\" for pointer type \"" + typeName + "\"");
                    }
                    targetType = this.createBasicType(targetTypeName, false, false, false);
                }
            }
        }
        return new BasicPointerType(this, typeName, targetType);
    }

    private boolean typeNameIsPointerType(String typeName) {
        int i;
        for (i = typeName.length() - 1; i >= 0 && Character.isWhitespace(typeName.charAt(i)); --i) {
        }
        return i >= 0 && typeName.charAt(i) == '*';
    }

    public void createType(String typeName, String superclassName, boolean isOopType, boolean isIntegerType, boolean isUnsigned, long size) {
        BasicType superclass = null;
        if (superclassName != null) {
            superclass = this.lookupOrCreateClass(superclassName, false, false, false);
        }
        BasicType curType = this.lookupOrCreateClass(typeName, isOopType, isIntegerType, isUnsigned);
        if (superclass != null) {
            if (curType.getSuperclass() == null) {
                curType.setSuperclass(superclass);
            }
            if (curType.getSuperclass() != superclass) {
                throw new RuntimeException("Error: the type \"" + typeName + "\" (declared in the remote VM in VMStructs::localHotSpotVMTypes) " + "had its superclass redefined (old was " + curType.getSuperclass().getName() + ", new is " + superclass.getName() + ").");
            }
        }
        if (curType.getSize() == -1L) {
            curType.setSize(size);
        } else {
            if (curType.getSize() != size) {
                throw new RuntimeException("Error: the type \"" + typeName + "\" (declared in the remote VM in VMStructs::localHotSpotVMTypes) " + "had its size redefined (old was " + curType.getSize() + ", new is " + size + ").");
            }
            System.err.println("Warning: the type \"" + typeName + "\" (declared in the remote VM in VMStructs::localHotSpotVMTypes) " + "had its size declared as " + size + " twice. Continuing.");
        }
    }

    public void createField(BasicType containingType, String name, Type type, boolean isStatic, long offset, Address staticFieldAddress) {
        containingType.addField(this.internalCreateField(containingType, name, type, isStatic, offset, staticFieldAddress));
    }

    Field internalCreateField(BasicType containingType, String name, Type type, boolean isStatic, long offset, Address staticFieldAddress) {
        if (type.isOopType()) {
            return new BasicOopField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type instanceof CIntegerType) {
            return new BasicCIntegerField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJBooleanType())) {
            return new BasicJBooleanField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJByteType())) {
            return new BasicJByteField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJCharType())) {
            return new BasicJCharField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJDoubleType())) {
            return new BasicJDoubleField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJFloatType())) {
            return new BasicJFloatField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJIntType())) {
            return new BasicJIntField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJLongType())) {
            return new BasicJLongField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJShortType())) {
            return new BasicJShortField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        return new BasicField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
    }

    private void dumpMemory(Address addr, int len) {
        int i = 0;
        while (i < len) {
            System.err.print(addr.addOffsetTo(i) + ":");
            for (int j = 0; j < 8 && i < len; ++i, ++j) {
                String s = Long.toHexString(addr.getCIntegerAt(i, 1L, true));
                System.err.print(" 0x");
                for (int k = 0; k < 2 - s.length(); ++k) {
                    System.err.print("0");
                }
                System.err.print(s);
            }
            System.err.println();
        }
    }
}

