/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.x86.X86Register;
import sun.jvm.hotspot.asm.x86.X86RegisterPart;
import sun.jvm.hotspot.utilities.Assert;

public class X86Registers {
    public static final int NUM_REGISTERS = 8;
    public static final X86Register EAX = new X86RegisterPart(0, "%eax", 0, 32);
    public static final X86Register ECX = new X86RegisterPart(1, "%ecx", 0, 32);
    public static final X86Register EDX = new X86RegisterPart(2, "%edx", 0, 32);
    public static final X86Register EBX = new X86RegisterPart(3, "%ebx", 0, 32);
    public static final X86Register ESP = new X86RegisterPart(4, "%esp", 0, 32);
    public static final X86Register EBP = new X86RegisterPart(5, "%ebp", 0, 32);
    public static final X86Register ESI = new X86RegisterPart(6, "%esi", 0, 32);
    public static final X86Register EDI = new X86RegisterPart(7, "%edi", 0, 32);
    public static final X86Register AX = new X86RegisterPart(0, "%ax", 0, 16);
    public static final X86Register CX = new X86RegisterPart(1, "%cx", 0, 16);
    public static final X86Register DX = new X86RegisterPart(2, "%dx", 0, 16);
    public static final X86Register BX = new X86RegisterPart(3, "%bx", 0, 16);
    public static final X86Register SP = new X86RegisterPart(4, "%sp", 0, 16);
    public static final X86Register BP = new X86RegisterPart(5, "%bp", 0, 16);
    public static final X86Register SI = new X86RegisterPart(6, "%si", 0, 16);
    public static final X86Register DI = new X86RegisterPart(7, "%di", 0, 16);
    public static final X86Register AL = new X86RegisterPart(0, "%al", 0, 8);
    public static final X86Register CL = new X86RegisterPart(1, "%cl", 0, 8);
    public static final X86Register DL = new X86RegisterPart(2, "%dl", 0, 8);
    public static final X86Register BL = new X86RegisterPart(3, "%bl", 0, 8);
    public static final X86Register AH = new X86RegisterPart(0, "%ah", 8, 8);
    public static final X86Register CH = new X86RegisterPart(1, "%ch", 8, 8);
    public static final X86Register DH = new X86RegisterPart(2, "%dh", 8, 8);
    public static final X86Register BH = new X86RegisterPart(3, "%bh", 8, 8);
    private static X86Register[] registers8;
    private static X86Register[] registers16;
    private static X86Register[] registers32;

    public static int getNumberOfRegisters() {
        return 8;
    }

    public static X86Register getRegister8(int regNum) {
        Assert.that(regNum > -1 && regNum < 8, "invalid integer register number!");
        return registers8[regNum];
    }

    public static X86Register getRegister16(int regNum) {
        Assert.that(regNum > -1 && regNum < 8, "invalid integer register number!");
        return registers16[regNum];
    }

    public static X86Register getRegister32(int regNum) {
        Assert.that(regNum > -1 && regNum < 8, "invalid integer register number!");
        return registers32[regNum];
    }

    public static String getRegisterName(int regNum) {
        Assert.that(regNum > -1 && regNum < 8, "invalid integer register number!");
        return registers32[regNum].toString();
    }

    static {
        registers32 = new X86Register[]{EAX, ECX, EDX, EBX, ESP, EBP, ESI, EDI};
        registers16 = new X86Register[]{AX, CX, DX, BX, SP, BP, SI, DI};
        registers8 = new X86Register[]{AL, CL, DL, BL, AH, CH, DH, BH};
    }
}

