/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.Field;
import sun.jvm.hotspot.debugger.cdbg.GlobalSym;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public class BasicField
implements Field {
    private String name;
    private Type type;
    private int accessControl;
    private boolean isStatic;
    private long offset;
    private Address address;

    public BasicField(String name, Type type, int accessControl, boolean isStatic) {
        this.name = name;
        this.type = type;
        this.accessControl = accessControl;
    }

    public int getAccessControl() {
        return this.accessControl;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setOffset(long offset) {
        if (this.isStatic) {
            throw new RuntimeException("Nonstatic fields only");
        }
        this.offset = offset;
    }

    public long getOffset() {
        if (this.isStatic) {
            throw new RuntimeException("Nonstatic fields only");
        }
        return this.offset;
    }

    public void setAddress(Address address) {
        if (!this.isStatic) {
            throw new RuntimeException("Static fields only");
        }
        this.address = address;
    }

    public Address getAddress() {
        if (!this.isStatic) {
            throw new RuntimeException("Static fields only");
        }
        return this.address;
    }

    public void resolveTypes(Type containingType, BasicCDebugInfoDataBase db, ResolveListener listener) {
        this.type = db.resolveType(containingType, this.type, listener, "resolving field type");
        if (this.isStatic && this.address == null) {
            String fieldSymName = this.getType().getName() + "::" + this.getName();
            GlobalSym sym = db.lookupSym(fieldSymName);
            if (sym == null) {
                listener.resolveFailed(this.getType(), this.getName());
            } else {
                this.address = sym.getAddress();
            }
        }
    }
}

