/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecodes;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Bits;

public class Bytecode {
    Method method;
    int bci;
    static final int jintSize = 4;
    static final String spaces = " ";
    static final String comma = ", ";

    Bytecode(Method method, int bci) {
        this.method = method;
        this.bci = bci;
    }

    int alignedOffset(int offset) {
        return Bits.roundTo(this.bci + offset, 4) - this.bci;
    }

    int javaSignedWordAt(int offset) {
        return this.method.getBytecodeIntArg(this.bci + offset);
    }

    short javaShortAt(int offset) {
        return this.method.getBytecodeShortArg(this.bci + offset);
    }

    byte javaByteAt(int offset) {
        return this.method.getBytecodeByteArg(this.bci + offset);
    }

    public Method method() {
        return this.method;
    }

    public int bci() {
        return this.bci;
    }

    public int code() {
        return Bytecodes.codeAt(this.method(), this.bci());
    }

    public int javaCode() {
        return Bytecodes.javaCode(this.code());
    }

    public String getBytecodeName() {
        return Bytecodes.name(this.code());
    }

    public String getJavaBytecodeName() {
        return Bytecodes.name(this.javaCode());
    }

    public int getLength() {
        return Bytecodes.lengthAt(this.method(), this.bci());
    }

    public int getJavaLength() {
        return Bytecodes.javaLengthAt(this.method(), this.bci());
    }

    public boolean isSafepointSafe() {
        return Bytecodes.safepointSafe(this.code());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getJavaBytecodeName());
        if (this.code() != this.javaCode()) {
            buf.append(spaces);
            buf.append('[');
            buf.append(this.getBytecodeName());
            buf.append(']');
        }
        return buf.toString();
    }
}

